Public Class Form1

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        AxGTSIPPhone1.SetZone("AnyZoneName")
        'Set Any Name you like
        'for the case that you want the softphone only dials to one fixed number, or address
        'axGTSIPPhone1.SetConfigValue("gtphone.preset.phonenum", "8888@pcbest.net");

        'the following configs are for SIP account
        'axGTSIPPhone1.SetConfigValue("gtsrv.sip.reg.client.num", "1"); //one SIP account
        'axGTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.displayname", "AnyName"); //The display name of first account. Sample: "Bob Wall"
        'axGTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.username", "1800"); //The user name of first account. Sample: "12345678"
        'axGTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.domain", "sipaccount.com"); //The domain of first account. Sample: "pcbest.net"
        'axGTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.proxy", "sipaccount.com"); //The proxy of first account. It is same as domain usually. Sample: "pcbest.net"
        'axGTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.authorization", "1800"); //The authorization code of first account. It is same as username usually.
        'axGTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.password", "xxxxx"); //password for the sip account

        AxGTSIPPhone1.SetConfigValue("gtsrv.sip.ip.port", "7022")
        'default it is 5060
        AxGTSIPPhone1.SetConfigValue("gtsrv.sip.rtpstartrange", "12020")
        'RTP start port
        'axGTSIPPhone1.SetConfigValue "gtsrv.sip.stun.server", ""); //this is used for sip phone to go out of NAT
        AxGTSIPPhone1.SetConfigValue("gtsrv.sip.prefered.codec", "0,8,3")
        'Ulaw, Alaw, and GSM
        'GTSIPPhone1.SetConfigValue("gtsrv.sip.callcontrol.auto.answercall", "1"); //will auto answer incoming call if set

        AxGTSIPPhone1.Start()

        btnDial.Enabled = False
        btnHangup.Enabled = False
        textBox1.Enabled = False
        textBox1.Text = "8888@pcbest.net"
        richTextBox1.Enabled = False
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        AxGTSIPPhone1.Stop()
    End Sub

    Private Sub AxGTSIPPhone1_OnCallConnected(ByVal sender As Object, ByVal e As AxGTSIPPHONELib._DGTSIPPhoneEvents_OnCallConnectedEvent) Handles AxGTSIPPhone1.OnCallConnected
        richTextBox1.Text = "Call Connected!"
        btnDial.Enabled = False
        btnHangup.Enabled = True
    End Sub

    Private Sub AxGTSIPPhone1_OnCallDialing(ByVal sender As Object, ByVal e As AxGTSIPPHONELib._DGTSIPPhoneEvents_OnCallDialingEvent) Handles AxGTSIPPhone1.OnCallDialing
        richTextBox1.Text = "Dialing out...!"
        btnDial.Enabled = False
        btnHangup.Enabled = True
    End Sub

    Private Sub AxGTSIPPhone1_OnCallIdle(ByVal sender As Object, ByVal e As AxGTSIPPHONELib._DGTSIPPhoneEvents_OnCallIdleEvent) Handles AxGTSIPPhone1.OnCallIdle
        richTextBox1.Text = "LINE IDLE"
        btnDial.Enabled = True
        btnDial.Text = "Dial"
        btnHangup.Enabled = False
    End Sub

    Private Sub AxGTSIPPhone1_OnCallOffered(ByVal sender As Object, ByVal e As AxGTSIPPHONELib._DGTSIPPhoneEvents_OnCallOfferedEvent) Handles AxGTSIPPhone1.OnCallOffered
        richTextBox1.Text = "A new call coming in! caller:" + e.caller
        btnDial.Text = "Answer"
        btnDial.Enabled = True
        btnHangup.Enabled = True
    End Sub

    Private Sub AxGTSIPPhone1_OnCallRinging(ByVal sender As Object, ByVal e As AxGTSIPPHONELib._DGTSIPPhoneEvents_OnCallRingingEvent) Handles AxGTSIPPhone1.OnCallRinging
        richTextBox1.Text = "Dialing out... remote is ringing!"
        btnDial.Enabled = False
        btnHangup.Enabled = True
    End Sub

    Private Sub AxGTSIPPhone1_OnPhoneReady(ByVal sender As Object, ByVal e As AxGTSIPPHONELib._DGTSIPPhoneEvents_OnPhoneReadyEvent) Handles AxGTSIPPhone1.OnPhoneReady
        btnDial.Enabled = True
        btnHangup.Enabled = False
        textBox1.Enabled = True
        textBox1.Text = "8888@pcbest.net"
        richTextBox1.Enabled = True
        richTextBox1.Text = "LINE IDLE"
    End Sub

    Private Sub AxGTSIPPhone1_OnSIPRegStatus(ByVal sender As Object, ByVal e As AxGTSIPPHONELib._DGTSIPPhoneEvents_OnSIPRegStatusEvent) Handles AxGTSIPPhone1.OnSIPRegStatus
        If e.status = 1 Then
            richTextBox1.Text = "SIP account is registered!"
        Else
            richTextBox1.Text = "SIP account is not registered, or there is no SIP account!"
        End If
    End Sub

    Private Sub btnDial_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDial.Click
        If btnDial.Text = "Answer" Then
            'in answering call case
            AxGTSIPPhone1.AnswerCall(0)
        Else
            AxGTSIPPhone1.MakeCall(0, "<sip:" + textBox1.Text & ">", "")
        End If
    End Sub

    Private Sub btnHangup_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnHangup.Click
        AxGTSIPPhone1.HungupCall(0)
    End Sub
End Class
