unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, OleCtrls, GTSIPPHONELib_TLB;

type
  TForm1 = class(TForm)
    GTSIPPhone1: TGTSIPPhone;
    Label1: TLabel;
    btnDial: TButton;
    Edit1: TEdit;
    btnHangup: TButton;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure GTSIPPhone1PhoneReady(ASender: TObject;
      PhoneStatus: Integer);
    procedure GTSIPPhone1CallConnected(ASender: TObject; ChanID: Integer);
    procedure GTSIPPhone1CallDialing(ASender: TObject; ChanID: Integer;
      const sCaller, sCallee: WideString);
    procedure GTSIPPhone1CallIdle(ASender: TObject; ChanID: Integer);
    procedure GTSIPPhone1CallOffered(ASender: TObject; ChanID: Integer;
      const Caller, Callee, DestAddr, ViaAddr, SrcIPAddr: WideString;
      SrcIPPort: Smallint);
    procedure GTSIPPhone1CallRinging(ASender: TObject; ChanID: Integer);
    procedure GTSIPPhone1SIPRegStatus(ASender: TObject; UserID, Status,
      Expires: Integer);
    procedure btnDialClick(Sender: TObject);
    procedure btnHangupClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  PhoneInited : bool;
implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
      PhoneInited := false;


end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
      if PhoneInited = true then
       GTSIPPhone1.Stop();
end;

procedure TForm1.GTSIPPhone1PhoneReady(ASender: TObject;
  PhoneStatus: Integer);
begin
            btnDial.Enabled := true;
            btnHangup.Enabled := false;
            Edit1.Enabled := true;
            Edit1.Text := '8888@pcbest.net';
            Label2.Enabled := true;
            Label2.Caption := 'LINE IDLE';
end;

procedure TForm1.GTSIPPhone1CallConnected(ASender: TObject;
  ChanID: Integer);
begin
           Label2.Caption := 'Call Connected!';
            btnDial.Enabled := false;
            btnHangup.Enabled := true;
end;

procedure TForm1.GTSIPPhone1CallDialing(ASender: TObject; ChanID: Integer;
  const sCaller, sCallee: WideString);
begin
            Label2.Caption  := 'Dialing out...!';
            btnDial.Enabled := false;
            btnHangup.Enabled := true;
end;

procedure TForm1.GTSIPPhone1CallIdle(ASender: TObject; ChanID: Integer);
begin
            Label2.Caption := 'LINE IDLE';
            btnDial.Enabled := true;
            btnDial.Caption := 'Dial';
            btnHangup.Enabled := false;
end;

procedure TForm1.GTSIPPhone1CallOffered(ASender: TObject; ChanID: Integer;
  const Caller, Callee, DestAddr, ViaAddr, SrcIPAddr: WideString;
  SrcIPPort: Smallint);
begin
            Label2.Caption := 'A new call coming in! caller:';
            Label2.Caption := Label2.Caption + Caller;
            btnDial.Caption := 'Answer';
            btnDial.Enabled := true;
            btnHangup.Enabled := true;
end;

procedure TForm1.GTSIPPhone1CallRinging(ASender: TObject; ChanID: Integer);
begin
            Label2.Caption := 'Dialing out... remote is ringing!';
            btnDial.Enabled := false;
            btnHangup.Enabled := true;
end;

procedure TForm1.GTSIPPhone1SIPRegStatus(ASender: TObject; UserID, Status,
  Expires: Integer);
begin
            if Status = 1 then
            begin
                Label2.Caption := 'SIP account is registered!';
            end
            else
            begin
                Label2.Caption := 'SIP account is not registered, or there is no SIP account!';
            end;
end;

procedure TForm1.btnDialClick(Sender: TObject);
begin
             if btnDial.Caption = 'Answer' then
            begin
                //in answering call case
                GTSIPPhone1.AnswerCall(0);
            end
            else
            begin

                GTSIPPhone1.MakeCall(0, '<sip:' + Edit1.Text + '>', '');
            end;
end;

procedure TForm1.btnHangupClick(Sender: TObject);
begin
           GTSIPPhone1.HungupCall(0);
end;

procedure TForm1.FormShow(Sender: TObject);
begin

      if PhoneInited = false then
      begin
     GTSIPPhone1.SetZone('AnyZoneName'); //Set any name you want

      //for the case that you want the softphone only dials to one fixed number, or address
      //GTSIPPhone1.SetConfigValue("gtphone.preset.phonenum", "8888@pcbest.net");

            //the following configs are for SIP account
            //GTSIPPhone1.SetConfigValue("gtsrv.sip.reg.client.num", "1"); //one SIP account
            //GTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.displayname", "AnyName"); //The display name of first account. Sample: "Bob Wall"
            //GTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.username", "1800"); //The user name of first account. Sample: "12345678"
            //GTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.domain", "sipaccount.com"); //The domain of first account. Sample: "pcbest.net"
            //GTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.proxy", "sipaccount.com"); //The proxy of first account. It is same as domain usually. Sample: "pcbest.net"
            //GTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.authorization", "1800"); //The authorization code of first account. It is same as username usually.
            //GTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.password", "xxxxx"); //password for the sip account

            GTSIPPhone1.SetConfigValue('gtsrv.sip.ip.port', '7022'); //default it is 5060
            GTSIPPhone1.SetConfigValue('gtsrv.sip.rtpstartrange', '12020'); //RTP start port

            //axGTSIPPhone1.SetConfigValue "gtsrv.sip.stun.server", ""); //this is used for sip phone to go out of NAT
            GTSIPPhone1.SetConfigValue('gtsrv.sip.prefered.codec', '0,8,3'); //Ulaw, Alaw, and GSM

            //GGTSIPPhone1.SetConfigValue("gtsrv.sip.callcontrol.auto.answercall", "1"); //will auto answer incoming call if set

            GTSIPPhone1.Start();

            btnDial.Enabled := false;
            btnHangup.Enabled := false;
            Edit1.Enabled := false;
            Edit1.Text := '8888@pcbest.net';
            Label2.Enabled := false;
            PhoneInited := true;
       end;
end;

end.
