using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace RobustSIPCSharp
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            axGTSIPPhone1.SetZone("AnyZoneName"); //Set Any Name you like

            //for the case that you want the softphone only dials to one fixed number, or address
            //axGTSIPPhone1.SetConfigValue("gtphone.preset.phonenum", "8888@pcbest.net");

            //the following configs are for SIP account
            //axGTSIPPhone1.SetConfigValue("gtsrv.sip.reg.client.num", "1"); //one SIP account
            //axGTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.displayname", "AnyName"); //The display name of first account. Sample: "Bob Wall"
            //axGTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.username", "1800"); //The user name of first account. Sample: "12345678"
            //axGTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.domain", "sipaccount.com"); //The domain of first account. Sample: "pcbest.net"
            //axGTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.proxy", "sipaccount.com"); //The proxy of first account. It is same as domain usually. Sample: "pcbest.net"
            //axGTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.authorization", "1800"); //The authorization code of first account. It is same as username usually.
            //axGTSIPPhone1.SetConfigValue("gtsrv.sip.reg1.password", "xxxxx"); //password for the sip account

            axGTSIPPhone1.SetConfigValue("gtsrv.sip.ip.port", "7022"); //default it is 5060
            axGTSIPPhone1.SetConfigValue("gtsrv.sip.rtpstartrange", "12020"); //RTP start port
    
            //axGTSIPPhone1.SetConfigValue "gtsrv.sip.stun.server", ""); //this is used for sip phone to go out of NAT
            axGTSIPPhone1.SetConfigValue("gtsrv.sip.prefered.codec", "0,8,3"); //Ulaw, Alaw, and GSM
    
            //GTSIPPhone1.SetConfigValue("gtsrv.sip.callcontrol.auto.answercall", "1"); //will auto answer incoming call if set
    
            axGTSIPPhone1.Start();

            btnDial.Enabled = false;
            btnHangup.Enabled = false;
            textBox1.Enabled = false;
            textBox1.Text = "8888@pcbest.net";
            richTextBox1.Enabled = false;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            axGTSIPPhone1.Stop();
        }

        private void axGTSIPPhone1_OnCallConnected(object sender, AxGTSIPPHONELib._DGTSIPPhoneEvents_OnCallConnectedEvent e)
        {
            richTextBox1.Text = "Call Connected!";
            btnDial.Enabled = false;
            btnHangup.Enabled = true;
        }

        private void axGTSIPPhone1_OnCallDialing(object sender, AxGTSIPPHONELib._DGTSIPPhoneEvents_OnCallDialingEvent e)
        {
            richTextBox1.Text = "Dialing out...!";
            btnDial.Enabled = false;
            btnHangup.Enabled = true;
        }

        private void axGTSIPPhone1_OnCallIdle(object sender, AxGTSIPPHONELib._DGTSIPPhoneEvents_OnCallIdleEvent e)
        {
            richTextBox1.Text = "LINE IDLE";
            btnDial.Enabled = true;
            btnDial.Text = "Dial";
            btnHangup.Enabled = false;
        }

        private void axGTSIPPhone1_OnCallOffered(object sender, AxGTSIPPHONELib._DGTSIPPhoneEvents_OnCallOfferedEvent e)
        {
            richTextBox1.Text = "A new call coming in! caller:" + e.caller;
            btnDial.Text = "Answer";
            btnDial.Enabled = true;
            btnHangup.Enabled = true;
        }

        private void axGTSIPPhone1_OnCallRinging(object sender, AxGTSIPPHONELib._DGTSIPPhoneEvents_OnCallRingingEvent e)
        {
            richTextBox1.Text = "Dialing out... remote is ringing!";
            btnDial.Enabled = false;
            btnHangup.Enabled = true;
        }

        private void axGTSIPPhone1_OnPhoneReady(object sender, AxGTSIPPHONELib._DGTSIPPhoneEvents_OnPhoneReadyEvent e)
        {
            btnDial.Enabled = true;
            btnHangup.Enabled = false;
            textBox1.Enabled = true;
            textBox1.Text = "8888@pcbest.net";
            richTextBox1.Enabled = true;
            richTextBox1.Text = "LINE IDLE";
        }

        private void axGTSIPPhone1_OnSIPRegStatus(object sender, AxGTSIPPHONELib._DGTSIPPhoneEvents_OnSIPRegStatusEvent e)
        {
            if (e.status == 1)
            {
                richTextBox1.Text = "SIP account is registered!";
            }
            else
            {
                richTextBox1.Text = "SIP account is not registered, or there is no SIP account!";
            }
        }

        private void btnDial_Click(object sender, EventArgs e)
        {
            if (btnDial.Text == "Answer")
            {
                //in answering call case
                axGTSIPPhone1.AnswerCall(0);
            }
            else
            {
                axGTSIPPhone1.MakeCall(0, "<sip:" + textBox1.Text + ">", "");
            }
        }

        private void btnHangup_Click(object sender, EventArgs e)
        {
            axGTSIPPhone1.HungupCall(0);
        }


    }
}