﻿Public Class CfgForm
    Public cfgWrap As SIPPhoneCfgWrap
    Public Sub New(ByVal cfg As SIPPhoneCfgWrap)
        InitializeComponent()
        cfgWrap = cfg
    End Sub

    Private Sub CfgForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'sip acct
        tbDisplayName.Text = cfgWrap.DisplayName
        tbUserName.Text = cfgWrap.UserName
        tbPassword.Text = cfgWrap.Password
        tbDomain.Text = cfgWrap.Domain
        cbRegisterWithDomain.Checked = cfgWrap.RegisterDomain

        'network
        tbSIPPort.Text = cfgWrap.SIPPort.ToString()
        tbRTPPort.Text = cfgWrap.RTPPort.ToString()
        tbStunServer.Text = cfgWrap.StunServer
        cbUseLocalNatAddr.Checked = cfgWrap.UseNATAddr

        tbAudoCodecs.Text = cfgWrap.AudioCodecs

        'audio
        cbSpeakers.Text = cfgWrap.Speaker
        cbMics.Text = cfgWrap.Microphone
        cbRecordAudio.Checked = cfgWrap.RecordCalls
        tbRootFolder.Text = cfgWrap.RecordRoot

        cbProtocol.Items.Add("UDP")
        cbProtocol.Items.Add("TCP")
        cbProtocol.Items.Add("TLS")
        cbProtocol.SelectedIndex = cfgWrap.Protocol


        Dim renderDevice As String
        Dim captureDevice As String

        renderDevice = cfgWrap.Speaker
        captureDevice = cfgWrap.Microphone

        Try
            For i As Integer = 0 To GTAPIASM.GTAPIEnv.GetRenderDeviceCount() - 1
                cbSpeakers.Items.Add(GTAPIASM.GTAPIEnv.GetRenderDeviceName(i))

                If renderDevice.Length > 0 AndAlso GTAPIASM.GTAPIEnv.GetRenderDeviceName(i).IndexOf(renderDevice) >= 0 Then
                    cbSpeakers.SelectedIndex = i
                Else
                    If renderDevice.Length = 0 Then
                        If GTAPIASM.GTAPIEnv.IsRenderDevicePrimary(i) Then
                            cbSpeakers.SelectedIndex = i
                        End If
                    End If
                End If
            Next


            For i As Integer = 0 To GTAPIASM.GTAPIEnv.GetCaptureDeviceCount() - 1
                cbMics.Items.Add(GTAPIASM.GTAPIEnv.GetCaptureDeviceName(i))

                If captureDevice.Length > 0 AndAlso GTAPIASM.GTAPIEnv.GetCaptureDeviceName(i).IndexOf(captureDevice) >= 0 Then
                    cbMics.SelectedIndex = i
                Else
                    If captureDevice.Length = 0 Then
                        If GTAPIASM.GTAPIEnv.IsCaptureDevicePrimary(i) Then
                            cbMics.SelectedIndex = i
                        End If
                    End If
                End If

            Next
        Catch ex As Exception
        End Try
    End Sub

    Private Sub btnStart_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStart.Click
        'sip acct
        cfgWrap.DisplayName = tbDisplayName.Text
        cfgWrap.UserName = tbUserName.Text
        cfgWrap.Password = tbPassword.Text
        cfgWrap.Domain = tbDomain.Text
        cfgWrap.RegisterDomain = cbRegisterWithDomain.Checked

        'network
        cfgWrap.SIPPort = Convert.ToUInt16(tbSIPPort.Text)
        cfgWrap.RTPPort = Convert.ToUInt16(tbRTPPort.Text)
        cfgWrap.StunServer = tbStunServer.Text
        cfgWrap.UseNATAddr = cbUseLocalNatAddr.Checked

        'audio codecs
        cfgWrap.AudioCodecs = tbAudoCodecs.Text

        'audio device
        cfgWrap.Speaker = cbSpeakers.Text
        cfgWrap.Microphone = cbMics.Text
        cfgWrap.RecordCalls = cbRecordAudio.Checked
        cfgWrap.RecordRoot = tbRootFolder.Text

        cfgWrap.Protocol = cbProtocol.SelectedIndex

        DialogResult = DialogResult.OK

        Close()
    End Sub

    Private Sub btnSkip_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSkip.Click
        DialogResult = DialogResult.Cancel

        Close()
    End Sub
End Class