﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace CSharpSIPPhone
{
    public partial class DynamicRecordForm : Form
    {
        public bool bEnableRecord;
        public string sRootFolder;

        public DynamicRecordForm()
        {
            InitializeComponent();
            bEnableRecord = false;
            sRootFolder = "";
        }

        private void DynamicRecordForm_Load(object sender, EventArgs e)
        {
            cbEnableAudioRecord.Checked = bEnableRecord;
            if (bEnableRecord)
            {
                tbRootFolder.Enabled = true;
                tbRootFolder.Text = sRootFolder;
                btnBrowse.Enabled = true;
            }
            else
            {
                tbRootFolder.Enabled = false;
                tbRootFolder.Text = sRootFolder;
                btnBrowse.Enabled = false;
            }

        }

        private void cbEnableAudioRecord_CheckedChanged(object sender, EventArgs e)
        {
            if (cbEnableAudioRecord.Checked)
            {
                tbRootFolder.Enabled = true;
                btnBrowse.Enabled = true;
            }
            else
            {
                tbRootFolder.Enabled = false;
                btnBrowse.Enabled = false;
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            bEnableRecord = cbEnableAudioRecord.Checked;
            if(bEnableRecord)
                sRootFolder = tbRootFolder.Text;
            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            if(folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                tbRootFolder.Text = folderBrowserDialog1.SelectedPath;
            }
        }
    }
}
