﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace CSharpSIPPhone
{
    public partial class SoundDevice : Form
    {
        public string sSpeaker;
        public string sMic;

        public SoundDevice()
        {
            InitializeComponent();
        }

        private void SoundDevice_Load(object sender, EventArgs e)
        {
            string renderDevice;
            string captureDevice;

            renderDevice = sSpeaker;
            captureDevice = sMic;

            try
            {
                for(int i=0; i<GTAPIASM.GTAPIEnv.GetRenderDeviceCount(); i++)
                {
                    cbSpeakers.Items.Add(GTAPIASM.GTAPIEnv.GetRenderDeviceName(i));

                    if(renderDevice.Length > 0 && GTAPIASM.GTAPIEnv.GetRenderDeviceName(i).IndexOf(renderDevice) >= 0)
                    {
                        cbSpeakers.SelectedIndex = i;
                    }
                    else
                    {
                        if(renderDevice.Length == 0)
                        {
                            if(GTAPIASM.GTAPIEnv.IsRenderDevicePrimary(i))
                                cbSpeakers.SelectedIndex = i;
                        }
                    }
                }


                for(int i=0; i<GTAPIASM.GTAPIEnv.GetCaptureDeviceCount(); i++)
                {
                    cbMics.Items.Add(GTAPIASM.GTAPIEnv.GetCaptureDeviceName(i));

                    if(captureDevice.Length > 0 && GTAPIASM.GTAPIEnv.GetCaptureDeviceName(i).IndexOf(captureDevice) >= 0)
                    {
                        cbMics.SelectedIndex = i;
                    }
                    else
                    {
                        if(captureDevice.Length == 0)
                        {
                            if(GTAPIASM.GTAPIEnv.IsCaptureDevicePrimary(i))
                                cbMics.SelectedIndex = i;
                        }
                    }
                }

            }
            catch(Exception ex)
            {
            }


        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            sSpeaker = cbSpeakers.Text;
            sMic = cbMics.Text;
            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}
