﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace CSharpSIPPhone
{
    public partial class CfgForm : Form
    {
        public SIPPhoneCfgWrap cfgWrap;

        public CfgForm(SIPPhoneCfgWrap cfg)
        {
            InitializeComponent();
            cfgWrap = cfg;
        }

        private void CfgForm_Load(object sender, EventArgs e)
        {
            //sip acct
            tbDisplayName.Text = cfgWrap.DisplayName;
            tbUserName.Text = cfgWrap.UserName;
            tbPassword.Text = cfgWrap.Password;
            tbDomain.Text = cfgWrap.Domain;
            cbRegisterWithDomain.Checked = cfgWrap.RegisterDomain;

            //network
            tbSIPPort.Text = cfgWrap.SIPPort.ToString();
            tbRTPPort.Text = cfgWrap.RTPPort.ToString();
            tbStunServer.Text = cfgWrap.StunServer;
            cbUseLocalNatAddr.Checked = cfgWrap.UseNATAddr;

            tbAudoCodecs.Text = cfgWrap.AudioCodecs;

            //audio
            cbSpeakers.Text = cfgWrap.Speaker;
            cbMics.Text = cfgWrap.Microphone;
            cbRecordAudio.Checked = cfgWrap.RecordCalls;
            tbRootFolder.Text = cfgWrap.RecordRoot;

            cbProtocol.Items.Add("UDP");
            cbProtocol.Items.Add("TCP");
            cbProtocol.SelectedIndex = cfgWrap.Protocol;

            string renderDevice;
            string captureDevice;

            renderDevice = cfgWrap.Speaker;
            captureDevice = cfgWrap.Microphone;

            try
            {
                for (int i = 0; i < GTAPIASM.GTAPIEnv.GetRenderDeviceCount(); i++)
                {
                    cbSpeakers.Items.Add(GTAPIASM.GTAPIEnv.GetRenderDeviceName(i));

                    if (renderDevice.Length > 0 && GTAPIASM.GTAPIEnv.GetRenderDeviceName(i).IndexOf(renderDevice) >= 0)
                    {
                        cbSpeakers.SelectedIndex = i;
                    }
                    else
                    {
                        if (renderDevice.Length == 0)
                        {
                            if (GTAPIASM.GTAPIEnv.IsRenderDevicePrimary(i))
                                cbSpeakers.SelectedIndex = i;
                        }
                    }
                }


                for (int i = 0; i < GTAPIASM.GTAPIEnv.GetCaptureDeviceCount(); i++)
                {
                    cbMics.Items.Add(GTAPIASM.GTAPIEnv.GetCaptureDeviceName(i));

                    if (captureDevice.Length > 0 && GTAPIASM.GTAPIEnv.GetCaptureDeviceName(i).IndexOf(captureDevice) >= 0)
                    {
                        cbMics.SelectedIndex = i;
                    }
                    else
                    {
                        if (captureDevice.Length == 0)
                        {
                            if (GTAPIASM.GTAPIEnv.IsCaptureDevicePrimary(i))
                                cbMics.SelectedIndex = i;
                        }
                    }
                }

            }
            catch (Exception ex)
            {
            }


        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            //sip acct
            cfgWrap.DisplayName = tbDisplayName.Text;
            cfgWrap.UserName = tbUserName.Text;
            cfgWrap.Password = tbPassword.Text;
            cfgWrap.Domain = tbDomain.Text;
            cfgWrap.RegisterDomain = cbRegisterWithDomain.Checked;

            //network
            cfgWrap.SIPPort = Convert.ToUInt16(tbSIPPort.Text);
            cfgWrap.RTPPort = Convert.ToUInt16(tbRTPPort.Text);
            cfgWrap.StunServer = tbStunServer.Text;
            cfgWrap.UseNATAddr = cbUseLocalNatAddr.Checked;

            //audio codecs
            cfgWrap.AudioCodecs = tbAudoCodecs.Text;


            //audio device
            cfgWrap.Speaker = cbSpeakers.Text;
            cfgWrap.Microphone = cbMics.Text;
            cfgWrap.RecordCalls = cbRecordAudio.Checked;
            cfgWrap.RecordRoot = tbRootFolder.Text;

            cfgWrap.Protocol = cbProtocol.SelectedIndex;

            DialogResult = DialogResult.OK;

            Close();
        }

        private void btnSkip_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;

            Close();
        }


    }
}
