VERSION 5.00
Object = "{7C974670-6AD1-4A9C-A49D-BC802D5B7925}#1.0#0"; "gtsipctrl.ocx"
Begin VB.Form Form1 
   Caption         =   "VB SIP Phone (Using ActiveX ocx sample)"
   ClientHeight    =   4185
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   4185
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdTransfer 
      Caption         =   "Transfer"
      Height          =   375
      Left            =   3360
      TabIndex        =   20
      Top             =   2760
      Width           =   1095
   End
   Begin VB.CommandButton cmdHold 
      Caption         =   "Hold"
      Height          =   375
      Left            =   3360
      TabIndex        =   19
      Top             =   2280
      Width           =   1095
   End
   Begin VB.CommandButton NumPound 
      Caption         =   "#"
      Height          =   375
      Left            =   1560
      TabIndex        =   17
      Top             =   2760
      Width           =   375
   End
   Begin VB.CommandButton Num0 
      Caption         =   "0"
      Height          =   375
      Left            =   840
      TabIndex        =   16
      Top             =   2760
      Width           =   375
   End
   Begin VB.CommandButton NumStar 
      Caption         =   "*"
      Height          =   375
      Left            =   240
      TabIndex        =   15
      Top             =   2760
      Width           =   375
   End
   Begin VB.CommandButton Num9 
      Caption         =   "9"
      Height          =   375
      Left            =   1560
      TabIndex        =   14
      Top             =   2280
      Width           =   375
   End
   Begin VB.CommandButton Num8 
      Caption         =   "8"
      Height          =   375
      Left            =   840
      TabIndex        =   13
      Top             =   2280
      Width           =   375
   End
   Begin VB.CommandButton Num7 
      Caption         =   "7"
      Height          =   375
      Left            =   240
      TabIndex        =   12
      Top             =   2280
      Width           =   375
   End
   Begin VB.CommandButton Num6 
      Caption         =   "6"
      Height          =   375
      Left            =   1560
      TabIndex        =   11
      Top             =   1800
      Width           =   375
   End
   Begin VB.CommandButton Num5 
      Caption         =   "5"
      Height          =   375
      Left            =   840
      TabIndex        =   10
      Top             =   1800
      Width           =   375
   End
   Begin VB.CommandButton Num4 
      Caption         =   "4"
      Height          =   375
      Left            =   240
      TabIndex        =   9
      Top             =   1800
      Width           =   375
   End
   Begin VB.CommandButton Num3 
      Caption         =   "3"
      Height          =   375
      Left            =   1560
      TabIndex        =   8
      Top             =   1320
      Width           =   375
   End
   Begin VB.CommandButton Num2 
      Caption         =   "2"
      Height          =   375
      Left            =   840
      TabIndex        =   7
      Top             =   1320
      Width           =   375
   End
   Begin VB.CommandButton Num1 
      Caption         =   "1"
      Height          =   375
      Left            =   240
      TabIndex        =   6
      Top             =   1320
      Width           =   375
   End
   Begin VB.Timer Timer1 
      Interval        =   100
      Left            =   2280
      Top             =   1920
   End
   Begin VB.CommandButton btnHungup 
      Caption         =   "Hungup"
      Height          =   375
      Left            =   3360
      TabIndex        =   4
      Top             =   1800
      Width           =   1095
   End
   Begin VB.CommandButton BtnDial 
      Caption         =   "Dial"
      Height          =   375
      Left            =   3360
      TabIndex        =   3
      Top             =   1200
      Width           =   1095
   End
   Begin VB.TextBox SIPAddr 
      Height          =   375
      Left            =   480
      TabIndex        =   1
      Text            =   "8888@sip.pcbest.net"
      Top             =   480
      Width           =   3855
   End
   Begin GTSIPCTRLLib.GTSIPAPI GTSIPAPI1 
      Left            =   2160
      Top             =   1440
      _Version        =   65536
      _ExtentX        =   1296
      _ExtentY        =   450
      _StockProps     =   0
   End
   Begin VB.Label Label2 
      Caption         =   "Please refer .NET VBSimplePhone for a complete phone sample. "
      ForeColor       =   &H000000FF&
      Height          =   495
      Left            =   120
      TabIndex        =   18
      Top             =   3360
      Width           =   4455
   End
   Begin VB.Label Label1 
      Caption         =   "SIP:"
      Height          =   255
      Left            =   0
      TabIndex        =   5
      Top             =   600
      Width           =   615
   End
   Begin VB.Label ChanStatus 
      Caption         =   "Label1"
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   960
      Width           =   2535
   End
   Begin VB.Label AccInfo 
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   4215
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim InitedHold As Boolean


Public Sub FreeSIPServer()
    GTSIPAPI1.StopServer
    GTSIPAPI1.DestroyEnv
End Sub

Public Sub InitSIPServer()
    GTSIPAPI1.CreateEnv
    
    GTSIPAPI1.CFGSetValue "gtsrv.sip.server.model", "0" '0 = client phone 1 = sip server app

    'SIP IP Address you want to use on local
    'Leave it unset if you want to listen on all the network interface
    'GTSIPAPI1.CFGSetValue "gtsrv.sip.ip.address", ""

    'SIP Port, default 5060
    GTSIPAPI1.CFGSetValue "gtsrv.sip.ip.port", "5076"
    
    'RTP PORT
    GTSIPAPI1.CFGSetValue "gtsrv.sip.rtpstartrange", "17400"
    GTSIPAPI1.CFGSetValue "gtsrv.sip.rtpendrange", "17800"

    'Log
    GTSIPAPI1.CFGSetValue "gtsrv.log.level", "4"
    GTSIPAPI1.CFGSetValue "gtsrv.log.filename", "c:\simplephone.txt"

    'channnel numbers, here we only use 1 channel
    GTSIPAPI1.CFGSetValue "gtsrv.sip.boardnum.per.server", "1"
    GTSIPAPI1.CFGSetValue "gtsrv.sip.spannum.per.board", "1"
    GTSIPAPI1.CFGSetValue "gtsrv.sip.channum.per.span", "1"

    'Internal communication port
    GTSIPAPI1.CFGSetValue "gtsrv.net.port", "8914"
    
    GTSIPAPI1.CFGSetValue "gtsrv.sip.prefered.codec", "0,8"

    'Configuration file, if you want to define parameters in a file
    'GTSIPAPI1.CFGSetValue "gtsrv.config.filename", "GTPBXSrv1.ini"
    
    'sip account infomation
    'how many sip accounts you want to use
    'GTSIPAPI1.CFGSetValue "gtsrv.sip.reg.client.num", "1"
    'GTSIPAPI1.CFGSetValue "gtsrv.sip.reg1.DisplayName", "Any name"
    'GTSIPAPI1.CFGSetValue "gtsrv.sip.reg1.username", "your number from SIP ISP"
    'GTSIPAPI1.CFGSetValue "gtsrv.sip.reg1.domain", "your ISP SIP domain"
    'GTSIPAPI1.CFGSetValue "gtsrv.sip.reg1.proxy", "your ISP SIP proxy, may be same as domain"
    'GTSIPAPI1.CFGSetValue "gtsrv.sip.reg1.authorization", "your number"
    'GTSIPAPI1.CFGSetValue "gtsrv.sip.reg1.password", "your password"
    'GTSIPAPI1.CFGSetValue "gtsrv.sip.reg1.expire", "3600"
    

    'Application name, it is related to sdk licence
        'Please contact PCBest Network(www.pcbest.net) to get licence info
    'GTSIPAPI1.SetAppName "VBOCXSimplePhone"
    
	'If StartServer returns false, please check if SIP port set above is being used by another application!
    GTSIPAPI1.StartServer
    
   
End Sub

Private Sub BtnDial_Click()
    Dim addr As String
    Dim temp As String
    
    temp = SIPAddr.Text
    
    If BtnDial.Caption = "Dial" Then
        If InStr(1, temp, "@") = 0 Then
            addr = "<sip:" + temp + "@" + GTSIPAPI1.CFGGetValue("gtsrv.sip.reg1.domain", "") + ">"
        Else
            addr = "<sip:" + temp + ">"
        End If
        GTSIPAPI1.SendMake 0, addr, ""
    Else
        GTSIPAPI1.SendAnswer 0
    End If
End Sub

Private Sub btnHungup_Click()
    GTSIPAPI1.SendHungUp 0
End Sub

Private Sub cmdHold_Click()
    If InitedHold = True Then
        'unhold
        InitedHold = False
        GTSIPAPI1.SendHold 0
    Else
        'hold
        InitedHold = True
        GTSIPAPI1.SendHold 0
    End If
End Sub

Private Sub cmdTransfer_Click()
    GTSIPAPI1.SendTransfer 0, "<sip:8888@sip.pcbest.net>"
End Sub

Private Sub Form_Load()
    InitSIPServer
    
    BtnDial.Enabled = True
    btnHungup.Enabled = False
    cmdHold.Enabled = False
    cmdTransfer.Enabled = False
    
    ChanStatus.Caption = "IDLE"
 
End Sub

Private Sub Form_Unload(Cancel As Integer)
    FreeSIPServer
End Sub

Private Sub GTSIPAPI1_OnCallConnected(ByVal ChanID As Long)
    GTSIPAPI1.StopSound
    GTSIPAPI1.SendStartDXAudio 0
    BtnDial.Enabled = False
    btnHungup.Enabled = True
    ChanStatus.Caption = "Connected"
    Dim codec As Integer
    codec = GTSIPAPI1.GetChanAudioCodec(0)
    If codec = 102 Then
        ChanStatus.Caption = ChanStatus.Caption + " (Codec:Speex)"
    End If
    If codec = 101 Then
        ChanStatus.Caption = ChanStatus.Caption + " (Codec:iLBC 30)"
    End If
    If codec = 100 Then
        ChanStatus.Caption = ChanStatus.Caption + " (Codec:iLBC 20)"
    End If
    If codec = 3 Then
        ChanStatus.Caption = ChanStatus.Caption + " (Codec:GSM)"
    End If
    If codec = 98 Then
        ChanStatus.Caption = ChanStatus.Caption + " (Codec:G726-32)"
    End If
    If codec = 0 Then
        ChanStatus.Caption = ChanStatus.Caption + " (Codec:G711-Mulaw)"
    End If
    If codec = 8 Then
        ChanStatus.Caption = ChanStatus.Caption + " (Codec:G711-Alaw)"
    End If
    
    cmdHold.Enabled = True
    cmdTransfer.Enabled = True
    InitedHold = False
End Sub

Private Sub GTSIPAPI1_OnCallDialing(ByVal ChanID As Long, ByVal Caller As String, ByVal Callee As String)
    BtnDial.Enabled = False
    btnHungup.Enabled = True
    ChanStatus.Caption = "Dialing out"
End Sub

Private Sub GTSIPAPI1_OnCallHolding(ByVal ChanID As Long, ByVal HoldOnStatus As Long)
    If HoldOnStatus = 1 Then
        If InitedHold = True Then
            'The party it hold the call
            cmdHold.Enabled = True
            cmdTransfer.Enabled = True
        Else
            'the party that call is holded by remote
            cmdHold.Enabled = False
            cmdTransfer.Enabled = False
        End If
    Else
        'hold status changed to unhold
        InitedHold = False
        cmdHold.Enabled = True
        cmdTransfer.Enabled = True
    End If
End Sub

Private Sub GTSIPAPI1_OnCallIdle(ByVal ChanID As Long)
    GTSIPAPI1.StopSound
    BtnDial.Enabled = True
    btnHungup.Enabled = False
    ChanStatus.Caption = "IDLE"
    BtnDial.Caption = "Dial"
End Sub

Private Sub GTSIPAPI1_OnCallOffered(ByVal ChanID As Long, ByVal Caller As String, ByVal Callee As String, ByVal DestAddr As String, ByVal ViaAddr As String, ByVal IPAddr As String, ByVal IPPort As Long)
    GTSIPAPI1.StopSound
    GTSIPAPI1.PlayLocalRingSound
    SIPAddr.Text = Caller
    BtnDial.Enabled = True
    btnHungup.Enabled = True
    ChanStatus.Caption = "New Call Inconming from " + sCaller
    BtnDial.Caption = "Answer"
End Sub

Private Sub GTSIPAPI1_OnCallRinging(ByVal ChanID As Long)
    GTSIPAPI1.StopSound
    GTSIPAPI1.PlayRemoteRingSound
    ChanStatus.Caption = "Remote Side Ringing"
End Sub

Private Sub GTSIPAPI1_OnRecvRegStatus(ByVal SIPAccID As Long, ByVal Status As Long, ByVal RegUnixTime As Long)
    AccInfo.Caption = GTSIPAPI1.CFGGetValue("gtsrv.sip.reg1.username", "No SIP Account")
    If Status = 1 Then
        AccInfo.Caption = AccInfo.Caption + " Registered Successfully!"
    Else
        AccInfo.Caption = AccInfo.Caption + " XXX!(Unable to register to SIP server)"
    End If
End Sub

Private Sub Num0_Click()
    GTSIPAPI1.PlayNumberTone Asc("0")
    If BtnDial.Enabled Then
        'Channel is IDLE
        SIPAddr.Text = SIPAddr.Text + "0"
    Else
        'Channel is in Call
        GTSIPAPI1.SendPlayDTMFStr 0, "0"
    End If
  

End Sub

Private Sub Num1_Click()
    GTSIPAPI1.PlayNumberTone Asc("1")
    
    If BtnDial.Enabled Then
        'Channel is IDLE
        SIPAddr.Text = SIPAddr.Text + "1"
    Else
        'Channel is in Call
        GTSIPAPI1.SendPlayDTMFStr 0, "1"
    End If
    
End Sub

Private Sub Num2_Click()
    GTSIPAPI1.PlayNumberTone Asc("2")
    If BtnDial.Enabled Then
        'Channel is IDLE
        SIPAddr.Text = SIPAddr.Text + "2"
    Else
        'Channel is in Call
        GTSIPAPI1.SendPlayDTMFStr 0, "2"
    End If

End Sub

Private Sub Num3_Click()
    GTSIPAPI1.PlayNumberTone Asc("3")
    If BtnDial.Enabled Then
        'Channel is IDLE
        SIPAddr.Text = SIPAddr.Text + "3"
    Else
        'Channel is in Call
        GTSIPAPI1.SendPlayDTMFStr 0, "3"
    End If

End Sub

Private Sub Num4_Click()
    GTSIPAPI1.PlayNumberTone Asc("4")
    If BtnDial.Enabled Then
        'Channel is IDLE
        SIPAddr.Text = SIPAddr.Text + "4"
    Else
        'Channel is in Call
        GTSIPAPI1.SendPlayDTMFStr 0, "4"
    End If

End Sub

Private Sub Num5_Click()
    GTSIPAPI1.PlayNumberTone Asc("5")
    If BtnDial.Enabled Then
        'Channel is IDLE
        SIPAddr.Text = SIPAddr.Text + "5"
    Else
        'Channel is in Call
        GTSIPAPI1.SendPlayDTMFStr 0, "5"
    End If

End Sub

Private Sub Num6_Click()
    GTSIPAPI1.PlayNumberTone Asc("6")
    If BtnDial.Enabled Then
        'Channel is IDLE
        SIPAddr.Text = SIPAddr.Text + "6"
    Else
        'Channel is in Call
        GTSIPAPI1.SendPlayDTMFStr 0, "6"
    End If

End Sub

Private Sub Num7_Click()
    GTSIPAPI1.PlayNumberTone Asc("7")
    If BtnDial.Enabled Then
        'Channel is IDLE
        SIPAddr.Text = SIPAddr.Text + "7"
    Else
        'Channel is in Call
        GTSIPAPI1.SendPlayDTMFStr 0, "7"
    End If

End Sub

Private Sub Num8_Click()
    GTSIPAPI1.PlayNumberTone Asc("8")
    If BtnDial.Enabled Then
        'Channel is IDLE
        SIPAddr.Text = SIPAddr.Text + "8"
    Else
        'Channel is in Call
        GTSIPAPI1.SendPlayDTMFStr 0, "8"
    End If

End Sub

Private Sub Num9_Click()
    GTSIPAPI1.PlayNumberTone Asc("9")
    If BtnDial.Enabled Then
        'Channel is IDLE
        SIPAddr.Text = SIPAddr.Text + "9"
    Else
        'Channel is in Call
        GTSIPAPI1.SendPlayDTMFStr 0, "9"
    End If

End Sub

Private Sub NumPound_Click()
    GTSIPAPI1.PlayNumberTone Asc("#")
    If BtnDial.Enabled Then
        'Channel is IDLE
        SIPAddr.Text = SIPAddr.Text + "#"
    Else
        'Channel is in Call
        GTSIPAPI1.SendPlayDTMFStr 0, "#"
    End If

End Sub

Private Sub NumStar_Click()
    GTSIPAPI1.PlayNumberTone Asc("*")
    If BtnDial.Enabled Then
        'Channel is IDLE
        SIPAddr.Text = SIPAddr.Text + "*"
    Else
        'Channel is in Call
        GTSIPAPI1.SendPlayDTMFStr 0, "*"
    End If

End Sub

Private Sub Timer1_Timer()
    GTSIPAPI1.ProcessGTAPIEvent
End Sub
