unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, OleCtrls, GTSIPCTRLLib_TLB, StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    GTSIPAPI1: TGTSIPAPI;
    Timer1: TTimer;
    SIPAccInfo: TLabel;
    SIPAddr: TEdit;
    Label2: TLabel;
    LineStatus: TLabel;
    Num1: TButton;
    Num2: TButton;
    Num3: TButton;
    Num4: TButton;
    Num5: TButton;
    Num6: TButton;
    Num7: TButton;
    Num8: TButton;
    Num9: TButton;
    NumStar: TButton;
    Num0: TButton;
    NumPound: TButton;
    BtnDial: TButton;
    BtnHungup: TButton;
    btnConnect: TButton;
    Label7: TLabel;
    Label8: TLabel;
    Label1: TLabel;
    edtPass: TEdit;
    edtUser: TEdit;
    edtHost: TEdit;
    MemoParams: TMemo;
    OpenDialogWave: TOpenDialog;
    btnSelectWave: TBitBtn;
    btnSendWave: TBitBtn;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    edtWaveFile: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    btnDisconnect: TButton;
    chkDXAudio: TCheckBox;
    MemoDTMF: TMemo;
    Label5: TLabel;
    procedure Timer1Timer(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Num1Click(Sender: TObject);
    procedure GTSIPAPI1CallIdle(Sender: TObject; ChanID: Integer);
    procedure GTSIPAPI1CallOffered(Sender: TObject; ChanID: Integer;
      const Caller, Callee, DestAddr, ViaAddr, IPAddr: WideString;
      IPPort: Integer);
    procedure GTSIPAPI1CallRinging(Sender: TObject; ChanID: Integer);
    procedure BtnDialClick(Sender: TObject);
    procedure BtnHungupClick(Sender: TObject);
    procedure GTSIPAPI1RecvRegStatus(Sender: TObject; SIPAccID, Status,
      RegUnixTime: Integer);
    procedure btnConnectClick(Sender: TObject);
    procedure GTSIPAPI1AudioPlayDone(ASender: TObject; ChanID,
      DoneReason: Integer; const DTMFStr: WideString);
    procedure btnSendWaveClick(Sender: TObject);
    procedure btnSelectWaveClick(Sender: TObject);
    procedure btnDisconnectClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure GTSIPAPI1CallConnected(ASender: TObject; ChanID: Integer);
    procedure GTSIPAPI1DTMFKeyDown(ASender: TObject; ChanID: Integer;
      KeyValue: Smallint; ClockTicks: Integer);
  private
    { Private declarations }
    procedure EnableCall(Param :Boolean);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}


procedure TForm1.btnConnectClick(Sender: TObject);
var
  List: TStringList;
  n, nTemp : Integer;
  sTemp : String;
begin

  List := TStringList.Create;

  GTSIPAPI1.CreateEnv;
  List.Text := MemoParams.Text;
  List.Text := StringReplace(List.Text, '[USER]',edtUser.Text, [rfReplaceAll, rfIgnoreCase]);
  List.Text := StringReplace(List.Text, '[DOMAIN]',edtHost.Text, [rfReplaceAll, rfIgnoreCase]);
  List.Text := StringReplace(List.Text, '[PASSWORD]',edtPass.Text, [rfReplaceAll, rfIgnoreCase]);
  for n := 0 to List.Count-1 do begin
     sTemp := List.Strings[n] ;
     nTemp := pos('#',sTemp );
     if nTemp > 0 then sTemp :=   copy(sTemp, 0, nTemp-1);

     nTemp := pos('=',sTemp );
     if nTemp > 0 then    GTSIPAPI1.CFGSetValue( trim( copy(sTemp, 0, nTemp-1) ),  trim( copy(sTemp, nTemp+1, Length(sTemp) ) )  );
  end;
  List.Free;

//  GTSIPAPI1.CFGSetValue('gtsrv.log.level', '4');
//  GTSIPAPI1.CFGSetValue('gtsrv.log.filename', 'c:\log.txt');

//If StartServer returns False, please check if SIP port is being used by another application.
  GTSIPAPI1.StartServer;
  EnableCall(True);

end;


procedure TForm1.BtnDialClick(Sender: TObject);
       var MyString: string;
begin
    if BtnDial.Caption = 'Answer' then
            GTSIPAPI1.SendAnswer(0)
    else begin
         if pos(SIPAddr.Text, '@') > 0  then
            MyString := '<sip:' + SIPAddr.Text + '>'
         else
            MyString := '<sip:' + SIPAddr.Text+'@'+ edtHost.Text + '>';
         GTSIPAPI1.SendMake(0, MyString, '');
    end;
end;

procedure TForm1.EnableCall(Param :Boolean);
begin
    btnSendWave.Enabled := Param;
    btnDisconnect.Enabled := Param;
    btnSendWave.Enabled := Param;
    LineStatus.Caption := 'Connected';
    btnConnect.Enabled := Param;

    if not Param then begin
      SIPAccInfo.Caption := '';
      LineStatus.Caption := 'IDLE';
    end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
        GTSIPAPI1.ProcessGTAPIEvent;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
        GTSIPAPI1.StopServer;
        GTSIPAPI1.DestroyEnv;
end;

procedure TForm1.Num1Click(Sender: TObject);
var
  sTemp : string;
begin
   sTemp := (Sender as TButton).Caption;
   GTSIPAPI1.PlayNumberTone( smallint( sTemp[1] ) );
   if GTSIPAPI1.GetChanStatus(0) <> 0 then GTSIPAPI1.SendPlayDTMFStr(0, sTemp);
end;


procedure TForm1.GTSIPAPI1CallIdle(Sender: TObject; ChanID: Integer);
begin
EnableCall(True);
  BtnDial.Caption := 'Dial';
  LineStatus.Caption := 'IDLE';
 //stop previous ring tone
 GTSIPAPI1.PlayNumberTone(Smallint(' '));
end;

procedure TForm1.GTSIPAPI1CallOffered(Sender: TObject; ChanID: Integer;
  const Caller, Callee, DestAddr, ViaAddr, IPAddr: WideString;
  IPPort: Integer);
begin
  BtnDial.Caption := 'Answer';
  LineStatus.Caption := 'New Call';
  SIPAddr.Text := Caller;
  EnableCall( True );
  GTSIPAPI1.PlayLocalRingSound;
end;

procedure TForm1.GTSIPAPI1CallRinging(Sender: TObject; ChanID: Integer);
begin
  LineStatus.Caption := 'Remote side ringing';
  GTSIPAPI1.PlayRemoteRingSound;
  BtnHungup.Enabled := True;
end;



procedure TForm1.BtnHungupClick(Sender: TObject);
begin
   GTSIPAPI1.SendHungUp(0);
   GTSIPAPI1.SendStopAudio(0);
end;

procedure TForm1.GTSIPAPI1RecvRegStatus(Sender: TObject; SIPAccID, Status,
  RegUnixTime: Integer);
var
  MyString : string;
begin

  btnConnect.Enabled := False;
  MyString := GTSIPAPI1.CFGGetValue('gtsrv.sip.reg1.username', '???');

  if Status = 1 then begin
      MyString := MyString + ' Registered!';
      BtnDial.Enabled := true;
  end
  else
     MyString := MyString + ' Unregistered!';

   SIPAccInfo.Caption := MyString;
end;



procedure TForm1.GTSIPAPI1AudioPlayDone(ASender: TObject; ChanID,
  DoneReason: Integer; const DTMFStr: WideString);
begin
 ShowMessage('Audio Play Done');
end;

procedure TForm1.btnSendWaveClick(Sender: TObject);
var
 nTemp : Integer;
begin
  edtWaveFile.Text := Trim(edtWaveFile.Text);
  nTemp := Length( edtWaveFile.Text );

  if ( nTemp > 0 ) and  ( lowercase( copy(edtWaveFile.Text, nTemp-3, nTemp )    ) = '.wav' )   then
     GTSIPAPI1.SendPlayAudio(0, edtWaveFile.Text, 0, '', 0);
end;

procedure TForm1.btnSelectWaveClick(Sender: TObject);
begin
  if OpenDialogWave.Execute then edtWaveFile.Text := OpenDialogWave.FileName;
end;

procedure TForm1.btnDisconnectClick(Sender: TObject);
begin
  GTSIPAPI1.StopServer;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  btnDisconnect.Click;
  EnableCall(False);
end;

procedure TForm1.GTSIPAPI1CallConnected(ASender: TObject; ChanID: Integer);
begin
   BtnHungup.Enabled := True;
   //stop previous ring tone
   GTSIPAPI1.PlayNumberTone(Smallint(' '));
   GTSIPAPI1.SendEnableDTMF(0);
   if chkDXAudio.Enabled then
      GTSIPAPI1.SendStartDXAudio(0)
   else
      GTSIPAPI1.SendStopDXAudio(0);

end;

procedure TForm1.GTSIPAPI1DTMFKeyDown(ASender: TObject; ChanID: Integer;
  KeyValue: Smallint; ClockTicks: Integer);
begin
  MemoDTMF.Lines.Add( char(KeyValue) );
end;

end.
