unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, OleCtrls, GTSIPCTRLLib_TLB, StdCtrls;

type
  TForm1 = class(TForm)
    GTSIPAPI1: TGTSIPAPI;
    Timer1: TTimer;
    SIPAccInfo: TLabel;
    SIPAddr: TEdit;
    Label2: TLabel;
    LineStatus: TLabel;
    Num1: TButton;
    Num2: TButton;
    Num3: TButton;
    Num4: TButton;
    Num5: TButton;
    Num6: TButton;
    Num7: TButton;
    Num8: TButton;
    Num9: TButton;
    NumStar: TButton;
    Num0: TButton;
    NumPound: TButton;
    BtnDial: TButton;
    BtnHungup: TButton;
    BtnHold: TButton;
    BtnTransfer: TButton;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Num1Click(Sender: TObject);
    procedure Num2Click(Sender: TObject);
    procedure Num3Click(Sender: TObject);
    procedure Num4Click(Sender: TObject);
    procedure Num5Click(Sender: TObject);
    procedure Num6Click(Sender: TObject);
    procedure Num7Click(Sender: TObject);
    procedure Num8Click(Sender: TObject);
    procedure Num9Click(Sender: TObject);
    procedure NumStarClick(Sender: TObject);
    procedure Num0Click(Sender: TObject);
    procedure NumPoundClick(Sender: TObject);
    procedure GTSIPAPI1CallConnected(Sender: TObject; ChanID: Integer);
    procedure GTSIPAPI1CallDialing(Sender: TObject; ChanID: Integer;
      const Caller, Callee: WideString);
    procedure GTSIPAPI1CallIdle(Sender: TObject; ChanID: Integer);
    procedure GTSIPAPI1CallOffered(Sender: TObject; ChanID: Integer;
      const Caller, Callee, DestAddr, ViaAddr, IPAddr: WideString;
      IPPort: Integer);
    procedure GTSIPAPI1CallRinging(Sender: TObject; ChanID: Integer);
    procedure BtnDialClick(Sender: TObject);
    procedure BtnHungupClick(Sender: TObject);
    procedure GTSIPAPI1RecvRegStatus(Sender: TObject; SIPAccID, Status,
      RegUnixTime: Integer);
    procedure BtnHoldClick(Sender: TObject);
    procedure BtnTransferClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Timer1Timer(Sender: TObject);
begin
        GTSIPAPI1.ProcessGTAPIEvent;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
        GTSIPAPI1.CreateEnv;

        //client phone model
        GTSIPAPI1.CFGSetValue('gtsrv.sip.server.model', '0');

	//SIP Port, default 5060
	GTSIPAPI1.CFGSetValue('gtsrv.sip.ip.port', '5086');

	//RTP PORT
	GTSIPAPI1.CFGSetValue('gtsrv.sip.rtpstartrange', '17400');
	GTSIPAPI1.CFGSetValue('gtsrv.sip.rtpendrange', '17800');

       	//Log
//	CFG_SetValue("gtsrv.log.level", "4");
//	CFG_SetValue("gtsrv.log.filename", "c:\\gtsimplephone.txt");

	//channnel numbers, here we only use 1 channel
	GTSIPAPI1.CFGSetValue('gtsrv.sip.boardnum.per.server', '1');
	GTSIPAPI1.CFGSetValue('gtsrv.sip.spannum.per.board', '1');
	GTSIPAPI1.CFGSetValue('gtsrv.sip.channum.per.span', '1');

        //Internal communication port
	GTSIPAPI1.CFGSetValue('gtsrv.net.port', '8714');

	//Application name, it is related to sdk licence
	//Please contact PCBest Network(www.pcbest.net) to get licence info
	GTSIPAPI1.SetAppName('DelphiSimplePhone');

	//define outbound route, leave them unset if you don't know
	//CFG_SetValue("gtsrv.sip.outbound.via.type", "0");
	//CFG_SetValue("gtsrv.sip.outbound.via.proxy", "");

	//set sip client user info
	//you must get an account from sip service provider first
	//CFG_SetValue("gtsrv.sip.reg.client.num", "1");
        //CFG_SetValue("gtsrv.sip.reg1.displayname", 'any name');
	//CFG_SetValue("gtsrv.sip.reg1.username", '12345678');
	//CFG_SetValue("gtsrv.sip.reg1.domain", 'pcbest.net');
	//CFG_SetValue("gtsrv.sip.reg1.proxy", 'pcbest.net');
	//CFG_SetValue("gtsrv.sip.reg1.authorization", '12345678');
	//CFG_SetValue("gtsrv.sip.reg1.password", 'password1');
	//CFG_SetValue("gtsrv.sip.reg1.expire", "3600");

	//if StartServer retrun false, please make sure the SIP port set above is not being used by another application!
        GTSIPAPI1.StartServer;

//        if GTSIPAPI1.GetDetectedNATType() >= 10 then
  //      begin
    //         MessageBox(NULL, 'You may not be able to make Internet call', 'warn', MB_OK);
      //  end;

        SIPAccInfo.Caption := '';
        LineStatus.Caption := 'IDLE';
        BtnDial.Enabled := true;
        BtnHungup.Enabled := false;
        BtnHold.Enabled := false;
        BtnTransfer.Enabled := false;

        SIPAddr.Text := '8888@pcbest.net';
        SIPAccInfo.Caption := 'XXX Unregistered!';
end;


procedure TForm1.FormDestroy(Sender: TObject);
begin
        GTSIPAPI1.StopServer;
        GTSIPAPI1.DestroyEnv;
end;

procedure TForm1.Num1Click(Sender: TObject);
begin
        GTSIPAPI1.PlayNumberTone(Smallint('1'));
        if GTSIPAPI1.GetChanStatus(0) <> 0 then
        begin
                GTSIPAPI1.SendPlayDTMFStr(0, '1');
        end;
end;

procedure TForm1.Num2Click(Sender: TObject);
begin
        GTSIPAPI1.PlayNumberTone(Smallint('2'));
        if GTSIPAPI1.GetChanStatus(0) <> 0 then
        begin
                GTSIPAPI1.SendPlayDTMFStr(0, '2');
        end;

end;

procedure TForm1.Num3Click(Sender: TObject);
begin
        GTSIPAPI1.PlayNumberTone(Smallint('3'));
        if GTSIPAPI1.GetChanStatus(0) <> 0 then
        begin
                GTSIPAPI1.SendPlayDTMFStr(0, '3');
        end;

end;

procedure TForm1.Num4Click(Sender: TObject);
begin
        GTSIPAPI1.PlayNumberTone(Smallint('4'));
        if GTSIPAPI1.GetChanStatus(0) <> 0 then
        begin
                GTSIPAPI1.SendPlayDTMFStr(0, '4');
        end;
end;

procedure TForm1.Num5Click(Sender: TObject);
begin
        GTSIPAPI1.PlayNumberTone(Smallint('5'));
        if GTSIPAPI1.GetChanStatus(0) <> 0 then
        begin
                GTSIPAPI1.SendPlayDTMFStr(0, '5');
        end;

end;

procedure TForm1.Num6Click(Sender: TObject);
begin
        GTSIPAPI1.PlayNumberTone(Smallint('6'));
        if GTSIPAPI1.GetChanStatus(0) <> 0 then
        begin
                GTSIPAPI1.SendPlayDTMFStr(0, '6');
        end;

end;

procedure TForm1.Num7Click(Sender: TObject);
begin
        GTSIPAPI1.PlayNumberTone(Smallint('7'));
        if GTSIPAPI1.GetChanStatus(0) <> 0 then
        begin
                GTSIPAPI1.SendPlayDTMFStr(0, '7');
        end;

end;

procedure TForm1.Num8Click(Sender: TObject);
begin
        GTSIPAPI1.PlayNumberTone(Smallint('8'));
        if GTSIPAPI1.GetChanStatus(0) <> 0 then
        begin
                GTSIPAPI1.SendPlayDTMFStr(0, '8');
        end;

end;

procedure TForm1.Num9Click(Sender: TObject);
begin
        GTSIPAPI1.PlayNumberTone(Smallint('9'));
        if GTSIPAPI1.GetChanStatus(0) <> 0 then
        begin
                GTSIPAPI1.SendPlayDTMFStr(0, '9');
        end;

end;

procedure TForm1.NumStarClick(Sender: TObject);
begin
        GTSIPAPI1.PlayNumberTone(Smallint('*'));
        if GTSIPAPI1.GetChanStatus(0) <> 0 then
        begin
                GTSIPAPI1.SendPlayDTMFStr(0, '*');
        end;

end;

procedure TForm1.Num0Click(Sender: TObject);
begin
        GTSIPAPI1.PlayNumberTone(Smallint('0'));
        if GTSIPAPI1.GetChanStatus(0) <> 0 then
        begin
                GTSIPAPI1.SendPlayDTMFStr(0, '0');
        end;

end;

procedure TForm1.NumPoundClick(Sender: TObject);
begin
        GTSIPAPI1.PlayNumberTone(Smallint('#'));
        if GTSIPAPI1.GetChanStatus(0) <> 0 then
        begin
                GTSIPAPI1.SendPlayDTMFStr(0, '#');
        end;

end;

procedure TForm1.GTSIPAPI1CallConnected(Sender: TObject; ChanID: Integer);
begin
        BtnDial.Enabled := false;
        BtnHungup.Enabled := true;
        BtnHold.Enabled := true;
        BtnTransfer.Enabled := true;
        LineStatus.Caption := 'Connected';

        //stop previous ring tone
        GTSIPAPI1.PlayNumberTone(Smallint(' '));

        GTSIPAPI1.SendStartDXAudio(0);
end;

procedure TForm1.GTSIPAPI1CallDialing(Sender: TObject; ChanID: Integer;
  const Caller, Callee: WideString);
begin
        BtnDial.Enabled := true;
        BtnHungup.Enabled := true;
        BtnHold.Enabled := false;
        BtnTransfer.Enabled := false;
        LineStatus.Caption := 'Dialing out';
end;

procedure TForm1.GTSIPAPI1CallIdle(Sender: TObject; ChanID: Integer);
begin
        BtnDial.Caption := 'Dial';
        BtnDial.Enabled := true;
        BtnHungup.Enabled := false;
        BtnHold.Enabled := false;
        BtnTransfer.Enabled := false;
        LineStatus.Caption := 'IDLE';

        //stop previous ring tone
        GTSIPAPI1.PlayNumberTone(Smallint(' '));
end;

procedure TForm1.GTSIPAPI1CallOffered(Sender: TObject; ChanID: Integer;
  const Caller, Callee, DestAddr, ViaAddr, IPAddr: WideString;
  IPPort: Integer);
begin
        BtnDial.Caption := 'Answer';
        BtnDial.Enabled := true;
        BtnHungup.Enabled := false;
        BtnHold.Enabled := false;
        BtnTransfer.Enabled := false;
        LineStatus.Caption := 'New Call';
        SIPAddr.Text := Caller;

        GTSIPAPI1.PlayLocalRingSound;
end;

procedure TForm1.GTSIPAPI1CallRinging(Sender: TObject; ChanID: Integer);
begin
        BtnDial.Enabled := true;
        BtnHungup.Enabled := true;
        BtnHold.Enabled := false;
        BtnTransfer.Enabled := false;
        LineStatus.Caption := 'Remote side ringing';
        GTSIPAPI1.PlayRemoteRingSound;
end;

procedure TForm1.BtnDialClick(Sender: TObject);
       var MyString: string;
begin
        if BtnDial.Caption = 'Answer' then
                GTSIPAPI1.SendAnswer(0)
        else
        begin
        //make sure the dest address is like : <sip: 123@abc.com>
             MyString := '<sip:' + SIPAddr.Text + '>';
             GTSIPAPI1.SendMake(0, MyString, '');
        end;
end;

procedure TForm1.BtnHungupClick(Sender: TObject);
begin
        GTSIPAPI1.SendHungUp(0);
end;

procedure TForm1.GTSIPAPI1RecvRegStatus(Sender: TObject; SIPAccID, Status,
  RegUnixTime: Integer);
var MyString : string;
begin
        MyString := GTSIPAPI1.CFGGetValue('gtsrv.sip.reg1.username', '???');

        if Status = 1 then
                MyString := MyString + ' Registered!'
        else
                MyString := MyString + ' Unregistered!';

        SIPAccInfo.Caption := MyString;
end;

procedure TForm1.BtnHoldClick(Sender: TObject);
begin
        //not done yet
end;

procedure TForm1.BtnTransferClick(Sender: TObject);
begin
        //not done yet
end;

end.
