//---------------------------------------------------------------------------
#include <stdio.h>
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "GTSIPCTRLLib_OCX"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
       if(!InitSIPServer())
	   {
			//StartServer Failed. Please make sure the SIP port is not being used by another application!
	   }
       btnHungup->Enabled = false;
       btnDial->Enabled = true;
       btnDial->Caption = "Dial";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
        GTSIPAPI1->ProcessGTAPIEvent();        
}
//---------------------------------------------------------------------------


bool TForm1::InitSIPServer()
{
        //TODO: Add your source code here
        GTSIPAPI1->CreateEnv();

        //set client phone model
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.server.model"), WideString("0"));

        //sip ip address and port
        //you don't need to set ip address if you want it on all your ethernet interface
        //GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.ip.address"), WideString(""));
        //We want sip on 8740 port
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.ip.port"), WideString("8740"));

        //we don't want it use local NAT address because it is internet call
        //default is "0", if you have asterisk or 3CX ip pbx on the local network,
        //you need to set this to "1"
        //GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.use.nat.addr"), WideString("0"));

        //rtp port range
        //note: every channel uses two rtp ports
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.rtpstartrange"), WideString("38000"));
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.rtpendrange"), WideString("38600"));

        //prefered codecs
        //GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.prefered.codec"), WideString("102,101,100,3,0,8"));

        //how many channels you want to create
        //here we use one channel for sample first
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.channum.per.span"), WideString("1"));
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.spannum.per.board"), WideString("1"));
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.boardnum.per.server"), WideString("1"));

        //internal communication port
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.net.port"), WideString("9052"));

        //log
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.log.level"), WideString("4"));
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.log.filename"), WideString("c:\\sipphone.txt"));

        //SIP account
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.reg.client.num"), WideString("1"));
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.reg1.displayname"), WideString("SystemTest"));
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.reg1.username"), WideString("12345678"));
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.reg1.domain"), WideString("pcbest.net"));
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.reg1.proxy"), WideString("pcbest.net"));
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.reg1.authorization"), WideString("12345678"));
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.reg1.password"), WideString("12345678"));
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.reg1.expire"), WideString("3600"));

        return GTSIPAPI1->StartServer();
}

bool TForm1::FreeSIPServer()
{
        //TODO: Add your source code here
        GTSIPAPI1->StopServer();
        GTSIPAPI1->DestroyEnv();
        return true;
}
void __fastcall TForm1::FormDestroy(TObject *Sender)
{
        FreeSIPServer();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::GTSIPAPI1CallRinging(TObject *Sender, long ChanID)
{
     //remote side ringed
     GTSIPAPI1->PlayRemoteRingSound();
     LineStatus->Caption = "Remote Side Ringing";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::GTSIPAPI1CallOffered(TObject *Sender, long ChanID,
      BSTR Caller, BSTR Callee, BSTR DestAddr, BSTR ViaAddr, BSTR IPAddr,
      long IPPort)
{
        btnDial->Caption = "Answer";
        GTSIPAPI1->PlayLocalRingSound();
        SIPAddr->Text = Caller;
        LineStatus->Caption = "New Call Coming In.";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::GTSIPAPI1CallIdle(TObject *Sender, long ChanID)
{
     GTSIPAPI1->PlayNumberTone(' '); //stop the previous sound first
       btnHungup->Enabled = false;
       btnDial->Enabled = true;
       btnDial->Caption = "Dial";
        LineStatus->Caption = "LINE IDLE";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::GTSIPAPI1CallHolding(TObject *Sender, long ChanID,
      long HoldOnStatus)
{
       btnHungup->Enabled = true;
       btnDial->Enabled = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::GTSIPAPI1CallDialing(TObject *Sender, long ChanID,
      BSTR Caller, BSTR Callee)
{
       btnHungup->Enabled = true;
       btnDial->Enabled = false;
       LineStatus->Caption = "Dialing out";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::GTSIPAPI1CallConnected(TObject *Sender,
      long ChanID)
{
        GTSIPAPI1->PlayNumberTone(' '); //stop the previous sound first
       btnHungup->Enabled = true;
       btnDial->Enabled = false;
       GTSIPAPI1->SendStartDXAudio(ChanID);  //connect directx audio to phone

       int codec = GTSIPAPI1->GetChanAudioCodec(ChanID);
       switch(codec)
       {
       case 0:
        LineStatus->Caption = "Connected! G711-Mulaw";
        break;
        case 8:
        LineStatus->Caption = "Connected! G711-Alaw";
        break;
        case 3:
        LineStatus->Caption = "Connected! GSM";
        break;
        case 98:
        LineStatus->Caption = "Connected! G726-32";
        break;
        case 100:
        LineStatus->Caption = "Connected! iLBC 20ms";
        break;
        case 101:
        LineStatus->Caption = "Connected! iLBC 30ms";
        break;
        case 102:
        LineStatus->Caption = "Connected! Speex";
        break;
        default:
       LineStatus->Caption = "Connected!";
        break;
       }

}
//---------------------------------------------------------------------------
void __fastcall TForm1::GTSIPAPI1RecvRegStatus(TObject *Sender,
      long ChanID, long ResType, long StatusCode)
{
        RegStatus->Caption = GTSIPAPI1->CFGGetValue(WideString("gtsrv.sip.reg1.username"), WideString("NO SIP Account"));
        if(ResType == 1)
        {
                RegStatus->Caption += " Registered successfully!";
        }
        else
        {
                RegStatus->Caption += " Registered failed!";
        }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnDialClick(TObject *Sender)
{
        if(btnDial->Caption == "Answer")
        {
                //asnwer the call
                GTSIPAPI1->SendAnswer(0);
        }
        else
        {
                char sTemp[255];
                if(strstr(SIPAddr->Text.c_str(), "@"))
                {
                        sprintf(sTemp, "<sip:%s>",  SIPAddr->Text.c_str());
                }
                else
                {
                        if(strstr(SIPAddr->Text.c_str(), "."))  //ip address or domian name
                                sprintf(sTemp, "<sip:%s>",  SIPAddr->Text.c_str());
                        else
                                sprintf(sTemp, "<sip:%s@pcbest.net>",  SIPAddr->Text.c_str());
                }
                GTSIPAPI1->SendMake(0, WideString(sTemp), WideString(""));
        }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnHungupClick(TObject *Sender)
{
        GTSIPAPI1->SendHungUp(0);        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnNum1Click(TObject *Sender)
{
        SIPAddr->Text = SIPAddr->Text + "1";
        GTSIPAPI1->PlayNumberTone('1');
        if(GTSIPAPI1->GetChanStatus(0) != 0) //not idle
                GTSIPAPI1->SendPlayDTMFStr(0, WideString("1"));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnNum2Click(TObject *Sender)
{
        SIPAddr->Text = SIPAddr->Text + "2";
        GTSIPAPI1->PlayNumberTone('2');
        if(GTSIPAPI1->GetChanStatus(0) != 0) //not idle
                GTSIPAPI1->SendPlayDTMFStr(0, WideString("2"));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnNum3Click(TObject *Sender)
{
        SIPAddr->Text = SIPAddr->Text + "3";
        GTSIPAPI1->PlayNumberTone('3');
        if(GTSIPAPI1->GetChanStatus(0) != 0) //not idle
                GTSIPAPI1->SendPlayDTMFStr(0, WideString("3"));

}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnNum4Click(TObject *Sender)
{
        SIPAddr->Text = SIPAddr->Text + "4";
        GTSIPAPI1->PlayNumberTone('4');
        if(GTSIPAPI1->GetChanStatus(0) != 0) //not idle
                GTSIPAPI1->SendPlayDTMFStr(0, WideString("4"));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnNum5Click(TObject *Sender)
{
        SIPAddr->Text = SIPAddr->Text + "5";
        GTSIPAPI1->PlayNumberTone('5');
        if(GTSIPAPI1->GetChanStatus(0) != 0) //not idle
                GTSIPAPI1->SendPlayDTMFStr(0, WideString("5"));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnNum6Click(TObject *Sender)
{
        SIPAddr->Text = SIPAddr->Text + "6";
        GTSIPAPI1->PlayNumberTone('6');
        if(GTSIPAPI1->GetChanStatus(0) != 0) //not idle
                GTSIPAPI1->SendPlayDTMFStr(0, WideString("6"));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnNum7Click(TObject *Sender)
{
        SIPAddr->Text = SIPAddr->Text + "7";
        GTSIPAPI1->PlayNumberTone('7');
        if(GTSIPAPI1->GetChanStatus(0) != 0) //not idle
                GTSIPAPI1->SendPlayDTMFStr(0, WideString("7"));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnNum8Click(TObject *Sender)
{
        SIPAddr->Text = SIPAddr->Text + "8";
        GTSIPAPI1->PlayNumberTone('8');
        if(GTSIPAPI1->GetChanStatus(0) != 0) //not idle
                GTSIPAPI1->SendPlayDTMFStr(0, WideString("8"));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnNum9Click(TObject *Sender)
{
        SIPAddr->Text = SIPAddr->Text + "9";
        GTSIPAPI1->PlayNumberTone('9');
        if(GTSIPAPI1->GetChanStatus(0) != 0) //not idle
                GTSIPAPI1->SendPlayDTMFStr(0, WideString("9"));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnStarClick(TObject *Sender)
{
        SIPAddr->Text = SIPAddr->Text + "*";
        GTSIPAPI1->PlayNumberTone('*');
        if(GTSIPAPI1->GetChanStatus(0) != 0) //not idle
                GTSIPAPI1->SendPlayDTMFStr(0, WideString("*"));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnNum0Click(TObject *Sender)
{
        SIPAddr->Text = SIPAddr->Text + "0";
        GTSIPAPI1->PlayNumberTone('0');
        if(GTSIPAPI1->GetChanStatus(0) != 0) //not idle
                GTSIPAPI1->SendPlayDTMFStr(0, WideString("0"));

}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnPoundClick(TObject *Sender)
{
        SIPAddr->Text = SIPAddr->Text + "#";
        GTSIPAPI1->PlayNumberTone('#');
        if(GTSIPAPI1->GetChanStatus(0) != 0) //not idle
                GTSIPAPI1->SendPlayDTMFStr(0, WideString("#"));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnChangeSoundDeviceClick(TObject *Sender)
{
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.dxsound.device.playback"), \
        WideString(PlaybackDevice->Text));
        GTSIPAPI1->CFGSetValue(WideString("gtsrv.sip.dxsound.device.capture"), \
        WideString(CaptureDevice->Text));
        GTSIPAPI1->SendResetDXAudio(0);
}
//---------------------------------------------------------------------------

