// SIPOutboundBroadcastDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SIPOutboundBroadcast.h"
#include "SIPOutboundBroadcastDlg.h"
#include "SIPOutboundBCEnv.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSIPOutboundBroadcastDlg dialog

CSIPOutboundBroadcastDlg::CSIPOutboundBroadcastDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSIPOutboundBroadcastDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSIPOutboundBroadcastDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_pSIPBCEnv = NULL;
}

void CSIPOutboundBroadcastDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSIPOutboundBroadcastDlg)
	DDX_Control(pDX, IDC_BUTTON_STOP, m_btnStop);
	DDX_Control(pDX, IDC_BUTTON_START, m_btnStart);
	DDX_Control(pDX, IDC_EDIT_ADDR_LIST, m_AddrList);
	DDX_Control(pDX, IDC_EDIT_FN, m_SoundFN);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSIPOutboundBroadcastDlg, CDialog)
	//{{AFX_MSG_MAP(CSIPOutboundBroadcastDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_START, OnButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	ON_BN_CLICKED(IDC_BUTTON_BROWSE, OnButtonBrowse)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSIPOutboundBroadcastDlg message handlers

BOOL CSIPOutboundBroadcastDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_btnStart.EnableWindow(TRUE);
	m_btnStop.EnableWindow(FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSIPOutboundBroadcastDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSIPOutboundBroadcastDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSIPOutboundBroadcastDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSIPOutboundBroadcastDlg::OnButtonStart() 
{
	int i;
	// TODO: Add your control notification handler code here
	m_btnStart.EnableWindow(FALSE);
	if(!m_pSIPBCEnv)
	{
		m_pSIPBCEnv = new CSIPOutboundBCEnv;
		CString fn;
		m_SoundFN.GetWindowText(fn);
		strcpy(m_pSIPBCEnv->m_sAudioFN,	fn);

		for(i=0; i<m_AddrList.GetLineCount(); i++)
		{
			char *p = new char[255];
			int n = m_AddrList.GetLine(i, p, 255);
			p[n] = 0;
			m_pSIPBCEnv->m_addrQueue.PutData(&p);
		}

		if(!m_pSIPBCEnv->StartServer())
			MessageBox("StartServer Failed! Please make sure SIP port is not being used by another application!", "ERROR", MB_OK);

		//then start timer on each channel, so it can process outbound jobs
		//after 1 second, sip server will start call out.
		for(i=0; i<m_pSIPBCEnv->GetTotalChannelNumber(); i++)
		{
			m_pSIPBCEnv->GetSIPCallBCChannel(i)->StartTimer(1000);
		}
	}
	m_btnStop.EnableWindow(TRUE);
}

void CSIPOutboundBroadcastDlg::OnButtonStop() 
{
	// TODO: Add your control notification handler code here
	m_btnStop.EnableWindow(FALSE);
	if(m_pSIPBCEnv)
	{
		m_pSIPBCEnv->StopServer();
		delete m_pSIPBCEnv;
		m_pSIPBCEnv = NULL;
	}
	m_btnStart.EnableWindow(TRUE);
	
}

void CSIPOutboundBroadcastDlg::OnButtonBrowse() 
{
	// TODO: Add your control notification handler code here
	CFileDialog fn(TRUE);

	if(fn.DoModal( ) == IDOK)
	{
		m_SoundFN.SetWindowText(fn.GetPathName());
	}
}

void CSIPOutboundBroadcastDlg::OnDestroy() 
{
	// TODO: Add your message handler code here
	//Stop SIP Server if it is running
	OnButtonStop();

	CDialog::OnDestroy();
	
}
