// SIPOutboundBCEnv.h: interface for the CSIPOutboundBCEnv class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SIPOUTBOUNDBCENV_H__16C1AE70_8D5F_42D3_9ABA_6928B2F49EE5__INCLUDED_)
#define AFX_SIPOUTBOUNDBCENV_H__16C1AE70_8D5F_42D3_9ABA_6928B2F49EE5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "GTAPI_Face.h"

#ifdef USE_GTAPI_NAMESPACE
using namespace GTAPI;
#endif

struct SIPCallBC_Channel : public GTAPI_Channel
{
public:
	SIPCallBC_Channel():GTAPI_Channel(){}
	virtual ~SIPCallBC_Channel(){}

	virtual void OnTimer();
};

class CSIPOutboundBCEnv  : public CGTAPIEnv
{
public:
	CSIPOutboundBCEnv();
	virtual ~CSIPOutboundBCEnv();

	virtual bool StartServer();
	virtual bool StopServer();

	virtual void On_RecvConnected(int ch);
	virtual void On_RecvOffered(int ch, const char* sCaller, const char* sCallee, const char* sDestAddr, \
		const char* sViaAddr, const char* sFromIP, unsigned short nFromPort);
	virtual void On_RecvDialing(int ch, const char* sCaller, const char* sCallee);
	virtual void On_RecvIdle(int ch, int code, const char* desc);
	virtual void On_RecvRinging(int ch);
	virtual void On_RecvRegStatus(int user_id, int status, int regtime);

	virtual void On_RecvAudioPlayDone(int ch, int doneReason, const char* dtmfBuffer);

	virtual GTAPI_Channel* AllocChannels(){return new SIPCallBC_Channel;}
	virtual void FreeChannels(GTAPI_Channel* p){delete ((SIPCallBC_Channel*)p);}

	SIPCallBC_Channel*	GetSIPCallBCChannel(int idx){return (SIPCallBC_Channel*)GetChannel(idx);}

public:
	char m_sAudioFN[255];
	TCQueue<char*> m_addrQueue;
};

#endif // !defined(AFX_SIPOUTBOUNDBCENV_H__16C1AE70_8D5F_42D3_9ABA_6928B2F49EE5__INCLUDED_)
