// SIPOutboundBCEnv.cpp: implementation of the CSIPOutboundBCEnv class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SIPOutboundBroadcast.h"
#include "SIPOutboundBCEnv.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
void SIPCallBC_Channel::OnTimer()
{
	char *pAddr;

	CSIPOutboundBCEnv* pEnv = (CSIPOutboundBCEnv*)pNetClient;
	if(pEnv->m_addrQueue.GetData(&pAddr))
	{
		if(pAddr)
		{
			char destAddr[255];
			_snprintf(destAddr, sizeof(destAddr), "<sip:%s>", pAddr);
			delete []pAddr;
			pEnv->Send_Make(ch_index, destAddr, "<sip:Caller@pcbest.net>");
			return;
		}
	}

	StartTimer(5000);//reset timer, try next time
}


CSIPOutboundBCEnv::CSIPOutboundBCEnv():CGTAPIEnv()
{
	m_sAudioFN[0] = 0;
}

CSIPOutboundBCEnv::~CSIPOutboundBCEnv()
{

}



bool CSIPOutboundBCEnv::StartServer()
{
	//SIP IP Address you want to use on local
	//Leave it unset if you want to listen on all the network interface
	//CFG_SetValue("gtsrv.sip.ip.address", "");

	//SIP Port, default 5060
	CFG_SetValue("gtsrv.sip.ip.port", "5366");

	//RTP PORT
	CFG_SetValue("gtsrv.sip.rtpstartrange", "14000");
	CFG_SetValue("gtsrv.sip.rtpendrange", "15000");

	//Log 
	CFG_SetValue(GTSRV_INI_LOG_LEVEL, "4");
	CFG_SetValue(GTSRV_INI_LOG, "c:\\gtsimplephone.txt");

	//G729 channel number, not support yet
	//CFG_SetValue("gtsrv.sip.g729a.channum", "0");

	//channnel numbers, here we only 64 channel
	CFG_SetValue("gtsrv.sip.boardnum.per.server", "1");
	CFG_SetValue("gtsrv.sip.spannum.per.board", "1");
	CFG_SetValue("gtsrv.sip.channum.per.span", "4");
/*
#We dont recommend you set "gtsrv.sip.channum.per.span" more than 16.
#Sugguested Configuration of CHANNELS, SPANS, and Boards:
#Channels	gtsrv.sip.channum.per.span	gtsrv.sip.spannum.per.board	gtsrv.sip.boardnum.per.server
#4			4				1				1
#8			8				1				1
#16			8				2				1
#24			8				3				1
#32			8				4				1
#40			8				5				1
#64			8				8				1
#128			8				8				2
#256			8				8				4
#512			16				8				4
*/

	//define inbound and outbound channels
	//CFG_SetValue("gtsrv.channel.inbound", "0-0");
	//only accept outbound jobs for this sample
	CFG_SetValue("gtsrv.channel.outbound", "0-63");

	//Internal communication port
	CFG_SetValue(GTSRV_INI_NET_PORT, "8614");

	//Configuration file, if you want to define parameters in a file
	//CFG_SetValue(GTSRV_CFG_FILENAME, "GTCallBC.ini");

	//Application name, it is related to sdk licence
	//Please contact PCBest Network(www.pcbest.net) to get licence info
	SetAppName("GTSIPCallBC");

	//define outbound route, leave them unset if you don't know
	//CFG_SetValue("gtsrv.sip.outbound.via.type", "0");
	//CFG_SetValue("gtsrv.sip.outbound.via.proxy", "");

	//set sip client user info
	//you must get an account from sip service provider first
	/*
	CFG_SetValue("gtsrv.sip.reg.client.num", "1");

	CFG_SetValue("gtsrv.sip.reg1.displayname", m_sipAccDisplayName);
	CFG_SetValue("gtsrv.sip.reg1.username", m_sipAccUserName);
	CFG_SetValue("gtsrv.sip.reg1.domain", m_sipAccDomainName);
	CFG_SetValue("gtsrv.sip.reg1.proxy", m_sipAccProxyName);
	CFG_SetValue("gtsrv.sip.reg1.authorization", m_sipAccAuthName);
	CFG_SetValue("gtsrv.sip.reg1.password", m_sipAccPassword);
	CFG_SetValue("gtsrv.sip.reg1.expire", "3600");
	*/

	bool ret = CGTAPIEnv::StartServer();
	Send_GetRegStatus(0);
	return ret;
}

bool CSIPOutboundBCEnv::StopServer()
{
	return CGTAPIEnv::StopServer();
}


void CSIPOutboundBCEnv::On_RecvConnected(int ch)
{
	CGTAPIEnv::On_RecvConnected(ch);

	//Start to play your voice
	if(strlen(m_sAudioFN))
	{
		Send_PlayAudio(ch, m_sAudioFN, 0, "", 0, 0);
	}
	else
	{
		Send_HangUp(ch, 0, "");
	}
}

void CSIPOutboundBCEnv::On_RecvOffered(int ch, const char* sCaller, const char* sCallee, const char* sDestAddr, \
	const char* sViaAddr, const char* sFromIP, unsigned short nFromPort)
{
	CGTAPIEnv::On_RecvOffered(ch, sCaller, sCallee, sDestAddr, \
	sViaAddr, sFromIP, nFromPort);

	//for outboud, this is impossible route
}

void CSIPOutboundBCEnv::On_RecvDialing(int ch, const char* sCaller, const char* sCallee)
{
	CGTAPIEnv::On_RecvDialing(ch, sCaller, sCallee);
}

void CSIPOutboundBCEnv::On_RecvIdle(int ch, int code, const char* desc)
{
	CGTAPIEnv::On_RecvIdle(ch, code, desc);

	SIPCallBC_Channel* pChan = GetSIPCallBCChannel(ch);

	pChan->StartTimer(5000);
}

void CSIPOutboundBCEnv::On_RecvRinging(int ch)
{
	CGTAPIEnv::On_RecvRinging(ch);
}

void CSIPOutboundBCEnv::On_RecvRegStatus(int user_id, int status, int regtime)
{
	CGTAPIEnv::On_RecvRegStatus(user_id, status, regtime);

	//only outbound calls, no SIP reg info need
}


void CSIPOutboundBCEnv::On_RecvAudioPlayDone(int ch, int doneReason, const char* dtmfBuffer)
{
	if(doneReason == GTAPI_FACE_AUDIO_DONE_PLAY)
	{
		//Played audio done, but the call is still connected, 
		//We hungup call to teminate it
		Send_HangUp(ch, 0, "");
	}
}
