// LogTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "GTCfg.h"
#include "GTLog.h"
#include "GTBase.h"

using namespace GTAPI;
CMutex mtx;
int cnt = 1;

class LogWrite : public CBaseThread
{
public:
	LogWrite(int idx) :CBaseThread() { thread_idx = idx; }
	virtual ~LogWrite(){}
	virtual	bool DoUnblockedLoop()
	{
		int msg_id = 0;

		for(int i=0; i<100; i++)
		{
			{
				CMutexLock alock(mtx);
				msg_id = cnt++;
			}
			CGTLogInterface::Log(GT_LOG_DEBUG, "%d [Thread %d] This is a test message, This is a test message, This is a test message, This is a test message, This is a test message, This is a test message, This is a test message, This is a test message", msg_id, thread_idx);
		}
		Sleep(50);
		return true;
	}

private:
	int thread_idx;
};

int _tmain(int argc, _TCHAR* argv[])
{
	CGTLOGEnv*	pLogEnv = AfxGetGTLogEnv();

	CGTCfgInterface::CFG_SetValue("gtsrv.log.file.number", "20");

	pLogEnv->_Init("c:\\temp\\logtest.txt", GT_LOG_INFO, 1024*1024*100);

	LogWrite** logW = new LogWrite*[3];

	for(int i=0; i<3; i++)
	{
		logW[i] = new LogWrite(i+1);
		logW[i]->TCreate();
	}

	printf("Press a key to exit:\n");
	getchar();

	for(int i=0; i<3; i++)
	{
		logW[i]->TDestroy();

		delete logW[i];
	}

	return 0;
}

