#include <stdio.h>
#include <iostream.h>
#include <conio.h>
#include "GTAPI_Face.h"

using namespace GTAPI;

class PCBestEnv : public CGTAPIEnv
{
public:
	void On_RecvConnected(int ch);
	void On_RecvStatus(int chBegin, int chEnd, int chStatus);
	void On_RecvAudioPlayDone(int ch, int doneReason, const char* dtmfBuffer);
	void On_RecvToneDetected(int ch, int freq);
	void On_RecvSessionProgress(int ch);
	void On_VoiceActivityDetected(int ch, int voice_dir, int voice_on, int level, unsigned int reserved);
	void On_DetectHumanVoiceDone(int ch, int result);
};

void
PCBestEnv::On_RecvSessionProgress(int ch)
{
	// Speech paths connected here!!
	printf( "Progress detected on Channel:%d\n" , ch );
//	if ( ch == 0 )
	{
//		Send_AddTone(1, 1100, 400); //1100HZ for 400ms. T30 standard for caller
//		Send_AddTone(1, 2100, 2400); //2100HZ for 2400ms. T30 standard for callee
//		Send_StartToneDetection(1);
//		Send_DuplexConnect( 0 , 1 );
//		Send_RecordAudio2( 0 , "recording.wav" , 0 , "" , 0 , 0 );
	}
}

void
PCBestEnv::On_RecvToneDetected(int ch, int freq)
{
	Send_StopToneDetection( ch );
	printf( "Detected Freq:%d on Channel:%d\n" , freq , ch );
}

void
PCBestEnv::On_VoiceActivityDetected(int ch, int voice_dir, int voice_on, int level, unsigned int reserved)
{
	 CGTAPIEnv::On_VoiceActivityDetected(ch, voice_dir, voice_on, level, reserved);
	printf( "Detected VAD on Channel:%d\n" , ch );
}

void
PCBestEnv::On_DetectHumanVoiceDone(int ch, int result)
{
	Send_StopToneDetection( ch );
	switch( result)
	{
	case 0:
	printf( "Detected AM on Channel:%d\n" , ch );
	break;

	case 1:
	printf( "Detected Voice on Channel:%d\n" , ch );
	break;

	case -1:
	printf( "Detected Silence on Channel:%d\n" , ch );
	break;

	default:
	printf( "Detected Unknown on Channel:%d\n" , ch );
	break;
	}
}

void
PCBestEnv::On_RecvConnected(int ch)
{
//CGTAPIEnv::On_RecvConnected(ch);

/*	printf( "Got Connected on Channel:%d\n" , ch );

	if ( ch == 1 )
	{
		Send_Make( 0 , "<sip:00862650000@192.168.1.151:5070>" , 0 );
	}
	else*/
	{
		Send_AddTone(1, 1100, 400); //1100HZ for 400ms. T30 standard for caller
		Send_AddTone(1 , 2100, 400); //2100HZ for 2400ms. T30 standard for callee
		Send_StartToneDetection(1);
	//	Send_DuplexConnect( 0 , 1 );
	//	Send_RecordAudio2( 0 , "recording.wav" , 0 , "" , 0 , 0 );
	}
CGTAPIEnv::On_RecvConnected(ch);
}

void
PCBestEnv::On_RecvAudioPlayDone(int ch, int doneReason, const char* dtmfBuffer)
{
	printf( "Got AudioDone\n" );
	GTAPI_Channel *c = GetChannel( ch );
	if ( c && (c->ch_status == GTAPI_Channel::GTAPI_CHANNEL_IDLE) )
		printf( "ch_status = IDLE\n" );
	else
		printf( "ch_status = NOT IDLE\n" );

	printf( "ch_status = %d\n" , c->ch_status );
	Send_GetChanStatus( ch );
}

void
PCBestEnv::On_RecvStatus(int chBegin, int chEnd, int chStatus)
{
	printf( "Begin:%d End:%d Status:%d\n" , chBegin , chEnd , chStatus );
}

int main( int argc , char *argv[] )
{
	PCBestEnv *env = new PCBestEnv();

	
	env->CFG_SetValue(GTSRV_INI_LOG_LEVEL, "0");
	env->CFG_SetValue(GTSRV_INI_LOG, "c:\\test.txt");

	env->CFG_SetValue( "gtsrv.sip.ip.port" , "5060" );
	env->CFG_SetValue( "gtsrv.sip.rtpstartrange" , "8000" );
	env->CFG_SetValue( "gtsrv.sip.rtpendrange" , "9000" );
	env->CFG_SetValue( "gtsrv.sip.prefered.codec" , "0,8" );
	
	//open two channels
	env->CFG_SetValue( "gtsrv.sip.boardnum.per.server" , "1" );
	env->CFG_SetValue( "gtsrv.sip.spannum.per.board" , "1" );
	env->CFG_SetValue( "gtsrv.sip.channum.per.span" , "2" );
	
	env->CFG_SetValue( "gtsrv.sip.use.nat.addr" , "1" );
	env->CFG_SetValue( "gtsrv.sip.callcontrol.auto.answercall" , "0" );
	env->CFG_SetValue( "gtsrv.sip.callcontrol.auto.transfercall" , "1" );
	env->CFG_SetValue( "gtsrv.sip.dtmf.method" , "2" );
	
	//env->CFG_SetValue( "gtsrv.sip.callcontrol.auto.acceptcall" , "0" );
	//env->CFG_SetValue( "gtsrv.sip.callcontrol.auto.ringcall" , "0" );
	//env->CFG_SetValue( "gtsrv.sip.on.rtp.packet" , "0" );
	//env->CFG_SetValue( "gtsrv.sip.conference.room" , "0" );

	env->CFG_SetValue( "gtsrv.sip.on.in.vad" , "1" );
	env->CFG_SetValue( "gtsrv.human.detect.enabled" , "1" );
	env->CFG_SetValue( "gtsrv.human.detect.duration" , "4000" );
	env->CFG_SetValue( "gtsrv.human.detect.voiceon" , "2000" );

	env->CFG_SetValue("gtsrv.sip.server.model", "1");
 
	if ( env->StartServer() )
	{
		printf( "Licensed To:%s\n" , env->GetLicTo() );

		env->Send_Make( 1 , argv[1] , 0 );

		while ( !_kbhit() )
		{
			Sleep( 1000 );
		}

		env->Send_StopAudio( 0 );
		env->Send_HangUp( 0 , 0 , "" );
		env->Send_HangUp( 1 , 0 , "" );

		Sleep( 1000 );
		env->StopServer();
	}


	delete env;

	return 0;
}
