Public Class VBSIPServerAppEnv
    Inherits GTAPIASM.GTAPIEnv

    Public m_pMainWnd As VBSIPServerAppMainForm
    Public m_nCurSel As Integer

    Public m_RTPInCount(4) As Integer
    Public m_RTPOutCount(4) As Integer

    Public Overrides Sub On_RecvConnected(ByVal ch As Integer)
        MyBase.On_RecvConnected(ch)

        Dim nSel As Integer
        Dim LogStr As String

        If ch = 0 Then
            m_pMainWnd.tbSIPAddr1.Enabled = False
            m_pMainWnd.btnDial1.Enabled = True
            m_pMainWnd.btnDial1.Text = "Hangup"
        ElseIf ch = 1 Then
            m_pMainWnd.tbSIPAddr2.Enabled = False
            m_pMainWnd.btnDial2.Enabled = True
            m_pMainWnd.btnDial2.Text = "Hangup"
        ElseIf ch = 2 Then
            m_pMainWnd.tbSIPAddr3.Enabled = False
            m_pMainWnd.btnDial3.Enabled = True
            m_pMainWnd.btnDial3.Text = "Hangup"
        ElseIf ch = 3 Then
            m_pMainWnd.tbSIPAddr4.Enabled = False
            m_pMainWnd.btnDial4.Enabled = True
            m_pMainWnd.btnDial4.Text = "Hangup"
        End If


        nSel = m_nCurSel 'm_pMainWnd.cbxApplicationType.SelectedIndex
        If nSel = 0 Then
            Send_PlayAudio(ch, m_pMainWnd.editSoundFile.Text, Convert.ToInt32(m_pMainWnd.dtmfMaxDigits.Text), m_pMainWnd.dtmfTermStr.Text, Convert.ToInt32(m_pMainWnd.dtmfTimeout.Text), 0)
            LogStr = "Connected! Playing sound " + m_pMainWnd.editSoundFile.Text
            m_pMainWnd.Log(ch, LogStr)
            StartTimer(ch, 2000)
        End If

        If nSel = 1 Then
            Send_RecordAudio(ch, m_pMainWnd.editSoundFile.Text, Convert.ToInt32(m_pMainWnd.dtmfMaxDigits.Text), m_pMainWnd.dtmfTermStr.Text, Convert.ToInt32(m_pMainWnd.dtmfTimeout.Text), 0)
            LogStr = "Connected! Recording sound to " + m_pMainWnd.editSoundFile.Text
            m_pMainWnd.Log(ch, LogStr)
            StartTimer(ch, 2000)
        End If

        If nSel = 2 Then
            Send_HalfConnect(ch, ch)
            m_pMainWnd.Log(ch, "Connected! Echo testing...")
        End If

        If nSel = 3 Then
            If ch = 0 Then
                m_pMainWnd.Log(ch, "Connected! Waiting for next channel to connect.")
            End If
            If ch = 1 Then
                Send_DuplexConnect(0, 1)
                m_pMainWnd.Log(0, "Connected! Chan 1 and 2 are connected!")
                m_pMainWnd.Log(1, "Connected! Chan 1 and 2 are connected!")
            End If

            If ch = 2 Then
                m_pMainWnd.Log(ch, "Connected! Waiting for next channel to connect.")
            End If

            If ch = 3 Then
                Send_DuplexConnect(2, 3)
                m_pMainWnd.Log(2, "Connected! Chan 3 and 4 are connected!")
                m_pMainWnd.Log(3, "Connected! Chan 3 and 4 are connected!")
            End If
        End If

        If nSel = 4 Then
            Send_EnableDTMF(ch, 0, "", 0)
            m_pMainWnd.Log(ch, "Connected! Waiting for DTMF digits.")
        End If

        If nSel = 5 Then
            Send_StartMusicOnHold(ch, m_pMainWnd.editSoundFile.Text, 1, 0)
            LogStr = "Connected! Music On Hold - Playing files in " + m_pMainWnd.editSoundFile.Text
            m_pMainWnd.Log(ch, LogStr)
        End If

        If nSel = 6 Then
            Send_SetChanInConference(0, ch, 1)
            LogStr = "Connected! In conference room."
            m_pMainWnd.Log(ch, LogStr)
        End If

        If nSel = 7 Then
            LogStr = "Connected! Detecting voice..., please talk."
            m_pMainWnd.Log(ch, LogStr)
        End If

        If nSel = 8 Then
            LogStr = "Connected!"
            m_pMainWnd.Log(ch, LogStr)
            m_RTPInCount(ch) = 0
            m_RTPOutCount(ch) = 0
            StartTimer(ch, 1000)
        End If

        If nSel = 9 Then
            LogStr = "Connected! Detecting fax tone..."
            m_pMainWnd.Log(ch, LogStr)
            Send_ClearToneList(ch)
            Send_AddTone(ch, 1100, 400)
            Send_AddTone(ch, 2100, 2200)
            Send_StartToneDetection(ch)
        End If

    End Sub

    Public Overrides Sub On_RecvDialing(ByVal ch As Integer, ByVal sCaller As String, ByVal sCallee As String)
        MyBase.On_RecvDialing(ch, sCaller, sCallee)

        If ch = 0 Then
            m_pMainWnd.tbSIPAddr1.Enabled = False
            m_pMainWnd.btnDial1.Enabled = True
            m_pMainWnd.btnDial1.Text = "Hangup"
        ElseIf ch = 1 Then
            m_pMainWnd.tbSIPAddr2.Enabled = False
            m_pMainWnd.btnDial2.Enabled = True
            m_pMainWnd.btnDial2.Text = "Hangup"
        ElseIf ch = 2 Then
            m_pMainWnd.tbSIPAddr3.Enabled = False
            m_pMainWnd.btnDial3.Enabled = True
            m_pMainWnd.btnDial3.Text = "Hangup"
        ElseIf ch = 3 Then
            m_pMainWnd.tbSIPAddr4.Enabled = False
            m_pMainWnd.btnDial4.Enabled = True
            m_pMainWnd.btnDial4.Text = "Hangup"
        End If

    End Sub

    Public Overrides Sub On_RecvOffered(ByVal ch As Integer, ByVal sCaller As String, ByVal sCallee As String, ByVal sDestAddr As String, ByVal sViaAddr As String, ByVal sFromIP As String, ByVal nFromPort As UShort)
        MyBase.On_RecvOffered(ch, sCaller, sCallee, sDestAddr, sViaAddr, sFromIP, nFromPort)

        If ch = 0 Then
            m_pMainWnd.tbSIPAddr1.Enabled = False
            m_pMainWnd.btnDial1.Enabled = True
            m_pMainWnd.btnDial1.Text = "Hangup"
        ElseIf ch = 1 Then
            m_pMainWnd.tbSIPAddr2.Enabled = False
            m_pMainWnd.btnDial2.Enabled = True
            m_pMainWnd.btnDial2.Text = "Hangup"
        ElseIf ch = 2 Then
            m_pMainWnd.tbSIPAddr3.Enabled = False
            m_pMainWnd.btnDial3.Enabled = True
            m_pMainWnd.btnDial3.Text = "Hangup"
        ElseIf ch = 3 Then
            m_pMainWnd.tbSIPAddr4.Enabled = False
            m_pMainWnd.btnDial4.Enabled = True
            m_pMainWnd.btnDial4.Text = "Hangup"
        End If

        Dim strlog As String
        strlog = "New call from " + sCaller + " to " + sCallee
        m_pMainWnd.Log(ch, strlog)
        Send_Answer(ch)
    End Sub

    Public Overrides Sub On_RecvIdle(ByVal ch As Integer, ByVal code As Integer, ByVal desc As String)
        MyBase.On_RecvIdle(ch, code, desc)
        m_pMainWnd.Log(ch, "IDLE")
        StopTimer(ch)

        If ch = 0 Then
            m_pMainWnd.tbSIPAddr1.Enabled = True
            m_pMainWnd.btnDial1.Enabled = True
            m_pMainWnd.btnDial1.Text = "Dial"
        ElseIf ch = 1 Then
            m_pMainWnd.tbSIPAddr2.Enabled = True
            m_pMainWnd.btnDial2.Enabled = True
            m_pMainWnd.btnDial2.Text = "Dial"
        ElseIf ch = 2 Then
            m_pMainWnd.tbSIPAddr3.Enabled = True
            m_pMainWnd.btnDial3.Enabled = True
            m_pMainWnd.btnDial3.Text = "Dial"
        ElseIf ch = 3 Then
            m_pMainWnd.tbSIPAddr4.Enabled = True
            m_pMainWnd.btnDial4.Enabled = True
            m_pMainWnd.btnDial4.Text = "Dial"
        End If
    End Sub

    Public Overrides Sub On_RecvRinging(ByVal ch As Integer)
        MyBase.On_RecvRinging(ch)
        If ch = 0 Then
            m_pMainWnd.tbSIPAddr1.Enabled = False
            m_pMainWnd.btnDial1.Enabled = True
            m_pMainWnd.btnDial1.Text = "Hangup"
        ElseIf ch = 1 Then
            m_pMainWnd.tbSIPAddr2.Enabled = False
            m_pMainWnd.btnDial2.Enabled = True
            m_pMainWnd.btnDial2.Text = "Hangup"
        ElseIf ch = 2 Then
            m_pMainWnd.tbSIPAddr3.Enabled = False
            m_pMainWnd.btnDial3.Enabled = True
            m_pMainWnd.btnDial3.Text = "Hangup"
        ElseIf ch = 3 Then
            m_pMainWnd.tbSIPAddr4.Enabled = False
            m_pMainWnd.btnDial4.Enabled = True
            m_pMainWnd.btnDial4.Text = "Hangup"
        End If
    End Sub

    Public Overrides Sub On_RecvRegStatus(ByVal user_id As Integer, ByVal status As Integer, ByVal regtime As Integer)
        MyBase.On_RecvRegStatus(user_id, status, regtime)
        Dim sTemp As String
        If status = 1 Then
            sTemp = "VB.NET SIP Server Application Demo --- " + CFG_GetValue("gtsrv.sip.reg1.authorization", "")
        Else
            sTemp = "VB.NET SIP Server Application Demo --- " + CFG_GetValue("gtsrv.sip.reg1.authorization", "") + "XXX!"
        End If
        m_pMainWnd.Text = sTemp
    End Sub

    Public Overrides Sub On_RecvDTMFKeyDown(ByVal ch As Integer, ByVal keyValue As Byte, ByVal ticks As UInteger)
        MyBase.On_RecvDTMFKeyDown(ch, keyValue, ticks)
        Dim strlog As String
        strlog = "Connected! " + Convert.ToChar(keyValue).ToString() + " key down!"
        m_pMainWnd.Log(ch, strlog)
    End Sub

    Public Overrides Sub On_RecvDTMFKeyUp(ByVal ch As Integer, ByVal keyValue As Byte, ByVal ticks As UInteger)
        MyBase.On_RecvDTMFKeyUp(ch, keyValue, ticks)
        Dim strlog As String
        strlog = "Connected! " + Convert.ToChar(keyValue).ToString() + " key up!"
        m_pMainWnd.Log(ch, strlog)
    End Sub

    Public Overrides Sub On_RecvDTMFDone(ByVal ch As Integer, ByVal doneReason As Integer, ByVal dtmfBuf As String)
        MyBase.On_RecvDTMFDone(ch, doneReason, dtmfBuf)

        Send_HangUp(ch, 0, "")
    End Sub

    Public Overrides Sub On_VoiceActivityDetected(ByVal ch As Integer, ByVal voice_dir As Integer, ByVal voice_on As Integer, ByVal level As Integer, ByVal reserved As UInteger)
        MyBase.On_VoiceActivityDetected(ch, voice_dir, voice_on, level, reserved)
        Dim LogStr As String
        If voice_dir = 1 And m_nCurSel = 7 Then
            If voice_on = 1 Then
                LogStr = "Connected! Voice is on."
                m_pMainWnd.Log(ch, LogStr)
            Else
                LogStr = "Connected! Voice is off."
                m_pMainWnd.Log(ch, LogStr)
            End If
        End If

    End Sub

    Public Overrides Function On_ProxyNewCallSession(ByVal pid As UInteger, ByVal sid As UInteger, ByVal msg As UInteger, ByVal fromid As String, ByVal toid As String, ByVal suri As String, ByVal via As String, ByVal saddr As String, ByVal nport As UShort, ByVal bCredit As Boolean) As String
        If m_nCurSel = 10 Then
            Return "<sip:81234@192.168.1.101>" 'here please change it to your own sip address.
        Else
            Return MyBase.On_ProxyNewCallSession(pid, sid, msg, fromid, toid, suri, via, saddr, nport, bCredit)
        End If
    End Function

    Public Overrides Sub On_Timer(ByVal ch As Integer)
        MyBase.On_Timer(ch)
        Dim LogStr As String

        If m_nCurSel = 0 Or m_nCurSel = 1 Then
            Send_GetAudioStatus(ch)

            If GetChannel(ch).ch_status = GTAPIASM.GTAPI_CHANNEL_STATE.CONNECTED Then
                StartTimer(ch, 2000)
            End If
        End If

        If m_nCurSel = 8 Then
            LogStr = "Connected! In RTP packages " + m_RTPInCount(ch).ToString()
            LogStr = LogStr + " Out RTP packages " + m_RTPOutCount(ch).ToString()
            m_pMainWnd.Log(ch, LogStr)

            If GetChannel(ch).ch_status = GTAPIASM.GTAPI_CHANNEL_STATE.CONNECTED Then
                StartTimer(ch, 1000)
            End If
        End If
    End Sub

    Public Overrides Sub On_RecvAudioStatus(ByVal ch As Integer, ByVal resType As Integer, ByVal statusCode As Integer, ByVal OffsetByte As UInteger)
        MyBase.On_RecvAudioStatus(ch, resType, statusCode, OffsetByte)

        Dim LogStr As String

        LogStr = ""

        If m_nCurSel = 0 Then
            If statusCode = 1 Then 'playing
                LogStr = "Connected! Playing sound. Offset bytes now: " + OffsetByte.ToString()
            End If
            If statusCode = 0 Then 'idle
                LogStr = "Connected! Playing done. Offset bytes now: " + OffsetByte.ToString()
            End If
            m_pMainWnd.Log(ch, LogStr)
        End If

        If m_nCurSel = 1 Then
            If statusCode = 2 Then 'recording
                LogStr = "Connected! Recording sound to " + m_pMainWnd.editSoundFile.Text
                LogStr = LogStr + " Offset bytes now: " + OffsetByte.ToString()
            End If
            If statusCode = 0 Then 'idle
                LogStr = "Connected! Recording done "
                LogStr = LogStr + " Offset bytes now: " + OffsetByte.ToString()
            End If
            m_pMainWnd.Log(ch, LogStr)
        End If

    End Sub

    Public Overrides Sub On_RecvRTPPacket(ByVal ch As Integer, ByVal fmt As Integer, ByVal buf As System.IntPtr, ByVal buflen As Integer, ByVal seq As UShort, ByVal timestamp As UInteger, ByVal pSysTime As System.IntPtr)
        MyBase.On_RecvRTPPacket(ch, fmt, buf, buflen, seq, timestamp, pSysTime)

        If m_nCurSel = 8 Then
            m_RTPInCount(ch) = m_RTPInCount(ch) + 1
        End If

    End Sub

    Public Overrides Sub On_SentRTPPacket(ByVal ch As Integer, ByVal fmt As Integer, ByVal buf As System.IntPtr, ByVal buflen As Integer, ByVal seq As UShort, ByVal timestamp As UInteger, ByVal pSysTime As System.IntPtr)
        MyBase.On_SentRTPPacket(ch, fmt, buf, buflen, seq, timestamp, pSysTime)

        If m_nCurSel = 8 Then
            m_RTPOutCount(ch) = m_RTPOutCount(ch) + 1
        End If

    End Sub

    Public Overrides Sub On_RecvToneDetected(ByVal ch As Integer, ByVal freq As Integer)
        MyBase.On_RecvToneDetected(ch, freq)

        If m_nCurSel = 9 Then
            m_pMainWnd.Log(ch, "Connected! Detected Fax")
            Send_StopToneDetection(ch)
        End If
    End Sub
End Class
