'import System.Windows.Forms
Imports System.IO


Public Class VBSIPServerAppMainForm

    Public m_pEnv As VBSIPServerAppEnv

    Private Sub VBSIPServerAppMainForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        cbxApplicationType.Items.Add("Play Sound")
        cbxApplicationType.Items.Add("Record Sound")
        cbxApplicationType.Items.Add("Echo Test")
        cbxApplicationType.Items.Add("Call Bridge")
        cbxApplicationType.Items.Add("DTMF Detector")
        cbxApplicationType.Items.Add("Music On Hold")
        cbxApplicationType.Items.Add("Conference")
        cbxApplicationType.Items.Add("Voice Activity Detection")
        cbxApplicationType.Items.Add("RTP Access")
        cbxApplicationType.Items.Add("Fax Detection")
        'cbxApplicationType.Items.Add("Proxy Calls to ...")

        cbxApplicationType.SelectedIndex = 0

        btnSIPStart.Enabled = True
        btnSIPStop.Enabled = False

        dtmfMaxDigits.Enabled = True
        dtmfTermStr.Enabled = True
        dtmfTimeout.Enabled = True

        dtmfMaxDigits.Text = "0"
        dtmfTermStr.Text = ""
        dtmfTimeout.Text = "0"

        btnDial1.Enabled = False
        btnDial2.Enabled = False
        btnDial3.Enabled = False
        btnDial4.Enabled = False

        tbSIPAddr1.Enabled = False
        tbSIPAddr2.Enabled = False
        tbSIPAddr3.Enabled = False
        tbSIPAddr4.Enabled = False

        editCfg.Text = Directory.GetParent(Application.StartupPath).ToString & "\ini\GTSIPServerApp.ini"
    End Sub

    Private Sub cbxApplicationType_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbxApplicationType.SelectedIndexChanged
        Dim nSel As Integer
        nSel = cbxApplicationType.SelectedIndex
        If nSel = 0 Or nSel = 1 Then
            editSoundFile.Enabled = True
            btnBrowse.Enabled = True
            dtmfMaxDigits.Enabled = True
            dtmfTermStr.Enabled = True
            dtmfTimeout.Enabled = True
        ElseIf nSel = 5 Then
            editSoundFile.Enabled = True
            btnBrowse.Enabled = False
            dtmfMaxDigits.Enabled = False
            dtmfTermStr.Enabled = False
            dtmfTimeout.Enabled = False
        Else
            editSoundFile.Enabled = False
            btnBrowse.Enabled = False
            dtmfMaxDigits.Enabled = False
            dtmfTermStr.Enabled = False
            dtmfTimeout.Enabled = False
        End If
    End Sub

    Private Sub btnSIPStart_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSIPStart.Click

        If (Not File.Exists(editCfg.Text)) Then
            MessageBox.Show("Config file doesn't exist!", "ERROR")
            Return
        End If

        cbxApplicationType.Enabled = False
        editSoundFile.Enabled = False
        btnBrowse.Enabled = False
        btnSIPStart.Enabled = False
        btnSIPStop.Enabled = True
        btnExit.Enabled = False

        dtmfMaxDigits.Enabled = False
        dtmfTermStr.Enabled = False
        dtmfTimeout.Enabled = False

        InitSIPServer(cbxApplicationType.SelectedIndex, editCfg.Text)

        btnDial1.Enabled = True
        btnDial2.Enabled = True
        btnDial3.Enabled = True
        btnDial4.Enabled = True

        tbSIPAddr1.Enabled = True
        tbSIPAddr2.Enabled = True
        tbSIPAddr3.Enabled = True
        tbSIPAddr4.Enabled = True

    End Sub

    Private Sub btnSIPStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSIPStop.Click
        Dim nSel As Integer
        cbxApplicationType.Enabled = True
        nSel = cbxApplicationType.SelectedIndex

        If nSel = 0 Or nSel = 1 Then
            editSoundFile.Enabled = True
            btnBrowse.Enabled = True

            dtmfMaxDigits.Enabled = True
            dtmfTermStr.Enabled = True
            dtmfTimeout.Enabled = True
        ElseIf nSel = 5 Then
            editSoundFile.Enabled = True
            btnBrowse.Enabled = False

            dtmfMaxDigits.Enabled = False
            dtmfTermStr.Enabled = False
            dtmfTimeout.Enabled = False
        Else
            editSoundFile.Enabled = False
            btnBrowse.Enabled = False

            dtmfMaxDigits.Enabled = False
            dtmfTermStr.Enabled = False
            dtmfTimeout.Enabled = False
        End If

        btnSIPStart.Enabled = True
        btnSIPStop.Enabled = False

        btnDial1.Enabled = False
        btnDial2.Enabled = False
        btnDial3.Enabled = False
        btnDial4.Enabled = False

        tbSIPAddr1.Enabled = False
        tbSIPAddr2.Enabled = False
        tbSIPAddr3.Enabled = False
        tbSIPAddr4.Enabled = False

        FreeSIPServer()

        btnExit.Enabled = True
    End Sub

    Private Sub btnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExit.Click
        Close()
    End Sub

    Public Sub InitSIPServer(ByVal nCurSel As Integer, ByVal iniCfgFile As String)
        Dim domainList As String
        domainList = ""

        m_pEnv = New VBSIPServerAppEnv
        m_pEnv.m_nCurSel = nCurSel
        m_pEnv.m_pMainWnd = Me
        m_pEnv.CreateEnv()
        m_pEnv.SetMainWnd(Me.Handle.ToInt32())

        m_pEnv.CFG_SetValue("gtsrv.sip.callcontrol.auto.acceptcall", "1")
        m_pEnv.CFG_SetValue("gtsrv.sip.callcontrol.auto.ringcall", "0")

        If nCurSel = 6 Then
            m_pEnv.CFG_SetValue("gtsrv.sip.server.model", "0")
            m_pEnv.CFG_SetValue("gtsrv.sip.conference.room", "1")
            VBSIPServerAppEnv.confHandle = 0
        Else
            m_pEnv.CFG_SetValue("gtsrv.sip.conference.room", "0")
        End If
        If nCurSel = 7 Then
            m_pEnv.CFG_SetValue("gtsrv.sip.on.in.vad", "1")
        Else
            m_pEnv.CFG_SetValue("gtsrv.sip.on.in.vad", "0")
        End If
        If nCurSel = 8 Then
            'set RTP access
            m_pEnv.CFG_SetValue("gtsrv.sip.on.rtp.packet", "1")
        Else
            m_pEnv.CFG_SetValue("gtsrv.sip.on.rtp.packet", "0")
        End If


        'Configuration file, if you want to define parameters in a file
        m_pEnv.CFG_SetValue("gtsrv.config.filename", iniCfgFile)

        m_pEnv.StartServer()

        m_pEnv.Send_GetRegStatus(0)



        'If m_pEnv.GetDetectedNATType() >= 12 And m_pEnv.CFG_GetIntValue("gtsrv.sip.use.nat.addr", 0) = 0 Then
        'MessageBox.Show("You have a blocked network. You may not be able to make Internet calls. Please config your network or firewall properly, then try again.")
        'End If

        If m_pEnv.m_nCurSel = 6 Then
            'conference call
            'm_pEnv.Send_StartConference(0)
        End If


        'Proxy Init
        'm_pEnv.CFG_SetValue("gtsrv.sip.proxy.sites.num", "1")
        'For i As Integer = 0 To GTAPIASM.GTAPIEnv.GetLocalIPCount()
        'domainList = domainList + GTAPIASM.GTAPIEnv.GetLocalIP(i) + ";"
        'Next i
        'domainList = domainList + m_pEnv.GetMappedPublicSIPIPAddress()
        'm_pEnv.CFG_SetValue("gtsrv.sip.proxy.site1.domain", domainList)
        'm_pEnv.CFG_SetValue("gtsrv.sip.proxy.site1.recordroute", "1")
        'm_pEnv.CFG_SetValue("gtsrv.sip.proxy.site1.udp.relay", "0")

        'm_pEnv.InitProxySites()

    End Sub

    Public Sub FreeSIPServer()
		If m_pEnv.m_nCurSel = 6 Then
			m_pEnv.DestroyConf(VBSIPServerAppEnv.confHandle)
			'm_pEnv.Send_StopConference(0)
		End If

        'm_pEnv.FreeProxySites()
        m_pEnv.StopServer()
        m_pEnv.DestroyEnv()
        m_pEnv = Nothing
    End Sub

    Public Sub Log(ByVal ch As Integer, ByVal info As String)
        If ch = 0 Then
            Chan1Status.Text = info
        End If
        If ch = 1 Then
            Chan2Status.Text = info
        End If
        If ch = 2 Then
            Chan3Status.Text = info
        End If
        If ch = 3 Then
            Chan4Status.Text = info
        End If
    End Sub

    Private Sub btnBrowse_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBrowse.Click
        Dim openFileDialog1 As New OpenFileDialog()
        Dim saveFileDialog1 As New SaveFileDialog()

        openFileDialog1.InitialDirectory = Application.StartupPath
        openFileDialog1.Filter = "wav files (*.wav)|*.wav|All files (*.*)|*.*"
        openFileDialog1.FilterIndex = 2
        openFileDialog1.RestoreDirectory = True

        saveFileDialog1.InitialDirectory = Application.StartupPath
        saveFileDialog1.Filter = "wav files (*.wav)|*.wav|All files (*.*)|*.*"
        saveFileDialog1.FilterIndex = 2
        saveFileDialog1.RestoreDirectory = True

        If cbxApplicationType.SelectedIndex = 0 Then
            If openFileDialog1.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
                editSoundFile.Text = openFileDialog1.FileName
            End If
        Else
            If saveFileDialog1.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
                editSoundFile.Text = saveFileDialog1.FileName
            End If
        End If

    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        If Not (m_pEnv Is Nothing) Then
            m_pEnv.ProcessGTAPIEvent()
        End If
    End Sub

    Private Sub DialButtonPressed(ByVal ch As Integer, byval sAddr as String)
        Dim sDestAddr As String

        Dim apiChan As GTAPIASM.GTAPIChan
        apiChan = m_pEnv.GetChannel(ch)

        If apiChan.ch_status <> GTAPIASM.GTAPI_CHANNEL_STATE.IDLE Then
            m_pEnv.Send_HangUp(ch, 0, "")
            Exit Sub
        End If

        If sAddr.IndexOf("<sip:") = 0 Then
            sDestAddr = sAddr
        ElseIf sAddr.IndexOf("sip:") = 0 Then
            sDestAddr = "<" + sAddr + ">"
        ElseIf sAddr.IndexOf("@") > 0 Then
            sDestAddr = "<sip:" + sAddr + ">"
        ElseIf m_pEnv.CFG_GetValue("gtsrv.sip.reg1.domain", "").Length > 0 Then
            sDestAddr = "<sip:" + sAddr + "@" + m_pEnv.CFG_GetValue("gtsrv.sip.reg1.domain", "") + ">"
        Else
            Exit Sub
        End If

        m_pEnv.Send_Make(ch, sDestAddr, "")

    End Sub

    Private Sub btnDial1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDial1.Click
        DialButtonPressed(0, tbSIPAddr1.Text)
    End Sub

    Private Sub btnDial2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDial2.Click
        DialButtonPressed(1, tbSIPAddr2.Text)
    End Sub

    Private Sub btnDial3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDial3.Click
        DialButtonPressed(2, tbSIPAddr3.Text)
    End Sub

    Private Sub btnDial4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDial4.Click
        DialButtonPressed(3, tbSIPAddr4.Text)
    End Sub

    Private Sub btnBrowseINI_Click(sender As Object, e As EventArgs) Handles btnBrowseINI.Click
        Dim openFileDialog1 As New OpenFileDialog()

        openFileDialog1.InitialDirectory = Directory.GetParent(Application.StartupPath).ToString & "\ini\"
        openFileDialog1.Filter = "ini files (*.ini)|*.ini|All files (*.*)|*.*"
        openFileDialog1.FilterIndex = 2
        openFileDialog1.RestoreDirectory = True


        If openFileDialog1.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
            editCfg.Text = openFileDialog1.FileName
        End If
    End Sub
End Class
