using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace BulkDialer
{
    public partial class Form3 : Form
    {
        public Int64 m_JobID;
        public CallJobInput m_Call;
        public Form1 MainDlg;

        public Form3()
        {
            InitializeComponent();
            m_JobID = 0;
            m_Call = new CallJobInput();
            MainDlg = null;
        }

        private void Form3_Load(object sender, EventArgs e)
        {
            tbJobID.Text = m_JobID.ToString();
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            m_Call.ID = Convert.ToInt64(tbJobID.Text);
            m_Call.Caller = tbCaller.Text;
            m_Call.Callee = tbCallee.Text;
            m_Call.DTMFs = tbDTMFs.Text;
            m_Call.VoiceFiles = tbAudioFile.Text;
            m_Call.dtDelivery = dtPicker.Value;

            if (MainDlg.InsertJob(m_Call) == 1)
            {
                m_Call.ID++;
                tbJobID.Text = m_Call.ID.ToString();
            }

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();
    
            openFileDialog1.InitialDirectory = "c:\\";
            openFileDialog1.Filter = "wav files (*.wav)|*.wav|All files (*.*)|*.*";
            openFileDialog1.FilterIndex = 2;
            openFileDialog1.RestoreDirectory = true;


            if(openFileDialog1.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                tbAudioFile.Text = openFileDialog1.FileName;
            }
        }

    }
}