using System;
using System.Collections.Generic;
using System.Text;

namespace BulkDialer
{
    public class SurveyItem
    {
        public string voice_fn;
        public string []dtmfs;
        public string dtmf_done;

        public SurveyItem()
        {
            voice_fn = "";
            dtmfs = null;
            dtmf_done = "";
        }
    }

    public class CallJob
    {
        public Int64 ID;
        public string Caller;
        public string Callee;
        public DateTime InitTime;
        public DateTime BeginTime;
        public DateTime EndTime;
        public SurveyItem[] Surveys;
        public int ErrorCount;

        public CallJob()
        {
            ID = 0;
            Caller = "";
            Callee = "";
            InitTime = DateTime.Now;
            BeginTime = DateTime.Now;
            EndTime = DateTime.Now;
            Surveys = null;
            ErrorCount = 0;
        }
    }

    public class CallJobInput
    {
        public Int64 ID;
        public string Caller;
        public string Callee;
        public string DTMFs;
        public string VoiceFiles;
        public DateTime dtDelivery;

        public CallJobInput()
        {
            ID = 0;
            Caller = "";
            Callee = "";
            DTMFs = "";
            VoiceFiles = "";
            dtDelivery = DateTime.Now;
        }
    }
}
