unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  uSIPServer, ComObj, OleCtrls, ExtCtrls, StdCtrls, GTSIPCTRLLib_TLB, uIVRServer, syncobjs,
  Menus, ComCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Memo1: TMemo;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Start1: TMenuItem;
    DTMF1: TMenuItem;
    InAudio1: TMenuItem;
    SIPInfo1: TMenuItem;
    RTPPackage1: TMenuItem;
    StatusBar1: TStatusBar;
    Stop1: TMenuItem;
    Channels1: TMenuItem;
    N41: TMenuItem;
    N81: TMenuItem;
    N161: TMenuItem;
    Display1: TMenuItem;
    Off2: TMenuItem;
    Logging1: TMenuItem;
    On2: TMenuItem;
    Off3: TMenuItem;
    On1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Start1Click(Sender: TObject);
    procedure InAudio1Click(Sender: TObject);
    procedure RTPPackage1Click(Sender: TObject);
    procedure SIPInfo1Click(Sender: TObject);
    procedure Stop1Click(Sender: TObject);
    procedure N41Click(Sender: TObject);
    procedure N81Click(Sender: TObject);
    procedure N161Click(Sender: TObject);
    procedure Off2Click(Sender: TObject);
    procedure On2Click(Sender: TObject);
    procedure Off3Click(Sender: TObject);
    procedure On1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Channels: Integer;
    Started: Boolean;
  end;

var
  Form1: TForm1;
  SIPThread: TSIP;
implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
i: Integer;
begin
    SIPThread:= TSIP.Create(True);
    SIPThread.SIP:= TGTSIPAPI.Create(Nil);
    SIPThread.LockSIP:= TCriticalSection.Create;
    SIPThread.DTMFMethod:= '2'; // RTP
    Channels:= 16;
    Started:= False;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
    SIPThread.Terminate;
    Sleep(1000);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
chan: Integer;
s: string;
begin
    if SIPThread = Nil then exit;

    for chan:= 0 to 19 do begin
        if chan > Channels - 1 then begin
            Memo1.Lines[chan]:= '';
            continue;
        end;
        Memo1.Lines[chan] := IntToStr(chan) + ': ' + SIPThread.GetChannelStatus(chan);
    end;
end;

procedure TForm1.Start1Click(Sender: TObject);
var
i: Integer;
begin
    SIPThread.Channels:= Channels;
    SIPThread.Logging:= On2.Checked;

    for i:= 0 to Channels - 1 do
    begin
        SIPThread.IVRThread[i]:= TIVR.Create(True);
        SIPThread.IVRThread[i].chan:= i;
        SIPThread.IVRThread[i].Logging:= On2.Checked;
        SIPThread.IVRThread[i].Resume;
        Memo1.Lines[i] := IntToStr(i) + ': Created';
    end;
    
    SIPThread.Resume;

    Logging1.Enabled:= False;
    Channels1.Enabled:= False;
    DTMF1.Enabled:= False;
    Start1.Enabled:= False;

    Started:= True;

    StatusBar1.SimpleText:='Started ' + IntToStr(Channels) + ' Channels';
end;

procedure TForm1.InAudio1Click(Sender: TObject);
begin
    SIPThread.DTMFMethod:= '0';  // DTMF in Audio
    InAudio1.Checked:= True;
    RTPPackage1.Checked:=False ;
    SIPInfo1.Checked:= False;
end;

procedure TForm1.RTPPackage1Click(Sender: TObject);
begin
    SIPThread.DTMFMethod:= '2';  // DTMF in RTP Package
    RTPPackage1.Checked:= True;
    InAudio1.Checked:= False;
    SIPInfo1.Checked:= False;
end;

procedure TForm1.SIPInfo1Click(Sender: TObject);
begin
     SIPThread.DTMFMethod:= '1';  // DTMF in SIP 'Info'
     SIPInfo1.Checked:= True;
     InAudio1.Checked:= False;
     RTPPackage1.Checked:=False ;
end;

procedure TForm1.Stop1Click(Sender: TObject);
var
i: Integer;
begin
    for i:= 0 to Channels - 1 do
    begin
        SIPThread.IVRThread[i].Terminate;
    end;
     StatusBar1.SimpleText:='Stopping';
end;

procedure TForm1.N41Click(Sender: TObject);
begin
    Channels:= 4;
    N161.Checked:= False;
    N81.Checked:= False;
    N41.Checked:= True;
end;

procedure TForm1.N81Click(Sender: TObject);
begin
    Channels:= 8;
    N161.Checked:= False;
    N81.Checked:= True;
    N41.Checked:= False;
end;

procedure TForm1.N161Click(Sender: TObject);
begin
    Channels:= 16;
    N161.Checked:= True;
    N81.Checked:= False;
    N41.Checked:= False;
end;


procedure TForm1.Off2Click(Sender: TObject);
var
i: Integer;
begin
    Off2.Checked := True;
    On1.Checked:= False;
    Timer1.Enabled:= False;
    for i:= 0 to 19 do begin
        Memo1.Lines[i]:= '';
    end;
end;

procedure TForm1.On2Click(Sender: TObject);
begin
    On2.Checked:= True;
    Off3.Checked:= False;
end;

procedure TForm1.Off3Click(Sender: TObject);
begin
    Off3.Checked:= True;
    On2.Checked:= False;
end;

procedure TForm1.On1Click(Sender: TObject);
begin
     On1.Checked:= True;
     Off2.Checked:= False;
     Timer1.Enabled:= True;
end;

end.
