using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace ProxyCalls
{
    public partial class Form1 : Form
    {
        public CSSIPProxyCallsEnv env;

        public Form1()
        {
            InitializeComponent();
        }

        private void btnStartServer_Click(object sender, EventArgs e)
        {
            btnStartServer.Enabled = false;
            btnStopServer.Enabled = true;
            InitSIPServer();
            timer1.Enabled = true;
        }

        private void btnStopServer_Click(object sender, EventArgs e)
        {
            timer1.Enabled = false;

            btnStartServer.Enabled = true;
            btnStopServer.Enabled = false;
            FreeSIPServer();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            btnStartServer.Enabled = true;
            btnStopServer.Enabled = false;

            timer1.Enabled = false;

            tbForwardAddr.Text = "PC Best<sip:8000@sip.pcbest.net>";
        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            if (btnStopServer.Enabled)
            {
                timer1.Enabled = false;

                btnStartServer.Enabled = true;
                btnStopServer.Enabled = false;
                FreeSIPServer();
            }
            Close();
        }


        public void InitSIPServer()
        {
            env = new CSSIPProxyCallsEnv();
            env.m_pMainWnd = this;
            env.CreateEnv();
            env.SetMainWnd(this.Handle);
            env.m_sForwardingAddr = tbForwardAddr.Text;

            env.CFG_SetValue("gtsrv.sip.server.model", "1"); //server application

            //SIP IP Address you want to use on local
            //Leave it unset if you want to listen on all the network interface
            //CFG_SetValue("gtsrv.sip.ip.address", "");

            //SIP Port, default 5060
            env.CFG_SetValue("gtsrv.sip.ip.port", "5060");

            //RTP PORT
            env.CFG_SetValue("gtsrv.sip.rtpstartrange", "8400");
            env.CFG_SetValue("gtsrv.sip.rtpendrange", "8800");

            //Log
            env.CFG_SetValue("gtsrv.log.level", "4");

            env.CFG_SetValue("gtsrv.log.filename", Application.StartupPath + "\\CSSIPProxy-log.txt");

            //channnel numbers, here we only use 4 channel
            env.CFG_SetValue("gtsrv.sip.boardnum.per.server", "1");
            env.CFG_SetValue("gtsrv.sip.spannum.per.board", "1");
            env.CFG_SetValue("gtsrv.sip.channum.per.span", "4");
            /*
            #We dont recommend you set "gtsrv.sip.channum.per.span" more than 16.
            #Sugguested Configuration of CHANNELS, SPANS, and Boards:
            #Channels	gtsrv.sip.channum.per.span	gtsrv.sip.spannum.per.board	gtsrv.sip.boardnum.per.server
            #4			4				1				1
            #8			8				1				1
            #16			8				2				1
            #24			8				3				1
            #32			8				4				1
            #40			8				5				1
            #64			8				8				1
            #128			8				8				2
            #256			8				8				4
            #512			16				8				4 
            */

            //only use 20ms codecs
            env.CFG_SetValue("gtsrv.sip.prefered.codec", "3,0,8");

            //Internal communication port
            env.CFG_SetValue("gtsrv.net.port", "8934");

            //Configuration file, if you want to define parameters in a file
            //env.CFG_SetValue(GTSRV_CFG_FILENAME, "GTSimpelPhone.ini");

            //Application name, it is related to sdk licence
            //Please contact PCBest Network(www.pcbest.net) to get licence info
            env.SetAppName("CSSIPProxyCalls");

            //define outbound route, leave them unset if you don't know
            //env.CFG_SetValue("gtsrv.sip.outbound.via.type", "0");
            //env.CFG_SetValue("gtsrv.sip.outbound.via.proxy", "");

            //set sip client user info here
            //here it is actually your SIP trunk registration info, means you get this account from other SIP server/proxy,
            //and register to outside SIP server/proxy as a SIP client. 
            //We comment them out here as it is not the purpose of this sample
            //env.CFG_SetValue("gtsrv.sip.reg.client.num", "1");
            //env.CFG_SetValue("gtsrv.sip.reg1.displayname", "Any");
            //env.CFG_SetValue("gtsrv.sip.reg1.username", "12345678");
            //env.CFG_SetValue("gtsrv.sip.reg1.domain", "pcbest.net");
            //env.CFG_SetValue("gtsrv.sip.reg1.proxy", "pcbest.net");
            //env.CFG_SetValue("gtsrv.sip.reg1.authorization", "12345678");
            //env.CFG_SetValue("gtsrv.sip.reg1.password", "************");
            //env.CFG_SetValue("gtsrv.sip.reg1.expire", "3600");

            if (!env.StartServer())
            {
                MessageBox.Show("StartServer failed! Please make sure the SIP port is not being using by another application.");
            }

            //env.Send_GetRegStatus(0);

            //Proxy code start from here:
            env.CFG_SetValue("gtsrv.sip.proxy.sites.num", "1");

            string domains = env.GetMappedPublicSIPIPAddress() + ";";
            domains += GTAPIASM.GTAPIEnv.GetLocalIP(0) + ";";
            domains += "mysipproxy.com"; //fake one. You change it to your own domain if you have

            env.CFG_SetValue("gtsrv.sip.proxy.site1.domain", domains);

            env.CFG_SetValue("gtsrv.sip.proxy.site1.recordroute", "1");
            //env.CFG_SetValue("gtsrv.sip.proxy.site1.udp.relay", "1");

            //if map sip client's Contact address in SIP REGISTER with actual address from network
            env.CFG_SetValue("gtsrv.sip.proxy.site1.map.reg.source", "1");

            env.CFG_SetValue("gtsrv.sip.proxy.site1.check.user.status", "1");

            env.InitProxySites();



        }

        public void FreeSIPServer()
        {
            env.FreeProxySites();
            env.StopServer();
            env.DestroyEnv();
            env = null;
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            env.ProcessGTAPIEvent();
        }

        private void tbForwardAddr_TextChanged(object sender, EventArgs e)
        {
            if (env != null)
                env.m_sForwardingAddr = tbForwardAddr.Text;
        }

    }
}