// ------------------------------------------------------------------
//	File: gtnetcmdclient.h
//
//
// ==================================================================
// IF YOU DO NOT AGREE WITH THE FOLLOWING STATEMENT, YOU MUST 
// PROMPTLY RETURN THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION 
// ("PRODUCT") TO PCBest Networks(www.pcbest.net).
//
// PCBest Networks owns all title and 
// ownership rights to Software.  "Software" means any data processing
// programs (hereinafter "programs") consisting of a series of 
// instructions or statements in object code form, including any 
// systemized collection of data in the form of a data base, and any
// related proprietary materials such as flow charts, logic diagrams, 
// manuals media and listings provided for use with the programs.
// User has no right, express or implied, to transfer, sell, provide
// access to or dispose of Software to any third party without PCBest Networks'
// prior written consent.  User will not copy, reverse assemble,
// reverse engineer, decompile, modify, alter, translate or display
// the Software other than as expressly permitted by PCBest Networks in writing.
// ------------------------------------------------------------------


#if !defined(__GTAPI_NETCMD_CLIENT_TYPES_DEFINITION_H)
#define __GTAPI_NETCMD_CLIENT_TYPES_DEFINITION_H

#include "GTTypes.h"
#include "GTEvent.h"

#ifdef USE_MEM_QUEUE_NETCMD
#include "GTBase.h"
#endif

#ifdef USE_GTAPI_NAMESPACE
namespace GTAPI
{
#endif

//class CBaseSocket;
#ifdef USE_MEM_QUEUE_NETCMD
class GT_DLL_API GTNetCmdClientI : public CGTEventInterface, public CBaseThread
#else
class GT_DLL_API GTNetCmdClientI : public CGTEventInterface
#endif
{
public:
	GTNetCmdClientI():CGTEventInterface(){m_pClientIObj=this;}
	virtual ~GTNetCmdClientI(){m_pClientIObj=0;}

#ifdef USE_MEM_QUEUE_NETCMD
#else
	static bool ConnectTo(const char* IPAddr, int nPort, int serverType = 0);  //0=TCP, 1=UDP
	static bool Disconnect(unsigned int timeout = 200);
	static bool ISServerConnected();
#endif

	static void SendCmdOut(int ch, char* cmd);

	virtual bool InitMicCtrl(){return false;}
	virtual bool FreeMicCtrl(){return false;}
	virtual bool InitSpkCtrl(){return false;}
	virtual bool FreeSpkCtrl(){return false;}

public:
	//Client Side CMD
//Call control command
	static void Send_Make(int ch, const char* calledNum, const char* callerNum);
	static void Send_MakeEx(int ch, const char* sCallee, const char* sCaller, const char* sURI, const char* sContact, const char* sAuthName, const char* sAuthPassword, const char* sDestIP = 0, unsigned short nDestPort = 0);
	static void Send_Answer(int ch);
	static void Send_WaitForCall(int ch);
	//static void Send_HungUp(int ch);
	static void Send_HangUp(int ch, int code, const char* desc);
	static void Send_Hold(int ch);
	static void Send_Transfer(int ch, const char* transTo);
	static void Send_TransferEx(int ch, const char* transTo, int replace_ch);

//SIP 3xx redirect response
	static void Send_Redirect(int ch, const char* redirectTo, const char* respCode, const char* respStr);

	static void Send_Accept(int ch);
	static void Send_Ring(int ch);

	static void Send_SessionProgress(int ch, const char* fn);

//General Status Handle
	static void Send_Handle(int beginCH, int endCH);
	static void Send_GetStatus(int ch=-1);
	static void Send_GetRegStatus(int ch);

//channel status functions. see the definition of On_RecvStatus below.
	static void Send_SetChanStatus(int ch, int status);
	static void Send_GetChanStatus(int ch);

//DTMF Handle
	static void Send_PlayDTMFStr(int ch, const char* str);
	static void Send_EnableDTMF(int ch, int iMaxDigit, const char* termStr, int iMaxTimer);
	static void Send_DisableDTMF(int ch);

//VAD
	static void Send_EnableVAD(int ch);
	static void Send_DisableVAD(int ch);

//Tone Handle
	static void Send_ClearToneList(int ch);
	static void Send_AddTone(int ch, int freq, int duration);
	static void Send_StartToneDetection(int ch);
	static void Send_StopToneDetection(int ch);

//CT_BUS Handle
	static void Send_DuplexConnect(int ch1, int ch2);
	static void Send_DuplexDisconnect(int ch1, int ch2);

	static void Send_RTPDuplexConnect(int ch1, int ch2);
	static void Send_RTPDuplexDisconnect(int ch1, int ch2);

	static void Send_HalfConnect(int chFrom, int chTo);
	static void Send_HalfDisconnect(int chFrom, int chTo);

	static void Send_ProxyConnect(int ch1, int ch2);
	static void Send_ProxyDisconnect(int ch1, int ch2);


//audio control command
	static void Send_PlayAudio(int ch, const char* audioFileName, int iMaxDigit, const char* termStr, int iMaxTimer, unsigned int uStartByte);
	static void Send_RecordAudio(int ch, const char* audioFileName, int iMaxDigit, const char* termStr, int iMaxTimer, unsigned int uStartByte);
	static void Send_RecordAudio2(int ch, const char* audioFileName, int iMaxDigit, const char* termStr, int iMaxTimer, unsigned int uStartByte);
	static void Send_AddAudio(int ch, const char* pAudioName, unsigned int uBeginByte);
	static void Send_ClearAudio(int ch);
	static void Send_StopAudio(int ch);
	static void Send_StopAudioEx(int ch, int opt, const char* reason); //opt = 0 (both), 1(playing), 2(recording)
	static void Send_SetAudioFormat(int ch, GT_UINT audioCode, GT_UINT audioSample, GT_UINT audioBit);
	static void Send_GetAudioStatus(int ch);

	static void Send_ConfPlayAudio(int conf, const char* audioFileName, int iMaxDigit, const char* termStr, int iMaxTimer, unsigned int uStartByte);
	static void Send_ConfRecordAudio(int conf, const char* audioFileName, int iMaxDigit, const char* termStr, int iMaxTimer, unsigned int uStartByte);
	static void Send_ConfRecordAudio2(int conf, const char* audioFileName, int iMaxDigit, const char* termStr, int iMaxTimer, unsigned int uStartByte);
	static void Send_ConfAddAudio(int conf, const char* pAudioName, unsigned int uBeginByte);
	static void Send_ConfClearAudio(int conf);
	static void Send_ConfStopAudio(int conf);
	static void Send_ConfStopAudioEx(int conf, int opt, const char* reason); //opt = 0 (both), 1(playing), 2(recording)
	static void Send_GetConfAudioStatus(int conf);
	static void Send_ConfSetAudioFormat(int conf, GT_UINT audioCode, GT_UINT audioSample, GT_UINT audioBit);

	static void Send_StartDXAudio(int ch);
	static void Send_StopDXAudio(int ch);
	static void Send_ResetDXAudio(int ch);
	static void Send_SetDXAudioVolume(int ch, int speaker, int microphone);

//music on hold
	static void Send_StartMusicOnHold(int ch, const char* sRoot, int bRandom, int maxTime);
	static void Send_StopMusicOnHold(int ch);

//fax control command
	static void Send_TxFax(int ch, char *TxFaxFile, char* TxFaxHeader, char* TxFaxFooter);
	static void Send_RvFax(int ch, char *RvFaxFile, char* RvFaxHeader, char* RvFaxFooter);
	static void Send_AddFax(int ch, const char* sFaxFile);
	static void Send_ClearFax(int ch);
	static void Send_GetFaxStatus(int ch);

//conference
	static void Send_StartConference(int conf);
	static void Send_StopConference(int conf);
	//ch==-1 is DXSound
	//bAdd 0 = off, 1 = on, 2 = monitoring
	static void Send_SetChanInConference(int conf, int ch, int bAdd);

//video
	static void Send_PlayAndRecordVideo(int ch, const char* in_fn, const char* out_fn);
	static void Send_StopVideo(int ch, int flag);

//text message
	static void Send_MessageText(int ch, const char* msgfrom, const char* msgto, const char* content);

	//Client Side Event Handle
	virtual void On_RecvConnected(int ch){}
	virtual void On_RecvOffered(int ch, const char* sCaller, const char* sCallee, const char* sDestAddr, \
		const char* sViaAddr, const char* sFromIP, unsigned short nFromPort){}
	virtual void On_RecvOfferedEx(int ch, const char* sCaller, const char* sCallee, const char* sDestAddr, \
		const char* sViaAddr, const char* sFromIP, unsigned short nFromPort, const char* sOrgSIPTxt, const char* Reserved1, const char* Reserved2, const char* Reserved3){}
	virtual void On_RecvDialing(int ch, const char* sCaller, const char* sCallee){}
	virtual void On_RecvRinging(int ch){}
	virtual void On_RecvSessionProgress(int ch){}
	//virtual void On_RecvSessionProgress(int ch, const char* sdpOwnerAddr, const char* sdpConnAddr, port_t port, int* codecs, void* reserved){}
	virtual void On_RecvIdle(int ch, int code, const char* desc){}

	virtual void On_RecvHolding(int ch, int hold_on){}
	virtual void On_RecvTransfering(int ch, const char* sAddr, const char* sReplaceCallID, const char* sReplaceFromTag, const char* sReplaceToTag){}

	//audio done reason
#define GT_AUDIO_DONE_DTMF_TIMEOUT				0
#define GT_AUDIO_DONE_DTMF_MAX_DIGITS			1
#define GT_AUDIO_DONE_DTMF_DIGIT_DETECTED		2
#define GT_AUDIO_DONE_PLAY						3
#define GT_AUDIO_DONE_RECORD					4
#define GT_AUDIO_DONE_FORCED_STOP				5
	virtual void On_RecvAudioPlayDone(int ch, int doneReason, const char* dtmfBuffer){}
	virtual void On_RecvAudioRecordDone(int ch, int doneReason, const char* dtmfBuffer){}


	//audio status code
#define GT_AUDIO_STATUS_IDLE					0
#define	GT_AUDIO_STATUS_PLAYING					1
#define	GT_AUDIO_STATUS_RECORDING				2
#define	GT_AUDIO_STATUS_STOPPING				3
#define	GT_AUDIO_STATUS_UNAVAILABLE				4

	//audio resource type
#define GT_AUDIO_RES_BOTH						0
#define	GT_AUDIO_RES_IN							1
#define GT_AUDIO_RES_OUT						2

	virtual void On_RecvAudioStatus(int ch, int resType, int statusCode, unsigned long bytesDone){}

	virtual void On_RecvConfAudioStatus(int ch, int resType, int statusCode, unsigned long bytesDone){}
	virtual void On_RecvConfAudioPlayDone(int ch, int doneReason, const char* dtmfBuffer){}
	virtual void On_RecvConfAudioRecordDone(int ch, int doneReason, const char* dtmfBuffer){}

	virtual void On_RecvDXAudioStatus(int ch, int status, const char* fn){}

	//dir = 0 received, 1 = sent
	virtual void On_RTPRawPacket(int ch, int dir, unsigned char* rawData, int dataLen, const char* senderAddr, unsigned short senderPort, unsigned int tick){}

	virtual void On_RecvRTPPacket(int ch, int fmt, char* buf, int buflen, unsigned short seq, unsigned int timestamp, SYSTEMTIME* pSysTime)
	{
		//threads of span
		//must be really fast here
		//do NOT do a lot of things here, please just put it into a queue,
		//then handle it later
	}
	virtual void On_SentRTPPacket(int ch, int fmt, char* buf, int buflen, unsigned short seq, unsigned int timestamp, SYSTEMTIME* pSysTime)
	{
		//threads of span
		//must be really fast here
		//do NOT do a lot of things here, please just put it into a queue,
		//then handle it later
	}
	virtual void On_CaptureDXAudio(int ch, int fmt, char* buf, int buflen, unsigned short seq, unsigned int timestamp, SYSTEMTIME* pSysTime)
	{
		//threads of dx channel
		//must be really fast here
		//do NOT do a lot of things here, please just put it into a queue,
		//then handle it later
	}
	virtual void On_RenderDXAudio(int ch, int fmt, char* buf, int buflen, unsigned short seq, unsigned int timestamp, SYSTEMTIME* pSysTime)
	{
		//threads of dx channel
		//must be really fast here
		//do NOT do a lot of things here, please just put it into a queue,
		//then handle it later
	}

//VAD
//must set "gtsrv.sip.on.in.vad" and "gtsrv.sip.on.out.vad"
	virtual void On_VoiceActivityDetected(int ch, int voice_dir, int voice_on, int level, unsigned int reserved){}


	//DTMF
	//DTMF Done reason clould be:
	// 0 = DTMF_DONE_TIMEOUT,
	// 1 = DTMF_DONE_MAX_DIGITS,
	// 2 = DTMF_DONE_DIGIT_DETECTED,
	virtual void On_RecvDTMFDone(int ch, int reason, const char* dtmfBuf){}
	virtual void On_RecvDTMFKeyDown(int ch, unsigned char keyValue, unsigned long ticks){}
	virtual void On_RecvDTMFKeyUp(int ch, unsigned char keyValue, unsigned long ticks){}

	//Tone
	virtual void On_RecvToneDetected(int ch, int freq){}

	//FAX
	virtual void On_RecvFaxDone(int ch){}
	virtual void On_RecvFaxStatus(int ch, int statusCode){}

	//Status
	//Channel status could be:
	// 0 = GT_CALL_IDLE,
	// 1 = GT_CALL_DIALING,
	// 2 = GT_CALL_RINGING,
	// 3 = GT_CALL_OFFERED,
	// 4 = GT_CALL_CONNECTING,
	// 5 = GT_CALL_CONNECTED,
	// 6 = GT_CALL_DISCONNECTING,
	// 7 = GT_CALL_RELEASING,
	// 8 = GT_CALL_NOT_AVAILABLE,  //When span is not up
	// 9 = GT_CALL_OFF_LINE,   // when resource is limited
	// 10 = GT_CALL_MARKED_BUSY, //when mannually marked busy or maint
	// 11 = GT_CALL_RESERVED, //reserved
	virtual void On_RecvStatus(int chBegin, int chEnd, int chStatus){}

	//user_id is the index of your SIP account.
	//status: 1 = successfully registered. 0 = not registered.
	//regtime: Seconds of how long it registered to SIP server
	virtual void On_RecvRegStatus(int user_id, int status, int regtime){}
	virtual void On_RecvSubscribeStatus(int id, int status, int regtime){}

	virtual void On_RecvError(int ch, int errCode){}

	virtual void On_RecvNotifySimpleMsgSummary(const char* sMsgWaiting, const char* sMsgAccount, const char* sVoiceMsg){}
	virtual void On_RecvNotifyPresence(int id, const char* subscription_state, const char* content_type, const char* content_info){}
	virtual void On_RecvMessageText(int ch, const char* sFrom, const char* sTo, const char* sDestAddr, \
		const char* sViaAddr, const char* sContent){}
	virtual void On_RecvMessageTextDelivered(int ch, int msg_code, const char* msg_txt){}

#ifdef USE_MEM_QUEUE_NETCMD
	virtual				bool DoUnblockedLoop(){CGTEventInterface::ProcessEvent(); Sleep(5); return true;}
	virtual void		ProcessEvent(TGTEvent* pevent);
#endif

public:
	static GTNetCmdClientI* m_pClientIObj;
};


#ifdef USE_GTAPI_NAMESPACE
}
#endif

#endif