// ------------------------------------------------------------------
//	File: gtlog.h
//
//
// ==================================================================
// IF YOU DO NOT AGREE WITH THE FOLLOWING STATEMENT, YOU MUST 
// PROMPTLY RETURN THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION 
// ("PRODUCT") TO PCBest Networks(www.pcbest.net).
//
// PCBest Networks owns all title and 
// ownership rights to Software.  "Software" means any data processing
// programs (hereinafter "programs") consisting of a series of 
// instructions or statements in object code form, including any 
// systemized collection of data in the form of a data base, and any
// related proprietary materials such as flow charts, logic diagrams, 
// manuals media and listings provided for use with the programs.
// User has no right, express or implied, to transfer, sell, provide
// access to or dispose of Software to any third party without PCBest Networks'
// prior written consent.  User will not copy, reverse assemble,
// reverse engineer, decompile, modify, alter, translate or display
// the Software other than as expressly permitted by PCBest Networks in writing.
// ------------------------------------------------------------------


#if !defined(__GTAPI_LOG_INTERFACE_DEFINITION_H)
#define __GTAPI_LOG_INTERFACE_DEFINITION_H

#include "GTTypes.h"

#define GT_LOG_DISABLE					0
#define GT_LOG_ERROR					1
#define GT_LOG_ALERT					2
#define GT_LOG_DEBUG					3
#define GT_LOG_INFO						4

#define GT_LOG_GROUP_SERVER				0x0010
#define GT_LOG_GROUP_BOARD				0x0100
#define GT_LOG_GROUP_SPAN				0x0200
#define GT_LOG_GROUP_CHAN				0x0300
#define GT_LOG_GROUP_CALL				0x0400
#define GT_LOG_GROUP_CALL_CONTROL		0x0401
#define GT_LOG_GROUP_CALL_FAX			0x0402
#define GT_LOG_GROUP_CALL_VOICE			0x0403
#define GT_LOG_GROUP_CALL_DTMF			0x0404
#define GT_LOG_GROUP_EVENTHANDLE		0x0500
#define GT_LOG_GROUP_DSP				0x0600
#define GT_LOG_GROUP_NET				0x0700
#define GT_LOG_GROUP_SIP				0x0800

#define	GT_LOG_MAX_BYTES_PER_LINE		1024
//#define GT_MAX_LOG_INFO_LEN				GT_LOG_MAX_BYTES_PER_LINE


//typedef GT_BOOL GT_LOG_Start_PRC();
//typedef GT_BOOL GT_LOG_Stop_PRC();

//typedef GT_BOOL GT_LOG_SetLogLevel_PRC(int level);
	
typedef void GT_LOG_EnterFunctionG_PRC(int group, const char *funcname);
typedef void GT_LOG_EnterFunction_PRC(const char *funcname);

//typedef void GT_LOG_Trace_PRC(int nTraceLevel,const char* Format, ... );
//typedef void GT_LOG_TraceG_PRC(int group, int nTraceLevel,const char* Format, ... );

typedef void GT_LOG_Trace_PRC(int nTraceLevel,const char* sLog);
typedef void GT_LOG_TraceG_PRC(int group, int nTraceLevel, const char* sLog);


typedef void GT_LOG_ExitFunction_PRC(const char* funcname );
typedef void GT_LOG_ExitFunctionG_PRC(int group, const char* funcname);

//typedef void GT_LOG_ActivateThread_PRC(const char *threadname = 0);
//typedef void GT_LOG_DeactivateThread_RPC();

//typedef void GT_LOG_ActivateGroup_PRC(int group, const char *GroupName = GT_NULL);
//typedef void GT_LOG_DeactivateGroup_PRC(int group);

typedef void GT_LOG_Init(const char *logFilename, GT_UINT logLevel, GT_UINT maxFileSize);
typedef void GT_LOG_Free();


#ifdef USE_GTAPI_NAMESPACE
namespace GTAPI
{
#endif

	struct CGTLOGEnv
	{
		GT_LOG_Init*						_Init;
		GT_LOG_Free*						_Free;
//		GT_LOG_Start_PRC*					_Start;
//		GT_LOG_Stop_PRC*					_Stop;
//		GT_LOG_SetLogLevel_PRC*				_SetLogLevel;
		GT_LOG_EnterFunction_PRC*			_EnterFunction;
		GT_LOG_EnterFunctionG_PRC*			_EnterFunctionG;
		GT_LOG_Trace_PRC*					_Log;
		GT_LOG_TraceG_PRC*					_LogG;
		GT_LOG_ExitFunction_PRC*			_ExitFunction;
		GT_LOG_ExitFunctionG_PRC*			_ExitFunctionG;
//		GT_LOG_ActivateThread_PRC*			_ActivateThread;
//		GT_LOG_DeactivateThread_RPC*		_DeactivateThread;
//		GT_LOG_ActivateGroup_PRC*			_ActivateGroup;
//		GT_LOG_DeactivateGroup_PRC*			_DeactivateGroup;

		CGTLOGEnv(){_Init=GT_NULL;_Free=GT_NULL;_EnterFunction=GT_NULL;_EnterFunctionG=GT_NULL;
		_Log=GT_NULL;_LogG=GT_NULL;_ExitFunction=GT_NULL;_ExitFunctionG=GT_NULL;}

		CGTLOGEnv(GT_LOG_Init* pinit, GT_LOG_Free* pfree, GT_LOG_EnterFunction_PRC* pent, GT_LOG_EnterFunctionG_PRC* pentG,
		GT_LOG_Trace_PRC* plog, GT_LOG_TraceG_PRC* plogG, GT_LOG_ExitFunction_PRC* pexit, GT_LOG_ExitFunctionG_PRC* pexitG)
		{
			_Init=pinit;
			_Free=pfree;
			_EnterFunction=pent;
			_EnterFunctionG=pentG;
			_Log=plog;
			_LogG=plogG;
			_ExitFunction=pexit;
			_ExitFunctionG=pexitG;
		}
	};

	GT_DLL_API CGTLOGEnv*					AfxGetGTLogEnv();
	GT_DLL_API void							AfxSetGTLogEnv(CGTLOGEnv* pLog);

	class GT_DLL_API CGTLogInterface
	{
	public:
		static void EnterFunction(int group, const char *funcname);
		static void EnterFunction(const char *funcname);

		static void Log(int nTraceLevel,const char* Format, ... );
		static void Log(int group, int nTraceLevel,const char* Format, ... );

		static void ExitFunction(const char* funcname = GT_NULL);
		static void ExitFunction(int group, const char* funcname = GT_NULL);
	};


#ifdef USE_GTAPI_NAMESPACE
}
#endif

#endif