// ------------------------------------------------------------------
//	File: gtapi_face2.h
//
//	Description:	This header file is DLL 'C' file that
//                includes all of the required header files for developing
//				   a SIP project.
//
// ==================================================================
// IF YOU DO NOT AGREE WITH THE FOLLOWING STATEMENT, YOU MUST 
// PROMPTLY RETURN THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION 
// ("PRODUCT") TO PCBest Networks(www.pcbest.net).
//
// PCBest Networks owns all title and 
// ownership rights to Software.  "Software" means any data processing
// programs (hereinafter "programs") consisting of a series of 
// instructions or statements in object code form, including any 
// systemized collection of data in the form of a data base, and any
// related proprietary materials such as flow charts, logic diagrams, 
// manuals media and listings provided for use with the programs.
// User has no right, express or implied, to transfer, sell, provide
// access to or dispose of Software to any third party without PCBest Networks'
// prior written consent.  User will not copy, reverse assemble,
// reverse engineer, decompile, modify, alter, translate or display
// the Software other than as expressly permitted by PCBest Networks in writing.
// ------------------------------------------------------------------



#ifndef GTAPI_HIGH_LEVEL_INTERFACE_HEAD_FILE2
#define GTAPI_HIGH_LEVEL_INTERFACE_HEAD_FILE2

#include "GTTypes.h"

#ifdef __BORLANDC__
typedef struct waveformat_tag {
  WORD  wFormatTag;
  WORD  nChannels;
  DWORD nSamplesPerSec;
  DWORD nAvgBytesPerSec;
  WORD  nBlockAlign;
} WAVEFORMAT;

typedef struct {
  WAVEFORMAT wf;
  WORD       wBitsPerSample;
} PCMWAVEFORMAT;
#endif



typedef void (GT_CALLBACK *GTAPI_CB_On_RecvConnected)(int ch);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvOffered)(int ch, const char* sCaller, const char* sCallee, const char* sDestAddr, \
		const char* sViaAddr, const char* sFromIP, unsigned short nFromPort);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvOfferedEx)(int ch, const char* sCaller, const char* sCallee, const char* sDestAddr, \
		const char* sViaAddr, const char* sFromIP, unsigned short nFromPort, const char* OrgSIPTxt, const char* Reserved1, const char* Reserved2, const char* Reserved3);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvDialing)(int ch, const char* sCaller, const char* sCallee);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvIdle)(int ch, int code, const char* desc);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvRinging)(int ch);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvSessionProgress)(int ch);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvRegStatus)(int user_id, int status, int regtime);


typedef void (GT_CALLBACK *GTAPI_CB_On_RecvStatus)(int chBegin, int chEnd, int chStatus);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvError)(int ch, int errCode);


typedef void (GT_CALLBACK *GTAPI_CB_On_RecvAudioPlayDone)(int ch, int doneReason, const char* dtmfBuffer);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvAudioRecordDone)(int ch, int doneReason, const char* dtmfBuffer);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvAudioStatus)(int ch, int resType, int statusCode, unsigned long bytesDone);

typedef void (GT_CALLBACK *GTAPI_CB_On_RecvConfAudioPlayDone)(int ch, int doneReason, const char* dtmfBuffer);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvConfAudioRecordDone)(int ch, int doneReason, const char* dtmfBuffer);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvConfAudioStatus)(int ch, int resType, int statusCode, unsigned long bytesDone);

typedef void (GT_CALLBACK *GTAPI_CB_On_RecvDTMFDone)(int ch, int doneReason, const char* dtmfBuf);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvDTMFKeyDown)(int ch, unsigned char keyValue, unsigned long ticks);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvDTMFKeyUp)(int ch, unsigned char keyValue, unsigned long ticks);

typedef void (GT_CALLBACK *GTAPI_CB_On_RecvHolding)(int ch, int hold_on);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvTransfering)(int ch, const char* sAddr, const char* sReplaceCallID, const char* sReplaceFromTag, const char* sReplaceToTag);

typedef void (GT_CALLBACK *GTAPI_CB_On_RecvNotifySimpleMsgSummary)(const char* sMsgWaiting, const char* sMsgAccount, const char* sVoiceMsg);

typedef void (GT_CALLBACK *GTAPI_CB_On_Timer)(int ch);

typedef void (GT_CALLBACK *GTAPI_CB_On_RecvRTPPacket)(int ch, int fmt, char* buf, int buflen, unsigned short seq, unsigned int timestamp, SYSTEMTIME* pSysTime);
typedef void (GT_CALLBACK *GTAPI_CB_On_SentRTPPacket)(int ch, int fmt, char* buf, int buflen, unsigned short seq, unsigned int timestamp, SYSTEMTIME* pSysTime);
typedef void (GT_CALLBACK *GTAPI_CB_On_CaptureDXAudio)(int ch, int fmt, char* buf, int buflen, unsigned short seq, unsigned int timestamp, SYSTEMTIME* pSysTime);
typedef void (GT_CALLBACK *GTAPI_CB_On_RenderDXAudio)(int ch, int fmt, char* buf, int buflen, unsigned short seq, unsigned int timestamp, SYSTEMTIME* pSysTime);

typedef void (GT_CALLBACK *GTAPI_CB_On_ProxyUserRegistered)(unsigned int pid, const char* username, unsigned __int64 tnow, unsigned int exp_sec, const char* org_contact, const char* mapped_contact, const char* szUAName, int UANatType, const char* szFromID, const char* szToID, const char* src_ip, unsigned short src_port);

typedef void (GT_CALLBACK *GTAPI_CB_On_ProxyCallTransaction)(unsigned int pid, unsigned int sid, const char *szFrom, const char* szTo, const char* szUri, const char* szVia, const char* szRealContact, unsigned __int64 t_start, unsigned __int64 t_end, int session_status, int result_code, const char* result_txt);

typedef const char*	(GT_CALLBACK *GTAPI_CB_On_ProxyNewCallSession)(unsigned int pid, unsigned int sid, GT_HANDLE msg, const char* authid, const char* fromid, const char* toid, const char* suri, const char* via, const char* saddr, unsigned short nport, int bCredit);

typedef void (GT_CALLBACK *GTAPI_CB_On_ProxyCallSessionStatus)(unsigned int pid, unsigned int sid, unsigned __int64 sbegin, unsigned __int64 send, \
		int status, const char* szFrom, const char* szTo, const char* szURI, const char* szVia, const char* szRealContact);

typedef void (GT_CALLBACK *GTAPI_CB_On_RecvSubscribeStatus)(int id, int status, int regtime);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvNotifyPresence)(int id, const char* subscription_state, const char* content_type, const char* content_info);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvMessageText)(int ch, const char* sFrom, const char* sTo, const char* sDestAddr, const char* sViaAddr, const char* sContent);
typedef void (GT_CALLBACK *GTAPI_CB_On_RecvMessageTextDelivered)(int ch, int msg_code, const char* msg_txt);

typedef void (GT_CALLBACK *GTAPI_CB_On_VoiceActivityDetected)(int ch, int voice_dir, int voice_on, int level, unsigned int reserved);

typedef void (GT_CALLBACK *GTAPI_CB_On_DetectHumanVoiceDone)(int ch, int result);

typedef void (GT_CALLBACK *GTAPI_CB_On_RecvNoAudio)(int ch, int reserved);

typedef void (GT_CALLBACK *GTAPI_CB_On_RecvDXAudioStatus)(int ch, int status, const char* fn);

typedef void (GT_CALLBACK *GTAPI_CB_On_RecvToneDetected)(int ch, int freq);

typedef void (GT_CALLBACK *GTAPI_CB_On_SIPMsg)(int dir, const char* src_ip, unsigned short src_port, const char* dest_ip, unsigned short dest_port, char* buf, int len);
typedef void (GT_CALLBACK *GTAPI_CB_On_ProxyUserSubscribed)(unsigned int pid, const char* fromid, const char* toid, const char* suri, const char* via, const char* callid, const char* saddr, unsigned short nport);

typedef void (GT_CALLBACK *GTAPI_CB_On_RTPRawPacket)(int ch, int dir, unsigned char* rawData, int dataLen, const char* senderAddr, unsigned short senderPort, unsigned int tick);

/*
typedef int	(GT_CALLBACK *GTAPI_CB_GetProxyUserValid)(unsigned int pid, const char* username);
typedef const char*	(GT_CALLBACK *GTAPI_CB_GetProxyUserPassword)(unsigned int pid, const char* username);
typedef time_t (GT_CALLBACK *GTAPI_CB_GetProxyUserRegTime)(unsigned int pid, const char* username);
typedef unsigned int (GT_CALLBACK *GTAPI_CB_GetProxyUserRegExpire)(unsigned int pid, const char* username);
typedef const char*	(GT_CALLBACK *GTAPI_CB_GetProxyUserContact)(unsigned int pid, const char* username);
typedef const char*	(GT_CALLBACK *GTAPI_CB_GetProxyUserUAName)(unsigned int pid, const char* username);
typedef int	(GT_CALLBACK *GTAPI_CB_GetProxyUserNATType)(unsigned int pid, const char* username);
*/

//info type: 
// 0 = GetProxyUserValid
// 1 = GetProxyUserPassword
// 2 = GetProxyUserRegTime
// 3 = GetProxyUserRegExpire
// 4 = GetProxyUserContact
// 5 = GetProxyUserUAName
// 6 = GetProxyUserNATType
//typedef const char*	(GT_CALLBACK *GTAPI_CB_GetProxyUserInfo)(int infotype, unsigned int pid, const char* username);


#ifdef __cplusplus
extern "C" 
{
#endif

	void GT_API GTAPI_Create_Env();
	void GT_API GTAPI_Destroy_Env();

	void GT_API GTAPI_SetMainWnd(HWND wnd);

	int GT_API GTAPI_StartServer();
	int GT_API GTAPI_StopServer();

	unsigned int GT_API GTAPI_GetChannelCount();

	unsigned short GT_API GTAPI_GetLocalSIPPort();
	unsigned short GT_API GTAPI_GetLocalRTPPort();

	void	GT_API GTAPI_SetMicVolume(float v);
	float	GT_API GTAPI_GetMicVolume();

	void	GT_API GTAPI_SetSpeakerVolume(float v);
	float	GT_API GTAPI_GetSpeakerVolume();

	void	GT_API GTAPI_SetSpeakerMuteStatus(GT_BOOL bMute);
	GT_BOOL	GT_API GTAPI_GetSpeakerMuteStatus();
	void	GT_API GTAPI_SetMicMuteStatus(GT_BOOL bMute);
	GT_BOOL	GT_API GTAPI_GetMicMuteStatus();

	unsigned int GT_API GTAPI_GetSoundDeviceCount();
	const char* GT_API GTAPI_GetSoundDeviceName(int idx);

	unsigned int GT_API GTAPI_GetRenderDeviceCount();
	const char* GT_API GTAPI_GetRenderDeviceName(int idx);
	GT_BOOL	GT_API GTAPI_IsRenderDevicePrimary(int idx);

	unsigned int GT_API GTAPI_GetCaptureDeviceCount();
	const char* GT_API GTAPI_GetCaptureDeviceName(int idx);
	GT_BOOL	GT_API GTAPI_IsCaptureDevicePrimary(int idx);

	int	GT_API GTAPI_GetDetectedNATType();
	const char*	GT_API GTAPI_GetMappedPublicSIPIPAddress();
	unsigned short GT_API GTAPI_GetMappedPublicSIPIPPort();

	const char*	GT_API GTAPI_GetLocalNetworkIPAddress();

	int GT_API GTAPI_GetLocalIPCount();
	const char* GT_API GTAPI_GetLocalIP(int idx);

	//flag 0 = display name, 1 = username, 2 = domain, 3 = port
	const char* GT_API GTAPI_GetSIPAddressInfo(int flag, const char* sipAddr); 

	const char* GT_API GTAPI_GetLicHWInfo(const char* sAppName, const char* sKey, int nChanNum, const char* sMAC); 
	const char* GT_API GTAPI_GetLicFileName(const char* sAppName);
	const char* GT_API GTAPI_ValidLicHWInfo(const char* sHWInfo);

	const char* GT_API GTAPI_GetChanCallID(int ch);
	const char* GT_API GTAPI_GetChanCallFromTag(int ch);
	const char* GT_API GTAPI_GetChanCallToTag(int ch);
	GT_BOOL	GT_API GTAPI_GetChanCallCredit(int ch);

	const char* GT_API GTAPI_GetPAssertedIdentity(int ch);
	void GT_API GTAPI_SetPAssertedIdentity(int ch, const char* p);

	const char* GT_API GTAPI_GetPChargingVector(int ch);
	void GT_API GTAPI_SetPChargingVector(int ch, const char* p);

	const char* GT_API GTAPI_GetRemotePartyID(int ch);
	void GT_API GTAPI_SetRemotePartyID(int ch, const char* p);

	const char* GT_API GTAPI_GetChanSIPMsg(int ch);

	void GT_API GTAPI_SetChanDir(int ch, int dir); //1 = inbound call only, 2 = outbound call only, 3 = both
	void GT_API GTAPI_SetChanAudioDir(int ch, int dir); //0 = no audio, 1 = send only, 2 = receive only, 3 = both

	void GT_API GTAPI_SetChanConfMask(int ch, unsigned int bitMask);
	void GT_API GTAPI_SetChanSIPAndRTPAddr(int ch, const char* SIPAddrAndPort, const char* RTPAddrAndPort);

	void GT_API GTAPI_SetChanDTMFType(int ch, unsigned int dtmfType); //dtmf method //0 = in audio //1 = sip info //2 = rtp //3 = auto
	unsigned int GT_API GTAPI_GetChanDTMFType(int ch);

	void GT_API GTAPI_SetChanAudioCodec(int ch, int ac);
	int GT_API GTAPI_GetChanAudioCodec(int ch);
	int GT_API GTAPI_GetChanLastMsgCode(int ch);
	const char* GT_API GTAPI_GetChanLastMsgText(int ch);
	const char* GT_API GTAPI_GetChanAudioRecordFileName(int ch);

	GT_BOOL GT_API GTAPI_ReserveChan(int ch, GT_BOOL bReserve);

	int GT_API GTAPI_SetChanUserData(int ch, int idx, unsigned long d);
	int GT_API GTAPI_GetChanUserData(int ch, int idx, unsigned long* d);

	int GT_API GTAPI_SetChanUserStr(int ch, int idx, const char* sVal);
	const char* GT_API GTAPI_GetChanUserStr(int ch, int idx);

	void GT_API GTAPI_SetChanAudioLevel(int ch, float inLevel, float outLevel);

	void GT_API GTAPI_SetChanCallExtraSIPHeader(int ch, const char* s);

	void GT_API GTAPI_StartTimer(int ch, unsigned int milli_sec);
	void GT_API GTAPI_StopTimer(int ch);

	void GT_API GTAPI_SetAppName(const char* sAppName);
	const char* GT_API GTAPI_GetLicTo();

	int GT_API GTAPI_PlayNumTone(char num);
	int GT_API GTAPI_PlayLocalRingSound();
	int GT_API GTAPI_PlayRemoteRingSound();
	int GT_API GTAPI_PlayBusySound();
	int GT_API GTAPI_StopSound();

	//peer node infomation
	const char* GT_API GTAPI_GetPeerSIPIPAddress(int ch);
	unsigned short GT_API GTAPI_GetPeerSIPIPPort(int ch);
	const char* GT_API GTAPI_GetPeerRTPIPAddress(int ch);
	unsigned short GT_API GTAPI_GetPeerRTPIPPort(int ch);
	const char*	GT_API GTAPI_GetPeerSIPContactAddress(int ch);

	//SIP account management
	GT_HANDLE GT_API GTAPI_SIPAccount_Add(const char* dp_name, const char* username, const char *domain, const char* proxy,
		const char* authorization, const char *password, int expire, GT_BOOL bReg, int maxSimultaneousCalls, int retryInterval, GT_BOOL bEnabled, int prot);
	void GT_API GTAPI_SIPAccount_Remove(GT_HANDLE h);
	int	 GT_API GTAPI_SIPAccount_Count();
	int	 GT_API GTAPI_SIPAccount_Index(GT_HANDLE h);
	GT_HANDLE GT_API GTAPI_SIPAccount_Handle(int idx);
	//type = 0 display name 1 = username 2 = domain  3 = proxy  4 = authorization 5 = password
	const char*	 GT_API GTAPI_SIPAccount_Get(int idx, int type);
	void GT_API GTAPI_SIPAccount_Set(int idx, int type, const char* v);
	void GT_API GTAPI_SIPAccount_Enable(GT_HANDLE h, int b);

	void GT_API GTAPI_SIPAccount_Register(int idx, int b);

//Call control command
	void GT_API GTAPI_Send_Make(int ch, const char* calledNum, const char* callerNum);
	void GT_API GTAPI_Send_MakeEx(int ch, const char* sCallee, const char* sCaller, const char* sURI, const char* sContact, const char* sAuthName, const char* sAuthPassword, const char* sDestIP, unsigned short nDestPort);
	void GT_API GTAPI_Send_Answer(int ch);
	void GT_API GTAPI_Send_WaitForCall(int ch);
	void GT_API GTAPI_Send_HangUp(int ch, int code, const char* desc);
	void GT_API GTAPI_Send_Hold(int ch);
	void GT_API GTAPI_Send_Transfer(int ch, const char* transTo);
	void GT_API GTAPI_Send_TransferEx(int ch, const char* transTo, int replace_ch);

	void GT_API GTAPI_Send_Redirect(int ch, const char* redirectTo, const char* respCode, const char* respText);

	void GT_API GTAPI_Send_Accept(int ch);
	void GT_API GTAPI_Send_Ring(int ch);

	void GT_API GTAPI_Send_SessionProgress(int ch, const char* fn);

//General Status Handle
	void GT_API GTAPI_Send_Handle(int beginCH, int endCH);
	void GT_API GTAPI_Send_GetStatus(int ch);
	void GT_API GTAPI_Send_GetRegStatus(int ch);

//channel status functions
	void GT_API GTAPI_Send_GetChanStatus(int ch);
	void GT_API GTAPI_Send_SetChanStatus(int ch, int status);

//DTMF Handle
	void GT_API GTAPI_Send_PlayDTMFStr(int ch, const char* str);
	void GT_API GTAPI_Send_EnableDTMF(int ch, int iMaxDigit, const char* termStr, int iMaxTimer);
	void GT_API GTAPI_Send_DisableDTMF(int ch);

//Tone Detection
	void GT_API GTAPI_Send_ClearToneList(int ch);
	void GT_API GTAPI_Send_AddTone(int ch, int freq, int duration);
	void GT_API GTAPI_Send_StartToneDetection(int ch);
	void GT_API GTAPI_Send_StopToneDetection(int ch);


//VAD
	void GT_API GTAPI_Send_EnableVAD(int ch);
	void GT_API GTAPI_Send_DisableVAD(int ch);

//CT_BUS Handle
	void GT_API GTAPI_Send_DuplexConnect(int ch1, int ch2);
	void GT_API GTAPI_Send_DuplexDisconnect(int ch1, int ch2);

	void GT_API GTAPI_Send_HalfConnect(int chFrom, int chTo);
	void GT_API GTAPI_Send_HalfDisconnect(int chFrom, int chTo);

	void GT_API GTAPI_Send_RTPDuplexConnect(int ch1, int ch2);
	void GT_API GTAPI_Send_RTPDuplexDisconnect(int ch1, int ch2);

	void GT_API GTAPI_Send_ProxyConnect(int ch1, int ch2);
	void GT_API GTAPI_Send_ProxyDisconnect(int ch1, int ch2);

//audio control command
	void GT_API GTAPI_Send_PlayAudio(int ch, const char* audioFileName, int iMaxDigit, const char* termStr, int iMaxTimer, unsigned int uBeginByte);
	void GT_API GTAPI_Send_RecordAudio(int ch, const char* audioFileName, int iMaxDigit, const char* termStr, int iMaxTimer, unsigned int uBeginByte);
	void GT_API GTAPI_Send_RecordAudio2(int ch, const char* audioFileName, int iMaxDigit, const char* termStr, int iMaxTimer, unsigned int uBeginByte);
	void GT_API GTAPI_Send_AddAudio(int ch, const char* pAudioName, unsigned int uBeginByte);
	void GT_API GTAPI_Send_ClearAudio(int ch);
	void GT_API GTAPI_Send_StopAudio(int ch);
	void GT_API GTAPI_Send_StopAudioEx(int ch, int opt, const char* reason);
	void GT_API GTAPI_Send_SetAudioFormat(int ch, GT_UINT audioCode, GT_UINT audioSample, GT_UINT audioBit);
	void GT_API GTAPI_Send_GetAudioStatus(int ch);

//conference audio control command
	void GT_API GTAPI_Send_ConfPlayAudio(int conf, const char* audioFileName, int iMaxDigit, const char* termStr, int iMaxTimer, unsigned int uBeginByte);
	void GT_API GTAPI_Send_ConfRecordAudio(int conf, const char* audioFileName, int iMaxDigit, const char* termStr, int iMaxTimer, unsigned int uBeginByte);
	void GT_API GTAPI_Send_ConfRecordAudio2(int conf, const char* audioFileName, int iMaxDigit, const char* termStr, int iMaxTimer, unsigned int uBeginByte);
	void GT_API GTAPI_Send_ConfAddAudio(int conf, const char* pAudioName, unsigned int uBeginByte);
	void GT_API GTAPI_Send_ConfClearAudio(int conf);
	void GT_API GTAPI_Send_ConfStopAudio(int conf);
	void GT_API GTAPI_Send_ConfStopAudioEx(int conf, int opt, const char* reason); //opt = 0 (both), 1(playing), 2(recording)
	void GT_API GTAPI_Send_GetConfAudioStatus(int conf);
	void GT_API GTAPI_Send_ConfSetAudioFormat(int conf, GT_UINT audioCode, GT_UINT audioSample, GT_UINT audioBit);

	void GT_API GTAPI_Send_StartDXAudio(int ch);
	void GT_API GTAPI_Send_StopDXAudio(int ch);
	void GT_API GTAPI_Send_ResetDXAudio(int ch);
	void GT_API GTAPI_Send_SetDXAudioVolume(int ch, int speaker, int microphone);

//conference
	void GT_API GTAPI_Send_StartConference(int conf);
	void GT_API GTAPI_Send_StopConference(int conf);
	void GT_API GTAPI_Send_SetChanInConference(int conf, int ch, int bAdd);

	GT_HANDLE GT_API GTAPI_CreateConf();
	void GT_API GTAPI_DestroyConf(GT_HANDLE h);
	GT_BOOL GT_API GTAPI_SetChanInConf(GT_HANDLE h, int ch, int bAdd);
	int	GT_API GTAPI_GetConfIndex(GT_HANDLE h);

//music on hold
	void GT_API GTAPI_Send_StartMusicOnHold(int ch, const char* sRoot, int bRandom, int maxTime);
	void GT_API GTAPI_Send_StopMusicOnHold(int ch);

//text
	void GT_API GTAPI_Send_MessageText(int ch, const char* msgfrom, const char* msgto, const char* content);

//video
		void GT_API GTAPI_EnableChanVideo(int ch, GT_BOOL b);
	/*
SQCIF 128  96       =        1
QCIF 176  144       =        2
CIF = 352x288        =        3
4CIF 704  576       =        4
16CIF 1408  1152    =        5

QVGA = 320x240       =        10
VGA = 640x480        =        20
	*/
	void GT_API GTAPI_ShowCameraWnd(GT_BOOL bShow, int resolution);

//Callback functions
	void	GT_API GTAPI_SetCB_On_RecvConnected(GTAPI_CB_On_RecvConnected p);
	void	GT_API GTAPI_SetCB_On_RecvOffered(GTAPI_CB_On_RecvOffered p);
	void	GT_API GTAPI_SetCB_On_RecvOfferedEx(GTAPI_CB_On_RecvOfferedEx p);

	void	GT_API GTAPI_SetCB_On_RecvDialing(GTAPI_CB_On_RecvDialing p);
	void	GT_API GTAPI_SetCB_On_RecvIdle(GTAPI_CB_On_RecvIdle p);
	void	GT_API GTAPI_SetCB_On_RecvRinging(GTAPI_CB_On_RecvRinging p);
	void	GT_API GTAPI_SetCB_On_RecvSessionProgress(GTAPI_CB_On_RecvSessionProgress p);

	void	GT_API GTAPI_SetCB_On_RecvRegStatus(GTAPI_CB_On_RecvRegStatus p);

	void GT_API GTAPI_SetCB_On_RecvStatus(GTAPI_CB_On_RecvStatus p);
	void GT_API GTAPI_SetCB_On_RecvError(GTAPI_CB_On_RecvError p);

	void GT_API GTAPI_SetCB_On_RecvAudioPlayDone(GTAPI_CB_On_RecvAudioPlayDone p);
	void GT_API GTAPI_SetCB_On_RecvAudioRecordDone(GTAPI_CB_On_RecvAudioRecordDone p);
	void GT_API GTAPI_SetCB_On_RecvAudioStatus(GTAPI_CB_On_RecvAudioStatus p);

	void GT_API GTAPI_SetCB_On_RecvConfAudioPlayDone(GTAPI_CB_On_RecvConfAudioPlayDone p);
	void GT_API GTAPI_SetCB_On_RecvConfAudioRecordDone(GTAPI_CB_On_RecvConfAudioRecordDone p);
	void GT_API GTAPI_SetCB_On_RecvConfAudioStatus(GTAPI_CB_On_RecvConfAudioStatus p);

	void GT_API GTAPI_SetCB_On_RecvDTMFDone(GTAPI_CB_On_RecvDTMFDone p);
	void GT_API GTAPI_SetCB_On_RecvDTMFKeyDown(GTAPI_CB_On_RecvDTMFKeyDown p);
	void GT_API GTAPI_SetCB_On_RecvDTMFKeyUp(GTAPI_CB_On_RecvDTMFKeyUp p);

	void GT_API GTAPI_SetCB_On_RecvHolding(GTAPI_CB_On_RecvHolding p);
	void GT_API GTAPI_SetCB_On_RecvTransfering(GTAPI_CB_On_RecvTransfering p);

	void GT_API GTAPI_SetCB_On_RecvNotifySimpleMsgSummary(GTAPI_CB_On_RecvNotifySimpleMsgSummary p);

	void GT_API GTAPI_SetCB_On_RecvSubscribeStatus(GTAPI_CB_On_RecvSubscribeStatus p);
	void GT_API GTAPI_SetCB_On_RecvNotifyPresence(GTAPI_CB_On_RecvNotifyPresence p);
	void GT_API GTAPI_SetCB_On_RecvMessageText(GTAPI_CB_On_RecvMessageText p);
	void GT_API GTAPI_SetCB_On_RecvMessageTextDelivered(GTAPI_CB_On_RecvMessageTextDelivered p);

	void GT_API GTAPI_SetCB_On_Timer(GTAPI_CB_On_Timer p);

	void GT_API GTAPI_SetCB_On_RecvRTPPacket(GTAPI_CB_On_RecvRTPPacket p);
	void GT_API GTAPI_SetCB_On_SentRTPPacket(GTAPI_CB_On_SentRTPPacket p);
	void GT_API GTAPI_SetCB_On_CaptureDXAudio(GTAPI_CB_On_CaptureDXAudio p);
	void GT_API GTAPI_SetCB_On_RenderDXAudio(GTAPI_CB_On_RenderDXAudio p);

	void GT_API GTAPI_SetCB_On_VoiceActivityDetected(GTAPI_CB_On_VoiceActivityDetected p);
	void GT_API GTAPI_SetCB_On_DetectHumanVoiceDone(GTAPI_CB_On_DetectHumanVoiceDone p);

	void GT_API GTAPI_SetCB_On_RecvNoAudio(GTAPI_CB_On_RecvNoAudio p);
	void GT_API GTAPI_SetCB_On_RecvDXAudioStatus(GTAPI_CB_On_RecvDXAudioStatus p);

	void GT_API GTAPI_SetCB_On_RecvToneDetected(GTAPI_CB_On_RecvToneDetected p);
	
	void GT_API GTAPI_SetCB_On_SIPMsg(GTAPI_CB_On_SIPMsg p);
	void GT_API GTAPI_SetCB_On_ProxyUserSubscribed(GTAPI_CB_On_ProxyUserSubscribed p);

	void GT_API GTAPI_SetCB_On_RTPRawPacket(GTAPI_CB_On_RTPRawPacket p);

//configuration functions
	int	GT_API GTAPI_CFG_KeyExists(const char* sKey);
	const char* GT_API GTAPI_CFG_GetValue(const char* sKey, const char* def);
	int GT_API GTAPI_CFG_GetIntValue(const char* sKey, const int def);
	long	GT_API GTAPI_CFG_GetLongValue(const char* sKey, const long def);
	void GT_API GTAPI_CFG_SetValue(const char* sKey, const char* val);

	void GT_API GTAPI_LOG_Trace(int nTraceLevel, const char* info);

#ifndef _WIN32_WCE
	GT_STATUS GT_API GTAPI_ConvertRawAudioToWave(const char *smmRawFileName, PCMWAVEFORMAT* TempFileParameters, const char* smmWAVEFileName);
	GT_STATUS GT_API GTAPI_ConvertWaveToRawAudio(const char *smmWAVEFileName, const char *smmRawFileName, PCMWAVEFORMAT *FileInformation);
#endif
	GT_STATUS GT_API GTAPI_AddWaveHeaderBeforeRec(FILE* hFile, PCMWAVEFORMAT *FileInformation );
	GT_STATUS GT_API GTAPI_ModifyWaveHeaderAfterRec(FILE* hFile, unsigned long ulNumberOfBytesRecorded, int t);

	GT_HANDLE GT_API GTAPI_FILE_Open(const char* fn, const char* wr_attr);
	GT_VOID GT_API GTAPI_FILE_Close(GT_HANDLE h);
	int GT_API GTAPI_FILE_Write(GT_HANDLE h, char* buf, size_t len);

	GT_HANDLE GT_API GTAPI_WAV_FILE_Open(const char* fn, const char* wr_attr, PCMWAVEFORMAT *pcmf);
	GT_VOID GT_API GTAPI_WAV_FILE_Close(GT_HANDLE h);
	GT_BOOL	GT_API GTAPI_WAV_FILE_Valid(const char *fn);

	GT_BOOL GT_API GTAPI_AMULAW2PCM(const char* srcfn, const char* dstfn);

	const char* GT_API GTAPI_UnixTime2Str(unsigned __int64 unix_time);
	unsigned __int64 GT_API GTAPI_Str2UnixTime(const char* time_str);

//memory utilities
	GT_HANDLE GT_API GTAPI_RTMB_Create(GT_BOOL bUseMutex);
	void GT_API	GTAPI_RTMB_Destroy(GT_HANDLE h);
	unsigned long GT_API GTAPI_RTMB_GetDataSize(GT_HANDLE h);
	unsigned long GT_API GTAPI_RTMB_GetData(GT_HANDLE h, char* pbuf, unsigned long bufsize);
	unsigned long GT_API GTAPI_RTMB_PutData(GT_HANDLE h, char* pbuf, unsigned long bufsize);
	void GT_API	GTAPI_RTMB_ResetAll(GT_HANDLE h);

//Timer
	typedef void (*GTAPI_TIMERPROCESS)(void *pData, //the reserved data
		unsigned int idEvent,  // timer identifier
		unsigned int dwTime   // current system time
		);

	GT_HANDLE GT_API GTAPI_TIMER_Create(
			unsigned int nIDEvent,          // timer identifier, can be 0
			GTAPI_TIMERPROCESS lpTimerFunc, // timer callback function. can be NULL. if it is NULL, use GTAPI_TIMER_SetCallBackFunc to set later
			void *pData);                // UserData callback pointer. can be NULL too.

	GT_BOOL GT_API GTAPI_TIMER_SetCallBackFunc(GT_HANDLE hTimer, GTAPI_TIMERPROCESS lpTimerFunc, void* pData);
	void GT_API GTAPI_TIMER_Destroy(GT_HANDLE hTimer);

	#define	GTAPI_TIMER_INFINITE_COUNT				0x7fffffff
	void GT_API GTAPI_TIMER_Start(GT_HANDLE hTimer, 
		unsigned int timerInterval, 
		unsigned int nCount); //can be 1 to maxium value of integer. or GTAPI_TIMER_INFINITE_COUNT

	void GT_API GTAPI_TIMER_Stop(GT_HANDLE hTimer);

//proxy
	void GT_API GTAPI_SetCB_On_ProxyUserRegistered(GTAPI_CB_On_ProxyUserRegistered p);
	void GT_API GTAPI_SetCB_On_ProxyCallTransaction(GTAPI_CB_On_ProxyCallTransaction p);
	void GT_API GTAPI_SetCB_On_ProxyNewCallSession(GTAPI_CB_On_ProxyNewCallSession p);

/*
	void GT_API GTAPI_SetCB_GetProxyUserValid(GTAPI_CB_GetProxyUserValid p);
	void GT_API GTAPI_SetCB_GetProxyUserPassword(GTAPI_CB_GetProxyUserPassword p);
	void GT_API GTAPI_SetCB_GetProxyUserRegTime(GTAPI_CB_GetProxyUserRegTime p);
	void GT_API GTAPI_SetCB_GetProxyUserRegExpire(GTAPI_CB_GetProxyUserRegExpire p);
	void GT_API GTAPI_SetCB_GetProxyUserContact(GTAPI_CB_GetProxyUserContact p);
	void GT_API GTAPI_SetCB_GetProxyUserUAName(GTAPI_CB_GetProxyUserUAName p);
	void GT_API GTAPI_SetCB_GetProxyUserNATType(GTAPI_CB_GetProxyUserNATType p);
*/
//	void GT_API GTAPI_SetCB_GetProxyUserInfo(GTAPI_CB_GetProxyUserInfo p);

	void GT_API GTAPI_SetCB_On_ProxyCallSessionStatus(GTAPI_CB_On_ProxyCallSessionStatus p);

	void GT_API GTAPI_InitProxySites();
	void GT_API GTAPI_FreeProxySites();

	void GT_API GTAPI_ProxySetUserInfo(unsigned int pid, const char* username, const char* passwd, unsigned __int64 regt, unsigned int regex, const char* org_contact, const char* mapped_contact, const char* uaname, int nattype, const char* src_ip, unsigned short src_port, const char* from_id, const char* to_id);
	void GT_API GTAPI_ProxySetUserMsg(unsigned int pid, const char* username, int bMsgWait, const char* sMsgAcct, int cnt1, int cnt2, int cnt3, int cnt4);
	void GT_API GTAPI_ProxyDisableAllUsers(unsigned int pid);
	void GT_API GTAPI_ProxySetUserAuthType(unsigned int pid, const char* username, int authType);
	void GT_API GTAPI_ProxySetUserAttr(unsigned int pid, const char* username, int attr, const char* val);

	//direction can be set to recipient, "initiator"
	//state can be set to:
	//"confirmed" ===> connected
	//"early" ===> ringing
	//"terminated" or "void" ===> idle
	void GT_API GTAPI_ProxyUpdateUserState(unsigned int pid, const char* username, const char* direction, const char* state);

	GT_BOOL GT_API GTAPI_ProxySetNewCallSessionAddr(unsigned int pid, unsigned int sid, const char* sAddr);
	GT_BOOL	GT_API GTAPI_ProxyConnectCallSessions(unsigned int pid1, unsigned int sid1, unsigned int dir1, unsigned int pid2, unsigned int sid2, unsigned int dir2);

////////////registry helper functions for SIPPBX//////////////////////////////
	GT_BOOL	GT_API GTAPI_SaveRegistryKey(unsigned int idx, const char* subkey, const char* fn);
	GT_BOOL	GT_API GTAPI_LoadRegistryKey(unsigned int idx, const char* subkey, const char* fn);


	///////////////////////////////////////////////////////////////////////////////////////////
	//Client/Server Command Communication
	///////////////////////////////////////////////////////////////////////////////////////////
	//EvtID 
	//0 = Client Accepted
	//1 = Client Closed
	//2 = Incoming Command String
	//3 = Outgoing Command String
	//4 = Exception
	typedef void (GT_CALLBACK *GTAPI_CMD_CB_PROCESS)(int EvtID, GT_HANDLE hSocket, const char* sCmd, int nSize, void *pData); 

	GT_HANDLE GT_API GTAPI_CMD_Server_Start(GTAPI_CMD_CB_PROCESS cb_proc, void* pData, unsigned short nPort, const char* sIP, int maxClients);
	GT_VOID GT_API GTAPI_CMD_Server_Stop(GT_HANDLE hCmdSrv);
	GT_BOOL GT_API GTAPI_CMD_Server_Send(GT_HANDLE hCmdSrv, GT_HANDLE hSocket, const char* sCmd, int nSize);

	GT_HANDLE GT_API GTAPI_CMD_Client_Start(GTAPI_CMD_CB_PROCESS cb_proc, void* pData, const char* sIP, unsigned short nPort);
	GT_VOID GT_API GTAPI_CMD_Client_Stop(GT_HANDLE hCmdClient);
	GT_BOOL GT_API GTAPI_CMD_Client_Send(GT_HANDLE hCmdClient, GT_HANDLE hSocket, const char* sCmd, int nSize);

	GT_BOOL	GT_API GTAPI_IsInPrivateIPAddressRange(const char* requestAddr);
	const char*	GT_API GTAPI_IsForLocalPrivateIP(const char* requestAddr);
	GT_BOOL	GT_API GTAPI_IsOneOfLocalIPAddress(const char* requestAddr);

	GT_VOID	GT_API GTAPI_DoRegularRoutine1();
	GT_VOID	GT_API GTAPI_DoRegularRoutine2();

	//Security Functions, type 0 = black list, 1 = white list. act == 1 add, 0 == remove
	GT_BOOL	GT_API GTAPI_SetIPFilter(const char* s, int type, int act);
	GT_INT	GT_API GTAPI_GetIPFilterCount(int type);
	const char*	GT_API GTAPI_GetIPFilterItem(int type, int idx);

#ifdef __cplusplus
}
#endif



#endif
