// StressTestDlg.h : header file
//

#if !defined(AFX_STRESSTESTDLG_H__8C55B7BB_75D6_4A06_8AA4_6C59BA4693D9__INCLUDED_)
#define AFX_STRESSTESTDLG_H__8C55B7BB_75D6_4A06_8AA4_6C59BA4693D9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "GTAPI_FACE.h"

#ifdef USE_GTAPI_NAMESPACE
using namespace GTAPI;
#endif

class CStressTestDlg;

struct NoAudioStatus
{
	time_t					m_noAudioTime;
	int						m_noAudioCount;

	NoAudioStatus()
	{
		m_noAudioTime = 0;
		m_noAudioCount = 0;
	}
};

class CGTSIPStressTestEnv : public CGTAPIEnv
{
public:
	CGTSIPStressTestEnv();
	virtual ~CGTSIPStressTestEnv();

	virtual bool StartServer();
	virtual bool StopServer();

	virtual void On_RecvConnected(int ch);
	virtual void On_RecvOffered(int ch, const char* sCaller, const char* sCallee, const char* sDestAddr, \
		const char* sViaAddr, const char* sFromIP, unsigned short nFromPort);
	virtual void On_RecvDialing(int ch, const char* sCaller, const char* sCallee);
	virtual void On_RecvIdle(int ch, int code, const char* desc);
	virtual void On_RecvRinging(int ch);
//	virtual void On_RecvRegStatus(int user_id, int status, int regtime);

	virtual void On_RecvNoAudio(int ch, int reserved);

	void LogoutCallCount();
	void MakeCallOut(int ch);

	virtual void			OnTimer(int ch);

public:
	CStressTestDlg*			m_pMainDlg;

	char					m_sAudioFileToPlay[255];
	char					m_sAudioRecordRoot[255];
	char					m_sOutboundSIPAddr[255];

	unsigned int			m_appType;

	int						m_CallCount;

	GTAPI::CMutex			m_mtxCount;

	GT_BOOL					m_bServerRunning;

	NoAudioStatus*			m_pNoAudioStatus;

	int						m_callDuration;
};


/////////////////////////////////////////////////////////////////////////////
// CStressTestDlg dialog

class CStressTestDlg : public CDialog
{
// Construction
public:
	CStressTestDlg(CWnd* pParent = NULL);	// standard constructor


	void Log(const char* info);

public:
	CGTSIPStressTestEnv* m_pEnv;

// Dialog Data
	//{{AFX_DATA(CStressTestDlg)
	enum { IDD = IDD_STRESSTEST_DIALOG };
	CEdit	m_editConnectDuration;
	CButton	m_chkLog;
	CButton	m_btnUseNAT;
	CEdit	m_editCodecs;
	CButton	m_btnStopSIP;
	CButton	m_btnStartSIP;
	CStatic	m_LineStatus;
	CEdit	m_editSpans;
	CEdit	m_editSIPPort;
	CEdit	m_editSIPAddr;
	CEdit	m_editRTPPort;
	CEdit	m_editInetPort;
	CEdit	m_editChans;
	CEdit	m_editBoards;
	CEdit	m_editAudioRecordRoot;
	CEdit	m_editAudioFileToPlay;
	CComboBox	m_cbxAppType;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CStressTestDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CStressTestDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnButtonStartSip();
	afx_msg void OnButtonStopSip();
	afx_msg void OnButtonAfBrowse();
	afx_msg void OnButtonRdBrowse();
	afx_msg void OnSelchangeComboAppType();
	afx_msg void OnDestroy();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_STRESSTESTDLG_H__8C55B7BB_75D6_4A06_8AA4_6C59BA4693D9__INCLUDED_)
