// SIPServerAppDlg.h : header file
//

#if !defined(AFX_SIPSERVERAPPDLG_H__DEE645DB_CF24_4B9E_9556_EEEFEB1CD18E__INCLUDED_)
#define AFX_SIPSERVERAPPDLG_H__DEE645DB_CF24_4B9E_9556_EEEFEB1CD18E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CSIPServerAppDlg dialog
//#include <vld.h>

#include "GTAPI_Face.h"

#ifdef USE_GTAPI_NAMESPACE
using namespace GTAPI;
#endif

/*
#define WM_USER        								0x0400
#define WM_SDKAPP_BASE 								(WM_USER+0x0F00)
#define WM_SDKAPP_OFFERED 							WM_SDKAPP_BASE+1
#define WM_SDKAPP_DIALING 							WM_SDKAPP_BASE+2
#define WM_SDKAPP_RINGING 							WM_SDKAPP_BASE+3
#define WM_SDKAPP_CONNECTED							WM_SDKAPP_BASE+4
#define WM_SDKAPP_IDLE								WM_SDKAPP_BASE+5
#define WM_SDKAPP_REGSTATUS							WM_SDKAPP_BASE+6

struct sdkapp_msg
{
	int eventID;
	int chanID;
	CString args[20];
};
*/

class CSIPServerAppDlg;

class CGTSIPServerAppEnv : public CGTAPIEnv
{
public:
	CGTSIPServerAppEnv(const char* cfgFile);
	virtual ~CGTSIPServerAppEnv();

	virtual bool StartServer();
	virtual bool StopServer();

	virtual void On_RecvConnected(int ch);
	virtual void On_RecvOffered(int ch, const char* sCaller, const char* sCallee, const char* sDestAddr, \
		const char* sViaAddr, const char* sFromIP, unsigned short nFromPort);
	virtual void On_RecvDialing(int ch, const char* sCaller, const char* sCallee);
	virtual void On_RecvIdle(int ch, int code, const char* desc);
	virtual void On_RecvRinging(int ch);
	virtual void On_RecvRegStatus(int user_id, int status, int regtime);


	virtual void On_RecvAudioPlayDone(int ch, int doneReason, const char* dtmfBuffer);
	virtual void On_RecvAudioRecordDone(int ch, int doneReason, const char* dtmfBuffer);
	virtual void On_RecvAudioStatus(int ch, int resType, int statusCode, unsigned long bytesDone);

	virtual void On_RecvDTMFDone(int ch, int reason, const char* dtmfBuf);
	virtual void On_RecvDTMFKeyDown(int ch, unsigned char keyValue, unsigned long ticks);
	virtual void On_RecvDTMFKeyUp(int ch, unsigned char keyValue, unsigned long ticks);

	virtual void On_VoiceActivityDetected(int ch, int voice_dir, int voice_on, int level, unsigned int reserved);

	virtual void On_RecvToneDetected(int ch, int freq);

	virtual void			OnTimer(int ch);

public:
	CSIPServerAppDlg*			m_pMainDlg;
	int							m_nCurSel;
	BOOL						m_bStopping;
	char						m_cfgFile[MAX_PATH];
};


class CSIPServerAppDlg : public CDialog
{
// Construction
public:
	CSIPServerAppDlg(CWnd* pParent = NULL);	// standard constructor

	void InitSIPServer(int nCurSel, const char* cfgFile);
	void FreeSIPServer();

	void Log(int ch, const char* info);

	void On_RecvConnected(int ch);
	void On_RecvOffered(int ch, const char* sCaller, const char* sCallee, const char* sDestAddr, \
		const char* sViaAddr, const char* sFromIP, unsigned short nFromPort);
	void On_RecvDialing(int ch, const char* sCaller, const char* sCallee);
	void On_RecvIdle(int ch, int code, const char* desc);
	void On_RecvRinging(int ch);

	void PressDialOrHangup(int ch, CButton* pButton, CEdit* pEdit);

// Dialog Data
	//{{AFX_DATA(CSIPServerAppDlg)
	enum { IDD = IDD_SIPSERVERAPP_DIALOG };
	CEdit	m_editSIPAddr4;
	CEdit	m_editSIPAddr3;
	CEdit	m_editSIPAddr2;
	CEdit	m_editSIPAddr1;
	CButton	m_btnDial4;
	CButton	m_btnDial3;
	CButton	m_btnDial2;
	CButton	m_btnDial1;
	CEdit	m_editDTMFMaxDigits;
	CEdit	m_editDTMFTimeout;
	CEdit	m_editDTMFTermStr;
	CButton	m_btnExit;
	CEdit	m_editCfg;
	CStatic	m_Status4;
	CStatic	m_Status3;
	CStatic	m_Status2;
	CStatic	m_Status1;
	CButton	m_btnFileBrowse;
	CButton	m_btnSIPStop;
	CButton	m_btnSIPStart;
	CEdit	m_SoundFile;
	CComboBox	m_cbxAppType;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSIPServerAppDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;
	CGTSIPServerAppEnv* m_pEnv;

	// Generated message map functions
	//{{AFX_MSG(CSIPServerAppDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnButtonSoundFileBrowse();
	afx_msg void OnButtonSipStart();
	afx_msg void OnButtonSipStop();
	afx_msg void OnSelchangeComboAppType();
	afx_msg void OnButtonDial1();
	afx_msg void OnButtonDial2();
	afx_msg void OnButtonDial3();
	afx_msg void OnButtonDial4();
	//afx_msg LRESULT OnSDKAppMessage(WPARAM wParam, LPARAM lParam);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedButton1();
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SIPSERVERAPPDLG_H__DEE645DB_CF24_4B9E_9556_EEEFEB1CD18E__INCLUDED_)
