// AudioRecordDlg.h : header file
//

#if !defined(AFX_AUDIORECORDDLG_H__94F25B71_CEEB_462A_89F0_D8105FD1D7C4__INCLUDED_)
#define AFX_AUDIORECORDDLG_H__94F25B71_CEEB_462A_89F0_D8105FD1D7C4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CAudioRecordDlg dialog
#include "GTAPI_FACE.h"

#ifdef USE_GTAPI_NAMESPACE
using namespace GTAPI;
#endif

class CAudioRecordDlg;

class CGTSIPAudioRecordEnv : public CGTAPIEnv
{
public:
	CGTSIPAudioRecordEnv();
	virtual ~CGTSIPAudioRecordEnv();

	virtual bool StartServer();
	virtual bool StopServer();

	virtual void On_RecvConnected(int ch);
	virtual void On_RecvOffered(int ch, const char* sCaller, const char* sCallee, const char* sDestAddr, \
		const char* sViaAddr, const char* sFromIP, unsigned short nFromPort);
	virtual void On_RecvDialing(int ch, const char* sCaller, const char* sCallee);
	virtual void On_RecvIdle(int ch, int code, const char* desc);
	virtual void On_RecvRinging(int ch);
	virtual void On_RecvRegStatus(int user_id, int status, int regtime);

	//fmt: 1 = Mulaw, 2 = Alaw, 3 = PCM
	virtual void On_RecvRTPPacket(int ch, int fmt, char* buf, int buflen, unsigned short seq, unsigned int timestamp, SYSTEMTIME* pSysTime);
	virtual void On_SentRTPPacket(int ch, int fmt, char* buf, int buflen, unsigned short seq, unsigned int timestamp, SYSTEMTIME* pSysTime);
	//virtual void On_CaptureDXAudio(int ch, int fmt, char* buf, int buflen, unsigned short seq, unsigned int timestamp, SYSTEMTIME* pSysTime);
	//virtual void On_RenderDXAudio(int ch, int fmt, char* buf, int buflen, unsigned short seq, unsigned int timestamp, SYSTEMTIME* pSysTime);

public:
	CAudioRecordDlg*			m_pMainDlg;
};

class CAudioRecordDlg : public CDialog
{
// Construction
public:
	CAudioRecordDlg(CWnd* pParent = NULL);	// standard constructor

	void Log(const char* info);

	void On_RecvConnected(int ch);
	void On_RecvOffered(int ch, const char* sCaller, const char* sCallee, const char* sDestAddr, \
		const char* sViaAddr, const char* sFromIP, unsigned short nFromPort);
	void On_RecvDialing(int ch, const char* sCaller, const char* sCallee);
	void On_RecvIdle(int ch, int code, const char* desc);
	void On_RecvRinging(int ch);
	void On_RecvRegStatus(int user_id, int status, int regtime);

	CGTSIPAudioRecordEnv m_Env;

	//for recording
	CMutex				m_mtxAudio;
	GT_HANDLE			m_hWavFile;

// Dialog Data
	//{{AFX_DATA(CAudioRecordDlg)
	enum { IDD = IDD_AUDIORECORD_DIALOG };
	CEdit	m_editAddr;
	CEdit	m_editWavFile;
	CStatic	m_staticLog;
	CComboBox	m_cbxChannel;
	CButton	m_btnDial;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAudioRecordDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CAudioRecordDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnButtonDial();
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_AUDIORECORDDLG_H__94F25B71_CEEB_462A_89F0_D8105FD1D7C4__INCLUDED_)
