VERSION 5.00
Object = "{7C974670-6AD1-4A9C-A49D-BC802D5B7925}#1.0#0"; "gtsipctrl.ocx"
Begin VB.Form Form1 
   Caption         =   "SIP Server Demo for PCBest Network SIP SDK"
   ClientHeight    =   9165
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   11625
   LinkTopic       =   "Form1"
   ScaleHeight     =   9165
   ScaleWidth      =   11625
   StartUpPosition =   3  'Windows Default
   Begin VB.Timer Timer1 
      Interval        =   200
      Left            =   8040
      Top             =   8640
   End
   Begin GTSIPCTRLLib.GTSIPAPI GTSIPAPI1 
      Left            =   6720
      Top             =   8640
      _Version        =   65536
      _ExtentX        =   1508
      _ExtentY        =   873
      _StockProps     =   0
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   375
      Left            =   9720
      TabIndex        =   27
      Top             =   8640
      Width           =   1575
   End
   Begin VB.CommandButton cmdStopServer 
      Caption         =   "Stop SIP Server"
      Height          =   375
      Left            =   2400
      TabIndex        =   26
      Top             =   8640
      Width           =   1935
   End
   Begin VB.CommandButton cmdStartServer 
      Caption         =   "Start SIP Server"
      Height          =   375
      Left            =   240
      TabIndex        =   25
      Top             =   8640
      Width           =   1935
   End
   Begin VB.Frame Frame5 
      Caption         =   "Channels' Status"
      Height          =   1815
      Left            =   120
      TabIndex        =   24
      Top             =   6600
      Width           =   11175
      Begin VB.TextBox tbAddr4 
         Height          =   285
         Left            =   8880
         TabIndex        =   43
         Text            =   "Text4"
         Top             =   1440
         Width           =   2055
      End
      Begin VB.TextBox tbAddr3 
         Height          =   285
         Left            =   8880
         TabIndex        =   42
         Text            =   "Text3"
         Top             =   1080
         Width           =   2055
      End
      Begin VB.TextBox tbAddr2 
         Height          =   285
         Left            =   8880
         TabIndex        =   41
         Text            =   "Text2"
         Top             =   720
         Width           =   2055
      End
      Begin VB.TextBox tbAddr1 
         Height          =   285
         Left            =   8880
         TabIndex        =   40
         Text            =   "Text1"
         Top             =   360
         Width           =   2055
      End
      Begin VB.CommandButton cmdDial4 
         Caption         =   "Dial"
         Height          =   255
         Left            =   7800
         TabIndex        =   39
         Top             =   1440
         Width           =   975
      End
      Begin VB.CommandButton cmdDial3 
         Caption         =   "Dial"
         Height          =   255
         Left            =   7800
         TabIndex        =   38
         Top             =   1080
         Width           =   975
      End
      Begin VB.CommandButton cmdDial2 
         Caption         =   "Dial"
         Height          =   255
         Left            =   7800
         TabIndex        =   37
         Top             =   720
         Width           =   975
      End
      Begin VB.CommandButton cmdDial1 
         Caption         =   "Dial"
         Height          =   255
         Left            =   7800
         TabIndex        =   36
         Top             =   360
         Width           =   975
      End
      Begin VB.Label LabelChan4 
         BorderStyle     =   1  'Fixed Single
         Caption         =   "IDLE"
         Height          =   255
         Left            =   1080
         TabIndex        =   35
         Top             =   1440
         Width           =   6615
      End
      Begin VB.Label LabelChan3 
         BorderStyle     =   1  'Fixed Single
         Caption         =   "IDLE"
         Height          =   255
         Left            =   1080
         TabIndex        =   34
         Top             =   1080
         Width           =   6615
      End
      Begin VB.Label LabelChan2 
         BorderStyle     =   1  'Fixed Single
         Caption         =   "IDLE"
         Height          =   255
         Left            =   1080
         TabIndex        =   33
         Top             =   720
         Width           =   6615
      End
      Begin VB.Label LabelChan1 
         BorderStyle     =   1  'Fixed Single
         Caption         =   "IDLE"
         Height          =   255
         Left            =   1080
         TabIndex        =   32
         Top             =   360
         Width           =   6615
      End
      Begin VB.Label Label17 
         Caption         =   "Chan 4:"
         Height          =   255
         Left            =   240
         TabIndex        =   31
         Top             =   1440
         Width           =   735
      End
      Begin VB.Label Label16 
         Caption         =   "Chan 3:"
         Height          =   255
         Left            =   240
         TabIndex        =   30
         Top             =   1080
         Width           =   855
      End
      Begin VB.Label Label15 
         Caption         =   "Chan 2:"
         Height          =   255
         Left            =   240
         TabIndex        =   29
         Top             =   720
         Width           =   735
      End
      Begin VB.Label Label14 
         Caption         =   "Chan 1:"
         Height          =   255
         Left            =   240
         TabIndex        =   28
         Top             =   360
         Width           =   855
      End
   End
   Begin VB.Frame Frame4 
      Caption         =   "DTMF Options when playing or recording audio"
      Height          =   855
      Left            =   120
      TabIndex        =   17
      Top             =   5640
      Width           =   11175
      Begin VB.TextBox textTimeOut 
         Height          =   285
         Left            =   9360
         TabIndex        =   23
         Text            =   "Text5"
         Top             =   360
         Width           =   975
      End
      Begin VB.TextBox textTermString 
         Height          =   285
         Left            =   4680
         TabIndex        =   21
         Text            =   "Text4"
         Top             =   360
         Width           =   1695
      End
      Begin VB.TextBox textMaxDigits 
         Height          =   285
         Left            =   2160
         TabIndex        =   19
         Text            =   "Text3"
         Top             =   360
         Width           =   855
      End
      Begin VB.Label Label13 
         Caption         =   "Timeout value(milliseconds):"
         Height          =   255
         Left            =   6840
         TabIndex        =   22
         Top             =   360
         Width           =   2175
      End
      Begin VB.Label Label12 
         Caption         =   "Term String:"
         Height          =   255
         Left            =   3480
         TabIndex        =   20
         Top             =   360
         Width           =   975
      End
      Begin VB.Label Label11 
         Caption         =   "Maxium DTMF Digits:"
         Height          =   255
         Left            =   240
         TabIndex        =   18
         Top             =   360
         Width           =   1695
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Sound File to Play or Record:"
      Height          =   855
      Left            =   120
      TabIndex        =   13
      Top             =   4680
      Width           =   11175
      Begin VB.CommandButton cmdBrowser 
         Caption         =   "Browse..."
         Height          =   255
         Left            =   4200
         TabIndex        =   15
         Top             =   360
         Width           =   1215
      End
      Begin VB.TextBox textSoundFileName 
         Height          =   285
         Left            =   240
         TabIndex        =   14
         Top             =   360
         Width           =   3735
      End
      Begin VB.Label Label10 
         Caption         =   $"OCXSIPServerApp.frx":0000
         Height          =   495
         Left            =   5640
         TabIndex        =   16
         Top             =   240
         Width           =   5415
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Application Type:"
      Height          =   3015
      Left            =   120
      TabIndex        =   3
      Top             =   1560
      Width           =   11175
      Begin VB.ComboBox cmbAppType 
         Height          =   315
         Left            =   240
         TabIndex        =   4
         Top             =   360
         Width           =   4335
      End
      Begin VB.Label Label18 
         Caption         =   "Fax Detection: Tone detection demo."
         Height          =   255
         Left            =   240
         TabIndex        =   44
         Top             =   2640
         Width           =   7335
      End
      Begin VB.Label Label9 
         Caption         =   "Voice Activity Detection: Detect voice on or off."
         Height          =   255
         Left            =   240
         TabIndex        =   12
         Top             =   2400
         Width           =   7335
      End
      Begin VB.Label Label8 
         Caption         =   "Conference: Connect 4 channels into one conference, so they can have a conference call."
         Height          =   255
         Left            =   240
         TabIndex        =   11
         Top             =   2160
         Width           =   8175
      End
      Begin VB.Label Label7 
         Caption         =   "Music On Hold: Specify a folder for music files, then SDK will play music files in this folder randomly."
         Height          =   255
         Left            =   240
         TabIndex        =   10
         Top             =   1920
         Width           =   8175
      End
      Begin VB.Label Label6 
         Caption         =   "DTMF Detector: Answer calls, and wait for DTMF digits. Digits will be displayed on the channels' status line."
         Height          =   255
         Left            =   240
         TabIndex        =   9
         Top             =   1680
         Width           =   8655
      End
      Begin VB.Label Label5 
         Caption         =   "Call Bridge: Full Duplex Connect two channels, so two clients can talk with each other."
         Height          =   255
         Left            =   240
         TabIndex        =   8
         Top             =   1440
         Width           =   9135
      End
      Begin VB.Label Label4 
         Caption         =   "Echo Test: A sample to return voice back to sender."
         Height          =   255
         Left            =   240
         TabIndex        =   7
         Top             =   1200
         Width           =   8535
      End
      Begin VB.Label Label3 
         Caption         =   "Record Sound: Answer the call, and record sound into a WAV file."
         Height          =   255
         Left            =   240
         TabIndex        =   6
         Top             =   960
         Width           =   9495
      End
      Begin VB.Label Label2 
         Caption         =   "Play Sound: Answer the call, and play the sound file specified in the following field."
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   720
         Width           =   10695
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Server Configuration File:"
      Height          =   1215
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   11175
      Begin VB.TextBox textCfgFile 
         Enabled         =   0   'False
         Height          =   285
         Left            =   240
         TabIndex        =   2
         Text            =   "c:\GTSIPServerApp.ini"
         Top             =   720
         Width           =   9135
      End
      Begin VB.Label Label1 
         Caption         =   "Please copy GTSIPServerApp.ini from sample folder to c:\, then edit it with your preferable configuration."
         Height          =   255
         Left            =   240
         TabIndex        =   1
         Top             =   360
         Width           =   10455
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim nSel As Long

Private Sub cmbAppType_Change()
    If cmbAppType.Text = "Play Sound" Or cmbAppType.Text = "Record Sound" Then
            textSoundFileName.Enabled = True
            cmdBrowser.Enabled = True
            textMaxDigits.Enabled = True
            textTermString.Enabled = True
            textTimeOut.Enabled = True
            Exit Sub
    End If
    
    If cmbAppType.Text = "Music On Hold" Then
            textSoundFileName.Enabled = True
            cmdBrowser.Enabled = False
            textMaxDigits.Enabled = False
            textTermString.Enabled = False
            textTimeOut.Enabled = False
            Exit Sub
    End If
    
    textSoundFileName.Enabled = False
    cmdBrowser.Enabled = False
    textMaxDigits.Enabled = False
    textTermString.Enabled = False
    textTimeOut.Enabled = False

    
End Sub

Private Sub cmdBrowser_Click()
With frmFileSelect
.init
.Show
End With
End Sub

Private Sub PressDial(ByVal ChanID As Integer, ByVal sAddr As String)
    Dim sDestAddr As String
    If InStr(sAddr, "<sip:") = 1 Then
        sDestAddr = sAddr
    ElseIf InStr(sAddr, "sip:") = 1 Then
        sDestAddr = "<" + sAddr + ">"
    ElseIf InStr(sAddr, "@") > 0 Then
        sDestAddr = "<sip:" + sAddr + ">"
    ElseIf GTSIPAPI1.CFGGetValue("gtsrv.sip.reg1.domain", "") <> "" Then
        sDestAddr = "<sip:" + sAddr + "@" + GTSIPAPI1.CFGGetValue("gtsrv.sip.reg1.domain", "") + ">"
    Else
        Exit Sub
    End If
    
    GTSIPAPI1.SendMake ChanID, sDestAddr, ""
End Sub

Private Sub DialPhone(ByVal ChanID As Long, ByVal AddrText As String)
    Dim addr As String
    
    If InStr(1, AddrText, "@") = 0 Then
        addr = "<sip:" + AddrText + "@" + GTSIPAPI1.CFGGetValue("gtsrv.sip.reg1.domain", "") + ">"
    Else
        addr = "<sip:" + AddrText + ">"
    End If
    GTSIPAPI1.SendMake 0, addr, ""
End Sub

Private Sub cmdDial1_Click()
    If cmdDial1.Caption = "Dial" Then
        DialPhone 0, tbAddr1.Text
    Else
        GTSIPAPI1.SendHungUp 0
    End If
    
End Sub


Private Sub cmdDial2_Click()
    If cmdDial2.Caption = "Dial" Then
        DialPhone 1, tbAddr2.Text
    Else
        GTSIPAPI1.SendHungUp 1
    End If
    
End Sub

Private Sub cmdDial3_Click()
    If cmdDial3.Caption = "Dial" Then
        DialPhone 2, tbAddr3.Text
    Else
        GTSIPAPI1.SendHungUp 2
    End If
End Sub

Private Sub cmdDial4_Click()
    If cmdDial4.Caption = "Dial" Then
        DialPhone 3, tbAddr4.Text
    Else
        GTSIPAPI1.SendHungUp 3
    End If
End Sub

Private Sub cmdExit_Click()
    End
End Sub

Private Sub cmdStartServer_Click()
    If cmbAppType.Text = "Play Sound" Then
        nSel = 0
    End If
    If cmbAppType.Text = "Record Sound" Then
        nSel = 1
    End If
    If cmbAppType.Text = "Echo Test" Then
        nSel = 2
    End If
    If cmbAppType.Text = "Call Bridge" Then
        nSel = 3
    End If
    If cmbAppType.Text = "DTMF Detector" Then
        nSel = 4
    End If
    If cmbAppType.Text = "Music On Hold" Then
        nSel = 5
    End If
    If cmbAppType.Text = "Conference" Then
        nSel = 6
    End If
    If cmbAppType.Text = "Voice Activity Detection" Then
        nSel = 7
    End If
    If cmbAppType.Text = "Fax Detection" Then
        nSel = 8
    End If
    If cmbAppType.Text = "Handle RTP Packet" Then
        nSel = 9
    End If
    
    cmbAppType.Enabled = False
    textSoundFileName.Enabled = False
    cmdBrowser.Enabled = False
    cmdStartServer.Enabled = False
    cmdStopServer.Enabled = True
    cmdExit.Enabled = False

    textMaxDigits.Enabled = False
    textTermString.Enabled = False
    textTimeOut.Enabled = False

    InitSIPServer
    
    cmdDial1.Enabled = True
    cmdDial2.Enabled = True
    cmdDial3.Enabled = True
    cmdDial4.Enabled = True
    
    tbAddr1.Enabled = True
    tbAddr2.Enabled = True
    tbAddr3.Enabled = True
    tbAddr4.Enabled = True

End Sub

Private Sub cmdStopServer_Click()
   If nSel = 0 Or nSel = 1 Then
        textSoundFileName.Enabled = True
        cmdBrowser.Enabled = True

        textMaxDigits.Enabled = True
        textTermString.Enabled = True
        textTimeOut.Enabled = True
    ElseIf nSel = 5 Then
        textSoundFileName.Enabled = True
        cmdBrowser.Enabled = False

        textMaxDigits.Enabled = False
        textTermString.Enabled = False
        textTimeOut.Enabled = False
    Else
        textSoundFileName.Enabled = False
        cmdBrowser.Enabled = False

        textMaxDigits.Enabled = False
        textTermString.Enabled = False
        textTimeOut.Enabled = False
    End If

    cmdStartServer.Enabled = True
    cmdStopServer.Enabled = False
    
    cmdDial1.Enabled = False
    cmdDial2.Enabled = False
    cmdDial3.Enabled = False
    cmdDial4.Enabled = False
    
    tbAddr1.Enabled = False
    tbAddr2.Enabled = False
    tbAddr3.Enabled = False
    tbAddr4.Enabled = False

    FreeSIPServer

    cmdExit.Enabled = True
    cmbAppType.Enabled = True
    
End Sub

Private Sub Form_Load()
    
    cmbAppType.AddItem "Play Sound"
    cmbAppType.AddItem "Record Sound"
    cmbAppType.AddItem "Echo Test"
    cmbAppType.AddItem "Call Bridge"
    cmbAppType.AddItem "DTMF Detector"
    cmbAppType.AddItem "Music On Hold"
    cmbAppType.AddItem "Conference"
    cmbAppType.AddItem "Voice Activity Detection"
    cmbAppType.AddItem "Fax Detection"
    cmbAppType.AddItem "Handle RTP Packet"
    
    cmbAppType.SelText = "Play Sound"
    
    cmdStartServer.Enabled = True
    cmdStopServer.Enabled = False
    
    textMaxDigits.Enabled = True
    textTermString.Enabled = True
    textTimeOut.Enabled = True
    
    textMaxDigits.Text = "0"
    textTermString.Text = ""
    textTimeOut.Text = "0"
    
    cmdDial1.Enabled = False
    cmdDial2.Enabled = False
    cmdDial3.Enabled = False
    cmdDial4.Enabled = False
    
    tbAddr1.Text = "8888@pcbest.net"
    tbAddr2.Text = "8888@pcbest.net"
    tbAddr3.Text = "8888@pcbest.net"
    tbAddr4.Text = "8888@pcbest.net"
    
    tbAddr1.Enabled = False
    tbAddr2.Enabled = False
    tbAddr3.Enabled = False
    tbAddr4.Enabled = False
    
    
End Sub

Public Sub InitSIPServer()
    GTSIPAPI1.CreateEnv
    
    GTSIPAPI1.CFGSetValue "gtsrv.sip.callcontrol.auto.acceptcall", "1"
    GTSIPAPI1.CFGSetValue "gtsrv.sip.callcontrol.auto.ringcall", "0"
    
    If nSel = 6 Then
        GTSIPAPI1.CFGSetValue "gtsrv.sip.conference.room", "1"
    End If
    If nSel = 7 Then
        GTSIPAPI1.CFGSetValue "gtsrv.sip.on.in.vad", "1"
    End If
    If nSel = 9 Then
        GTSIPAPI1.CFGSetValue "gtsrv.sip.on.rtp.packet", "1"
    End If

    'Configuration file, if you want to define parameters in a file
    GTSIPAPI1.CFGSetValue "gtsrv.config.filename", "c:\GTSIPServerApp.ini"

    'Application name, it is related to sdk licence
    'Please contact http://www.pcbest.net/contactus.htm to get licence info
    'SetAppName("GTSIPServerApp");
    
        'if StartServer return false, please make sure SIP port is not being used by another application!
    GTSIPAPI1.StartServer

    GTSIPAPI1.SendGetRegStatus 0

    If GTSIPAPI1.GetDetectedNATType() >= 10 And _
      GTSIPAPI1.CFGGetIntValue("gtsrv.sip.use.nat.addr", 0) = 0 Then
        MsgBox "You may not be able to make Internet calls becuase you have a blocked network.\n Check you network or config your firewall properly, then try again."
    End If

    If nSel = 6 Then
        GTSIPAPI1.SendStartConference 0
    End If
    
    'If GTSIPAPI1.GetLicTo() <> "" Then
    '    MsgBox "License to " + GTSIPAPI1.GetLicTo()
    'End If

End Sub

Public Sub FreeSIPServer()
    If nSel = 6 Then
        GTSIPAPI1.SendStopConference 0
    End If
    GTSIPAPI1.StopServer
    GTSIPAPI1.DestroyEnv
End Sub

Public Sub Logout(ByVal ChanID As Long, ByVal TextLogInfo As String)
    If ChanID = 0 Then
        LabelChan1.Caption = TextLogInfo
    End If
    If ChanID = 1 Then
        LabelChan2.Caption = TextLogInfo
    End If
    If ChanID = 2 Then
        LabelChan3.Caption = TextLogInfo
    End If
    If ChanID = 3 Then
        LabelChan4.Caption = TextLogInfo
    End If
End Sub


Private Sub GTSIPAPI1_OnAudioStatusEx(ByVal ChanID As Long, ByVal ResType As Long, ByVal StatusCode As Long, ByVal ByteOffset As Long)
        Dim LogStr As String

        LogStr = ""

        If nSel = 0 Then
            If ResType = 2 Then
                If StatusCode = 1 Then 'playing
                    LogStr = "Connected! Playing sound. Offset bytes now: " + Str(ByteOffset)
                End If
                If StatusCode = 0 Then 'idle
                    LogStr = "Connected! Playing done. Offset bytes now: " + Str(ByteOffset)
                End If
            End If
            Logout ChanID, LogStr
        End If

        If nSel = 1 Then
            If ResType = 1 Then
                If StatusCode = 2 Then 'recording
                    LogStr = "Connected! Recording sound to " + textSoundFileName.Text
                    LogStr = LogStr + " Offset bytes now: " + Str(ByteOffset)
                End If
                If StatusCode = 0 Then 'idle
                    LogStr = "Connected! Recording done "
                    LogStr = LogStr + " Offset bytes now: " + Str(ByteOffset)
                End If
            End If
            Logout ChanID, LogStr
        End If

End Sub

Private Sub GTSIPAPI1_OnCallConnected(ByVal ChanID As Long)
    Dim LogStr As String
    
    If ChanID = 0 Then
        cmdDial1.Enabled = True
        cmdDial1.Caption = "Hangup"
        tbAddr1.Enabled = False
    ElseIf ChanID = 1 Then
        cmdDial2.Enabled = True
        cmdDial2.Caption = "Hangup"
        tbAddr2.Enabled = False
    ElseIf ChanID = 2 Then
        cmdDial3.Enabled = True
        cmdDial3.Caption = "Hangup"
        tbAddr3.Enabled = False
    ElseIf ChanID = 3 Then
        cmdDial4.Enabled = True
        cmdDial4.Caption = "Hangup"
        tbAddr4.Enabled = False
    End If
    
    
    If nSel = 0 Then
        GTSIPAPI1.SendPlayAudio ChanID, textSoundFileName.Text, 0, "", 0 'Convert.ToInt32(m_pMainWnd.dtmfMaxDigits.Text), m_pMainWnd.dtmfTermStr.Text, Convert.ToInt32(m_pMainWnd.dtmfTimeout.Text)
        LogStr = "Connected! Playing sound " + textSoundFileName.Text
        Logout ChanID, LogStr
        GTSIPAPI1.StartTimer ChanID, 2000
    End If

    If nSel = 1 Then
        GTSIPAPI1.SendRecordAudio ChanID, textSoundFileName.Text, 0, "", 0 'Convert.ToInt32(m_pMainWnd.dtmfMaxDigits.Text), m_pMainWnd.dtmfTermStr.Text, Convert.ToInt32(m_pMainWnd.dtmfTimeout.Text)
        LogStr = "Connected! Recording sound to " + textSoundFileName.Text
        Logout ChanID, LogStr
        GTSIPAPI1.StartTimer ChanID, 2000
    End If

    If nSel = 2 Then
        GTSIPAPI1.SendHalfConnect ChanID, ChanID
        Logout ChanID, "Connected! Echo testing..."
    End If

    If nSel = 3 Then
        If ChanID = 0 Then
            Logout ChanID, "Connected! Waiting for next channel to connect."
        End If
        If ChanID = 1 Then
            GTSIPAPI1.SendDuplexConnect 0, 1
            Logout 0, "Connected! Chan 1 and 2 are connected!"
            Logout 1, "Connected! Chan 1 and 2 are connected!"
        End If

        If ChanID = 2 Then
            Logout ChanID, "Connected! Waiting for next channel to connect."
        End If

        If ChanID = 3 Then
            GTSIPAPI1.SendDuplexConnect 2, 3
            Logout 2, "Connected! Chan 3 and 4 are connected!"
            Logout 3, "Connected! Chan 3 and 4 are connected!"
        End If
    End If

    If nSel = 4 Then
        GTSIPAPI1.SendEnableDTMF ChanID
        Logout ChanID, "Connected! Waiting for DTMF digits."
    End If

    If nSel = 5 Then
        GTSIPAPI1.SendStartMusicOnHold ChanID, m_pMainWnd.editSoundFile.Text, 1, 0
        LogStr = "Connected! Music On Hold - Playing files in " + m_pMainWnd.editSoundFile.Text
        Logout ChanID, LogStr
    End If

    If nSel = 6 Then
        GTSIPAPI1.SendSetChanInConference 0, ChanID, 1
        LogStr = "Connected! In conference room."
        Logout ChanID, LogStr
    End If

    If nSel = 7 Then
        LogStr = "Connected! Detecting voice..., please talk."
        Logout ChanID, LogStr
    End If
    
    If nSel = 8 Then
        LogStr = "Connected! Detecting fax..."
        Logout ChanID, LogStr
        GTSIPAPI1.SendClearToneList ChanID
        GTSIPAPI1.SendAddTone ChanID, 1100, 400
        GTSIPAPI1.SendAddTone ChanID, 2100, 2200
        GTSIPAPI1.SendStartToneDetection ChanID
    End If
End Sub

Private Sub GTSIPAPI1_OnCallDialing(ByVal ChanID As Long, ByVal Caller As String, ByVal Callee As String)
    Logout ChanID, "Dialing"
    If ChanID = 0 Then
        cmdDial1.Enabled = True
        cmdDial1.Caption = "Hangup"
        tbAddr1.Enabled = False
    ElseIf ChanID = 1 Then
        cmdDial2.Enabled = True
        cmdDial2.Caption = "Hangup"
        tbAddr2.Enabled = False
    ElseIf ChanID = 2 Then
        cmdDial3.Enabled = True
        cmdDial3.Caption = "Hangup"
        tbAddr3.Enabled = False
    ElseIf ChanID = 3 Then
        cmdDial4.Enabled = True
        cmdDial4.Caption = "Hangup"
        tbAddr4.Enabled = False
    End If
End Sub

Private Sub GTSIPAPI1_OnCallIdle(ByVal ChanID As Long)
    Logout ChanID, "IDLE"
    GTSIPAPI1.StopTimer ChanID
    
    If ChanID = 0 Then
        cmdDial1.Enabled = True
        cmdDial1.Caption = "Dial"
        tbAddr1.Enabled = True
    ElseIf ChanID = 1 Then
        cmdDial2.Enabled = True
        cmdDial2.Caption = "Dial"
        tbAddr2.Enabled = True
    ElseIf ChanID = 2 Then
        cmdDial3.Enabled = True
        cmdDial3.Caption = "Dial"
        tbAddr3.Enabled = True
    ElseIf ChanID = 3 Then
        cmdDial4.Enabled = True
        cmdDial4.Caption = "Dial"
        tbAddr4.Enabled = True
    End If
    
End Sub

Private Sub GTSIPAPI1_OnCallOffered(ByVal ChanID As Long, ByVal Caller As String, ByVal Callee As String, ByVal DestAddr As String, ByVal ViaAddr As String, ByVal IPAddr As String, ByVal IPPort As Long)
    Dim strlog As String
    strlog = "New call from " + sCaller + " to " + sCallee
    Logout ChanID, strlog
    GTSIPAPI1.SendAnswer ChanID
    
    If ChanID = 0 Then
        cmdDial1.Enabled = True
        cmdDial1.Caption = "Hangup"
        tbAddr1.Enabled = False
    ElseIf ChanID = 1 Then
        cmdDial2.Enabled = True
        cmdDial2.Caption = "Hangup"
        tbAddr2.Enabled = False
    ElseIf ChanID = 2 Then
        cmdDial3.Enabled = True
        cmdDial3.Caption = "Hangup"
        tbAddr3.Enabled = False
    ElseIf ChanID = 3 Then
        cmdDial4.Enabled = True
        cmdDial4.Caption = "Hangup"
        tbAddr4.Enabled = False
    End If
    
End Sub

Private Sub GTSIPAPI1_OnDTMFKeyDown(ByVal ChanID As Long, ByVal KeyValue As Integer, ByVal ClockTicks As Long)
    Dim strlog As String
    strlog = "Connected! " + Str(KeyValue) + " key down!"
    Logout ChanID, strlog
End Sub

Private Sub GTSIPAPI1_OnDTMFKeyUp(ByVal ChanID As Long, ByVal KeyValue As Integer, ByVal ClockTicks As Long)
    Dim strlog As String
    strlog = "Connected! " + Str(KeyValue) + " key up!"
    Logout ChanID, strlog
End Sub

Private Sub GTSIPAPI1_OnRecvRegStatus(ByVal SIPAccID As Long, ByVal Status As Long, ByVal RegUnixTime As Long)
    Dim sTemp As String
    If Status = 1 Then
        sTemp = "VB6 SIP Server Application Demo --- " + GTSIPAPI1.CFGGetValue("gtsrv.sip.reg1.username", "")
    Else
        sTemp = "VB6 SIP Server Application Demo --- " + GTSIPAPI1.CFGGetValue("gtsrv.sip.reg1.username", "") + "XXX!"
    End If
    Form1.Caption = sTemp
End Sub

Private Sub GTSIPAPI1_OnRecvTimer(ByVal ChanID As Long)
        If m_nCurSel = 0 Or m_nCurSel = 1 Then
            GTSIPAPI1.SendGetAudioStatus ChanID

            If GTSIPAPI1.GetChanStatus(ChanID) = 3 Then 'connected
                GTSIPAPI1.StartTimer ChanID, 2000
            End If
        End If
End Sub

Private Sub GTSIPAPI1_OnRecvToneDetected(ByVal ChanID As Long, ByVal Freq As Long)
    If nSel = 8 Then
        LogStr = "Connected! Detected Fax tone " + Str(Freq)
        Logout ChanID, LogStr
        GTSIPAPI1.SendStopToneDetection ChanID
    End If
End Sub

Private Sub GTSIPAPI1_OnRTPPacket(ByVal ChanID As Long, ByVal InPacket As Long, ByVal AudioFmt As Long, ByVal SequenceNum As Long, ByVal TimeStamp As Long, ByVal BufAddr As Long, ByVal BufLen As Long)
    If InPacket = 1 Then
        'In coming audio
        Logout ChanID, "Packet Received " & SequenceNum & " " & TimeStamp & " " & BufAddr & " " & BufLen
    Else
        'outgoing audio
        
    End If
    
End Sub

Private Sub GTSIPAPI1_OnVoiceActivityDetected(ByVal ChanID As Long, ByVal VoiceDir As Long, ByVal VoiceOn As Long, ByVal Level As Long, ByVal Reserved As Long)
    Dim LogStr As String
    If VoiceDir = 1 And nSel = 7 Then
        If VoiceOn = 1 Then
            LogStr = "Connected! Voice is on."
            Logout ChanID, LogStr
        Else
            LogStr = "Connected! Voice is off."
            Logout ChanID, LogStr
        End If
    End If
End Sub



Private Sub Timer1_Timer()
    GTSIPAPI1.ProcessGTAPIEvent
End Sub
