unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  uSIPClient, ComObj, OleCtrls, ExtCtrls, StdCtrls, GTSIPCTRLLib_TLB, uIVRClient, syncobjs,
  Menus, ComCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Memo1: TMemo;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Start1: TMenuItem;
    DTMF1: TMenuItem;
    InAudio1: TMenuItem;
    SIPInfo1: TMenuItem;
    RTPPackage1: TMenuItem;
    StatusBar1: TStatusBar;
    Edit1: TEdit;
    Stop1: TMenuItem;
    Channels1: TMenuItem;
    N41: TMenuItem;
    N81: TMenuItem;
    N161: TMenuItem;
    Display1: TMenuItem;
    IVR1: TMenuItem;
    SIP1: TMenuItem;
    Off2: TMenuItem;
    Logging1: TMenuItem;
    On2: TMenuItem;
    Off3: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Start1Click(Sender: TObject);
    procedure InAudio1Click(Sender: TObject);
    procedure RTPPackage1Click(Sender: TObject);
    procedure SIPInfo1Click(Sender: TObject);
    procedure Stop1Click(Sender: TObject);
    procedure N41Click(Sender: TObject);
    procedure N81Click(Sender: TObject);
    procedure N161Click(Sender: TObject);
    procedure IVR1Click(Sender: TObject);
    procedure SIP1Click(Sender: TObject);
    procedure Off2Click(Sender: TObject);
    procedure On2Click(Sender: TObject);
    procedure Off3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Channels: Integer;
    Started: Boolean;
  end;

var
  Form1: TForm1;
  SIPThread: TSIP;
implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
i: Integer;
begin
    SIPThread:= TSIP.Create(True);
    SIPThread.SIP:= TGTSIPAPI.Create(Nil);
    SIPThread.LockSIP:= TCriticalSection.Create;
    SIPThread.DTMFMethod:= '2'; // RTP
    Channels:= 16;
    Started:= False;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
    SIPThread.Terminate;
    Sleep(1000);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
chan: Integer;
GoodAuthor, BadAuthor, GoodSubject, BadSubject, GoodWorktype,
    BadWorktype, GoodLength, OKLength, BadLength: Integer;
s: string;
begin
    if SIPThread = Nil then exit;

    if IVR1.Checked then begin
        Memo1.Lines[0] := '           AUTHOR         SUBJECT         WORKTYPE          FILE LENGTH';
        Memo1.Lines[1] := 'CHAN    GOOD     BAD    GOOD     BAD    GOOD     BAD    GOOD      OK     BAD';
        GoodAuthor:= 0;
        BadAuthor:= 0;
        GoodSubject:= 0;
        BadSubject:= 0;
        GoodWorktype:= 0;
        BadWorktype:= 0;
        GoodLength:= 0;
        OKLength:= 0;
        BadLength:= 0;
    end;

    for chan:= 0 to 19 do begin
        if chan > Channels - 1 then begin
            if IVR1.Checked then
                Memo1.Lines[chan + 2]:= ''
            else
                Memo1.Lines[chan]:= '';
            continue;
        end;
        if IVR1.Checked then begin
            if Started then begin
                GoodAuthor:= GoodAuthor + SIPThread.IVRThread[chan].GoodAuthor;
                BadAuthor:= BadAuthor + SIPThread.IVRThread[chan].BadAuthor;
                GoodSubject:= GoodSubject + SIPThread.IVRThread[chan].GoodSubject;
                BadSubject:= BadSubject + SIPThread.IVRThread[chan].BadSubject ;
                GoodWorktype:= GoodWorktype + SIPThread.IVRThread[chan].GoodWorktype;
                BadWorktype:= BadWorktype + SIPThread.IVRThread[chan].BadWorktype;
                GoodLength:= GoodLength + SIPThread.IVRThread[chan].GoodLength;
                OKLength:= OKLength + SIPThread.IVRThread[chan].OKLength;
                BadLength:= BadLength + SIPThread.IVRThread[chan].BadLength;
                Memo1.Lines[chan + 2] := SIPThread.IVRThread[chan].IVRStatus
            end else begin
                Memo1.Lines[chan + 2] := '';
            end;
        end else begin
            Memo1.Lines[chan] := IntToStr(chan) + ': ' + SIPThread.GetChannelStatus(chan);
        end;
    end;
    if IVR1.Checked then begin
         s:= Format('     %7d %7d %7d %7d %7d %7d %7d %7d %7d',[GoodAuthor, BadAuthor,
            GoodSubject, BadSubject, GoodWorktype, BadWorktype, GoodLength, OKLength, BadLength]);
         Memo1.Lines[Channels + 2]:= s;
    end;
end;

procedure TForm1.Start1Click(Sender: TObject);
var
i: Integer;
begin


    SIPThread.Channels:= Channels;
    SIPThread.Logging:= On2.Checked;

    for i:= 0 to Channels - 1 do
    begin
        SIPThread.IVRThread[i]:= TIVR.Create(True);
        SIPThread.IVRThread[i].chan:= i;
        SIPThread.IVRThread[i].SIPAddr:= Trim(Edit1.Text);
        SIPThread.IVRThread[i].Logging:= On2.Checked;
        SIPThread.IVRThread[i].Resume;
        Memo1.Lines[i] := IntToStr(i) + ': Created';
    end;
    
    SIPThread.Resume;

    DTMF1.Enabled:= False;
    Start1.Enabled:= False;
    Logging1.Enabled:= False;
    Channels1.Enabled:= False;

    Started:= True;

    StatusBar1.SimpleText:='Client Started ' + IntToStr(Channels) + ' Channels';
end;

procedure TForm1.InAudio1Click(Sender: TObject);
begin
    SIPThread.DTMFMethod:= '0';  // DTMF in Audio
    InAudio1.Checked:= True;
    RTPPackage1.Checked:=False ;
    SIPInfo1.Checked:= False;
end;

procedure TForm1.RTPPackage1Click(Sender: TObject);
begin
    SIPThread.DTMFMethod:= '2';  // DTMF in RTP Package
    RTPPackage1.Checked:= True;
    InAudio1.Checked:= False;
    SIPInfo1.Checked:= False;
end;

procedure TForm1.SIPInfo1Click(Sender: TObject);
begin
     SIPThread.DTMFMethod:= '1';  // DTMF in SIP 'Info'
     SIPInfo1.Checked:= True;
     InAudio1.Checked:= False;
     RTPPackage1.Checked:=False ;
end;

procedure TForm1.Stop1Click(Sender: TObject);
var
i: Integer;
begin
    for i:= 0 to Channels - 1 do
    begin
        SIPThread.IVRThread[i].Terminate;
    end;
     StatusBar1.SimpleText:='Stopping';
end;

procedure TForm1.N41Click(Sender: TObject);
begin
    Channels:= 4;
    N161.Checked:= False;
    N81.Checked:= False;
    N41.Checked:= True;
end;

procedure TForm1.N81Click(Sender: TObject);
begin
    Channels:= 8;
    N161.Checked:= False;
    N81.Checked:= True;
    N41.Checked:= False;
end;

procedure TForm1.N161Click(Sender: TObject);
begin
    Channels:= 16;
    N161.Checked:= True;
    N81.Checked:= False;
    N41.Checked:= False;
end;


procedure TForm1.IVR1Click(Sender: TObject);
begin
    IVR1.Checked:= True;
    SIP1.Checked:= False;
    Off2.Checked:= False;
    Timer1.Enabled:= True;
end;

procedure TForm1.SIP1Click(Sender: TObject);
begin
    IVR1.Checked:= False;
    SIP1.Checked:= True;
    Off2.Checked:= False;
    Timer1.Enabled:= True;
end;

procedure TForm1.Off2Click(Sender: TObject);
var
i: Integer;
begin
   Off2.Checked:= True;
   IVR1.Checked:= False;
   SIP1.Checked:= False;
   Timer1.Enabled:= False;
   for i:= 0 to 19 do
   begin
    Memo1.Lines[i]:= '';
   end;
end;

procedure TForm1.On2Click(Sender: TObject);
begin
    On2.Checked:= True;
    Off3.Checked:= False;

end;

procedure TForm1.Off3Click(Sender: TObject);
begin
    Off3.Checked:= True;
    On2.Checked:= False;
end;

end.
