using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace CS_PABX
{
    public partial class Form1 : Form
    {
        public CSSIPPABXEnv env;
        public Extension[] Extensions;

        public Form1()
        {
            InitializeComponent();

            Extensions = new Extension[4];

            Extensions[0] = new Extension();
            Extensions[0].Username = "101";
            Extensions[0].Password = "101";
            
            Extensions[1] = new Extension();
            Extensions[1].Username = "102";
            Extensions[1].Password = "102";

            Extensions[2] = new Extension();
            Extensions[2].Username = "103";
            Extensions[2].Password = "103";

            Extensions[3] = new Extension();
            Extensions[3].Username = "104";
            Extensions[3].Password = "104";
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            btnStartServer.Enabled = true;
            btnStopServer.Enabled = false;

            tb101Status.Enabled = false;
            tb101At.Enabled = false;

            tb102Status.Enabled = false;
            tb102At.Enabled = false;

            tb103Status.Enabled = false;
            tb103At.Enabled = false;

            tb104Status.Enabled = false;
            tb104At.Enabled = false;

            timer1.Enabled = false;

        }

        private void btnStartServer_Click(object sender, EventArgs e)
        {
            btnStartServer.Enabled = false;
            btnStopServer.Enabled = true;
            InitSIPServer();

            tb101Status.Enabled = true;
            tb101At.Enabled = true;

            tb102Status.Enabled = true;
            tb102At.Enabled = true;

            tb103Status.Enabled = true;
            tb103At.Enabled = true;

            tb104Status.Enabled = true;
            tb104At.Enabled = true;

            timer1.Enabled = true;
        }

        private void btnStopServer_Click(object sender, EventArgs e)
        {
            timer1.Enabled = false;

            btnStartServer.Enabled = true;
            btnStopServer.Enabled = false;
            FreeSIPServer();

            tb101Status.Enabled = false;
            tb101At.Enabled = false;

            tb102Status.Enabled = false;
            tb102At.Enabled = false;

            tb103Status.Enabled = false;
            tb103At.Enabled = false;

            tb104Status.Enabled = false;
            tb104At.Enabled = false;
        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            if (btnStopServer.Enabled)
            {
                timer1.Enabled = false;

                btnStartServer.Enabled = true;
                btnStopServer.Enabled = false;
                FreeSIPServer();
            }
            Close();
        }

        public void InitSIPServer()
        {
            env = new CSSIPPABXEnv();
            env.m_pMainWnd = this;
            env.CreateEnv();
            env.SetMainWnd(this.Handle);


            env.CFG_SetValue("gtsrv.sip.server.model", "1"); //server application

            //env.CFG_SetValue("gtsrv.sip.protocol", "3"); //for UDP and TCP both

            //SIP IP Address you want to use on local
            //Leave it unset if you want to listen on all the network interface
            //CFG_SetValue("gtsrv.sip.ip.address", "");

            //SIP Port, default 5060
            env.CFG_SetValue("gtsrv.sip.ip.port", "5060");

            //RTP PORT
            env.CFG_SetValue("gtsrv.sip.rtpstartrange", "8400");
            env.CFG_SetValue("gtsrv.sip.rtpendrange", "8800");

            //Log
            env.CFG_SetValue("gtsrv.log.level", "4");

            env.CFG_SetValue("gtsrv.log.filename", Application.StartupPath + "\\CSSIPPABX-log.txt");

            //channnel numbers, here we only use 4 channel
            env.CFG_SetValue("gtsrv.sip.boardnum.per.server", "1");
            env.CFG_SetValue("gtsrv.sip.spannum.per.board", "1");
            env.CFG_SetValue("gtsrv.sip.channum.per.span", "4");
            /*
            #We dont recommend you set "gtsrv.sip.channum.per.span" more than 16.
            #Sugguested Configuration of CHANNELS, SPANS, and Boards:
            #Channels	gtsrv.sip.channum.per.span	gtsrv.sip.spannum.per.board	gtsrv.sip.boardnum.per.server
            #4			4				1				1
            #8			8				1				1
            #16			8				2				1
            #24			8				3				1
            #32			8				4				1
            #40			8				5				1
            #64			8				8				1
            #128			8				8				2
            #256			8				8				4
            #512			16				8				4 
            */

            //only use 20ms codecs
            env.CFG_SetValue("gtsrv.sip.prefered.codec", "3,0,8");

            //Internal communication port
            env.CFG_SetValue("gtsrv.net.port", "8934");

            //Configuration file, if you want to define parameters in a file
            //env.CFG_SetValue(GTSRV_CFG_FILENAME, "GTSimpelPhone.ini");

            //Application name, it is related to sdk licence
            //Please contact PCBest Network(www.pcbest.net) to get licence info
            env.SetAppName("CSSIPRegServer");

            //define outbound route, leave them unset if you don't know
            //env.CFG_SetValue("gtsrv.sip.outbound.via.type", "0");
            //env.CFG_SetValue("gtsrv.sip.outbound.via.proxy", "");

            //set sip client user info here
            //here it is actually your SIP trunk registration info, means you get this account from other SIP server/proxy,
            //and register to outside SIP server/proxy as a SIP client. 
            //We comment them out here as it is not the purpose of this sample
            //env.CFG_SetValue("gtsrv.sip.reg.client.num", "1");
            //env.CFG_SetValue("gtsrv.sip.reg1.displayname", "Any");
            //env.CFG_SetValue("gtsrv.sip.reg1.username", "12345678");
            //env.CFG_SetValue("gtsrv.sip.reg1.domain", "sip.pcbest.net");
            //env.CFG_SetValue("gtsrv.sip.reg1.proxy", "sip.pcbest.net");
            //env.CFG_SetValue("gtsrv.sip.reg1.authorization", "12345678");
            //env.CFG_SetValue("gtsrv.sip.reg1.password", "************");
            //env.CFG_SetValue("gtsrv.sip.reg1.expire", "3600");

            if (!env.StartServer())
            {
                MessageBox.Show("StartServer failed! Please make sure the SIP port set in INI file is not being using by another application.");
            }

            //env.Send_GetRegStatus(0);

            //Proxy code start from here:
            env.CFG_SetValue("gtsrv.sip.proxy.sites.num", "1");

            string domains = env.GetMappedPublicSIPIPAddress() + ";";
            domains += GTAPIASM.GTAPIEnv.GetLocalIP(0) + ";";
            domains += "mysipproxy.com"; //fake one. You change it to your own domain if you have

            env.CFG_SetValue("gtsrv.sip.proxy.site1.domain", domains);

            //env.CFG_SetValue("gtsrv.sip.proxy.site1.recordroute", "1");
            //env.CFG_SetValue("gtsrv.sip.proxy.site1.udp.relay", "0");

            //if map sip client's Contact address in SIP REGISTER with actual address from network
            env.CFG_SetValue("gtsrv.sip.proxy.site1.map.reg.source", "1");

            env.CFG_SetValue("gtsrv.sip.proxy.site1.check.user.status", "1");

            env.InitProxySites();

            //Add extensions

            for (int i = 0; i < Extensions.Length; i++)
            {
                env.ProxySetUserInfo(0, Extensions[i].Username, Extensions[i].Password, 0, 0, "", "", "", 0, "", 0, "", "");
            }

        }

        public void FreeSIPServer()
        {
            env.FreeProxySites();
            env.StopServer();
            env.DestroyEnv();
            env = null;
        }

        public void On_RecvConnected(int ch)
        {
        }

        public void On_RecvDialing(int ch, string sCaller, string sCallee)
        {
        }

        public void On_RecvOffered(int ch, string sCaller, string sCallee, string sDestAddr, string sViaAddr, string sFromIP, ushort nFromPort)
        {
            //env.Send_Answer(ch);
        }

        public void On_RecvIdle(int ch, int code, string desc)
        {
        }

        public void On_RecvRinging(int ch)
        {
        }

        public void On_RecvRegStatus(int acct_id, int status, int regtime)
        {
        }

        public void On_ProxyUserRegistered(uint pid, string username, ulong tnow, uint exp_sec, string org_contact, string mapped_contact, string szUAName, int UANatType, string from_id, string to_id, string src_ip, ushort src_port)
        {
            string sStatus = "";
            string sAt = "";

            //update local extension structure for late to use
            for (int i = 0; i < Extensions.Length; i++)
            {
                if(Extensions[i].Username == username)
                {
                    Extensions[i].RegTime = tnow;
                    Extensions[i].RegExp = exp_sec;
                    Extensions[i].OrgContact = org_contact;
                    Extensions[i].MappedContact = mapped_contact;
                    Extensions[i].UAName = szUAName;
                    Extensions[i].SIPId = from_id;
                    Extensions[i].FromIP = src_ip;
                    Extensions[i].FromPort = src_port;
                    break;
                }
            }

            if (tnow > 0 && exp_sec > 0)
            {
                //extension register
                sStatus = "Online";
                sAt = org_contact + " " + mapped_contact + " " + szUAName + " " + from_id;
            }
            else if (exp_sec == 0)
            {
                //extension unregister
                sStatus = "Offline";
                sAt = "";
            }

            if (username == "101")
            {
                tb101Status.Text = sStatus;
                tb101At.Text = sAt;
            }
            if (username == "102")
            {
                tb102Status.Text = sStatus;
                tb102At.Text = sAt;
            }
            if (username == "103")
            {
                tb103Status.Text = sStatus;
                tb103At.Text = sAt;
            }
            if (username == "104")
            {
                tb104Status.Text = sStatus;
                tb104At.Text = sAt;
            }
        }

        public string On_ProxyNewCallSession(uint pid, uint sid, IntPtr msg, string authid, string fromid, string toid, string suri, string via, string saddr, ushort nport, bool bCredit)
        {
            /*
            Possible return values:
            "sip:undefined" = wait until ProxySetNewCallSessionAddr is called
            Sometimes you cannot immediately decide what to do with this call, and then you can call ProxySetNewCallSessionAddr function to provide an address later.
            NOTE: The OCX(ActiveX) users should(have to) use ProxySetNewCallSessionAddr function later to provide one of the following values:
            "channel" = to channel. Default value. Then one of the channels will have On_RecvOffered event triggered.
            "unauthorized" = need credit to process. You should check the fromID, to see if it is a call from proxy sites user(or extension of PBX). If it does, and Credit is false, then unauthorized string is returned to ask authorization to call out.
            "sip:123@abc.com" = with right credit or don't need credit, processed by proxy site and transfered to this address
            "|" can be used to seperate the credit info. For example: "To<sip:123@abc.com>|From<sip:456@abc.com>|User<1234>|Password<4567>"
            Otherwise, if none of above matched, refer to user's contact info.
            */

            String toUserName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, toid);

            //check if it is for one of the extensions
            for (int i = 0; i < Extensions.Length; i++)
            {
                if (Extensions[i].Username == toUserName)
                {
                    //to one of extensions
                    if (Extensions[i].MappedContact.Length > 0)
                        return Extensions[i].MappedContact;
                    else if (Extensions[i].OrgContact.Length > 0)
                        return Extensions[i].OrgContact;
                    else
                    {
                        //not registered
                        return "rejected";
                    }

                }
            }

            if (toUserName.Length > 0)
            {
                if (toUserName[0] == '9')
                {
                    //assume there is an outbound dialplan defined starting as 9.
                    //stripping off the 9 in the front
                    string sDest = toUserName.Substring(1);
                    //make the outgoing sip address. you will have to make changes here for other-sip-server-ip
                    sDest = "<sip:" + sDest + "@other-sip-server-ip" + ">";

                    return sDest;
                }
            }

            return "channel";

        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            env.ProcessGTAPIEvent();
        }

    }

    public class Extension
    {
        public String Username;
        public String Password;
        public ulong RegTime;
        public uint RegExp;
        public String OrgContact;
        public String MappedContact;
        public String UAName;
        public String SIPId;
        public String FromIP;
        public ushort FromPort;

        public Extension()
        {
            Username = "";
            Password = "";
            RegTime = 0;
            RegExp = 0;
            OrgContact = "";
            MappedContact = "";
            UAName = "";
            SIPId = "";
            FromIP = "";
            FromPort = 0;
        }
    }
}