// ------------------------------------------------------------------
//	File: gttypes.h
//
//
// ==================================================================
// IF YOU DO NOT AGREE WITH THE FOLLOWING STATEMENT, YOU MUST 
// PROMPTLY RETURN THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION 
// ("PRODUCT") TO PCBest Networks(www.pcbest.net).
//
// PCBest Networks owns all title and 
// ownership rights to Software.  "Software" means any data processing
// programs (hereinafter "programs") consisting of a series of 
// instructions or statements in object code form, including any 
// systemized collection of data in the form of a data base, and any
// related proprietary materials such as flow charts, logic diagrams, 
// manuals media and listings provided for use with the programs.
// User has no right, express or implied, to transfer, sell, provide
// access to or dispose of Software to any third party without PCBest Networks'
// prior written consent.  User will not copy, reverse assemble,
// reverse engineer, decompile, modify, alter, translate or display
// the Software other than as expressly permitted by PCBest Networks in writing.
// ------------------------------------------------------------------

#if !defined(__GTAPI_TYPES_DEFINITION_H)
#define __GTAPI_TYPES_DEFINITION_H

#define USE_GTAPI_NAMESPACE

#if (defined(WIN32) || defined(_WIN32_WCE))
/* --------------------------------------------------------------- */

#ifndef _WIN64
 /*
  * Define WINNT version
  */
 #ifndef _WIN32_WINNT
  /* Required for compiling critical sections */
  #define _WIN32_WINNT 0x0500
 #endif
 /* clean windows headers */
 #define WIN32_LEAN_AND_MEAN

#else

 /*
  * Define WINNT version
  */
 #ifndef _WIN64_WINNT
  /* Required for compiling critical sections */
  #define _WIN64_WINNT 0x0500
 #endif
 /* clean windows headers */
 #define WIN64_LEAN_AND_MEAN

#endif /* !_WIN64_ */

#endif


#if (defined(WIN32) || defined(_WIN32_WCE))
	#include <basetsd.h>
	#include <windows.h>
#elif __linux__
	#include <stddef.h>
	#ifdef __KERNEL__ 
		#include <linux/types.h>
	#else
		#include <stdint.h>
	#endif
#endif



#if (defined(WIN32) || defined(_WIN32_WCE))
	#ifndef WINAPI
		#define WINAPI __stdcall
	#endif
	#define GT_API WINAPI
	#define GT_CALLBACK __stdcall
#elif __linux__
	#define WINAPI
	#define GT_API
	#define GT_CALLBACK
#endif

#if (defined(WIN32) || defined(_WIN32_WCE))
	#ifdef GT_NO_DLL
		#define GT_DLL_API 
	#else
		#ifdef GTAPI_EXPORTS
			#define GT_DLL_API __declspec(dllexport)
		#else
			#define GT_DLL_API __declspec(dllimport)
		#endif
	#endif

#else //non-win32 platform
	#define GT_DLL_API
#endif


/*
 * --------------------------------------------------------------------
 * Standard base types
 * --------------------------------------------------------------------
 */

/*
 * Address type
 */
typedef void     GT_VOID, *GT_PVOID;
#define GT_NULL    (0)

#ifndef NULL
	#define NULL	(0)
#endif
/*
 * Boolean type
 */
typedef unsigned GT_BOOL, *GT_PBOOL;
#define GT_TRUE   1
#define GT_FALSE  0

/*
 * Character type
 */
typedef char     GT_CHAR, *GT_PCHAR;

/*
 * Real data type
 */
typedef double   GT_REAL, *GT_PREAL;

/*
 * Float data type
 */
typedef float    GT_FLOAT;

/*
 * Double data type
 */
typedef double   GT_DOUBLE;

/*
 * Word types -- the size depends on target OS
 */
typedef unsigned int  GT_WORD, *GT_PWORD;  /* Try not to use this */
typedef unsigned int  GT_DWORD, *GT_PDWORD;

/*
 * Interger data type
 */
typedef unsigned int  GT_UINT, *GT_PUINT;
typedef signed   int  GT_INT,  *GT_PINT;

/*
 * Short data type
 */
typedef unsigned short GT_USHORT, *GT_PUSHORT;
typedef signed   short GT_SHORT,  *GT_PSHORT;

/*
 * Long data type
 */
typedef unsigned long GT_ULONG, *GT_PULONG;
typedef signed   long GT_LONG,  *GT_PLONG;

/*
 * --------------------------------------------------------------------
 * Sized base types
 * --------------------------------------------------------------------
 */

/*
 * 8-bit long data types
 */
typedef unsigned char GT_U8, *GT_PU8;
typedef signed   char GT_I8, *GT_PI8;
typedef unsigned char GT_BYTE, *GT_PBYTE;


/*
 * 16-bit long data types
 */
typedef unsigned short GT_U16, *GT_PU16;
typedef signed   short GT_I16, *GT_PI16;

/*
 * 32-bit long data types
 */
#if (defined(WIN32) || defined(_WIN32_WCE))
 #ifndef _WIN64
  typedef unsigned long GT_U32, *GT_PU32;
  typedef signed   long GT_I32, *GT_PI32;
 #else
  typedef UINT32  GT_U32, *GT_PU32;
  typedef INT32   GT_I32, *GT_PI32;
 #endif
#elif __linux__
 #if __WORDSIZE == 32
  typedef unsigned long GT_U32, *GT_PU32;
  typedef signed   long GT_I32, *GT_PI32;
 #elif __WORDSIZE == 64
  typedef uint32_t  GT_U32, *GT_PU32;
  typedef int32_t   GT_I32, *GT_PI32;
 #else
  #error Problem determing word size, cannot set 32 bit data type
 #endif
#else
 #error Problem determing O/S, cannot set 32 bit data type
#endif

/*
 * 64-bit long data types
 */
#if (defined(WIN32) || defined(_WIN32_WCE))
 typedef unsigned __int64 GT_U64, *GT_PU64;
 typedef signed   __int64 GT_I64, *GT_PI64;
#elif __linux__
 typedef uint64_t GT_U64, *GT_PU64;
 typedef int64_t  GT_I64, *GT_PI64;
#endif

/*
 * --------------------------------------------------------------------
 * Other base types
 * --------------------------------------------------------------------
 */

/*
 * Resource handles
 */

//#ifdef  _WIN64
//typedef GT_U32 GT_HANDLE;
typedef void* GT_HANDLE;


#define GT_HANDLE_NONE 0
#define GT_NO_HANDLE 0 /* depreciated - use GT_HANDLE_NONE instead */

/*
 * Size type
 */
#if (defined(WIN32) || defined(_WIN32_WCE))
 typedef SIZE_T  GT_SIZE_T; 
#elif __linux__
 typedef size_t  GT_SIZE_T;
#endif

/*
 * Time type
 */
typedef unsigned long GT_TIMESTAMP_MS;


typedef int GT_STATUS;
#define GT_SUCCESS   0

#define GT_QEVENT_APP							0xFFFF0000
#define GT_QEVENT_APP_QUIT						(GT_QEVENT_APP + 1)
#define GT_QEVENT_APP_HOUR_NOTIFY				(GT_QEVENT_APP + 2)
#define GT_QEVENT_APP_TIMER					(GT_QEVENT_APP + 3)
#define GT_QEVENT_APP_TRACER					(GT_QEVENT_APP + 4)


#define GT_NULL_STR								GT_NULL



#if (defined(WIN32) || defined(_WIN32_WCE))
	#define	snprintf	_snprintf
#if _MSC_VER <= 1400
//Defines the MFC version. For example, in Visual Studio 2010, _MFC_VER is defined as 0x0A00.
 /*
Use _MSC_VER define:
#if _MSC_VER >= 1400
   // this is Visual C++ 2005
#elif _MSC_VER >= 1310
   // this is Visual c++ .NET 2003
#elif _MSC_VER > 1300
   // this is Visual C++ .NET 2002
#endif
 */
	#define	vsnprintf	_vsnprintf
#endif
#endif


//#define GT_EVENT_STARTER_VALUE							0x7FF00000
//#define GT_EVENT_DSP_TIMER_EXPIRED						(GT_EVENT_STARTER_VALUE + 0x01)


//For SIP ActiveX Phone and SIP ActiveX Control, this option has to be disabled, otherwise it will crash the application which uses it
//especially when starting(calling StartServer).
//Haven't found reason
//#define USE_MEM_QUEUE_NETCMD

#endif
