// ------------------------------------------------------------------
//	File: gtevent.h
//
//
// ==================================================================
// IF YOU DO NOT AGREE WITH THE FOLLOWING STATEMENT, YOU MUST 
// PROMPTLY RETURN THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION 
// ("PRODUCT") TO PCBest Networks(www.pcbest.net).
//
// PCBest Networks owns all title and 
// ownership rights to Software.  "Software" means any data processing
// programs (hereinafter "programs") consisting of a series of 
// instructions or statements in object code form, including any 
// systemized collection of data in the form of a data base, and any
// related proprietary materials such as flow charts, logic diagrams, 
// manuals media and listings provided for use with the programs.
// User has no right, express or implied, to transfer, sell, provide
// access to or dispose of Software to any third party without PCBest Networks'
// prior written consent.  User will not copy, reverse assemble,
// reverse engineer, decompile, modify, alter, translate or display
// the Software other than as expressly permitted by PCBest Networks in writing.
// ------------------------------------------------------------------



#if !defined(__GTAPI_EVENT_HEADER_FILE_H)
#define __GTAPI_EVENT_HEADER_FILE_H

#include "GTTypes.h"
#include "GTList.h"
//#include "GTUtil.h"

#ifdef USE_GTAPI_NAMESPACE
namespace GTAPI
{
#endif

	typedef struct GTEvent
	{
	public:
		GT_UINT          id;        /* The event id */
		GT_HANDLE		 handle;    /* The handle of the object raising the event */
		//GT_TIMESTAMP_MS  timestamp; /* The timestamp the event was raised */
		GT_VOID         *userData;  /* The user data associated with the object (see GT_QUEUE_Attach) */
		GT_VOID         *p0;        /* The first parameter of the event */
		GT_VOID         *p1;        /* The second parameter of the event */
		GT_VOID         *p2;        /* The third parameter of the event */

		GTEvent()
		{
			id = 0;
			handle = 0;
			userData = GT_NULL;
			p0 = p1 = p2 = GT_NULL;
		}
	} TGTEvent;

	typedef TCQueue<TGTEvent> TGTEventQueue;

	class GT_DLL_API CGTEventInterface
	{
	public:
		CGTEventInterface(){CreateEventQueue(200);}
		virtual ~CGTEventInterface(){DestroyEventQueue();}

		GT_BOOL							PushEvent(TGTEvent* pevent)
		{
			if(m_pMsgQueue)
			{
				if(m_pMsgQueue->PutData(pevent, 100))
					return GT_TRUE;
			}

			return GT_FALSE;
		}

		void							ProcessEvent()
		{
			TGTEvent msg;
			
			if(m_pMsgQueue)
			{
				while(m_pMsgQueue->GetData(&msg, 0))
				{
					ProcessEvent(&msg);
				}
			}
		}

		void							ClearEvent()
		{
			if(m_pMsgQueue)
				m_pMsgQueue->Clear();
		}

	protected:
		virtual void					ProcessEvent(TGTEvent* pevent){}

		void							CreateEventQueue(int queueSize)
		{
			m_pMsgQueue = new TGTEventQueue(queueSize, false);
		}

		void							DestroyEventQueue()
		{
			if(m_pMsgQueue)
			{
				delete m_pMsgQueue;
				m_pMsgQueue = NULL;
			}
		}

	protected:
		TGTEventQueue*				m_pMsgQueue;

	};

/*
	class CGTStatusMachine;

	class GT_DLL_API CGTSMEvent
	{
	public:
		CGTSMEvent(){m_EventID=0;m_pNextStatus=0;}
		virtual ~CGTSMEvent(){}

		CGTStatusMachine*					GetNextStatus(){return m_pNextStatus;}
		void								SetNextStatus(CGTStatusMachine* sm){m_pNextStatus = sm;}

		GT_UINT								GetEventID(){return m_EventID;}
		void								SetEventID(GT_UINT id){m_EventID=id;}

		virtual GT_INT						Action(){return 0;}

	protected:
		virtual GT_INT						Notify(){return 0;}
		virtual GT_INT						Signal(){return 0;}

	protected:
		GT_UINT								m_EventID;
		CGTStatusMachine*					m_pNextStatus;
	};


	class GT_DLL_API CGTStatusMachine
	{
	public:
		CGTStatusMachine(){m_hTimer=GT_TIMER_Create(0,CGTStatusMachine::GT_StatusMachine_Timer_Callback,this);}
		virtual ~CGTStatusMachine(){GT_TIMER_Destroy(m_hTimer);}

		virtual void OnTimer(){}

		void StartTimer(GT_UINT millsec){GT_TIMER_Start(m_hTimer, millsec, 1);}
		void StopTimer(){GT_TIMER_Stop(m_hTimer);}

		static void GT_StatusMachine_Timer_Callback(void *pData, unsigned int idEvent, unsigned int dwTime)
		{
			CGTStatusMachine* p = (CGTStatusMachine*)pData;
			p->OnTimer();
		}

	protected:
		GT_HANDLE				m_hTimer;
		CPtArray				m_EventList;
	};
*/


#ifdef USE_GTAPI_NAMESPACE
}
#endif

#endif