// ------------------------------------------------------------------
//	File: gtcfg.h
//
//
// ==================================================================
// IF YOU DO NOT AGREE WITH THE FOLLOWING STATEMENT, YOU MUST 
// PROMPTLY RETURN THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION 
// ("PRODUCT") TO PCBest Networks(www.pcbest.net).
//
// PCBest Networks owns all title and 
// ownership rights to Software.  "Software" means any data processing
// programs (hereinafter "programs") consisting of a series of 
// instructions or statements in object code form, including any 
// systemized collection of data in the form of a data base, and any
// related proprietary materials such as flow charts, logic diagrams, 
// manuals media and listings provided for use with the programs.
// User has no right, express or implied, to transfer, sell, provide
// access to or dispose of Software to any third party without PCBest Networks'
// prior written consent.  User will not copy, reverse assemble,
// reverse engineer, decompile, modify, alter, translate or display
// the Software other than as expressly permitted by PCBest Networks in writing.
// ------------------------------------------------------------------



#if !defined(__GTAPI_CFG_INTERFACE_DEFINITION_H)
#define __GTAPI_CFG_INTERFACE_DEFINITION_H

#include "GTTypes.h"

typedef void GT_CFG_Load_PRC(const char* sCfgFileName);
typedef bool GT_CFG_KeyExists_PRC(const char* sKey);
typedef const char* GT_CFG_GetValue_PRC(const char* sKey, const char* def);
typedef int GT_CFG_GetIntValue_PRC(const char* sKey, const int def);
typedef long GT_CFG_GetLongValue_PRC(const char* sKey, const long def);
typedef void GT_CFG_SetValue_PRC(const char* sKey, const char* val);


#ifdef USE_GTAPI_NAMESPACE
namespace GTAPI
{
#endif

	////////////////////////////////////////////////////////////////////////////////////////////
	/////Config Function
	////////////////////////////////////////////////////////////////////////////////////////////
	GT_DLL_API void					GT_CFG_Load(const char* sCfgFileName);
	GT_DLL_API bool					GT_CFG_KeyExists(const char* sKey);
	GT_DLL_API const char*			GT_CFG_GetValue(const char* sKey, const char* def);
	GT_DLL_API int					GT_CFG_GetIntValue(const char* sKey, const int def);
	GT_DLL_API long					GT_CFG_GetLongValue(const char* sKey, const long def);
	GT_DLL_API void					GT_CFG_SetValue(const char* sKey, const char* val);

	struct CGTCFGEnv
	{
		GT_CFG_Load_PRC*					_Load;
		GT_CFG_KeyExists_PRC*				_KeyExists;
		GT_CFG_GetValue_PRC*				_GetValue;
		GT_CFG_GetIntValue_PRC*				_GetIntValue;
		GT_CFG_GetLongValue_PRC*			_GetLongValue;
		GT_CFG_SetValue_PRC*				_SetValue;


		CGTCFGEnv()
		{_Load=GT_NULL;_KeyExists=GT_NULL;_GetValue=GT_NULL;_GetIntValue=GT_NULL;_GetLongValue=GT_NULL;_SetValue=GT_NULL;}

		CGTCFGEnv(GT_CFG_Load_PRC* pload, GT_CFG_KeyExists_PRC* pkeyexists, \
			GT_CFG_GetValue_PRC* pgetvaule, GT_CFG_GetIntValue_PRC* pgetintvalue, \
			GT_CFG_GetLongValue_PRC* pgetlongvalue, GT_CFG_SetValue_PRC* psetvalue)
		{
			_Load = pload;
			_KeyExists = pkeyexists;
			_GetValue = pgetvaule;
			_GetIntValue = pgetintvalue;
			_GetLongValue = pgetlongvalue;
			_SetValue = psetvalue;
		}
	};

	GT_DLL_API CGTCFGEnv*					AfxGetGTCfgEnv();
	GT_DLL_API void							AfxSetGTCfgEnv(CGTCFGEnv* pLog);

	class GT_DLL_API CGTCfgInterface
	{
	public:
		static bool	CFG_KeyExists(const char* sKey);
		static const char* CFG_GetValue(const char* sKey, const char* def);
		static int CFG_GetIntValue(const char* sKey, const int def);
		static long	CFG_GetLongValue(const char* sKey, const long def);
		static void CFG_SetValue(const char* sKey, const char* val);
	};


#ifdef USE_GTAPI_NAMESPACE
}
#endif

#endif