﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Xml;
using System.Data.SqlClient;
using System.IO;
using System.Diagnostics;
using System.Net.Mail;
using System.Net.Mime;
using VR2;

namespace VR2WinApp
{
    public partial class EmailRecording : Form
    {
        public string CallerId;
        public string CalleeId;
        public string TimeInit;
        public string TimeBegin;
        public string TimeEnd;
        public string Duration;
        public string WavFile;
        public EmailServerSetting email_set;

        public EmailRecording()
        {
            InitializeComponent();
        }

        private void tbSendEmail_Click(object sender, EventArgs e)
        {
            string[] NotifyRecordingEmails;
            string sEmails = tbEmails.Text;

            if (sEmails.Length > 0)
            {
                char[] delimiters = new char[] { ';', ',' };
                NotifyRecordingEmails = sEmails.Split(delimiters, StringSplitOptions.RemoveEmptyEntries);

                try
                {
                    MailMessage myMail = new MailMessage(email_set.emailAddr, email_set.emailAddr);
                    myMail.Subject = "VR2 Recording log - " + TimeInit + " " + CallerId + " " + CalleeId;

                    myMail.Body = "Caller: " + CallerId + "\r\n";
                    myMail.Body += "Called: " + CalleeId + "\r\n";
                    myMail.Body += "Start: " + TimeInit + "\r\n";
                    myMail.Body += "Connect: " + TimeBegin + "\r\n";
                    myMail.Body += "End: " + TimeEnd + "\r\n";
                    myMail.Body += "Duration: " + Duration + " seconds\r\n";

                    if (File.Exists(WavFile))
                        myMail.Attachments.Add(new Attachment(WavFile));

                    for (int i = 0; i < NotifyRecordingEmails.Length; i++)
                    {
                        MailAddress bcc = new MailAddress(NotifyRecordingEmails[i]);
                        //myMail.Bcc.Add(bcc);
                        myMail.To.Add(bcc);
                    }

                    SmtpClient smtp_client = new SmtpClient(email_set.emailServer, email_set.emailPort);

                    smtp_client.UseDefaultCredentials = false;
                    smtp_client.Credentials = new NetworkCredential(email_set.emailAddr, email_set.emailPassword);
                    smtp_client.EnableSsl = email_set.emailSSL;

                    // Set the method that is called back when the send operation ends.
                    //smtp_client.SendCompleted += new SendCompletedEventHandler(SendCompletedCallback);

                    //string userState = "test message1";
                    //smtp_client.SendAsync(myMail, this);


                    smtp_client.Send(myMail);

                    MessageBox.Show("Email was sent successfully!");
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString());
                    //VRAPIASM.VRAPIEnv.Log(1, ex.Message);
                }

            }
            else
            {
                MessageBox.Show("Please enter email address to send");
            }
        }

        private void EmailRecording_Load(object sender, EventArgs e)
        {
            tbCaller.Text = CallerId;
            tbCalled.Text = CalleeId;
            tbDuration.Text = Duration;
            tbAudioFile.Text = WavFile;
        }
    }
}
