using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.IO;


namespace VR2WinApp
{
    public partial class VR2Options : Form
    {
        public XmlDocument xmlCfg;
        public Form1 mainForm;
        public int StartRecordingOnBoot;

        public VR2Options()
        {
            InitializeComponent();
            mainForm = null;
            xmlCfg = null;
            StartRecordingOnBoot = 0;
        }



        public static bool GetBooleanFromXMLNode(XmlNode tmpNode)
        {
            if (tmpNode != null)
            {
                if (tmpNode.InnerText.Trim().ToUpper() == "TRUE")
                    return true;
                else
                {
                    if (tmpNode.InnerText.Trim() == "1")
                        return true;
                    else
                        return false;
                }
            }

            return false;
        }


        private void VR2Options_Load(object sender, EventArgs e)
        {
            for (int i = 0; i < mainForm.NICs.Count; i++)
            {
                cbNICs.Items.Add(mainForm.NICs[i]);
            }

            cbNICs.SelectedIndex = 0;

            if(StartRecordingOnBoot == 1)
                cbStartRecordingOnBoot.Checked = true;
            else
                cbStartRecordingOnBoot.Checked = false;

            XmlElement root = xmlCfg.DocumentElement;

            XmlNode tmpNode = null;

            try
            {
                /*
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Type");
                if (tmpNode != null)
                {
                    VRType = Convert.ToInt32(tmpNode.InnerText.Trim());
                }
                */

                tmpNode = root.SelectSingleNode("//VoiceRecorder/AudioRootFolder");
                if (tmpNode != null)
                {
                    tbRootFolder.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/AudioFileFormat");
                if (tmpNode != null)
                {
                    int AudioFormat = Convert.ToInt32(tmpNode.InnerText.Trim());

                    if (AudioFormat == 0)
                    {
                        rbWav.Checked = true;
                        rbMP3.Checked = false;
                        rbGSM.Checked = false;
                        rbWZP.Checked = false;
                    }
                    else if (AudioFormat == 1)
                    {
                        rbWav.Checked = false;
                        rbMP3.Checked = true;
                        rbGSM.Checked = false;
                        rbWZP.Checked = false;
                    }
                    else if (AudioFormat == 2)
                    {
                        rbWav.Checked = false;
                        rbMP3.Checked = false;
                        rbGSM.Checked = true;
                        rbWZP.Checked = false;
                    }
                    else if (AudioFormat == 3)
                    {
                        rbWav.Checked = false;
                        rbMP3.Checked = false;
                        rbGSM.Checked = false;
                        rbWZP.Checked = true;
                    }

                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/EncryptAudioFile");
                if (tmpNode != null)
                {
                    if (Convert.ToInt32(tmpNode.InnerText.Trim()) == 1)
                    {
                        cbEncryptAudioFile.Checked = true;
                    }
                    else
                    {
                        cbEncryptAudioFile.Checked = false;
                    }
                }

                /*
                                tmpNode = root.SelectSingleNode("//VoiceRecorder/Credential");
                                if (tmpNode != null)
                                {
                                    try
                                    {
                                        string sCredential = tmpNode.InnerText.Trim();
                                        if (sCredential.Length > 0)
                                        {
                                            char[] delimiters = new char[] { ';', ',' };
                                            string[] members = sCredential.Split(delimiters, StringSplitOptions.None);
                                            if (members.Length == 3)
                                            {
                                                UserName = members[0];
                                                Password = new SecureString();
                                                for (int j = 0; j < members[1].Length; j++)
                                                {
                                                    Password.AppendChar(members[1][j]);
                                                }
                                                Domain = members[2];
                                            }
                                        }
                                    }
                                    catch (Exception)
                                    {
                                    }
                                }*/

                cbLogLevel.Items.Add("Disabled");
                cbLogLevel.Items.Add("Error only");
                cbLogLevel.Items.Add("Error + Warning");
                cbLogLevel.Items.Add("Error + Warning + Debug");
                cbLogLevel.Items.Add("ALL");
                cbLogLevel.SelectedIndex = 0;
                tmpNode = root.SelectSingleNode("//VoiceRecorder/LogLevel");
                if (tmpNode != null)
                {
                    try
                    {
                        cbLogLevel.SelectedIndex = Convert.ToInt16(tmpNode.InnerText.Trim());
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(ex.ToString());
                    }
                }
                else
                {
                }

                tbLogFile.Text = "";
                tmpNode = root.SelectSingleNode("//VoiceRecorder/LogFileName");
                if (tmpNode != null)
                {
                    tbLogFile.Text = tmpNode.InnerText.Trim();
                }

                //Filters:
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Filters");
                if (tmpNode != null)
                {
                    tbFilters.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/Excludes");
                if (tmpNode != null)
                {
                    tbExcludes.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/ChannelCount");
                if (tmpNode != null)
                {
                    tbChannels.Text = tmpNode.InnerText.Trim();
                    if (tbChannels.Text == "")
                        tbChannels.Text = "4";
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/LicKey");
                if (tmpNode != null)
                {
                    tbLicKey.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/LicMAC");
                if (tmpNode != null)
                {
                    tbLicMAC.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/ManagerPort");
                if (tmpNode != null)
                {
                    tbManagePort.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/KeepRecordMaxDays");
                if (tmpNode != null)
                {
                    tbMaxDays.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/EnableRTSrv");
                if (tmpNode != null)
                {
                    int EnableRTSrv;
                    try
                    {
                        EnableRTSrv = Convert.ToInt32(tmpNode.InnerText.Trim());
                    }
                    catch (Exception)
                    {
                        EnableRTSrv = 0;
                    }

                    if (EnableRTSrv == 1)
                        cbRTSrv.Checked = true;
                    else
                        cbRTSrv.Checked = false;

                }

                //DATABASE
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/Enabled");
                if (tmpNode != null)
                {
                    cbDBEnabled.Checked = GetBooleanFromXMLNode(tmpNode);
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBType");
                if (tmpNode != null)
                {
                    cbDBType.SelectedIndex = Convert.ToInt32(tmpNode.InnerText);
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBServer");
                if (tmpNode != null)
                {
                    tbDBServer.Text = tmpNode.InnerText;
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBName");
                if (tmpNode != null)
                {
                    tbDBName.Text = tmpNode.InnerText;
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/AuthType");
                if (tmpNode != null)
                {
                    cbDBAuthType.SelectedIndex = Convert.ToInt32(tmpNode.InnerText);
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/UserName");
                if (tmpNode != null)
                {

                    tbDBUserName.Text = tmpNode.InnerText;
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/Password");
                if (tmpNode != null)
                {
                    tbDBPassword.Text = tmpNode.InnerText;
                }

/*
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/CallLogTableName");
                if (tmpNode != null)
                {
                    if (tmpNode.InnerText.Length > 0)
                        db_set.CallLogTableName = tmpNode.InnerText;
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/ChannelStatusTableName");
                if (tmpNode != null)
                {
                    if (tmpNode.InnerText.Length > 0)
                        db_set.ChannelStatusTableName = tmpNode.InnerText;
                }*/

                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/UpdateChannelStatusToDB");
                if (tmpNode != null)
                {
                    cbUpdateChanToDB.Checked = GetBooleanFromXMLNode(tmpNode);
                }

                //VoIP related options
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/Protocol");
                if (tmpNode != null)
                {
                    cbProtocol.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/Port");
                if (tmpNode != null)
                {
                    tbPort.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/NIC");
                if (tmpNode != null)
                {
                    short NicIndex = Convert.ToInt16(tmpNode.InnerText.Trim());

                    if (NicIndex >= 0 && NicIndex < mainForm.NICs.Count)
                        cbNICs.SelectedIndex = NicIndex;               
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RTP/PBXAddr");
                if (tmpNode != null)
                {
                    tbPBXAddr.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RTP/ExtenAddr");
                if (tmpNode != null)
                {
                    tbExtensionList.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/IgnorePossibleSameCall");
                if (tmpNode != null)
                {
                    cbIgnorePossibleSameCall.Checked = GetBooleanFromXMLNode(tmpNode);
                }


                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/Recording");
                if (tmpNode != null)
                {
                    cbRecordingCalls.Checked = GetBooleanFromXMLNode(tmpNode);
                }
                else
                    cbRecordingCalls.Checked = true;

                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordCallLegs");
                if (tmpNode != null)
                {
                    cbCallLegs.Checked = GetBooleanFromXMLNode(tmpNode);
                }
                else
                    cbCallLegs.Checked = false;

                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/XMLCallInfo");
                if (tmpNode != null)
                {
                    cbXMLCallInfo.Checked = GetBooleanFromXMLNode(tmpNode);
                }
                else
                    cbXMLCallInfo.Checked = true;

                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/UsePacketTime");
                if (tmpNode != null)
                {
                    cbPacketTime.Checked = GetBooleanFromXMLNode(tmpNode);
                }
                else
                    cbPacketTime.Checked = false;

                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordPauseDTMFKey");
                if (tmpNode != null)
                {
                    tbPauseDTMF.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordPauseOption");
                if (tmpNode != null)
                {
                    tbPauseSet.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/SIPHeadersInXML");
                if (tmpNode != null)
                {
                    tbSIPHeaders.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/ExtenPattern");
                if (tmpNode != null)
                {
                    tbExtenPattern.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordOnlyAfterAnswer");
                if (tmpNode != null)
                {
                    cbRecordAfterAnswer.Checked = GetBooleanFromXMLNode(tmpNode);
                }
                else
                    cbRecordAfterAnswer.Checked = false;

                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/NoAudioSeconds");
                if (tmpNode != null)
                {
                    tbNoAudioSec.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/IDMaps");
                if (tmpNode != null)
                {
                    tbIDMaps.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/NotifyEmails");
                if (tmpNode != null)
                {
                    tbNotifyEmailAddr.Text = tmpNode.InnerText.Trim();
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/Server");
                if (tmpNode != null)
                    tbSMTPSrv.Text = tmpNode.InnerText;

                tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/Port");
                if (tmpNode != null)
                    tbSMTPPort.Text = tmpNode.InnerText;

                tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/EmailAddr");
                if (tmpNode != null)
                    tbEmailAddr.Text = tmpNode.InnerText;

                tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/Password");
                if (tmpNode != null)
                    tbEmailPassword.Text = tmpNode.InnerText;

                cbSSL.Checked = GetBooleanFromXMLNode(root.SelectSingleNode("//VoiceRecorder/SMTPServer/SSL"));

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {

            XmlElement root = xmlCfg.DocumentElement;

            XmlNode tmpNode = null;

            tmpNode = root.SelectSingleNode("//VoiceRecorder/AudioRootFolder");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbRootFolder.Text.Trim();
            }


            tmpNode = root.SelectSingleNode("//VoiceRecorder/AudioFileFormat");
            if (tmpNode != null)
            {
                if (rbWav.Checked) tmpNode.InnerText = "0";
                if (rbMP3.Checked) tmpNode.InnerText = "1";
                if (rbGSM.Checked) tmpNode.InnerText = "2";
                if (rbWZP.Checked) tmpNode.InnerText = "3";
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/EncryptAudioFile");
            if (tmpNode != null)
            {
                if(cbEncryptAudioFile.Checked)
                    tmpNode.InnerText = "1";
                else
                    tmpNode.InnerText = "0";
            }

            /*
                            tmpNode = root.SelectSingleNode("//VoiceRecorder/Credential");
                            if (tmpNode != null)
                            {
                                try
                                {
                                    string sCredential = tmpNode.InnerText.Trim();
                                    if (sCredential.Length > 0)
                                    {
                                        char[] delimiters = new char[] { ';', ',' };
                                        string[] members = sCredential.Split(delimiters, StringSplitOptions.None);
                                        if (members.Length == 3)
                                        {
                                            UserName = members[0];
                                            Password = new SecureString();
                                            for (int j = 0; j < members[1].Length; j++)
                                            {
                                                Password.AppendChar(members[1][j]);
                                            }
                                            Domain = members[2];
                                        }
                                    }
                                }
                                catch (Exception)
                                {
                                }
                            }*/

            tmpNode = root.SelectSingleNode("//VoiceRecorder/LogLevel");
            if (tmpNode != null)
            {
                tmpNode.InnerText = cbLogLevel.SelectedIndex.ToString();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/LogFileName");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbLogFile.Text.Trim();
            }

            //Filters:
            tmpNode = root.SelectSingleNode("//VoiceRecorder/Filters");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbFilters.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/Excludes");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbExcludes.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/ChannelCount");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbChannels.Text.Trim();
                if (tmpNode.InnerText == "")
                    tmpNode.InnerText = "4";
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/LicKey");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbLicKey.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/LicMAC");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbLicMAC.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/ManagerPort");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbManagePort.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/KeepRecordMaxDays");
            if (tmpNode != null)
            {
                tbMaxDays.Text = tmpNode.InnerText.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/EnableRTSrv");
            if (tmpNode != null)
            {
                if(cbRTSrv.Checked)
                    tmpNode.InnerText = "1";
                else
                    tmpNode.InnerText = "0";
            }

            //DATABASE
            tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/Enabled");
            if (tmpNode != null)
            {
                if(cbDBEnabled.Checked)
                    tmpNode.InnerText = "true";
                else
                    tmpNode.InnerText = "false";
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBType");
            if (tmpNode != null)
            {
                tmpNode.InnerText = cbDBType.SelectedIndex.ToString();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBServer");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbDBServer.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBName");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbDBName.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/AuthType");
            if (tmpNode != null)
            {
                tmpNode.InnerText = cbDBAuthType.SelectedIndex.ToString();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/UserName");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbDBUserName.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/Password");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbDBPassword.Text.Trim();
            }

            /*
                            tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/CallLogTableName");
                            if (tmpNode != null)
                            {
                                if (tmpNode.InnerText.Length > 0)
                                    db_set.CallLogTableName = tmpNode.InnerText;
                            }

                            tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/ChannelStatusTableName");
                            if (tmpNode != null)
                            {
                                if (tmpNode.InnerText.Length > 0)
                                    db_set.ChannelStatusTableName = tmpNode.InnerText;
                            }*/

            tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/UpdateChannelStatusToDB");
            if (tmpNode != null)
            {
                if(cbUpdateChanToDB.Checked)
                    tmpNode.InnerText = "true";
                else
                    tmpNode.InnerText = "false";
            }

            //VoIP related options
            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/Protocol");
            if (tmpNode != null)
            {
                tmpNode.InnerText = cbProtocol.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/Port");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbPort.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/NIC");
            if (tmpNode != null)
            {
                tmpNode.InnerText = cbNICs.SelectedIndex.ToString();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RTP/PBXAddr");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbPBXAddr.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RTP/ExtenAddr");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbExtensionList.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/IgnorePossibleSameCall");
            if (tmpNode != null)
            {
                if(cbIgnorePossibleSameCall.Checked)
                    tmpNode.InnerText = "true";
                else
                    tmpNode.InnerText = "false";
            }


            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/Recording");
            if (tmpNode != null)
            {
                if(cbRecordingCalls.Checked)
                    tmpNode.InnerText = "true";
                else
                    tmpNode.InnerText = "false";
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordCallLegs");
            if (tmpNode != null)
            {
                if(cbCallLegs.Checked)
                    tmpNode.InnerText = "true";
                else
                    tmpNode.InnerText = "false";
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/XMLCallInfo");
            if (tmpNode != null)
            {
                if(cbXMLCallInfo.Checked)
                    tmpNode.InnerText = "true";
                else
                    tmpNode.InnerText = "false";
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/UsePacketTime");
            if (tmpNode != null)
            {
                if(cbPacketTime.Checked)
                    tmpNode.InnerText = "true";
                else
                    tmpNode.InnerText = "false";
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordPauseDTMFKey");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbPauseDTMF.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordPauseOption");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbPauseSet.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/SIPHeadersInXML");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbSIPHeaders.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/ExtenPattern");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbExtenPattern.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordOnlyAfterAnswer");
            if (tmpNode != null)
            {
                if (cbRecordAfterAnswer.Checked)
                    tmpNode.InnerText = "true";
                else
                    tmpNode.InnerText = "false";
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/NoAudioSeconds");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbNoAudioSec.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/IDMaps");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbIDMaps.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/NotifyEmails");
            if (tmpNode != null)
            {
                tmpNode.InnerText = tbNotifyEmailAddr.Text.Trim();
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/Server");
            if (tmpNode != null)
                tmpNode.InnerText = tbSMTPSrv.Text.Trim();

            tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/Port");
            if (tmpNode != null)
                tmpNode.InnerText = tbSMTPPort.Text.Trim();

            tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/EmailAddr");
            if (tmpNode != null)
                tmpNode.InnerText = tbEmailAddr.Text.Trim();

            tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/Password");
            if (tmpNode != null)
                tmpNode.InnerText = tbEmailPassword.Text.Trim();

            tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/SSL");
            if(cbSSL.Checked)
                tmpNode.InnerText = "true";
            else
                tmpNode.InnerText = "false";

            if (cbStartRecordingOnBoot.Checked)
                StartRecordingOnBoot = 1;
            else
                StartRecordingOnBoot = 0;

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        public static string AddFolderDashForDir(string sDir)
        {
            string ret = sDir;
            if (sDir[sDir.Length - 1] != '\\')
                ret += '\\';
            return ret;
        }

        private void btnRootFolderBrowse_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog folderBrowserDialog1 = new FolderBrowserDialog();
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                tbRootFolder.Text = folderBrowserDialog1.SelectedPath;
            }
        }

    }
}