using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace VR2WinApp
{
    public partial class RunningModel : Form
    {
        public int RunModel;
        public string ServerIP;
        public ushort ServerPort;

        public RunningModel()
        {
            InitializeComponent();
            RunModel = 0;
            ServerIP = "";
            ServerPort = 0;
        }

        private void RunningModel_Load(object sender, EventArgs e)
        {
            tbIPAddr.Text = ServerIP;
            tbPort.Text = ServerPort.ToString();
            if (RunModel == 0)
            {
                radioButton1.Checked = true;
                radioButton2.Checked = false;
                tbIPAddr.Enabled = false;
                tbPort.Enabled = false;
            }
            else
            {
                radioButton1.Checked = false;
                radioButton2.Checked = true;
                tbIPAddr.Enabled = true;
                tbPort.Enabled = true;
            }
        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton2.Checked)
            {
                tbIPAddr.Enabled = true;
                tbPort.Enabled = true;
            }
            else
            {
                tbIPAddr.Enabled = false;
                tbPort.Enabled = false;
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (radioButton2.Checked)
            {
                RunModel = 1;
                ServerIP = tbIPAddr.Text;
                ServerPort = Convert.ToUInt16(tbPort.Text);
            }
            else
            {
                RunModel = 0;
                //ServerIP = tbIPAddr.Text;
                //ServerPort = tbPort.Text;
            }

            DialogResult = DialogResult.OK;

            Close();
        }


    }
}