using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using Microsoft.Win32;
using System.Xml;
using System.Threading;
using System.ServiceProcess;
using System.Security.Permissions;
using System.Security.Principal;
using VR2;

namespace VR2WinApp
{
    public partial class Form1 : Form
    {
        public const string VR2_REG_KEY_ROOT = "SOFTWARE\\PC Best Networks Inc\\VoIP Recorder V2\\";
        public const string VR2_Service_Name = "PCBest Networks VoIP Recorder v2";

        VR2Main vr2;

        public bool _bExit;
        //public bool Started;
        //public bool Inited;

        public const string VR2_TITLE = "PCBest Networks VoIP Recorder V2.10";
        //public const string VR2_TITLE = "Single Bill Solution VoIP Recorder v1.00";

        public XmlDocument xmlCfg;

        public List<string> NICs;

        public static Form1 main_form;

        public Queue<VR2Channel> event_queue;

        public int StartRecordingOnBoot;

        public int RunModel; // 0 = deskTop, 1 = win service

        public MyVR2Client vr_client;
        public bool serverConnected;
        public bool waiting_general;
        public string serverIP;
        public ushort serverPort;
        public bool serviceRunning;

        public Form1()
        {
            InitializeComponent();

            _bExit = false;

            //Started = false;
            //Inited = false;

            NICs = new List<string>();

            main_form = this;

            StartRecordingOnBoot = 0;
            RunModel = 0;

            event_queue = new Queue<VR2Channel>();

            vr_client = new MyVR2Client();
            vr_client.main_form = this;

            serverIP = "127.0.0.1";
            serverPort = 1376;

            serviceRunning = false;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            main_form = this;

            sbsPictureBox.Visible = false;
            pcbestLogo.Visible = true;
            richTextBox1.Visible = true;

            this.Text = VR2_TITLE;

            notifyIcon1.ContextMenuStrip = contextMenuStrip1;
            notifyIcon1.Text = VR2_TITLE;

            string sSysPath = Environment.SystemDirectory;

            if (!File.Exists(sSysPath + "\\packet.dll") || !File.Exists(sSysPath + "\\wpcap.dll"))
            {

                string message = "WinPcap is not installed! Please download it from http://www.winpcap.org/ and install it first.";
                string caption = "Error Detected - Missing WinPcap Driver";
                MessageBoxButtons buttons = MessageBoxButtons.OK;
                DialogResult result;

                // Displays the MessageBox.
                result = MessageBox.Show(message, caption, buttons);

                _bExit = true;
                Close();

                return;
            }


            RegistryKey regkey;

            regkey = Registry.LocalMachine.CreateSubKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\WinPcapInst");
            if (regkey == null)
            {
                string message = "WinPcap is not installed! Please download it from http://www.winpcap.org/ and install it first.";
                string caption = "Error Detected - Missing WinPcap Driver";
                MessageBoxButtons buttons = MessageBoxButtons.OK;
                DialogResult result;

                // Displays the MessageBox.
                result = MessageBox.Show(message, caption, buttons);

                _bExit = true;
                Close();

                return;
            }
            else
            {
                regkey.Close();
            }

            //string tmp;
            regkey = Registry.CurrentUser.CreateSubKey(VR2_REG_KEY_ROOT);
            if (regkey == null)
                return;

            Object obj = regkey.GetValue("RecordOnBoot");
            if (obj != null)
                StartRecordingOnBoot = (int)obj;

            obj = regkey.GetValue("RunModel");
            if (obj != null)
            {
                RunModel = (int)obj;
                obj = regkey.GetValue("ServerIP");
                if (obj != null)
                {
                    serverIP = (string)obj;
                }

                obj = regkey.GetValue("ServerPort");
                if (obj != null)
                {
                    int port = (int)obj;
                    serverPort = Convert.ToUInt16(port);
                }

            }
            else
            {
                //object is null, it is the first running, need to ask
                RunningModel dlg = new RunningModel();
                dlg.RunModel = RunModel;
                dlg.ServerIP = serverIP;
                dlg.ServerPort = serverPort;
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    RunModel = dlg.RunModel;
                    serverIP = dlg.ServerIP;
                    serverPort = dlg.ServerPort;
                    if (serverIP.Length == 0)
                        serverIP = "127.0.0.1";

                    regkey.SetValue("RunModel", RunModel);
                    regkey.SetValue("ServerIP", serverIP);
                    int port = serverPort;
                    regkey.SetValue("ServerPort", port);
                }
            }

            regkey.Close();

            if (LoadConfigFromXML() < 0)
            {
                _bExit = true;
                Close();
                return;
            }

            VRAPIASM.VRAPIEnv.InitCapture(0);

            short nicCount = VRAPIASM.VRAPIEnv.GetNICCount();

            if (nicCount <= 0)
            {
                VRAPIASM.VRAPIEnv.FreeCapture();
                MessageBox.Show("No Network Interface!");
                _bExit = true;
                Close();
                return;
            }
            else
            {
                for (short i = 0; i < nicCount; i++)
                {
                    string s = i.ToString() + " : " + VRAPIASM.VRAPIEnv.GetNICName(i) + " - " + VRAPIASM.VRAPIEnv.GetNICDescription(i);
                    short ipCount = VRAPIASM.VRAPIEnv.GetNICIPCount(i);
                    if (ipCount > 0)
                        s += " IP:";
                    for (short j = 0; j < ipCount; j++)
                    {
                        if (VRAPIASM.VRAPIEnv.GetNICIP(i, j) != "0.0.0.0")
                        {
                            s += VRAPIASM.VRAPIEnv.GetNICIP(i, j) + ";";
                        }
                    }

                    NICs.Add(s);
                }
                VRAPIASM.VRAPIEnv.FreeCapture();
            }

            startRecordingToolStripMenuItem.Enabled = true;
            stopRecordingToolStripMenuItem.Enabled = false;

            toolStripButtonPlay.Enabled = true;
            toolStripButtonStop.Enabled = false;

            recordingToolStripMenuItem.Text = "Status: Recording Stopped";
            toolStripStatusLabel1.Text = "Status: Recording Stopped";

            dataGridView1.Enabled = false;

            tbTotalChannels.Enabled = false;
            tbTotalChannels.Text = "";

            tbAvailableChannels.Enabled = false;
            tbAvailableChannels.Text = "";

            tbOfflineChannels.Enabled = false;
            tbOfflineChannels.Text = "";

            tbChannelInUse.Enabled = false;
            tbChannelInUse.Text = "";

//start_here:
            if (RunModel == 0)
            {
                if (StartRecordingOnBoot == 1)
                {
                    Start();
                }
            }
            else
            {
                //service model
                try
                {
                    ServiceControllerStatus srvStatus = GetWinServiceStatus(VR2_Service_Name);
                    if (srvStatus == System.ServiceProcess.ServiceControllerStatus.Stopped)
                    {
                        serviceRunning = false;
                        timer1.Enabled = false;

                        startRecordingToolStripMenuItem.Enabled = true;
                        stopRecordingToolStripMenuItem.Enabled = false;

                        toolStripButtonPlay.Enabled = true;
                        toolStripButtonStop.Enabled = false;


                        //Started = false;
                        optionsToolStripMenuItem1.Enabled = true;
                        toolStripButtonOptions.Enabled = true;

                        dataGridView1.Enabled = false;

                        tbTotalChannels.Enabled = false;
                        tbTotalChannels.Text = "";

                        tbAvailableChannels.Enabled = false;
                        tbAvailableChannels.Text = "";

                        tbOfflineChannels.Enabled = false;
                        tbOfflineChannels.Text = "";

                        tbChannelInUse.Enabled = false;
                        tbChannelInUse.Text = "";

                        recordingToolStripMenuItem.Text = "Status: Recording Service Stopped";
                        toolStripStatusLabel1.Text = "Status: Recording Service Stopped";
                    }
                    else if (GetWinServiceStatus(VR2_Service_Name) == System.ServiceProcess.ServiceControllerStatus.Running)
                    {
                        serviceRunning = true;
                        startRecordingToolStripMenuItem.Enabled = false;
                        stopRecordingToolStripMenuItem.Enabled = true;

                        toolStripButtonPlay.Enabled = false;
                        toolStripButtonStop.Enabled = true;

                        //Started = true;
                        optionsToolStripMenuItem1.Enabled = false;
                        toolStripButtonOptions.Enabled = false;

                        tbTotalChannels.Enabled = true;
                        tbAvailableChannels.Enabled = true;
                        tbOfflineChannels.Enabled = true;
                        tbChannelInUse.Enabled = true;

                        //tbTotalChannels.Text = vr2.ChannelCount.ToString();
                        //tbAvailableChannels.Text = vr2.ChannelCount.ToString();
                        tbOfflineChannels.Text = "0";
                        tbChannelInUse.Text = "";

                        timer1.Enabled = true;

                        recordingToolStripMenuItem.Text = "Status: Recording Service Running";
                        toolStripStatusLabel1.Text = "Status: Recording Service Running";
                    }
                    else
                    {

                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString());

                    //no service is installed
                    timer1.Enabled = false;

                    startRecordingToolStripMenuItem.Enabled = false;
                    stopRecordingToolStripMenuItem.Enabled = false;

                    toolStripButtonPlay.Enabled = false;
                    toolStripButtonStop.Enabled = false;


                    //Started = false;
                    optionsToolStripMenuItem1.Enabled = true;
                    toolStripButtonOptions.Enabled = true;

                    dataGridView1.Enabled = false;

                    tbTotalChannels.Enabled = false;
                    tbTotalChannels.Text = "";

                    tbAvailableChannels.Enabled = false;
                    tbAvailableChannels.Text = "";

                    tbOfflineChannels.Enabled = false;
                    tbOfflineChannels.Text = "";

                    tbChannelInUse.Enabled = false;
                    tbChannelInUse.Text = "";

                    recordingToolStripMenuItem.Text = "Status: N/A";
                    toolStripStatusLabel1.Text = "Status: N/A";

                    serviceRunning = false;
                }

            //start_here1:
                if (serviceRunning)
                {
                    uint resConnect = vr_client.ConnectTo(serverIP, serverPort);

                    if (resConnect == 0)
                    {
                        LogoutText("Cannot connect to recorder service!");
                        vr_client.Disconnect();
/*
                        RunningModel dlg = new RunningModel();
                        dlg.RunModel = RunModel;
                        dlg.ServerIP = serverIP;
                        dlg.ServerPort = serverPort;
                        if (dlg.ShowDialog() == DialogResult.OK)
                        {
                            RunModel = dlg.RunModel;
                            serverIP = dlg.ServerIP;
                            serverPort = dlg.ServerPort;
                            if (serverIP.Length == 0)
                                serverIP = "127.0.0.1";

                            if (RunModel == 0)
                                goto start_here;
                            else
                                goto start_here1;
                        }*/
                    }
                }
                else
                {
                }
            }
        }

        public bool StartPreCheck(string cfgFile)
        {
            XmlElement root = xmlCfg.DocumentElement;
            XmlNode tmpNode = root.SelectSingleNode("//VoiceRecorder/AudioRootFolder");
            if (tmpNode != null)
            {
                string rootFolder = tmpNode.InnerText.Trim();
                if(rootFolder.Length > 0)
                {
                    if (!Directory.Exists(rootFolder))
                    {
                        MessageBox.Show("Recording Root Folder(" + rootFolder + ") doesn't exist! Please create it first or change it in Options/Basic." + cfgFile);
                        return false;
                    }
                }
                else
                {
                    MessageBox.Show("Recording Root Folder is set to null. Please set it in Options/Basic.");
                    return false;
                }
            }
            else
            {
                MessageBox.Show("Missing AudioRootFolder in XML config file :" + cfgFile);
                return false;
            }

            return true;
        }

        public void StopService()
        {
            bool succ = false;

            try
            {
                StopWinService(VR2_Service_Name);
                succ = true;
            }
            catch (Exception ex)
            {
                succ = false;
                MessageBox.Show(ex.ToString());
            }

            if (succ)
            {
                serviceRunning = false;
                timer1.Enabled = false;

                startRecordingToolStripMenuItem.Enabled = true;
                stopRecordingToolStripMenuItem.Enabled = false;

                toolStripButtonPlay.Enabled = true;
                toolStripButtonStop.Enabled = false;


                //Started = false;
                optionsToolStripMenuItem1.Enabled = true;
                toolStripButtonOptions.Enabled = true;

                dataGridView1.Enabled = false;

                tbTotalChannels.Enabled = false;
                tbTotalChannels.Text = "";

                tbAvailableChannels.Enabled = false;
                tbAvailableChannels.Text = "";

                tbOfflineChannels.Enabled = false;
                tbOfflineChannels.Text = "";

                tbChannelInUse.Enabled = false;
                tbChannelInUse.Text = "";

                recordingToolStripMenuItem.Text = "Status: Recording Service Stopped";
                toolStripStatusLabel1.Text = "Status: Recording Service Stopped";

            }

        }

        public void StartService()
        {
            bool succ = false;
            try
            {
                StartWinService(VR2_Service_Name);
                succ = true;
            }
            catch (Exception ex)
            {
                succ = false;
                MessageBox.Show(ex.ToString());
            }

            if (succ)
            {
                serviceRunning = true;

                Thread.Sleep(1000);

                startRecordingToolStripMenuItem.Enabled = false;
                stopRecordingToolStripMenuItem.Enabled = true;

                toolStripButtonPlay.Enabled = false;
                toolStripButtonStop.Enabled = true;

                //Started = true;
                optionsToolStripMenuItem1.Enabled = false;
                toolStripButtonOptions.Enabled = false;

                tbTotalChannels.Enabled = true;
                tbAvailableChannels.Enabled = true;
                tbOfflineChannels.Enabled = true;
                tbChannelInUse.Enabled = true;

                //tbTotalChannels.Text = vr2.ChannelCount.ToString();
                //tbAvailableChannels.Text = vr2.ChannelCount.ToString();
                tbOfflineChannels.Text = "0";
                tbChannelInUse.Text = "";

                timer1.Enabled = true;

                recordingToolStripMenuItem.Text = "Status: Recording Service Running";
                toolStripStatusLabel1.Text = "Status: Recording Service Running";
            }
        }

        public void Start()
        {
            string xmlFileName = Application.StartupPath + "\\VR2Config.xml";

            if (!StartPreCheck(xmlFileName))
                return;

            vr2 = new VR2Main();
            vr2.m_pCallOffered1 = cbCallOffered;
            vr2.Start(xmlFileName);

            Thread.Sleep(1000);

            startRecordingToolStripMenuItem.Enabled = false;
            stopRecordingToolStripMenuItem.Enabled = true;

            toolStripButtonPlay.Enabled = false;
            toolStripButtonStop.Enabled = true;

            //Started = true;
            optionsToolStripMenuItem1.Enabled = false;
            toolStripButtonOptions.Enabled = false;

            tbTotalChannels.Enabled = true;
            tbAvailableChannels.Enabled = true;
            tbOfflineChannels.Enabled = true;
            tbChannelInUse.Enabled = true;

            tbTotalChannels.Text = vr2.ChannelCount.ToString();
            tbAvailableChannels.Text = vr2.ChannelCount.ToString();
            tbOfflineChannels.Text = "0";
            tbChannelInUse.Text = "";

            if (!dataGridView1.Enabled || dataGridView1.RowCount != vr2.ChannelCount)
            {
                dataGridView1.Enabled = true;

                dataGridView1.DataSource = null;
                dataGridView1.ReadOnly = true;

                dataGridView1.RowCount = vr2.ChannelCount;
                dataGridView1.ColumnCount = 12;

                //dataGridView1.RowHeadersWidth = 2 * dataGridView1.RowHeadersWidth;

                dataGridView1.Columns[0].HeaderText = "Status";

                dataGridView1.Columns[1].HeaderText = "Init Time";
                dataGridView1.Columns[2].HeaderText = "Connect Time";
                dataGridView1.Columns[3].HeaderText = "Seconds";

                dataGridView1.Columns[4].HeaderText = "CallerIP";
                dataGridView1.Columns[5].HeaderText = "CallerID";
                dataGridView1.Columns[6].HeaderText = "CalleeIP";
                dataGridView1.Columns[7].HeaderText = "calleeID";
                dataGridView1.Columns[8].HeaderText = "UniqueID";
                dataGridView1.Columns[9].HeaderText = "AudioFile";
                dataGridView1.Columns[10].HeaderText = "Direction";
                dataGridView1.Columns[11].HeaderText = "DTMF";

                //dataGridView1.Rows[0].HeaderCell.OwningColumn.Width = 200;

                for (int i = 0; i < vr2.ChannelCount; i++)
                {
                    int index = i + 1;
                    dataGridView1.Rows[i].HeaderCell.Value = index.ToString();
                    dataGridView1.Rows[i].Cells[0].Value = "Idle";
                }

            }

            timer1.Enabled = true;

            recordingToolStripMenuItem.Text = "Status: Recording ...";

            if(vr2.IsLicensed())
                toolStripStatusLabel1.Text = "Status: Recording ...";
            else
                toolStripStatusLabel1.Text = "Status: Recording (NOT Licensed Software. ONLY record first 30 seconds of each call!)";

        }

        public void Stop()
        {
            timer1.Enabled = false;

            vr2.Stop();
            vr2 = null;
            startRecordingToolStripMenuItem.Enabled = true;
            stopRecordingToolStripMenuItem.Enabled = false;

            toolStripButtonPlay.Enabled = true;
            toolStripButtonStop.Enabled = false;


            //Started = false;
            optionsToolStripMenuItem1.Enabled = true;
            toolStripButtonOptions.Enabled = true;

            dataGridView1.Enabled = false;

            tbTotalChannels.Enabled = false;
            tbTotalChannels.Text = "";

            tbAvailableChannels.Enabled = false;
            tbAvailableChannels.Text = "";

            tbOfflineChannels.Enabled = false;
            tbOfflineChannels.Text = "";

            tbChannelInUse.Enabled = false;
            tbChannelInUse.Text = "";

            recordingToolStripMenuItem.Text = "Status: Recording Stopped";
            toolStripStatusLabel1.Text = "Status: Recording Stopped";
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (!_bExit)
            {
                e.Cancel = true;
                Hide();
                this.ShowInTaskbar = false;

                notifyIcon1.Visible = true;
                notifyIcon1.BalloonTipTitle = VR2_TITLE;
                notifyIcon1.BalloonTipText = "minimized here! double-click to show up.";
                notifyIcon1.BalloonTipIcon = System.Windows.Forms.ToolTipIcon.Info;
                notifyIcon1.ShowBalloonTip(500);
            }
            else
            {
                if (RunModel == 0)
                {
                    if (vr2 != null)
                    {
                        Stop();
                    }
                }
                else if (RunModel == 1)
                {
                    //doesn't matter, if service is running, let it run. Exit this client side.

                }
            }
        }

        private void Form1_Resize(object sender, EventArgs e)
        {
            if (FormWindowState.Minimized == this.WindowState)
            {
                notifyIcon1.BalloonTipTitle = VR2_TITLE;
                notifyIcon1.BalloonTipText = "minimized here! double-click to show up.";
                notifyIcon1.BalloonTipIcon = System.Windows.Forms.ToolTipIcon.Info;

                notifyIcon1.Visible = true;
                notifyIcon1.ShowBalloonTip(500);
                this.Hide();
                this.ShowInTaskbar = false;
            }

            else if (FormWindowState.Normal == this.WindowState)
            {
                notifyIcon1.Visible = false;
                this.ShowInTaskbar = true;
            }
        }

        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            Show();
            this.WindowState = FormWindowState.Normal;

            //this.ShowInTaskbar = true;
            //notifyIcon1.Visible = false;
        }

        public int LoadConfigFromXML()
        {
            string xmlFileName = Application.StartupPath + "\\VR2Config.xml";

            if (!File.Exists(xmlFileName))
            {
                xmlFileName = Application.StartupPath + "\\VR2Config-std.xml";
                if (!File.Exists(xmlFileName))
                {
                    MessageBox.Show("Neither VR2Config.xml nor VR2Config-std.xml exists!");
                    return -1;
                }
            }

            xmlCfg = new XmlDocument();
            try
            {
                xmlCfg.Load(xmlFileName);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                return -2;
            }

            //XmlElement root = xmlCfg.DocumentElement;

            xmlFileName = Application.StartupPath + "\\VR2Config.xml";

            if (!File.Exists(xmlFileName))
            {
                SaveConfigToXML();
            }

            return 1;
        }

        private void optionsToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            VR2Options dlg = new VR2Options();
            dlg.xmlCfg = xmlCfg;
            dlg.mainForm = this;
            dlg.StartRecordingOnBoot = StartRecordingOnBoot;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                StartRecordingOnBoot = dlg.StartRecordingOnBoot;
                SaveConfigToXML();
            }
        }

        private void toolStripButtonOptions_Click(object sender, EventArgs e)
        {
            VR2Options dlg = new VR2Options();
            dlg.xmlCfg = xmlCfg;
            dlg.mainForm = this;
            dlg.StartRecordingOnBoot = StartRecordingOnBoot;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                StartRecordingOnBoot = dlg.StartRecordingOnBoot;
                SaveConfigToXML();
            }
        }

        private void optionsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            VR2Options dlg = new VR2Options();
            dlg.mainForm = this;
            dlg.xmlCfg = xmlCfg;
            dlg.StartRecordingOnBoot = StartRecordingOnBoot;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                StartRecordingOnBoot = dlg.StartRecordingOnBoot;
                SaveConfigToXML();
            }
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            _bExit = true;
            Close();
        }

        private void quitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            _bExit = true;
            Close();
        }

        private void startRecordingToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (RunModel == 0)
                Start();
            else
                StartService();
        }

        private void stopRecordingToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (RunModel == 0)
                Stop();
            else
                StopService();
        }

        private void aboutToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            //SBSAboutForm frm = new SBSAboutForm();
            AboutForm frm = new AboutForm();
            frm.ShowDialog();
        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //SBSAboutForm frm = new SBSAboutForm();
            AboutForm frm = new AboutForm();
            frm.ShowDialog();
        }

        private void popOutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Show();
            this.WindowState = FormWindowState.Normal;
        }

        void SaveConfigToXML()
        {
            RegistryKey regkey;
            //string tmp;
            regkey = Registry.CurrentUser.CreateSubKey(VR2_REG_KEY_ROOT);
            if (regkey == null)
                return;

            regkey.SetValue("RecordOnBoot", StartRecordingOnBoot);

            regkey.Close();

            string xmlFileName = Application.StartupPath + "\\VR2Config.xml";

            try
            {
                xmlCfg.Save(xmlFileName);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
            }

        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (vr2 != null && VR2Main.MainObj != null)
            {
                int chanInUse = 0;

                if(vr2.Channels == null) return;

                lock (VR2Main.MainObj)
                {
                    VR2Channel[] Channels = vr2.Channels;

                    for (int i = 0; i < vr2.ChannelCount; i++)
                    {
                        if (Channels[i].ChanStatus == 0)
                        {
                            dataGridView1.Rows[i].Cells[0].Value = "Idle";
                            dataGridView1.Rows[i].Cells[1].Value = "";
                            dataGridView1.Rows[i].Cells[2].Value = "";
                            dataGridView1.Rows[i].Cells[3].Value = "";
                        }
                        else if (Channels[i].ChanStatus == 1)
                        {
                            dataGridView1.Rows[i].Cells[0].Value = "Ringing";
                            dataGridView1.Rows[i].Cells[1].Value = Channels[i].InitTime.ToString("yyyy-MM-dd HH:mm:ss");
                            dataGridView1.Rows[i].Cells[2].Value = "";
                            dataGridView1.Rows[i].Cells[3].Value = "";
                            chanInUse++;
                        }
                        else if (Channels[i].ChanStatus == 2)
                        {
                            dataGridView1.Rows[i].Cells[0].Value = "Connected";
                            dataGridView1.Rows[i].Cells[1].Value = Channels[i].InitTime.ToString("yyyy-MM-dd HH:mm:ss");
                            dataGridView1.Rows[i].Cells[2].Value = Channels[i].ConnectTime.ToString("yyyy-MM-dd HH:mm:ss");
                            TimeSpan sp = DateTime.Now - Channels[i].ConnectTime;
                            int totalSec = Convert.ToInt32(sp.TotalSeconds);
                            dataGridView1.Rows[i].Cells[3].Value = totalSec.ToString();
                            chanInUse++;
                        }


                        dataGridView1.Rows[i].Cells[4].Value = Channels[i].CallerIP;
                        dataGridView1.Rows[i].Cells[5].Value = Channels[i].CallerID;
                        dataGridView1.Rows[i].Cells[6].Value = Channels[i].CalleeIP;
                        dataGridView1.Rows[i].Cells[7].Value = Channels[i].CalleeID;
                        dataGridView1.Rows[i].Cells[8].Value = Channels[i].UniqueID;
                        dataGridView1.Rows[i].Cells[9].Value = Channels[i].AudioFile;
                        dataGridView1.Rows[i].Cells[10].Value = Channels[i].CallDir == 0 ? "Inbound" : "Outbound";
                        dataGridView1.Rows[i].Cells[11].Value = Channels[i].DTMFStr;
                    }
                }

                tbChannelInUse.Text = chanInUse.ToString();

                tbTotalCalls.Text = vr2.totalCallCount.ToString();
                tbConnectedCalls.Text = vr2.connCallCount.ToString();
                int failedCnt = (vr2.totalCallCount - vr2.connCallCount);
                tbFailedCalls.Text = failedCnt.ToString();
            }

            lock (event_queue)
            {
                while (event_queue.Count > 0)
                {
                    VR2Channel chan = event_queue.Dequeue();
                    string callerid = GetSIPAddressInfo(1, chan.CallerID);
                    string calleeid = GetSIPAddressInfo(1, chan.CalleeID);

                    if (callerid.Length > 0 && calleeid.Length > 0)
                    {
                        string msg = "New call from " + callerid + " to " + calleeid;
                        notifyIcon1.BalloonTipTitle = VR2_TITLE;
                        notifyIcon1.BalloonTipText = msg;
                        notifyIcon1.BalloonTipIcon = System.Windows.Forms.ToolTipIcon.Info;

                        notifyIcon1.Visible = true;
                        notifyIcon1.ShowBalloonTip(1000);
                    }

                    //toolStripStatusLabel1.Text = "Status: " + msg;

                }
            }

        }


        public static string GetSIPAddressInfo(int flag, string sipAddr)
        {
            //some memory problem with this one
            /*
             X [2009-04-21 11:58:43] *************On_ProxyNewCallSession got exception: Attempted to read or write protected memory. This is often an indication that other memory is corrupt.
             X [2009-04-21 11:58:43] System.AccessViolationException: Attempted to read or write protected memory. This is often an indication that other memory is corrupt.
             at GTAPIASM.GTAPIEnv.GTAPI_GetSIPAddressInfo(Int32 flag, String sipAddr)
             at GTAPIASM.GTAPIEnv.GetSIPAddressInfo(Int32 flag, String sipAddr) in C:\TEMP\projects\Samples\GTAPIASM\GTAPIASM\GTAPIEnv.cs:line 821
             at GTSIPPBX.SIPPBX.getExtensionBySIPAddr(String sip_addr)
             at GTSIPPBX.GTSIPPBXEnv.On_ProxyNewCallSession(UInt32 pid, UInt32 sid, UInt32 msg, String fromid, String toid, String suri, String via, String saddr, UInt16 nport, Boolean bCredit)
             */
            //return string.Copy(GTAPI_GetSIPAddressInfo(flag, sipAddr));

            if (sipAddr == null)
                return "";

            if (sipAddr.Length == 0)
                return "";

            //a fix for google andriod phone bad implementation
            if (sipAddr.IndexOf("<sip:") == -1 && sipAddr.IndexOf("sip:") >= 0)
            {
                int idx1 = sipAddr.IndexOf("sip:");
                if (idx1 == 0)
                {
                    sipAddr = "<" + sipAddr + ">";
                }
                else
                {
                    sipAddr = sipAddr.Substring(0, idx1) + "<" + sipAddr.Substring(idx1) + ">";
                }
            }

            int nPos = 0;
            int nPos1 = 0;

            if (flag == 0) //display name
            {
                nPos = sipAddr.IndexOf("<sip:");
                if (nPos == -1 || nPos == 0)
                    return "";
                else
                    return sipAddr.Substring(0, nPos);
            }
            else if (flag == 1) //user name
            {
                nPos = sipAddr.IndexOf("<sip:");
                if (nPos == -1)
                    return "";
                else
                {
                    nPos += 5;

                    nPos1 = sipAddr.IndexOf('@', nPos);
                    if (nPos1 == -1)
                        return "";
                    else
                        return sipAddr.Substring(nPos, nPos1 - nPos);
                }
            }
            else if (flag == 2) //ip address
            {
                nPos = sipAddr.IndexOf('@');
                if (nPos == -1)
                {
                    nPos = sipAddr.IndexOf("<sip:");
                    if (nPos == -1)
                        return "";
                    else
                        nPos += 5;
                }
                else
                    nPos += 1;

                nPos1 = sipAddr.IndexOf('>', nPos);

                string ipAddr = "";

                if (nPos1 == -1)
                    ipAddr = sipAddr.Substring(nPos);
                else
                    ipAddr = sipAddr.Substring(nPos, nPos1 - nPos);

                nPos = ipAddr.IndexOf(';');
                if (nPos != -1)
                    ipAddr = ipAddr.Substring(0, nPos);

                nPos = ipAddr.IndexOf(':');
                if (nPos != -1)
                    ipAddr = ipAddr.Substring(0, nPos);

                return ipAddr;
            }
            else if (flag == 3) //port
            {
                nPos = sipAddr.IndexOf('@');
                if (nPos == -1)
                {
                    nPos = sipAddr.IndexOf("<sip:");
                    if (nPos == -1)
                        return "";
                    else
                        nPos += 5;
                }
                else
                    nPos += 1;

                nPos1 = sipAddr.IndexOf('>', nPos);

                string ipAddr = "";

                if (nPos1 == -1)
                    ipAddr = sipAddr.Substring(nPos);
                else
                    ipAddr = sipAddr.Substring(nPos, nPos1 - nPos);

                nPos = ipAddr.IndexOf(';');
                if (nPos != -1)
                    ipAddr = ipAddr.Substring(0, nPos);

                nPos = ipAddr.IndexOf(':');
                if (nPos == -1)
                    ipAddr = "";
                else
                    ipAddr = ipAddr.Substring(nPos + 1);

                return ipAddr;
            }

            return "";
        }


        public static int cbCallOffered(int ChanIndex, string CallerIP, string CallerID, string CalleeIP, string CalleeID, uint CallTime, string UniqueID, string AudioFile, int CallDir)
        {
            VR2Channel chan = new VR2Channel();

            chan.ChanIndex = ChanIndex;
            chan.CallerIP = CallerIP;
            chan.CallerID = CallerID;
            chan.CalleeIP = CalleeIP;
            chan.CalleeID = CalleeID;
            chan.UniqueID = UniqueID;
            chan.AudioFile = AudioFile;
            chan.CallDir = CallDir;
            chan.InitTime = DateTime.Now;
            //chan.ConnectTime = DateTime.Now;
            //chan.EndTime = DateTime.Now;

            lock (main_form.event_queue)
            {
                main_form.event_queue.Enqueue(chan);
            }

            return 0;

        }

        private void toolStripButtonPlay_Click(object sender, EventArgs e)
        {
            if (RunModel == 0)
                Start();
            else
                StartService();
        }

        private void toolStripButtonStop_Click(object sender, EventArgs e)
        {
            if (RunModel == 1)
                Stop();
            else
                StopService();
        }

        private void toolStripButtonSearch_Click(object sender, EventArgs e)
        {
            PerformQuickSearch();
        }

        private void quickSearchToolStripMenuItem_Click(object sender, EventArgs e)
        {
            PerformQuickSearch();
        }

        public void PerformQuickSearch()
        {
            DBServerSetting db_set = null;

            XmlElement root = xmlCfg.DocumentElement;

            XmlNode tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/Enabled");
            if (tmpNode != null)
            {
                if (VR2.VR2Main.GetBooleanFromXMLNode(tmpNode))
                {
                    db_set = new DBServerSetting();

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBType");
                    if (tmpNode != null)
                        db_set.dbType = Convert.ToInt32(tmpNode.InnerText);

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBServer");
                    if (tmpNode != null)
                        db_set.sDBServer = tmpNode.InnerText;

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBName");
                    if (tmpNode != null)
                        db_set.sDBName = tmpNode.InnerText;

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/AuthType");
                    if (tmpNode != null)
                        db_set.authType = Convert.ToInt32(tmpNode.InnerText);

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/UserName");
                    if (tmpNode != null)
                        db_set.sUserName = tmpNode.InnerText;

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/Password");
                    if (tmpNode != null)
                        db_set.sPassword = tmpNode.InnerText;

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/CallLogTableName");
                    if (tmpNode != null)
                    {
                        if (tmpNode.InnerText.Length > 0)
                            db_set.CallLogTableName = tmpNode.InnerText;
                    }

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/ChannelStatusTableName");
                    if (tmpNode != null)
                    {
                        if (tmpNode.InnerText.Length > 0)
                            db_set.ChannelStatusTableName = tmpNode.InnerText;
                    }

                }
                else
                {
                    MessageBox.Show("Please enable database setting in Options/Database.");
                    return;
                }
            }
            else
            {
                MessageBox.Show("Please enable database setting in Options/Database.");
                return;
            }

            if (db_set != null)
            {
                if (db_set.ConnectDB())
                {
                    db_set.TestTables();

                    //update channel status if possible
                    //catCMD.CommandText = "CREATE TABLE " + ChannelStatusTableName + "(ChanID SmallInt, CallerIP varchar(80) NULL, CallerID varchar(80) NULL, CalleeIP varchar(80) NULL, CalleeID varchar(80) NULL, TimeInit datetime NULL, TimeBegin datetime NULL, TimeEnd datetime NULL, UniqueID varchar(150) NULL, RecordPath varchar(250) NULL, DIR TINYINT, CallConnected TINYINT, ChanStatus TINYINT)";

                    db_set.DisconnectDB();
                }
                else
                {
                    MessageBox.Show("Cannot access database. Please check database setting in Options/Database.");
                    return;
                }
            }
            else
            {
                MessageBox.Show("Please enable database setting in Options/Database.");
                return;
            }


            QuickSearch sr = new QuickSearch();
            sr.db_set = db_set;
            sr.ShowDialog();
        }

        private void complexSearchToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DBServerSetting db_set = null;
            int MaxChanNum = 4;

            XmlElement root = xmlCfg.DocumentElement;

            XmlNode tmpNode = root.SelectSingleNode("//VoiceRecorder/ChannelCount");
            if (tmpNode != null)
            {
                MaxChanNum = Convert.ToInt32(tmpNode.InnerText.Trim());
            }

            tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/Enabled");
            if (tmpNode != null)
            {
                if (VR2.VR2Main.GetBooleanFromXMLNode(tmpNode))
                {
                    db_set = new DBServerSetting();

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBType");
                    if (tmpNode != null)
                        db_set.dbType = Convert.ToInt32(tmpNode.InnerText);

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBServer");
                    if (tmpNode != null)
                        db_set.sDBServer = tmpNode.InnerText;

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBName");
                    if (tmpNode != null)
                        db_set.sDBName = tmpNode.InnerText;

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/AuthType");
                    if (tmpNode != null)
                        db_set.authType = Convert.ToInt32(tmpNode.InnerText);

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/UserName");
                    if (tmpNode != null)
                        db_set.sUserName = tmpNode.InnerText;

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/Password");
                    if (tmpNode != null)
                        db_set.sPassword = tmpNode.InnerText;

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/CallLogTableName");
                    if (tmpNode != null)
                    {
                        if (tmpNode.InnerText.Length > 0)
                            db_set.CallLogTableName = tmpNode.InnerText;
                    }

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/ChannelStatusTableName");
                    if (tmpNode != null)
                    {
                        if (tmpNode.InnerText.Length > 0)
                            db_set.ChannelStatusTableName = tmpNode.InnerText;
                    }

                }
                else
                {
                    MessageBox.Show("Please enable database setting in Options/Database.");
                    return;
                }
            }
            else
            {
                MessageBox.Show("Please enable database setting in Options/Database.");
                return;
            }

            if (db_set != null)
            {
                if (db_set.ConnectDB())
                {
                    db_set.TestTables();

                    //update channel status if possible
                    //catCMD.CommandText = "CREATE TABLE " + ChannelStatusTableName + "(ChanID SmallInt, CallerIP varchar(80) NULL, CallerID varchar(80) NULL, CalleeIP varchar(80) NULL, CalleeID varchar(80) NULL, TimeInit datetime NULL, TimeBegin datetime NULL, TimeEnd datetime NULL, UniqueID varchar(150) NULL, RecordPath varchar(250) NULL, DIR TINYINT, CallConnected TINYINT, ChanStatus TINYINT)";

                    db_set.DisconnectDB();
                }
                else
                {
                    MessageBox.Show("Cannot access database. Please check database setting in Options/Database.");
                    return;
                }
            }
            else
            {
                MessageBox.Show("Please enable database setting in Options/Database.");
                return;
            }

            ComplexSearch sr = new ComplexSearch();
            sr.db_set = db_set;
            sr.maxChanNum = MaxChanNum;
            sr.ShowDialog();
        }

        public void ServerConnected(bool bConnected)
        {
            /*
                        if (bConnected)
                        {
                            btnConnect.Enabled = false;
                            btnDisconnect.Enabled = true;
                        }
                        else
                        {
                            btnConnect.Enabled = true;
                            btnDisconnect.Enabled = false;
                        }
             */
            serverConnected = bConnected;
            if (!bConnected)
            {
                dataGridView1.Enabled = false;
                //LogoutText("Lost connection to server");
                //connectToolStripMenuItem.Enabled = true;
                //disconnectToolStripMenuItem.Enabled = false;
            }
            else
            {
                //LogoutText("Connected To Server " + serverIP + ":" + serverPort.ToString());
                vr_client.GetStatus("general");
                //connectToolStripMenuItem.Enabled = false;
                //disconnectToolStripMenuItem.Enabled = true;
            }
        }

        //Recorder VR2 Client Events
        public void Recorder_OnCallOffered(int ChanIndex, string CallerIP, string CallerID, string CalleeIP, string CalleeID, uint CallTime, string UniqueID, string AudioFile, int CallDir)
        {
/*
            LogoutText("OnCallOffered event arrived. caller:" + CallerID + " called:" + CalleeID + " call dir: " + CallDir.ToString() + " file: " + AudioFile);

            try
            {
                //if (DataViewType == 0)
                {
                    dataGridView1.Rows[ChanIndex].Cells[0].Value = "Ringing";
                    dataGridView1.Rows[ChanIndex].Cells[1].Value = CallerIP;
                    dataGridView1.Rows[ChanIndex].Cells[2].Value = CallerID;
                    dataGridView1.Rows[ChanIndex].Cells[3].Value = CalleeIP;
                    dataGridView1.Rows[ChanIndex].Cells[4].Value = CalleeID;
                    dataGridView1.Rows[ChanIndex].Cells[5].Value = UniqueID;
                    dataGridView1.Rows[ChanIndex].Cells[6].Value = AudioFile;
                    dataGridView1.Rows[ChanIndex].Cells[7].Value = CallDir == 0 ? "Inbound" : "Outbound";
                }
            }
            catch (Exception)
            {
            }*/

        }

        public void Recorder_OnCallConnected(int ChanIndex, string CallerIP, string CallerID, string CalleeIP, string CalleeID, uint InitTime, uint ConnectTime, string UniqueID, string AudioFile, int CallDir)
        {
/*
            LogoutText("OnCallConnected event arrived. caller:" + CallerID + " called:" + CalleeID + " call dir: " + CallDir.ToString() + " file: " + AudioFile);

            try
            {
                //if (DataViewType == 0)
                {
                    dataGridView1.Rows[ChanIndex].Cells[0].Value = "Recording";
                    dataGridView1.Rows[ChanIndex].Cells[1].Value = CallerIP;
                    dataGridView1.Rows[ChanIndex].Cells[2].Value = CallerID;
                    dataGridView1.Rows[ChanIndex].Cells[3].Value = CalleeIP;
                    dataGridView1.Rows[ChanIndex].Cells[4].Value = CalleeID;
                    dataGridView1.Rows[ChanIndex].Cells[5].Value = UniqueID;
                    dataGridView1.Rows[ChanIndex].Cells[6].Value = AudioFile;
                    dataGridView1.Rows[ChanIndex].Cells[7].Value = CallDir == 0 ? "Inbound" : "Outbound";
                }
            }
            catch (Exception)
            {
            }*/
        }

        public void Recorder_OnCallIdle(int ChanIndex, string CallerIP, string CallerID, string CalleeIP, string CalleeID, uint InitTime, uint ConnectTime, uint EndTime, string UniqueID, string AudioFile, int AudioFileNum, int Reason, int CallDir, string DTMFStr)
        {
/*
            LogoutText("OnCallIdle event arrived. caller:" + CallerID + " called:" + CalleeID + " call dir: " + CallDir.ToString() + " file: " + AudioFile);

            try
            {
                //if (DataViewType == 0)
                {
                    dataGridView1.Rows[ChanIndex].Cells[0].Value = "Idle";

                    //dataGridView1.Rows[ChanIndex].Cells[1].Value = CallerIP;
                    //dataGridView1.Rows[ChanIndex].Cells[2].Value = CallerID;
                    //dataGridView1.Rows[ChanIndex].Cells[3].Value = CalleeIP;
                    //dataGridView1.Rows[ChanIndex].Cells[4].Value = CalleeID;
                    //dataGridView1.Rows[ChanIndex].Cells[5].Value = UniqueID;
                    //dataGridView1.Rows[ChanIndex].Cells[6].Value = AudioFile;
                    //dataGridView1.Rows[ChanIndex].Cells[7].Value = CallDir == 0 ? "Inbound" : "Outbound";
                    //dataGridView1.Rows[ChanIndex].Cells[8].Value = DTMFStr;

                    dataGridView1.Rows[ChanIndex].Cells[1].Value = "";
                    dataGridView1.Rows[ChanIndex].Cells[2].Value = "";
                    dataGridView1.Rows[ChanIndex].Cells[3].Value = "";
                    dataGridView1.Rows[ChanIndex].Cells[4].Value = "";
                    dataGridView1.Rows[ChanIndex].Cells[5].Value = "";
                    dataGridView1.Rows[ChanIndex].Cells[6].Value = "";
                    dataGridView1.Rows[ChanIndex].Cells[7].Value = "";
                    dataGridView1.Rows[ChanIndex].Cells[8].Value = "";
                }
            }
            catch (Exception)
            {
            }*/
        }

        public void Recorder_OnCallInfo(int ChanIndex, string CallerIP, string CallerID, string CalleeIP, string CalleeID, string UniqueID, string AudioFile, int CallDir)
        {
/*
            LogoutText("OnCallInfo event arrived. caller:" + CallerID + " called:" + CalleeID + " call dir: " + CallDir.ToString() + " file: " + AudioFile);
            try
            {
                //if (DataViewType == 0)
                {
                    dataGridView1.Rows[ChanIndex].Cells[1].Value = CallerIP;
                    dataGridView1.Rows[ChanIndex].Cells[2].Value = CallerID;
                    dataGridView1.Rows[ChanIndex].Cells[3].Value = CalleeIP;
                    dataGridView1.Rows[ChanIndex].Cells[4].Value = CalleeID;
                    dataGridView1.Rows[ChanIndex].Cells[5].Value = UniqueID;
                    dataGridView1.Rows[ChanIndex].Cells[6].Value = AudioFile;
                    dataGridView1.Rows[ChanIndex].Cells[7].Value = CallDir == 0 ? "Inbound" : "Outbound";
                }
            }
            catch (Exception)
            {
            }*/
        }

        public void Recorder_OnStatusChannel(VR2Channel chan)
        {
/*
            try
            {
                //if (DataViewType == 0)
                {
                    if (chan.ChanStatus == 0)
                        dataGridView1.Rows[chan.ChanIndex].Cells[0].Value = "Idle";
                    else if (chan.ChanStatus == 1)
                        dataGridView1.Rows[chan.ChanIndex].Cells[0].Value = "Ringing";
                    else if (chan.ChanStatus == 2)
                        dataGridView1.Rows[chan.ChanIndex].Cells[0].Value = "Recording";

                    if (chan.ChanStatus == 0)
                    {
                        dataGridView1.Rows[chan.ChanIndex].Cells[1].Value = "";
                        dataGridView1.Rows[chan.ChanIndex].Cells[2].Value = "";
                        dataGridView1.Rows[chan.ChanIndex].Cells[3].Value = "";
                        dataGridView1.Rows[chan.ChanIndex].Cells[4].Value = "";
                        dataGridView1.Rows[chan.ChanIndex].Cells[5].Value = "";
                        dataGridView1.Rows[chan.ChanIndex].Cells[6].Value = "";
                        dataGridView1.Rows[chan.ChanIndex].Cells[7].Value = "";
                        dataGridView1.Rows[chan.ChanIndex].Cells[8].Value = "";
                    }
                    else
                    {
                        dataGridView1.Rows[chan.ChanIndex].Cells[1].Value = chan.CallerIP;
                        dataGridView1.Rows[chan.ChanIndex].Cells[2].Value = chan.CallerID;
                        dataGridView1.Rows[chan.ChanIndex].Cells[3].Value = chan.CalleeIP;
                        dataGridView1.Rows[chan.ChanIndex].Cells[4].Value = chan.CalleeID;
                        dataGridView1.Rows[chan.ChanIndex].Cells[5].Value = chan.UniqueID;
                        dataGridView1.Rows[chan.ChanIndex].Cells[6].Value = chan.AudioFile;
                        dataGridView1.Rows[chan.ChanIndex].Cells[7].Value = chan.CallDir == 0 ? "Inbound" : "Outbound";
                        dataGridView1.Rows[chan.ChanIndex].Cells[8].Value = chan.DTMFStr;
                    }
                }
            }
            catch (Exception)
            {
            }*/
        }

        public void Recorder_OnCallDTMF(int ChanIndex, string KeyPressed, string DTMFStr)
        {
/*
            try
            {
                //if (DataViewType == 0)
                {
                    dataGridView1.Rows[ChanIndex].Cells[8].Value = DTMFStr;
                }
            }
            catch (Exception)
            {
            }*/
        }


        public void Recorder_OnStatusGeneral(string[] members)
        {
            int MaxChanNum = 0;
            int availableChannelNum = 0;
            int chStatus = 0;

            try
            {
                if (members.Length > 0)
                {
                    //first arg is total number of channels
                    MaxChanNum = Convert.ToInt32(members[0]);
                    tbTotalChannels.Text = MaxChanNum.ToString();

                    if (!dataGridView1.Enabled || dataGridView1.RowCount != MaxChanNum)
                    {
                        dataGridView1.Enabled = true;

                        dataGridView1.DataSource = null;
                        dataGridView1.ReadOnly = true;

                        dataGridView1.RowCount = MaxChanNum;
                        dataGridView1.ColumnCount = 9;

                        dataGridView1.Columns[0].HeaderText = "Status";
                        dataGridView1.Columns[1].HeaderText = "CallerIP";
                        dataGridView1.Columns[2].HeaderText = "CallerID";
                        dataGridView1.Columns[3].HeaderText = "CalleeIP";
                        dataGridView1.Columns[4].HeaderText = "calleeID";
                        dataGridView1.Columns[5].HeaderText = "UniqueID";
                        dataGridView1.Columns[6].HeaderText = "AudioFile";
                        dataGridView1.Columns[7].HeaderText = "Direction";
                        dataGridView1.Columns[8].HeaderText = "DTMF";

                        //dataGridView1.Rows[0].HeaderCell.OwningColumn.Width = 200;

                        for (int i = 0; i < MaxChanNum; i++)
                        {
                            int index = i + 1;
                            dataGridView1.Rows[i].HeaderCell.Value = index.ToString();
                            dataGridView1.Rows[i].Cells[0].Value = "Idle";
                        }

                    }
                    /*
                    if (RTListening == 1)
                    {
                        if (cbChanID.Items.Count != MaxChanNum && MaxChanNum > 0)
                        {
                            cbChanID.Items.Clear();
                            for (int i = 1; i <= MaxChanNum; i++)
                            {
                                cbChanID.Items.Add(i.ToString());
                            }

                            cbChanID.SelectedIndex = 0;
                            lbRTChanStatus.Text = "Idle";
                        }
                    }*/
                }
                if (members.Length > 1)
                {
                    //second arg is total number of channels which is available(not offline)
                    tbTotalCalls.Text = members[1];
                }
                else
                {
                    //tbAvailableChannels.Text = MaxChanNum.ToString();
                }

                if (members.Length > 2)
                {
                    //second arg is total number of channels which is offline
                    tbConnectedCalls.Text = members[2];

                    tbFailedCalls.Text = Convert.ToString(Convert.ToInt32(members[1]) - Convert.ToInt32(members[2]));
                }
                else
                {
                    tbOfflineChannels.Text = "0";
                }

                if (members.Length > 3)
                {
                    for (int i = 0; i < MaxChanNum; i++)
                    {
                        chStatus = Convert.ToInt32(members[3 + i]);
                        if (chStatus == -1)
                        {
                            dataGridView1.Rows[i].Cells[0].Value = "Offline";
                        }
                        else if (chStatus == 0)
                        {
                            //if(dataGridView1.Rows[i].Cells[0].Value == "Offline")
                            dataGridView1.Rows[i].Cells[0].Value = "Idle";
                            availableChannelNum++;
                        }
                        else if (chStatus == 1)
                        {
                            //dataGridView1.Rows[i].Cells[0].Value = "Ringing";
                            availableChannelNum++;
                        }
                        else if (chStatus == 2)
                        {
                            //dataGridView1.Rows[i].Cells[0].Value = "Recording";
                            availableChannelNum++;
                        }
                    }

                    tbAvailableChannels.Text = availableChannelNum.ToString();
                    tbOfflineChannels.Text = Convert.ToString(MaxChanNum - availableChannelNum);
                }
            }
            catch (Exception ex)
            {
                LogoutText(ex.ToString());
            }

            waiting_general = false;
        }

        public void LogoutText(string sLogInfo/*, bool bTrace*/)
        {
            lock (this)
            {
                sLogInfo = "[" + DateTime.Now.ToString("yyyy-MM-ddTHH:mm:ss") + "]" + " " + sLogInfo;
                if (richTextBox1.Text.Length > 1024 * 512)
                    richTextBox1.Text = "";
                richTextBox1.Text = richTextBox1.Text + sLogInfo + "\r\n";
                richTextBox1.Select(richTextBox1.Text.Length - 2, 1);
                richTextBox1.ScrollToCaret();
            }
        }

        public static ServiceControllerStatus GetWinServiceStatus(string strServiceName)
        {
            ServiceController service = new ServiceController(strServiceName);
            ServiceControllerStatus status = service.Status;
            service.Dispose();
            return status;
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "Administrators")]
        public static void StartWinService(string strServiceName)
        {
            ServiceController service = null;

            try
            {
                service = new ServiceController(strServiceName);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
            }

            if (service != null)
            {
                service.Start();
                service.Dispose();
            }
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "Administrators")]
        public static void StopWinService(string strServiceName)
        {
            ServiceController service = null;

            try
            {
                service = new ServiceController(strServiceName);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
            }

            if (service != null)
            {
                service.Stop();
                service.Dispose();
            }
        }



    }


    public class MyVR2Client : VR2Client
    {
        public Form1 main_form;

        public override void ServerConnected(bool bConnected)
        {
            main_form.ServerConnected(bConnected);
        }

        public override void OnCallOffered(int ChanIndex, string CallerIP, string CallerID, string CalleeIP, string CalleeID, uint CallTime, string UniqueID, string AudioFile, int CallDir)
        {
            base.OnCallOffered(ChanIndex, CallerIP, CallerID, CalleeIP, CalleeID, CallTime, UniqueID, AudioFile, CallDir);
            main_form.Recorder_OnCallOffered(ChanIndex, CallerIP, CallerID, CalleeIP, CalleeID, CallTime, UniqueID, AudioFile, CallDir);
        }

        public override void OnCallConnected(int ChanIndex, string CallerIP, string CallerID, string CalleeIP, string CalleeID, uint InitTime, uint ConnectTime, string UniqueID, string AudioFile, int CallDir)
        {
            base.OnCallConnected(ChanIndex, CallerIP, CallerID, CalleeIP, CalleeID, InitTime, ConnectTime, UniqueID, AudioFile, CallDir);
            main_form.Recorder_OnCallConnected(ChanIndex, CallerIP, CallerID, CalleeIP, CalleeID, InitTime, ConnectTime, UniqueID, AudioFile, CallDir);
        }

        public override void OnCallIdle(int ChanIndex, string CallerIP, string CallerID, string CalleeIP, string CalleeID, uint InitTime, uint ConnectTime, uint EndTime, string UniqueID, string AudioFile, int AudioFileNum, int Reason, int CallDir, string DTMFStr)
        {
            base.OnCallIdle(ChanIndex, CallerIP, CallerID, CalleeIP, CalleeID, InitTime, ConnectTime, EndTime, UniqueID, AudioFile, AudioFileNum, Reason, CallDir, DTMFStr);
            main_form.Recorder_OnCallIdle(ChanIndex, CallerIP, CallerID, CalleeIP, CalleeID, InitTime, ConnectTime, EndTime, UniqueID, AudioFile, AudioFileNum, Reason, CallDir, DTMFStr);
        }

        public override void OnCallInfo(int ChanIndex, string CallerIP, string CallerID, string CalleeIP, string CalleeID, string UniqueID, string AudioFile, int CallDir)
        {
            base.OnCallInfo(ChanIndex, CallerIP, CallerID, CalleeIP, CalleeID, UniqueID, AudioFile, CallDir);
            main_form.Recorder_OnCallInfo(ChanIndex, CallerIP, CallerID, CalleeIP, CalleeID, UniqueID, AudioFile, CallDir);
        }

        public override void OnStatusGeneral(string[] members)
        {
            base.OnStatusGeneral(members);
            main_form.Recorder_OnStatusGeneral(members);

        }

        public override void OnStatusChannel(VR2Channel chan)
        {
            base.OnStatusChannel(chan);
            main_form.Recorder_OnStatusChannel(chan);
        }

        public override void OnCallDTMF(int ChanIndex, string KeyPressed, string DTMFStr)
        {
            base.OnCallDTMF(ChanIndex, KeyPressed, DTMFStr);
            main_form.Recorder_OnCallDTMF(ChanIndex, KeyPressed, DTMFStr);
        }

    }
}