using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.ServiceProcess;
using System.Text;
using System.Windows.Forms;
using System.IO;
using VR2;

namespace VR2Svc
{
    public partial class VRService : ServiceBase
    {
        VR2.VR2Main vr2;

        public VRService()
        {
            InitializeComponent();
        }

        protected override void OnStart(string[] args)
        {
            // TODO: Add code here to start your service.
            vr2 = new VR2Main();

            string xmlFileName = Application.StartupPath + "\\VR2Config.xml";

            if (!File.Exists(xmlFileName))
            {
                string xmlFileName1 = Application.StartupPath + "\\VR2Config-std.xml";
                if (!File.Exists(xmlFileName1))
                {
                    //MessageBox.Show("Neither VR2Config.xml nor VR2Config-std.xml exists!");
                    //return -1;
                    vr2 = null;

                    return;
                }
                else
                {
                    File.Copy(xmlFileName1, xmlFileName);
                }
            }

            vr2.Start(Application.StartupPath + "\\VR2Config.xml");
        }

        protected override void OnStop()
        {
            // TODO: Add code here to perform any tear-down necessary to stop your service.
            if (vr2 != null)
            {
                vr2.Stop();
                vr2 = null;
            }
        }
    }
}
