using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace VR2ManagerClient
{
    public partial class ConnectForm : Form
    {
        public string serverIP;
        public ushort serverPort;

        public ConnectForm()
        {
            InitializeComponent();
        }

        private void btnConnect_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;

            try
            {
                serverIP = tbIPAddr.Text;
                serverPort = Convert.ToUInt16(tbPort.Text);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                return;
            }

            Close();
        }

        private void btnDisconnect_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void ConnectForm_Load(object sender, EventArgs e)
        {
            tbIPAddr.Text = serverIP;
            tbPort.Text = serverPort.ToString();
        }
    }
}