using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace VR2ManagerClient
{
    public partial class SelectWavForm : Form
    {
        public string f_path;
        public string f_name;
        public string f_ext;
        public int file_num;
        public int idx_sel;

        public SelectWavForm()
        {
            InitializeComponent();
            f_path = "";
            f_name = "";
            f_ext = "";
            file_num = 0;
            idx_sel = 0;
        }

        private void SelectWavForm_Load(object sender, EventArgs e)
        {
            for (int i = 0; i < file_num; i++)
            {
                string fn = "";
                if (i == 0)
                    fn = f_path + f_name + f_ext;
                else
                    fn = f_path + f_name + "-" + i.ToString() + f_ext;

                listBoxFiles.Items.Add(fn);
            }
            listBoxFiles.SelectedIndex = 0;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            idx_sel = listBoxFiles.SelectedIndex;
            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }


    }
}