//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"

#include "C:\temp\pcbest-vr2.04-sdk\Inc\VRAPIDef.h"
#include "C:\temp\pcbest-vr2.04-sdk\Inc\VRAPI.h"

bool Capturing = false;

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;

void VR_CALLBACK cb_call_offered(int ChanIndex, const char* CallerIP, const char* CallerID, const char* CalleeIP, const char* CalleeID, unsigned int CallTime, const char* UniqueID, const char* AudioFile, int CallDir)
{
	if(Form1)
		Form1->OnCallOffered(ChanIndex, CallerIP, CallerID, CalleeIP, CalleeID, CallTime, UniqueID, AudioFile, CallDir);
}

void VR_CALLBACK cb_call_connected(int ChanIndex, const char* CallerIP, const char* CallerID, const char* CalleeIP, const char* CalleeID, unsigned int InitTime, unsigned int ConnectTime, const char* UniqueID, const char* AudioFile, int CallDir)
{
	if(Form1)
		Form1->OnCallConnected(ChanIndex, CallerIP, CallerID, CalleeIP, CalleeID, InitTime, ConnectTime, UniqueID, AudioFile, CallDir);
}

void VR_CALLBACK cb_call_idle(int ChanIndex, const char* CallerIP, const char* CallerID, const char* CalleeIP, const char* CalleeID, unsigned int InitTime, unsigned int ConnectTime, unsigned int EndTime, const char* UniqueID, const char* AudioFile, int AudioFileNum, int Reason, int CallDir, const char* sDTMF, int Codec)
{
	if(Form1)
		Form1->OnCallEnd(ChanIndex, CallerIP, CallerID, CalleeIP, CalleeID, InitTime, ConnectTime, EndTime, UniqueID, AudioFile, AudioFileNum, Reason, CallDir, sDTMF, Codec);
}

void VR_CALLBACK cb_call_audio_buffer(int ChanIndex, const char* UniqueID, int Direction, const char* Buff, int BuffSize)
{
	//if(Form1)
		//Form1->OnCallAudioStream(ChanIndex, UniqueID, Direction, (unsigned char*)Buff, BuffSize);
}
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
//Form1 = this;
}
//---------------------------------------------------------------------------


void __fastcall TForm1::btnStartClick(TObject *Sender)
{
        int idx = -1;
        AnsiString sCaption =  "Selected NIC:";

     //MessageBox(this, cbNic->SelText.c_str(), sCaption.c_str(), MB_OK);

for (int i = 0; i < VR_GetNICCount(); i++)
{
        if(!stricmp(VR_GetNICDescription(i), cbNic->Text.c_str()))
        {
        idx = i;
        break;
        }
}

if(idx < 0) return;

    VR_SetNIC(idx);

	//If using pcap file instead of NIC
	//VR_SetPCAPFile("C:\\temp\\projects\\Recorder2\\PCapSamples\\Skinny\\Cisco-Skinny-CCM-5.pcap");


    VR_SetChannelCount(atoi(editChanCount->Text.c_str()));
	VR_SetAudioRootFolder(editRoot->Text.c_str());

	//log
    VR_SetLogLevel(4);
    AnsiString sLogPath = "";

    if( editRoot->Text[editRoot->Text.Length()-1] != '\\')
        sLogPath =  editRoot->Text + "\\VR2-log.txt";
    else
        sLogPath =  editRoot->Text + "VR2-log.txt";

    VR_SetLogFileName(sLogPath.c_str());

	//Protocol: SIP, H323, RTP, MGCP, and SCCP or SKINNY or SKINNY_CCM71 or SCCP_CCM71, IAX2
	VR_SetProtocol("SIP");
	//VR_SetPort(2000);

	VR_SetCB_Call_Offered(cb_call_offered);
	VR_SetCB_Call_Connected(cb_call_connected);
	VR_SetCB_Call_Idle(cb_call_idle);

    VR_StartCapture();

	btnStart->Enabled = false;
	btnStop->Enabled = true;

	//VR_EnableRTSrv(1);

    Capturing = true;
}
//---------------------------------------------------------------------------
void TForm1::LogStatus(int ch, const char* strLog)
{
	switch(ch)
	{
	case 0:
		editChan1->Text = strLog;
		break;
	case 1:
		editChan2->Text = strLog;
		break;
	case 2:
		editChan3->Text = strLog;
		break;
	case 3:
		editChan4->Text = strLog;
		break;
	}
}

void TForm1::OnCallOffered(int ChanIndex, const char* CallerIP, const char* CallerID, const char* CalleeIP, const char* CalleeID, unsigned int CallTime, const char* UniqueID, const char* AudioFile, int CallDir)
{
        AnsiString s = "New call ";
        s +=  CallerID;
        s += " ";
        s +=  CalleeID;

	LogStatus(ChanIndex, s.c_str());
}

void TForm1::OnCallConnected(int ChanIndex, const char* CallerIP, const char* CallerID, const char* CalleeIP, const char* CalleeID, unsigned int InitTime, unsigned int ConnectTime, const char* UniqueID, const char* AudioFile, int CallDir)
{
        AnsiString s = "Call Connected ";
        s +=  CallerID;
        s += " ";
        s +=  CalleeID;

	LogStatus(ChanIndex, s.c_str());
}

void TForm1::OnCallEnd(int ChanIndex, const char* CallerIP, const char* CallerID, const char* CalleeIP, const char* CalleeID, unsigned int InitTime, unsigned int ConnectTime, unsigned int EndTime, const char* UniqueID, const char* AudioFile, int AudioFileNum, int Reason, int CallDir, const char* sDTMF, int Codec)
{
        AnsiString s = "Call End ";
        s +=  CallerID;
        s += " ";
        s +=  CalleeID;

	LogStatus(ChanIndex, s.c_str());
}


void __fastcall TForm1::FormCreate(TObject *Sender)
{
VR_InitCapture(0);

for (int i = 0; i < VR_GetNICCount(); i++)
{
        cbNic->AddItem(VR_GetNICDescription(i), cbNic);
}

btnStart->Enabled = true;
btnStop->Enabled = false;

if(VR_GetNICCount() > 0)
        cbNic->Text = VR_GetNICDescription(0);
else
        btnStart->Enabled = false;

editChanCount->Text = "4";
editRoot->Text = "C:\\VR2";

editChan1->Enabled = false;
editChan2->Enabled = false;
editChan3->Enabled = false;
editChan4->Enabled = false;

}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
    if(Capturing)
        VR_StopCapture();

    VR_FreeCapture();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnStopClick(TObject *Sender)
{
   VR_StopCapture();
    Capturing = false;
	btnStart->Enabled = true;
	btnStop->Enabled = false;
    
    //reset the API for next time use
    VR_FreeCapture();
    VR_InitCapture(0);
}
//---------------------------------------------------------------------------

