// ------------------------------------------------------------------
//	File: VRAPIDef.h
//
//	Description:	This header file is DLL 'C' file that
//                includes all of the required header files for developing
//				   a SIP recorder project
//
// ==================================================================
// IF YOU DO NOT AGREE WITH THE FOLLOWING STATEMENT, YOU MUST 
// PROMPTLY RETURN THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION 
// ("PRODUCT") TO PCBest Network Inc.(www.pcbest.net).
//
// PCBest Network Inc. owns all title and 
// ownership rights to Software.  "Software" means any data processing
// programs (hereinafter "programs") consisting of a series of 
// instructions or statements in object code form, including any 
// systemized collection of data in the form of a data base, and any
// related proprietary materials such as flow charts, logic diagrams, 
// manuals media and listings provided for use with the programs.
// User has no right, express or implied, to transfer, sell, provide
// access to or dispose of Software to any third party without PCBest Network's
// prior written consent.  User will not copy, reverse assemble,
// reverse engineer, decompile, modify, alter, translate or display
// the Software other than as expressly permitted by PCBest Network in writing.
// ------------------------------------------------------------------

#ifndef VRAPI_INTERFACE_HEAD_FILE_DEF
#define VRAPI_INTERFACE_HEAD_FILE_DEF

#ifndef WINAPI
	#define WINAPI __stdcall
#endif
#define VR_API WINAPI
#define VR_CALLBACK __stdcall


#define VR2_VERSION				"2.22"

typedef int (VR_CALLBACK *VR_CB_call_offered)(int ChanIndex, const char* CallerIP, const char* CallerID, const char* CalleeIP, const char* CalleeID, unsigned int CallTime, const char* UniqueID, const char* AudioFile, int CallDir);
typedef void (VR_CALLBACK *VR_CB_call_connected)(int ChanIndex, const char* CallerIP, const char* CallerID, const char* CalleeIP, const char* CalleeID, unsigned int InitTime, unsigned int ConnectTime, const char* UniqueID, const char* AudioFile, int CallDir);
typedef void (VR_CALLBACK *VR_CB_call_idle)(int ChanIndex, const char* CallerIP, const char* CallerID, const char* CalleeIP, const char* CalleeID, unsigned int InitTime, unsigned int ConnectTime, unsigned int EndTime, const char* UniqueID, const char* AudioFile, int AudioFileNum, int Reason, int CallDir, const char* sDTMF, int Codec);
typedef void (VR_CALLBACK *VR_CB_call_audio_buffer)(int ChanIndex, const char* UniqueID, int Direction, const char* Buff, int BuffSize);
typedef void (VR_CALLBACK *VR_CB_call_dtmf)(int ChanIndex, const char* KeyPressed, const char* DTMFStr);
typedef void (VR_CALLBACK *VR_CB_call_id)(int ChanIndex, int IDType, const char* CallID);
typedef void (VR_CALLBACK *VR_CB_call_info)(int ChanIndex, const char* CallerIP, const char* CallerID, const char* CalleeIP, const char* CalleeID, const char* UniqueID, const char* AudioFile, int CallDir);
typedef void (VR_CALLBACK *VR_CB_set_channame)(int ChanIndex, const char* ChanName);
typedef void (VR_CALLBACK *VR_CB_call_sip_info)(int ChanIndex, const char* CallerIP, const char* CallerID, const char* CalleeIP, const char* CalleeID, const char* UniqueID, const char* RequestURI, const char* ContactAddr, const char* PAssertedIdentity, const char* PChargingVector, const char* SIPCallID, const char* SIPInvite);

typedef void (VR_CALLBACK *VR_CB_fatal_error)(int ErrorLevel, int ErrorCode, int ChanIndex, const char* ErrorMsg, int reserved);

typedef int (VR_CALLBACK *VR_CB_get_wav_file_name)(int ChanIndex, const char* UniqueID, char* FNBuf, int BufSize);
typedef const char* (VR_CALLBACK *VR_CB_get_wav_file_name1)(int ChanIndex, const char* UniqueID, const char* CallerID, const char* CalleeID);

typedef const char* (VR_CALLBACK *VR_CB_get_xml_file_name)(int ChanIndex, const char* UniqueID, const char* CallerID, const char* CalleeID);


extern int g_nTotalCalls;
extern int g_nSuccCalls;
//extern int g_bWarning;

//#define GTSRV_LIC_DEBUG

#endif