//#define PBXV3_DEBUG

using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.IO;
using System.Windows.Forms;
using Microsoft.Win32;

namespace SIPPBXv3
{
    public class SIPPBXLog
    {
        public GTSIPPBXEnv env;

        public SIPPBXLog()
        {
            env = null;
        }

        public virtual void LogoutText(string sLogInfo)
        {
            if (env != null)
                env.LogoutText(sLogInfo);
        }

        public virtual void DoLog(string sTxt)
        {
            string sTxt1 = "[" + SIPPBXWinUtil.GetSQLDateTime(DateTime.Now) + "]" + " " + sTxt;

            //real actions to send out the log.
            if (env != null)
            {
                env.LOG_Trace(4, sTxt);
            }
        }
    }

    public class SIPPBXMain
    {
        public Thread mainThread;

        public string SelfBrand;
        //public string PBXVersion;
        public string SelfBrandWebLink;

        private GTSIPPBXEnv env;
        private SIPPBX pbx;
        private SIPPBXLog log;

        private SIPPBXDBAgent dbAgent;

        public DBServerSetting dbPBXSet;

        private bool pbx_running;

        private int Timer_Count;
        private int nMinutesCount;

        public string PBX_REG_KEY_ROOT;

        public bool isExiting;

        public int cfgType;

        public SIPPBXMain()
        {
            isExiting = false;
            cfgType = 0;
            env = null;

            pbx_running = false;

            //First2SecondsProcessDone = false;

            pbx = new SIPPBX();

            SelfBrand = "";
            SelfBrandWebLink = "";
            PBX_REG_KEY_ROOT = "SOFTWARE\\PCBest.net\\SIPPBXV3\\";

            //SelfBrand = "Cast-Iron Communications SIP PBX";
            //SelfBrandWebLink = "http://www.cast-iron.net/";

            //SelfBrand = "AktifTelecom TalksPBX";
            //SelfBrandWebLink = "http://www.aktiftelecom.com/";

            //SelfBrand = "iFoneline IPPBX";
            //SelfBrandWebLink = "http://www.ifoneline.com.au";

            //SelfBrand = "iServ IP PBX";
            //SelfBrandWebLink = "http://www.mia.co.za";

            pbx.PBXVersion = "3.68";

            Timer_Count = 0;
            nMinutesCount = 0;

            dbPBXSet = null;

            log = new SIPPBXLog();

            mainThread = new Thread(Run);

            dbAgent = new SIPPBXDBAgent();
        }

        static void Run(object obj)
        {
            SIPPBXMain host = (SIPPBXMain)obj;

            while (!host.isExiting)
            {
                host.timerTick();
                Thread.Sleep(100);
            }

        }

        public SIPPBXLog GetPBXLog()
        {
            return log;
        }

        public void LogoutText(string sLogInfo)
        {
            log.LogoutText(sLogInfo);
        }

        public void DoLog(string sTxt)
        {
            log.DoLog(sTxt);

            try
            {
                if (dbPBXSet != null)
                {
                    if (dbPBXSet.myConn != null)
                        SIPPBXDBUtil.SaveDBLog(sTxt, dbPBXSet.myConn, log);
                }
            }
            catch (Exception ex)
            {
                env.LOG_Trace(2, ex.ToString());
                //reset db
                if (dbPBXSet != null)
                {
                    try
                    {
                        dbPBXSet.DisconnectDB();
                    }
                    catch (Exception)
                    {
                    }

                    dbPBXSet.ConnectDB();
                }
            }
        }

        public void HandleLogs(Queue<string> logQueue)
        {
            string s = "";
            lock (logQueue)
            {
                while (logQueue.Count != 0)
                {
                    s = logQueue.Dequeue();
                    DoLog(s);
                }
            }
        }

        public static string GetTempPath()
        {
            string path = Application.StartupPath;
            if (!path.EndsWith("\\")) path += "\\";
            path += "log\\";
            return path;
        }

        public static void LogMessageToFile(string msg)
        {
            string sLogFN = GetTempPath() + "PBXv3-log.txt";

            System.IO.StreamWriter sw = System.IO.File.AppendText(sLogFN);
            try
            {
                string logLine = System.String.Format(
                    "{0:G}: {1}", System.DateTime.Now, msg);
                sw.WriteLine(logLine);
            }
            catch (Exception)
            {
            }
            finally
            {
                sw.Close();
            }
        }


        private bool StartServer()
        {
            if (pbx_running)
                return pbx_running;

            string lic_key = "";

#if PBXV3_DEBUG
            LogMessageToFile("1");
#endif

            env = new GTSIPPBXEnv();
            env.pbxMain = this;
            env.pbx = pbx;
            log.env = env;

#if PBXV3_DEBUG
            LogMessageToFile("2");
#endif

            env.CreateEnv();

#if PBXV3_DEBUG
            LogMessageToFile("3");
#endif

            //env.SetMainWnd(Handle.ToInt32());

            LoadConfig();

#if PBXV3_DEBUG
            LogMessageToFile("4");
#endif

            pbx.LoadPlugins(env);

#if PBXV3_DEBUG
            LogMessageToFile("5");
#endif

            //run the Init type plugin
            for (int i = 0; i < pbx.plugins.Count; i++)
            {
                ISIPPBXPluginClient client = pbx.plugins[i];
                if (client == null)
                    break;

                if (client.Type == "Init")
                {
                    SIPPBXPluginHost plugin_host = new SIPPBXPluginHost();
                    plugin_host.pbx_chan = null;
                    plugin_host.env = env;
                    plugin_host.Client = client;
                    client.Host = plugin_host;
                    try
                    {
                        client.Start();
                    }
                    catch (Exception ex)
                    {
                        LogoutText(ex.ToString());
                    }
                }
            }

#if PBXV3_DEBUG
            LogMessageToFile("6");
#endif


            GTAPIASM.GTAPIEnv.DoRegularRoutine1();

#if PBXV3_DEBUG
            LogMessageToFile("7");
#endif

            //Application name, it is related to sdk licence
            //Please contact PCBest Network(www.pcbest.net) to get licence info
            if (SelfBrand == "iServ IP PBX")
            {
                env.SetAppName("iServ-IPPBX");
                lic_key = "";
            }
            else
                env.SetAppName("GTSIPPBX-v2");

            env.CFG_SetValue("gtsrv.lic.file.dir", pbx.pbx_dir);

            env.CFG_SetValue("gtsrv.app.version", pbx.PBXVersion);

            env.CFG_SetValue("gtsrv.sip.server.model", "1"); //server

            env.CFG_SetValue("gtsrv.sip.protocol", pbx.sip_set.sipProtocol.ToString());

            //SIP IP Address you want to use on local
            //Leave it unset if you want to listen on all the network interface
            if (pbx.sip_set.sipAddr.Length > 0)
            {
                for (int i = 0; i < GTAPIASM.GTAPIEnv.GetLocalIPCount(); i++)
                {
                    if (GTAPIASM.GTAPIEnv.GetLocalIP(i) == pbx.sip_set.sipAddr)
                    {
                        env.CFG_SetValue("gtsrv.sip.ip.address", pbx.sip_set.sipAddr);
                        break;
                    }
                }
            }

#if PBXV3_DEBUG
            LogMessageToFile("8");
#endif

            //SIP Port, default 5060
            env.CFG_SetValue("gtsrv.sip.ip.port", pbx.sip_set.sipPort.ToString());

            if(pbx.sip_set.sPublicIPAddr.Length > 0)
                env.CFG_SetValue("gtsrv.sip.public.ip.in.rtp", pbx.sip_set.sPublicIPAddr);

#if PBXV3_DEBUG
            LogMessageToFile("9");
#endif

            //PBX user agent name
            if (SelfBrand.Length > 0)
                env.CFG_SetValue("gtsrv.sip.user.agent", SelfBrand + " v" + pbx.PBXVersion);
            else if(pbx.sip_set.sUAName.Length > 0)
                env.CFG_SetValue("gtsrv.sip.user.agent", pbx.sip_set.sUAName);
            else
                env.CFG_SetValue("gtsrv.sip.user.agent", "PC Best Networks SIP PBX v" + pbx.PBXVersion);

#if PBXV3_DEBUG
            LogMessageToFile("10");
#endif

            //Log
            env.CFG_SetValue("gtsrv.log.level", pbx.log_level.ToString());
            string log_fn = pbx.log_dir;
            if (log_fn.Length == 0)
                log_fn = pbx.pbx_dir;
            if (log_fn[log_fn.Length - 1] != '\\')
                log_fn += '\\';
            log_fn += "gtpbxlog.txt";
            env.CFG_SetValue("gtsrv.log.filename", log_fn);
            env.CFG_SetValue("gtsrv.log.size", "100000000");

            //DTMF auto
            env.CFG_SetValue("gtsrv.sip.dtmf.method", pbx.sip_set.dtmfMethod.ToString());

            env.CFG_SetValue("gtsrv.sip.callcontrol.auto.acceptcall", "1");
            env.CFG_SetValue("gtsrv.sip.callcontrol.auto.ringcall", "0");

            //This is the tag to disable SDK attempt to auto transfer(call) used by PBX like app.
            env.CFG_SetValue("gtsrv.sip.set.refer.addr", "0");

            env.CFG_SetValue("gtsrv.sip.proxy.max.user.reg.expire", pbx.pbx_sys_set.MaxProxyUserRegSec.ToString());

            //Internal communication port
            env.CFG_SetValue("gtsrv.net.port", "8922");

            //Configuration file, if you want to define parameters in a file
            //env.CFG_SetValue(GTSRV_CFG_FILENAME, "GTSimpelPhone.ini");

            if (env.pbx.PBXLicKey.Length > 0)
            {
                if (env.pbx.ChanNum <= 8)
                {
                    env.CFG_SetValue("gtsrv.sip.boardnum.per.server", "1");
                    env.CFG_SetValue("gtsrv.sip.spannum.per.board", "1");
                    env.CFG_SetValue("gtsrv.sip.channum.per.span", env.pbx.ChanNum.ToString());
                }
                else
                {
                    int chanperspan = 8;
                    int spannum = 0;
                    int boardnum = 0;

                loop_again:
                    if (env.pbx.ChanNum % chanperspan == 0)
                    {
                        spannum = env.pbx.ChanNum / chanperspan;
                        boardnum = 1;
                        if (spannum > 16)
                        {
                            int basespan = 16;
                        loop_again1:
                            if (spannum % basespan == 0)
                            {
                                boardnum = spannum / basespan;
                                spannum = basespan;
                            }
                            else if(basespan >= 2)
                            {
                                basespan -= 1;
                                goto loop_again1;
                            }
                        }

                        if (boardnum > 40) boardnum = 40;
                    }
                    else if(chanperspan >= 2)
                    {
                        chanperspan -= 1;
                        goto loop_again;
                    }

                    env.CFG_SetValue("gtsrv.sip.boardnum.per.server", boardnum.ToString());
                    env.CFG_SetValue("gtsrv.sip.spannum.per.board", spannum.ToString());
                    env.CFG_SetValue("gtsrv.sip.channum.per.span", chanperspan.ToString());
                }
                env.CFG_SetValue("gtsrv.licence.key", env.pbx.PBXLicKey);
            }
            else
            {
                env.CFG_SetValue("gtsrv.sip.boardnum.per.server", "1");
                env.CFG_SetValue("gtsrv.sip.spannum.per.board", "1");
                env.CFG_SetValue("gtsrv.sip.channum.per.span", "8");

                env.CFG_SetValue("gtsrv.licence.key", lic_key);
            }

            //channnel numbers, defaultly we only use 6 channel
            int total_chans = env.CFG_GetIntValue("gtsrv.sip.boardnum.per.server", 1) *
            env.CFG_GetIntValue("gtsrv.sip.spannum.per.board", 1) *
            env.CFG_GetIntValue("gtsrv.sip.channum.per.span", 8);

            if (pbx.ChanNum != total_chans)
            {
                LogoutText("Total Channel Number switchs to " + total_chans.ToString());
                pbx.ChanNum = total_chans;
            }

            //RTP PORT
            env.CFG_SetValue("gtsrv.sip.rtpstartrange", pbx.sip_set.rtpPort.ToString());
            env.CFG_SetValue("gtsrv.sip.rtpendrange", (pbx.sip_set.rtpPort + pbx.ChanNum * pbx.sip_set.rtpPortSpace + 2000).ToString());

            if(pbx.sip_set.rtpPortSpace >=4) //default it is 4 minimal.
                env.CFG_SetValue("gtsrv.sip.rtp.port.space", pbx.sip_set.rtpPortSpace.ToString());


            pbx.chan_list = new SIPPBXChan[total_chans];
            for (int i = 0; i < total_chans; i++)
            {
                pbx.chan_list[i] = new SIPPBXChan(i);
            }

            //pbx.OutboundIndexStart = total_chans / 2;
            /*
                        //define inbound and outbound channels
                        int inbound_last = pbx.OutboundIndexStart - 1;
                        env.CFG_SetValue("gtsrv.channel.inbound", "0-" + inbound_last.ToString());
                        env.CFG_SetValue("gtsrv.channel.outbound", pbx.OutboundIndexStart.ToString() + "-" + total_chans.ToString());

                        total_chans /= 2;
                        env.CFG_SetValue("gtsrv.sip.udp.switch.group", total_chans.ToString());
            */

            //define outbound route, leave them unset if you don't know
            //env.CFG_SetValue("gtsrv.sip.outbound.via.type", "0");
            //env.CFG_SetValue("gtsrv.sip.outbound.via.proxy", "");

            //env.CFG_SetValue("gtsrv.sip.prefered.codec", "102,100,3,0,8");
            env.CFG_SetValue("gtsrv.sip.prefered.codec", pbx.sip_set.auCodecs);

            //video codec list    34 = H263, 124 = H264, 115 = H263p
            env.CFG_SetValue("gtsrv.sip.prefered.video.codec", pbx.sip_set.videoCodecs);

            env.CFG_SetValue("gtsrv.sip.stun.server", pbx.sip_set.sStunServer);

            //conference settings
            // env.CFG_SetValue("gtsrv.sip.conference.room", "1");

            if (pbx.pbx_sys_set.bNoAudioDisconnect)
            {
                int dur = pbx.pbx_sys_set.NoAudioDisconnectDur * 1000;
                env.CFG_SetValue("gtsrv.sip.no.audio.duration", dur.ToString());
                env.LOG_Trace(4, "No Audio Disconnect Duration: " + dur.ToString() + " milliseconds");
            }

            env.CFG_SetValue("gtsrv.sip.dyn.check.remote.rtp", pbx.sip_set.dynMapRTP.ToString());
            env.CFG_SetValue("gtsrv.sip.enable.dns.srv", pbx.sip_set.useDNSSRV ? "1" : "0");

#if PBXV3_DEBUG
            LogMessageToFile("11");
#endif

            if (pbx.USBKeyDriver.Length > 0)
            {
                //use USB key as USB dongle
#if PBXV3_DEBUG
                LogMessageToFile("11-1");
#endif

                env.CFG_SetValue("gtsrv.lic.usb.key.driver", pbx.USBKeyDriver);

#if PBXV3_DEBUG
                LogMessageToFile("11-2");
#endif
            }
            else if (pbx.LicMAC.Length > 0)
            {
                env.CFG_SetValue("gtsrv.lic.mac.addr", pbx.LicMAC);
            }

            if(pbx.get_remote_contact_from_ring)
                env.CFG_SetValue("gtsrv.sip.get.remote.contact.from.ring", "1");
            else
                env.CFG_SetValue("gtsrv.sip.get.remote.contact.from.ring", "0");

            bool bHumanDetect = false;

            for (int i = 0; i < pbx.auto_dialer_tasks.Count; i++)
            {
                if (pbx.auto_dialer_tasks[i].m_bEnableDetect)
                {
                    bHumanDetect = true;
                    break;
                }
            }

            if (bHumanDetect)
            {
                env.CFG_SetValue("gtsrv.human.detect.enabled", "1");
                //env.CFG_SetValue("gtsrv.sip.on.in.vad", "1");
                env.CFG_SetValue("gtsrv.human.detect.max.sound.level", "100");
                env.CFG_SetValue("gtsrv.human.detect.duration", "4000");
                env.CFG_SetValue("gtsrv.human.detect.voiceon", "2000");
            }

#if PBXV3_DEBUG
            LogMessageToFile("11-3");
#endif

            //#1://QCIF 128  96
            //#2: //QCIF 176  144
            //#3: //CIF = 352x288
            //#4: //4CIF 704  576 
            //#5: //16CIF 1408  1152 
            //#10: //QVGA = 320x240 
            //#20: //VGA = 640x480 
            //#gtsrv.video.resolution = 2
            if (pbx.sip_set.videoCodecs.Length > 0)
            {
#if PBXV3_DEBUG
                LogMessageToFile("11-4");
#endif

                //looks like gtsrv.video.resolution is for video camera of computer
                //not set here.
            }

#if PBXV3_DEBUG
            LogMessageToFile("12");
#endif

            bool ret = env.StartServer();
            if (!ret)
                return ret;

            pbx_running = true;

#if PBXV3_DEBUG
            LogMessageToFile("13");
#endif

            pbx.StartManager(env);

            pbx.StartWebServer();

#if PBXV3_DEBUG
            LogMessageToFile("14");
#endif

            //set sip client user info ***** If you want to take incoming calls, you must set this value,
            // or you can only answer calls by your IP address
            //you must get an account from sip service provider first
            if (pbx.sip_acct.Count > 0)
            {
                //env.CFG_SetValue("gtsrv.sip.reg.client.num", pbx.sip_acct.Count.ToString());
                SIPAccount acct;
                for (int i = 0; i < pbx.sip_acct.Count; i++)
                {
                    acct = pbx.sip_acct[i];
                    acct.accHandle = env.SIPAccount_Add(acct.DisplayName, acct.UserName, acct.DomainServer, acct.ProxyServer, acct.AuthName, acct.Password, acct.ExpireSec, acct.RegWithProxyServer ? 1 : 0, 0, 0, !acct.Disabled, acct.SIPProtocol);
                }
            }

            if (pbx.IPFilterList.Count > 0)
            {
                IPFilter filter;
                for (int i = 0; i < pbx.IPFilterList.Count; i++)
                {
                    filter = pbx.IPFilterList[i];
                    env.SetIPFilter(filter.IPAddr, filter.WhiteOrBlack, 1);
                }
            }

#if PBXV3_DEBUG
            LogMessageToFile("15");
#endif

            SIPProxySite asite = pbx.sip_proxy_sites[0];
            if (asite == null)
            {
                return ret;
            }

            for (int i = 0; i < GTAPIASM.GTAPIEnv.GetLocalIPCount(); i++)
            {
                if (!asite.domainList.Contains(GTAPIASM.GTAPIEnv.GetLocalIP(i)))
                {
                    if (asite.domainList.Length != 0)
                        asite.domainList += ";";

                    asite.domainList += GTAPIASM.GTAPIEnv.GetLocalIP(i);
                }
            }

            if (!asite.domainList.Contains(env.GetMappedPublicSIPIPAddress()))
            {
                if (asite.domainList.Length != 0)
                    asite.domainList += ";";

                asite.domainList += env.GetMappedPublicSIPIPAddress();
            }

            //proxy
            env.CFG_SetValue("gtsrv.sip.proxy.sites.num", "1");

            env.CFG_SetValue("gtsrv.sip.proxy.site1.domain", pbx.sip_proxy_sites[0].domainList);

            env.CFG_SetValue("gtsrv.sip.proxy.site1.recordroute", "1");
            env.CFG_SetValue("gtsrv.sip.proxy.site1.udp.relay", "0");

            if (pbx.sip_proxy_sites[0].mapSIPAddr)
                env.CFG_SetValue("gtsrv.sip.proxy.site1.map.reg.source", "1");
            else
                env.CFG_SetValue("gtsrv.sip.proxy.site1.map.reg.source", "0");

            if (pbx.sip_proxy_sites[0].optionPingExten)
            {
                env.CFG_SetValue("gtsrv.sip.proxy.site1.check.user.status", "1");
#if PBXV3_DEBUG
                LogMessageToFile("pbx.sip_proxy_sites[0].optionPingExten 1");
#endif

            }
            else
            {
                env.CFG_SetValue("gtsrv.sip.proxy.site1.check.user.status", "0");
#if PBXV3_DEBUG
                LogMessageToFile("pbx.sip_proxy_sites[0].optionPingExten 0");
#endif
            }

            env.InitProxySites();

#if PBXV3_DEBUG
            LogMessageToFile("16");
#endif

            ResetExtensions();

            pbx.LicOwner = env.GetLicTo();

            //dynamical conference room
            //env.Send_StartConference(0);
            CreateAllConferenceRooms();

            for (int i = 0; i < pbx.sip_acct.Count; i++)
            {
                env.Send_GetRegStatus(i);
            }

            if (dbPBXSet.IsDBConnected())
            {
                SIPPBXCFGDB.SaveSysCfgToDB(this, pbx, env, dbPBXSet.myConn, log);
                SIPPBXDBUtil.InitAllStatusTables(pbx, env, dbPBXSet.myConn);
                SIPPBXCFGDB.SavePBXLicOwner(this, pbx, env, dbPBXSet.myConn, log);
            }
            else
            {
                dbPBXSet = null;
            }

#if PBXV3_DEBUG
            LogMessageToFile("17");
#endif

            if (ret)
            {
                isExiting = false;
                mainThread.Start(this);
            }

            if (pbx.sip_set.videoCodecs.Length > 0)
            {
                for (int i = 0; i < pbx.ChanNum; i++)
                {
                    env.EnableChanVideo(i, true);
                }
            }

#if PBXV3_DEBUG
            LogMessageToFile("18");
#endif

            //Start DB Agent
            dbAgent.pbx = pbx;
            dbAgent.env = env;
            dbAgent.db_set = pbx.GetDBServerSet();
            dbAgent.Start();

            return ret;
        }

        private bool StopServer()
        {
            if (pbx_running)
            {
                //end the event processing thread first
                isExiting = true;
                Thread.Sleep(300);

                dbAgent.Stop();

                pbx.StopWebServer();

                pbx.StopManager();

                SaveConfig();

                if (dbPBXSet != null)
                {
                    dbPBXSet.DisconnectDB();
                    dbPBXSet = null;
                }

                //run the Init type plugin for exit
                for (int i = 0; i < pbx.plugins.Count; i++)
                {
                    ISIPPBXPluginClient client = pbx.plugins[i];
                    if (client == null)
                        break;

                    if (client.Type == "Init")
                    {
                        SIPPBXPluginHost plugin_host = new SIPPBXPluginHost();
                        plugin_host.pbx_chan = null;
                        plugin_host.env = env;
                        plugin_host.Client = client;
                        client.Host = plugin_host;
                        try
                        {
                            client.Done();
                        }
                        catch (Exception ex)
                        {
                            LogoutText(ex.ToString());
                        }
                    }
                }

                //env.Send_StopConference(0);
                FreeAllConferenceRooms();

                env.FreeProxySites();
                env.StopServer();
                env.DestroyEnv();

                HandleLogs(env.m_logQueue);

                log.env = null;

                env = null;

                pbx_running = false;
            }

            return true;
        }

        public void ResetExtensions()
        {
            if (env != null)
            {
                env.ProxyDisableAllUsers(0);

                for (int i = 0; i < pbx.sip_exten.Count; i++)
                {
                    SIPPBXExten extn = pbx.sip_exten[i];
                    //note here, ProxySetUserInfo will enable the user automatically.
                    env.ProxySetUserInfo(0, extn.UserName, extn.Password, extn.RegSDKTime, extn.RegisterExpire, extn.ContactAddr, extn.MappedContactAddr, extn.UAName, extn.NATType, extn.RegSrcIP, extn.RegSrcPort, extn.RegFromID, extn.RegToID);
                    env.ProxySetUserAuthType(0, extn.UserName, extn.AuthType);
                    env.ProxySetUserAttr(0, extn.UserName, 101, extn.RegMaxExp.ToString()); 
                }

                for (int i = 0; i < pbx.sip_exten.Count; i++)
                {
                    SIPPBXExten extn = pbx.sip_exten[i];
                    if (extn.vmb != null)
                    {
                        SIPPBXDBUtil.UpdateExtenVoiceMailFromDB(pbx, env, extn, dbPBXSet.myConn, log);
                    }
                }
            }
        }

        public void CreateAllConferenceRooms()
        {
            SIPConferRoom room;

            //create conference rooms
            for (int i = 0; i < pbx.sip_conferooms.Count; i++)
            {
                room = pbx.sip_conferooms[i];
                room.conf_handle = env.CreateConf();
            }

        }

        public void FreeAllConferenceRooms()
        {
            SIPConferRoom room;

            //release all conference rooms first
            for (int i = 0; i < pbx.sip_conferooms.Count; i++)
            {
                room = pbx.sip_conferooms[i];
                if (room.conf_handle != IntPtr.Zero)
                {
                    for (int j = 0; j < room.conf_chans.Count; j++)
                    {
                        env.SetChanInConf(room.conf_handle, room.conf_chans[j].index, 0);
                    }
                    room.conf_chans.Clear();
                    env.DestroyConf(room.conf_handle);
                    room.conf_handle = IntPtr.Zero;
                }
            }

        }

        public void timerTick()
        {
            //env.LOG_Trace(1, "timerTick begin");

            lock (this)
            {
                if (env != null)
                {
                    Timer_Count++;

                    try
                    {
                        lock (env)
                        {
                            //env.LOG_Trace(1, "timerTick calling ProcessGTAPIEvent");
                            env.ProcessGTAPIEvent();

                            if (pbx.manager != null)
                            {
                                //env.LOG_Trace(1, "timerTick calling manager.ProcessEvents");
                                pbx.manager.ProcessEvents();
                            }
                        }

                        //env.LOG_Trace(1, "timerTick calling HandleLogs");
                        HandleLogs(env.m_logQueue);

                        if (Timer_Count % 10 == 0) //every 1 second
                        {
                            //env.LOG_Trace(1, "timerTick calling EverySecondProcess");
                            EverySecondProcess();
                        }
                        if (Timer_Count % 20 == 0) //every 2 seconds
                        {
                            //env.LOG_Trace(1, "timerTick calling Every2SecondsProcess");
                            Every2SecondsProcess();
                        }
                        if (Timer_Count % 30 == 0)
                        {
                            //env.LOG_Trace(1, "timerTick calling Every3SecondsProcess");
                            Every3SecondsProcess();
                        }
                        if (Timer_Count % 40 == 0) //every 4 seconds
                        {
                            //env.LOG_Trace(1, "timerTick calling Every4SecondsProcess");
                            Every4SecondsProcess();
                        }
                        if (Timer_Count % 50 == 0)
                        {
                            //env.LOG_Trace(1, "timerTick calling Every5SecondsProcess");
                            Every5SecondsProcess();
                        }
                        if (Timer_Count % 100 == 0)
                        {
                            //env.LOG_Trace(1, "timerTick calling Every5SecondsProcess");
                            Every10SecondsProcess();
                        }
                        if (Timer_Count % 600 == 0)
                        {
                            env.LOG_Trace(1, "timerTick calling EveryMinuteProcess");
                            EveryMinuteProcess();
                        }

                        if (Timer_Count % 6000 == 0)
                        {
                            //env.LOG_Trace(1, "timerTick calling Every10MinuteProcess");
                            Every10MinuteProcess();
                        }

                        if (Timer_Count % 36000 == 0)
                        {
                            //env.LOG_Trace(1, "timerTick calling Every10MinuteProcess");
                            EveryHourProcess();
                        }

                        if (Timer_Count % 864000 == 0)
                        {
                            //env.LOG_Trace(1, "timerTick calling Every10MinuteProcess");
                            EveryDayProcess();
                        }
                    }
                    catch (Exception ex)
                    {
                        LogoutText(ex.Message);
                        env.LOG_Trace(1, ex.Message);
                        env.LOG_Trace(1, ex.ToString());
                    }

                    if (Timer_Count == 864000)
                        Timer_Count = 0;
                }
            }

            //env.LOG_Trace(1, "timerTick end");

        }

        public void EverySecondProcess()
        {
            //env.LOG_Trace(4, "PBXService: EverySecondProcess *");

            //run the Routine type plugin
            for (int i = 0; i < pbx.plugins.Count; i++)
            {
                ISIPPBXPluginClient client = pbx.plugins[i];
                if (client == null)
                    break;

                if (client.Type == "Routine")
                {
                    SIPPBXPluginHost plugin_host = new SIPPBXPluginHost();
                    plugin_host.pbx_chan = null;
                    plugin_host.env = env;
                    plugin_host.Client = client;
                    client.Host = plugin_host;
                    try
                    {
                        client.Start();
                        client.Done();
                    }
                    catch (Exception ex)
                    {
                        LogoutText(ex.ToString());
                    }
                }
            }

            //env.LOG_Trace(4, "PBXService: EverySecondProcess #");
        }

        public void Every2SecondsProcess()
        {
            //env.LOG_Trace(4, "PBXService: Every2SecondsProcess *");

            if (dbPBXSet != null)
            {
                SIPPBXDBUtil.LoadSrvOptCmd(pbx, env, dbAgent);
                PBXOptCmdProcess.ProcessPBXOptCmdQueue(pbx, env);

                if (!SIPPBXDBUtil.SaveAllStatusIntoDB(pbx, env, dbAgent))
                {
                    //DB connection had problem
                    //reset DB connection
                    LogoutText("SaveAllStatusIntoDB returned false! reset DB connection...");
                    env.LOG_Trace(1, "SaveAllStatusIntoDB returned false! reset DB connection...");

                    dbPBXSet.DisconnectDB();
                    dbPBXSet = null;

                    dbPBXSet = pbx.GetDBServerSet();
                    if (dbPBXSet != null)
                    {
                        if (!dbPBXSet.ConnectDB())
                        {
                            dbPBXSet = null;
                            LogoutText("Couldn't connect to DB!");
                            env.LOG_Trace(1, "Couldn't connect to DB!");
                        }
                    }

                }
            }

            //env.LOG_Trace(4, "PBXService: Every2SecondsProcess #");
        }

        public void Every3SecondsProcess()
        {
        }

        public void Every4SecondsProcess()
        {
            //env.LOG_Trace(4, "PBXService: Every4SecondsProcess *");

            int activeTasks = 0;
            for (int i = 0; i < pbx.auto_dialer_tasks.Count; i++)
            {
                if (pbx.auto_dialer_tasks[i].isOn)
                    activeTasks++;
            }

            if (activeTasks == 0)
                return;

            try
            {
                if (dbPBXSet != null)
                {
                    if (dbPBXSet.IsDBConnected())
                    {
                        //Job 1: Get and Save Jobs for each tasks
                        for (int i = 0; i < pbx.auto_dialer_tasks.Count; i++)
                        {
                            if ((pbx.bFreeVersion && pbx.freeOutCallCount < 100) || !pbx.bFreeVersion)
                            {
                                if (pbx.auto_dialer_tasks[i].isOn)
                                    pbx.auto_dialer_tasks[i].GetJobs(dbPBXSet.myConn, env);
                            }
                            pbx.auto_dialer_tasks[i].SaveJobs(dbPBXSet.myConn, env);
                        }

                        //Job 2
                        for (int i = 0; i < pbx.auto_dialer_tasks.Count; i++)
                        {
                            pbx.freeOutCallCount += pbx.auto_dialer_tasks[i].ProcessJobs(env);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                LogoutText(ex.Message);
                env.LOG_Trace(1, ex.Message);
                env.LOG_Trace(1, ex.ToString());

                //mostly it is DB connection lost
                //reset db connection
                if (dbPBXSet != null)
                {
                    try
                    {
                        dbPBXSet.DisconnectDB();
                    }
                    catch (Exception)
                    {
                    }

                    dbPBXSet.ConnectDB();
                }
            }
            
            //env.LOG_Trace(4, "PBXService: Every4SecondsProcess #");
        }

        public void Every5SecondsProcess()
        {
            //env.LOG_Trace(4, "PBXService: Every5SecondsProcess *");

            pbx.SaveCDRQueue(env, dbPBXSet);
            RefreshConfig();

            //env.LOG_Trace(4, "PBXService: Every5SecondsProcess #");
        }

        public void Every10SecondsProcess()
        {
            while (pbx.call_back_queue.Count > 0)
            {
                AutoDialerTask task = pbx.call_back_queue.Dequeue();
                task.ProcessJobs(env);
            }
        }

        public void EveryMinuteProcess()
        {
            //env.LOG_Trace(4, "PBXService: EveryMinuteProcess *");

            DateTime dt = DateTime.Now;

            if (pbx.pbx_sys_set.sRestartTime == dt.ToString("HH:mm"))
            {
                LogoutText("Restart... PBX on restart time.");
                StopPBX();
                StartPBX();
            }

            if(nMinutesCount++ >= 10)
            {
                //every 10 minutes clear sys log
                nMinutesCount = 0;
                SIPPBXDBUtil.ClearDBlog(0, dbPBXSet.myConn, log);
            }

            if (pbx.pbx_sys_set.MaxCallDuration > 0)
            {
                for (int i = 0; i < pbx.ChanNum; i++)
                {
                    GTAPIASM.GTAPIChan api_chan = env.GetChannel(i);

                    if (env.IsChanConnected(i))
                    {
                        TimeSpan ts = DateTime.Now - api_chan.call_start_time;
                        if (ts.TotalMinutes > pbx.pbx_sys_set.MaxCallDuration)
                        {
                            env.DisconnectCall(i, 0, "", "PBX: disconnect call because reached max duration");
                        }
                    }
                }
            }

            //env.LOG_Trace(4, "PBXService: EveryMinuteProcess #");
        }

        public void Every10MinuteProcess()
        {
        }

        public void EveryHourProcess()
        {
        }

        public void EveryDayProcess()
        {
            LogoutText("Memory used before collection: " + GC.GetTotalMemory(false).ToString());
            GC.Collect();
            LogoutText("Memory used after full collection: " + GC.GetTotalMemory(false).ToString());
        }

        public bool StartPBX()
        {
            bool ret = false;

            string sLogFN = GetTempPath() + "PBXv3-log.txt";
            try
            {
                // Create new FileInfo object and get the Length.
                FileInfo f = new FileInfo(sLogFN);
                if (f.Length > 10485760) //10MB
                {
                    f.Delete();
                }
            }
            catch (Exception)
            {
            }

            lock (this)
            {
                if (StartServer())
                {
                    ret = true;
                }
                else
                {
                    LogoutText("ERROR: Cannot start the PBX. Please check if local SIP port(UDP 5060) is being used by another application!");
                    LogMessageToFile("ERROR: Cannot start the PBX. Please check if local SIP port(UDP 5060) is being used by another application!");
                    throw new Exception("ERROR: Cannot start the PBX. Please check if local SIP port(UDP 5060) is being used by another application!");
                    //StopPBX();
                }
            }
            return ret;
        }

        public bool StopPBX()
        {
            lock (this)
            {
                StopServer();
            }

            return true;
        }

        public void LoadConfig()
        {
#if PBXV3_DEBUG
            LogMessageToFile("LoadConfig() 1 " + pbx.pbx_dir + "\\sippbxv3.xml");
#endif

            cfgType = SIPPBXCFG.LoadConfigFromXML(pbx.pbx_dir + "\\sippbxv3.xml", pbx, env);

#if PBXV3_DEBUG
            LogMessageToFile("LoadConfig() 2 " + cfgType.ToString());
#endif

            if (cfgType == 0)
            {
                //file not found
                env.LogoutText("File(" + pbx.pbx_dir + "\\sippbxv3.xml) NOT found!");
            }
            else if (cfgType == 1)
            {
#if PBXV3_DEBUG
                LogMessageToFile("LoadConfig() 3 ");
#endif

                //from database
                dbPBXSet = pbx.GetDBServerSet();
                if (dbPBXSet != null)
                {
#if PBXV3_DEBUG                    
                    LogMessageToFile("LoadConfig() 4 ");
#endif

                    if (dbPBXSet.ConnectDB())
                    {
#if PBXV3_DEBUG
                        LogMessageToFile("LoadConfig() 5 ");
#endif

                        dbPBXSet.TestTables();
                        SIPPBXCFGDB.LoadAllCfgFromDB(this, pbx, env, log);
                        SIPPBXDBUtil.ClearDBlog(0, dbPBXSet.myConn, log);
                    }
                    else
                    {
#if PBXV3_DEBUG
                        LogMessageToFile("LoadConfig() 6 ");
#endif

                        if (dbPBXSet.CanConnectMaster())
                        {
#if PBXV3_DEBUG
                            LogMessageToFile("LoadConfig() 7 ");
#endif

                            if (!dbPBXSet.CheckDatabaseExists(""))
                            {
                                dbPBXSet.CreateDB(pbx);
                                Thread.Sleep(5000);
                            }

#if PBXV3_DEBUG
                            LogMessageToFile("LoadConfig() 8 ");
#endif

                            int retrymax = 0;
                            while (!dbPBXSet.ConnectDB() && retrymax++ < 3)
                            {
                                Thread.Sleep(3000);
                            }

#if PBXV3_DEBUG
                            LogMessageToFile("LoadConfig() 9 ");
#endif

                            if (dbPBXSet.IsDBConnected())
                            {
#if PBXV3_DEBUG
                                LogMessageToFile("LoadConfig() 10 ");
#endif

                                dbPBXSet.TestTables();
                                SIPPBXCFGDB.LoadAllCfgFromDB(this, pbx, env, log);
                                SIPPBXDBUtil.ClearDBlog(0, dbPBXSet.myConn, log);
                            }
                            else
                            {
                                LogMessageToFile("LoadConfig() 11 still cannot access DB!");
                                throw new Exception("LoadConfig() still cannot access DB!");
                            }
                        }
                        else
                        {
                            LogMessageToFile("LoadConfig() cannot access DB!");
                            throw new Exception("LoadConfig() cannot access DB!");
                        }

#if PBXV3_DEBUG
                        LogMessageToFile("LoadConfig() 12 ");
#endif
                    }
                }
            }
            else if (cfgType == 2)
            {
                //from Regsitry
            }
            else if (cfgType == 3)
            {
                //from XML
            }

        }

        public void SaveConfig()
        {
            if (cfgType == 0)
            {
                //file not found
            }
            else if (cfgType == 1)
            {
                //from database
            }
            else if (cfgType == 2)
            {
                //from Regsitry
            }
            else if (cfgType == 3)
            {
                //from XML
            }


        }

        public void RefreshConfig()
        {
            if (cfgType == 0)
            {
                //file not found
            }
            else if (cfgType == 1)
            {
                //from database
                SIPPBXCFGDB.RefreshAllCfgFromDB(this, pbx, env, log);
            }
            else if (cfgType == 2)
            {
                //from Regsitry
            }
            else if (cfgType == 3)
            {
                //from XML
            }


        }
    }
}
