using System;
using System.Collections.Generic;
using System.Text;
//using System.Windows.Forms;
using Microsoft.Win32;
using System.IO;
using System.Runtime.InteropServices;
using System.Diagnostics;
using System.Reflection;

namespace SIPPBXv3
{
    class SIPPBXCFGReg
    {
        public void SaveLoadBalanceConfigToRegistry()
        {
            RegistryKey regkey;
            //string tmp;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "LoadBalance");
            if (regkey == null)
                return;

            if (pbx.lb_on)
            {
                regkey.SetValue("Count", pbx.lb_addrs.Count);
                for (int i = 0; i < pbx.lb_addrs.Count; i++)
                {
                    SIPPBXDest dest = pbx.lb_addrs[i];
                    int idx = i + 1;
                    regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "LoadBalance\\" + idx.ToString());

                    regkey.SetValue("Type", dest.DestType);
                    regkey.SetValue("Addr", dest.DestAddr);
                    regkey.SetValue("RingTimeout", dest.RingTimeout);
                }
            }
            else
            {
                regkey.SetValue("Count", (int)0);
            }

            regkey.Close();
        }

        public void LoadLoadBalanceConfigFromRegistry()
        {
            RegistryKey regkey;
            //string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "LoadBalance");

            if (regkey == null)
                return;

            Object obj = regkey.GetValue("Count");
            int count = 0;

            if (obj != null)
                count = (int)obj;

            pbx.lb_addrs.Clear();

            if (count > 0)
            {
                pbx.lb_on = true;
                for (int i = 0; i < count; i++)
                {
                    SIPPBXDest dest = new SIPPBXDest();
                    int idx = i + 1;
                    regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "LoadBalance\\" + idx.ToString());

                    obj = regkey.GetValue("Type");
                    if (obj != null)
                        dest.DestType = (int)obj;

                    obj = regkey.GetValue("Addr");
                    if (obj != null)
                        dest.DestAddr = (string)obj;

                    obj = regkey.GetValue("RingTimeout");
                    if (obj != null)
                        dest.RingTimeout = (int)obj;

                    pbx.lb_addrs.Add(dest);
                }
            }
            else
            {
                pbx.lb_on = false;
                pbx.lb_addrs.Clear();
            }

            regkey.Close();
        }

        public void LoadRingGroupConfigFromRegistry()
        {
            RegistryKey regkey;
            //string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "RingGroups");

            if (regkey == null)
                return;

            Object obj = regkey.GetValue("Count");
            int count = 0;

            if (obj != null)
                count = (int)obj;

            pbx.sip_ringgroups.Clear();

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    SIPPBXRingGroup rg = new SIPPBXRingGroup();

                    int idx = i + 1;
                    int DestCount = 0;

                    regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "RingGroups\\" + idx.ToString());

                    if (regkey == null)
                        return;

                    obj = regkey.GetValue("Name");
                    if (obj != null)
                        rg.gpName = (string)obj;
                    else
                        continue;

                    obj = regkey.GetValue("Type");
                    if (obj != null)
                        rg.ringType = (int)obj;

                    obj = regkey.GetValue("PlayMOH");
                    if (obj != null)
                        rg.playMOH = (((int)obj) == 1);

                    obj = regkey.GetValue("MOHDir");
                    if (obj != null)
                        rg.mohDir = (string)obj;

                    obj = regkey.GetValue("VMBOn");
                    if (obj != null)
                    {
                        if ((int)obj == 1)
                        {
                            rg.vmb = new VoiceMailBox();
                            obj = regkey.GetValue("VMBPrompt");
                            if (obj != null)
                                rg.vmb.vmbPrompt = (string)obj;

                            obj = regkey.GetValue("VMBEmail");
                            if (obj != null)
                                rg.vmb.vmbEmailAddr = (string)obj;

                            obj = regkey.GetValue("VMBMaxLength");
                            if (obj != null)
                                rg.vmb.maxLengthInSecond = (int)obj;
                        }
                        else
                        {
                            rg.vmb = null;
                        }
                    }


                    obj = regkey.GetValue("DestCount");
                    if (obj != null)
                        DestCount = (int)obj;

                    for (int j = 0; j < DestCount; j++)
                    {
                        SIPPBXDest dest = new SIPPBXDest();
                        obj = regkey.GetValue("Dest" + j.ToString() + "-Type");
                        if (obj != null)
                            dest.DestType = (int)obj;

                        obj = regkey.GetValue("Dest" + j.ToString() + "-Addr");
                        if (obj != null)
                            dest.DestAddr = (string)obj;

                        obj = regkey.GetValue("Dest" + j.ToString() + "-RingTimeout");
                        if (obj != null)
                            dest.RingTimeout = (int)obj;

                        rg.destList.Add(dest);
                    }

                    pbx.sip_ringgroups.Add(rg);
                }
            }

            regkey.Close();
        }

        public void SaveRingGroupConfigToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "RingGroups");

            if (regkey == null)
                return;

            int count = pbx.sip_ringgroups.Count;
            regkey.SetValue("Count", count);

            SIPPBXRingGroup rg;

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    rg = pbx.sip_ringgroups[i];
                    int idx = i + 1;

                    regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "RingGroups\\" + idx.ToString());

                    if (regkey == null)
                        return;

                    regkey.SetValue("Name", rg.gpName);
                    regkey.SetValue("Type", rg.ringType);
                    regkey.SetValue("PlayMOH", rg.playMOH ? 1 : 0);
                    regkey.SetValue("MOHDir", rg.mohDir);
                    regkey.SetValue("DestCount", rg.destList.Count);
                    regkey.SetValue("VMBOn", rg.vmb != null ? 1 : 0);

                    if (rg.vmb != null)
                    {
                        regkey.SetValue("VMBPrompt", rg.vmb.vmbPrompt);
                        regkey.SetValue("VMBEmail", rg.vmb.vmbEmailAddr);
                        regkey.SetValue("VMBMaxLength", rg.vmb.maxLengthInSecond);
                    }

                    for (int j = 0; j < rg.destList.Count; j++)
                    {
                        regkey.SetValue("Dest" + j.ToString() + "-Type", rg.destList[j].DestType);
                        regkey.SetValue("Dest" + j.ToString() + "-Addr", rg.destList[j].DestAddr);
                        regkey.SetValue("Dest" + j.ToString() + "-RingTimeout", rg.destList[j].RingTimeout);
                    }
                }
            }

            regkey.Close();
        }

        /// Pickup Group
        /// ////////////////////////////////////////////////
        public void LoadPickupGroupConfigFromRegistry()
        {
            RegistryKey regkey;
            //string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "PickupGroups");

            if (regkey == null)
                return;

            Object obj = regkey.GetValue("Count");
            int count = 0;
            int MemberCount = 0;

            if (obj != null)
                count = (int)obj;

            pbx.pickup_groups.Clear();

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    PickUpGroup pg = new PickUpGroup();

                    int idx = i + 1;

                    regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "PickupGroups\\" + idx.ToString());

                    if (regkey == null)
                        return;

                    obj = regkey.GetValue("Name");
                    if (obj != null)
                        pg.name = (string)obj;
                    else
                        continue;

                    obj = regkey.GetValue("Type");
                    if (obj != null)
                        pg.ml.mb_type = (int)obj;

                    obj = regkey.GetValue("MemberCount");
                    if (obj != null)
                        MemberCount = (int)obj;

                    for (int j = 0; j < MemberCount; j++)
                    {
                        obj = regkey.GetValue("Member" + j.ToString());
                        if (obj != null)
                            pg.ml.members.Add((string)obj);
                    }

                    pbx.pickup_groups.Add(pg);
                }
            }

            regkey.Close();
        }

        public void SavePickupGroupConfigToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "PickupGroups");

            if (regkey == null)
                return;

            int count = pbx.pickup_groups.Count;
            regkey.SetValue("Count", count);

            PickUpGroup pg;

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    pg = pbx.pickup_groups[i];
                    int idx = i + 1;

                    regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "PickupGroups\\" + idx.ToString());

                    if (regkey == null)
                        return;

                    regkey.SetValue("Name", pg.name);
                    regkey.SetValue("Type", pg.ml.mb_type);
                    regkey.SetValue("MemberCount", pg.ml.members.Count);
                    for (int j = 0; j < pg.ml.members.Count; j++)
                    {
                        regkey.SetValue("Member" + j.ToString(), pg.ml.members[j]);
                    }
                }
            }

            regkey.Close();
        }

        ////
        /// Conference Rooms
        /// ////////////////////////////////////////////////
        public void LoadConferRoomsConfigFromRegistry()
        {
            RegistryKey regkey;
            //string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "ConferRooms");

            if (regkey == null)
                return;

            Object obj = regkey.GetValue("Count");
            int count = 0;

            if (obj != null)
                count = (int)obj;

            pbx.sip_conferooms.Clear();

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    SIPConferRoom room = new SIPConferRoom();

                    int idx = i + 1;

                    regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "ConferRooms\\" + idx.ToString());

                    if (regkey == null)
                        return;

                    obj = regkey.GetValue("Name");
                    if (obj != null)
                        room.conf_name = (string)obj;
                    else
                        continue;

                    pbx.sip_conferooms.Add(room);
                }
            }

            regkey.Close();
        }

        public void SaveConferRoomsConfigToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "ConferRooms");

            if (regkey == null)
                return;

            int count = pbx.sip_conferooms.Count;
            regkey.SetValue("Count", count);

            SIPConferRoom room;

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    room = pbx.sip_conferooms[i];
                    int idx = i + 1;

                    regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "ConferRooms\\" + idx.ToString());

                    if (regkey == null)
                        return;

                    regkey.SetValue("Name", room.conf_name);
                }
            }

            regkey.Close();
        }


        /// </summary>

        public void SaveMonitorGroupConfigToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "MonitorGroups");

            if (regkey == null)
                return;

            int count = pbx.sip_monitorgroups.Count;
            regkey.SetValue("Count", count);

            SIPPBXMonitorGroup mg;

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    mg = pbx.sip_monitorgroups[i];
                    int idx = i + 1;

                    regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "MonitorGroups\\" + idx.ToString());

                    if (regkey == null)
                        return;

                    regkey.SetValue("Name", mg.mgName);
                    regkey.SetValue("Number", mg.mgNumber);

                    regkey.SetValue("PasswordPrompt", mg.mgPasswordPrompt);
                    regkey.SetValue("Password", mg.mgPassword);

                    regkey.SetValue("KeyBargeIn", mg.mgKeyBargeIn);
                    regkey.SetValue("KeyBargeOut", mg.mgKeyOut);

                    regkey.SetValue("ExtenPrompt", mg.mgExtenPrompt);
                    regkey.SetValue("ExtenAll", mg.mgAllExtens ? 1 : 0);

                    if (!mg.mgAllExtens)
                    {
                        regkey.SetValue("ExtenCount", mg.mgExtenList.Count);
                        for (int j = 0; j < mg.mgExtenList.Count; j++)
                        {
                            regkey.SetValue("Exten" + j.ToString(), mg.mgExtenList[j]);
                        }
                    }
                }
            }

            regkey.Close();
        }

        public void LoadMonitorGroupConfigFromRegistry()
        {
            RegistryKey regkey;
            //string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "MonitorGroups");

            if (regkey == null)
                return;

            int count = 0;
            int ExtenCount = 0;

            Object obj = regkey.GetValue("Count");
            if (obj != null)
                count = (int)obj;

            pbx.sip_monitorgroups.Clear();

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    SIPPBXMonitorGroup mg = new SIPPBXMonitorGroup();
                    mg.mgExtenPrompt = pbx.please_enter_extension_number_dir;
                    mg.mgPasswordPrompt = pbx.please_enter_password_dir;

                    int idx = i + 1;

                    regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "MonitorGroups\\" + idx.ToString());

                    if (regkey == null)
                        return;

                    obj = regkey.GetValue("Name");
                    if (obj != null)
                        mg.mgName = (string)obj;
                    else
                        continue;

                    obj = regkey.GetValue("Number");
                    if (obj != null)
                        mg.mgNumber = (string)obj;

                    obj = regkey.GetValue("PasswordPrompt");
                    if (obj != null)
                        mg.mgPasswordPrompt = (string)obj;

                    obj = regkey.GetValue("Password");
                    if (obj != null)
                        mg.mgPassword = (string)obj;

                    obj = regkey.GetValue("KeyBargeIn");
                    if (obj != null)
                        mg.mgKeyBargeIn = (string)obj;

                    obj = regkey.GetValue("KeyBargeOut");
                    if (obj != null)
                        mg.mgKeyOut = (string)obj;

                    obj = regkey.GetValue("ExtenPrompt");
                    if (obj != null)
                        mg.mgExtenPrompt = (string)obj;

                    obj = regkey.GetValue("ExtenAll");
                    if (obj != null)
                        mg.mgAllExtens = ((int)obj == 1);

                    obj = regkey.GetValue("ExtenCount");
                    if (obj != null)
                        ExtenCount = (int)obj;

                    if (!mg.mgAllExtens)
                    {
                        for (int j = 0; j < ExtenCount; j++)
                        {
                            obj = regkey.GetValue("Exten" + j.ToString());
                            if (obj != null)
                                mg.mgExtenList.Add((string)obj);
                        }
                    }

                    pbx.sip_monitorgroups.Add(mg);
                }
            }

            regkey.Close();
        }

        public void SaveExtensionsConfigToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "Extensions");

            if (regkey == null)
                return;

            int count = pbx.sip_exten.Count;
            regkey.SetValue("Count", count);

            SIPPBXExten extn;

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    extn = pbx.sip_exten[i];
                    int idx = i + 1;

                    regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "Extensions\\" + idx.ToString());

                    if (regkey == null)
                        return;

                    regkey.SetValue("UserName", extn.UserName);
                    regkey.SetValue("RealName", extn.RealName);
                    regkey.SetValue("Password", extn.Password);
                    regkey.SetValue("Email", extn.Email);
                    regkey.SetValue("AlternativePhoneNumber", extn.AlternativePhoneNumber);

                    regkey.SetValue("RegSDKTime", extn.RegSDKTime);
                    regkey.SetValue("RegisterTime", extn.RegisterTime);
                    regkey.SetValue("RegisterExpire", extn.RegisterExpire);
                    regkey.SetValue("ContactAddr", extn.ContactAddr);
                    regkey.SetValue("RegFromID", extn.RegFromID);
                    regkey.SetValue("RegToID", extn.RegToID);
                    regkey.SetValue("UAName", extn.UAName);
                    regkey.SetValue("NATType", extn.NATType);
                    regkey.SetValue("AcceptOtherID", extn.bAcceptOtherID ? 1 : 0);
                    regkey.SetValue("RestSeconds", extn.RestSeconds);

                    regkey.SetValue("MsgWaitingCount", extn.MsgWaitingCount);
                    regkey.SetValue("MsgTotalCount", extn.MsgTotalCount);
                    regkey.SetValue("MsgAccount", extn.MsgAccount);
                    regkey.SetValue("VoiceMsg", extn.VoiceMsg);

                    //regkey.SetValue("Subscribed" + idx.ToString(), extn.bSubscribed);

                    regkey.SetValue("PriorityLevel", extn.PriorityLevel);
                    regkey.SetValue("VirtualExtenDestAddr", extn.VirtualExtenDestAddr);

                    regkey.SetValue("ACDCallMethod", extn.ACDCallMethod);

                    regkey.SetValue("RecordCall", extn.RecordCall ? 1 : 0);

                    regkey.SetValue("RingTimeoutSec", extn.RingTimeoutSec);
                    regkey.SetValue("CallForwardingPlan", extn.CallForwardingPlan);

                    if (extn.vmb != null)
                    {
                        regkey.SetValue("VMBOn", 1);
                        regkey.SetValue("VMBPrompt", extn.vmb.vmbPrompt);
                        regkey.SetValue("VMBEmail", extn.vmb.vmbEmailAddr);
                        regkey.SetValue("VMBMaxLength", extn.vmb.maxLengthInSecond);
                    }
                    else
                    {
                        regkey.SetValue("VMBOn", 0);
                    }
                }
            }

            regkey.Close();

            //DB routes
            DBServerSetting db_set = pbx.GetDBServerSet();
            if (db_set != null)
            {
                if (db_set.ConnectDB())
                {
                    SIPPBXDBUtil.SaveCFGExtenTable(pbx, env, db_set.myConn);
                    db_set.DisconnectDB();
                }
            }

        }

        public void LoadAutoDialerTasksFromRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "AutoDialerTasks");

            if (regkey == null)
                return;

            Object obj = regkey.GetValue("Count");
            int count = 0;

            if (obj != null)
                count = (int)obj;

            pbx.auto_dialer_tasks.Clear();

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    AutoDialerTask task = new AutoDialerTask();

                    int idx = i + 1;

                    obj = regkey.GetValue("Name" + idx.ToString());
                    if (obj != null)
                        task.task_name = (string)obj;

                    obj = regkey.GetValue("IsOn" + idx.ToString());
                    if (obj != null)
                    {
                        if ((int)obj == 1)
                            task.isOn = true;
                        else
                            task.isOn = false;
                    }

                    obj = regkey.GetValue("TypeCode" + idx.ToString());
                    if (obj != null)
                    {
                        task.type_code = Convert.ToInt16((string)obj);
                    }

                    obj = regkey.GetValue("SIPAcct" + idx.ToString());
                    if (obj != null)
                        task.sip_acc = (string)obj;

                    obj = regkey.GetValue("DialPlan" + idx.ToString());
                    if (obj != null)
                        task.dial_plan = (string)obj;

                    obj = regkey.GetValue("RingTimeout" + idx.ToString());
                    if (obj != null)
                        task.m_ringTimeout = (int)obj;

                    obj = regkey.GetValue("MaxSimCalls" + idx.ToString());
                    if (obj != null)
                        task.m_maxSimCalls = (int)obj;


                    /*
                                        obj = regkey.GetValue("WriteSIPCode" + idx.ToString());
                                        if (obj != null)
                                            task.m_bWriteSIPCode = ((int)obj == 1)?true:false;
                    */

                    pbx.auto_dialer_tasks.Add(task);
                }
            }

            regkey.Close();

        }

        public void SaveAutoDialerTasksToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "AutoDialerTasks");

            if (regkey == null)
                return;

            int count = pbx.auto_dialer_tasks.Count;
            regkey.SetValue("Count", count);

            AutoDialerTask task;

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    task = pbx.auto_dialer_tasks[i];
                    int idx = i + 1;
                    regkey.SetValue("Name" + idx.ToString(), task.task_name);
                    regkey.SetValue("IsOn" + idx.ToString(), task.isOn ? 1 : 0);
                    regkey.SetValue("TypeCode" + idx.ToString(), task.type_code);
                    regkey.SetValue("SIPAcct" + idx.ToString(), task.sip_acc);
                    regkey.SetValue("DialPlan" + idx.ToString(), task.dial_plan);

                    regkey.SetValue("RingTimeout" + idx.ToString(), task.m_ringTimeout);
                    regkey.SetValue("MaxSimCalls" + idx.ToString(), task.m_maxSimCalls);

                    //regkey.SetValue("WriteSIPCode" + idx.ToString(), task.m_bWriteSIPCode?1:0);
                }
            }

            regkey.Close();

        }

        public void SaveSIPAccountConfigToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "SIPAccounts");

            if (regkey == null)
                return;

            int count = pbx.sip_acct.Count;
            regkey.SetValue("Count", count);

            SIPAccount acct;

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    acct = pbx.sip_acct[i];
                    int idx = i + 1;
                    regkey.SetValue("DisplayName" + idx.ToString(), acct.DisplayName);
                    regkey.SetValue("UserName" + idx.ToString(), acct.UserName);
                    regkey.SetValue("DomainServer" + idx.ToString(), acct.DomainServer);
                    regkey.SetValue("ProxyServer" + idx.ToString(), acct.ProxyServer);
                    regkey.SetValue("AuthName" + idx.ToString(), acct.AuthName);
                    regkey.SetValue("Password" + idx.ToString(), acct.Password);
                    regkey.SetValue("ExpireSec" + idx.ToString(), acct.ExpireSec);
                    regkey.SetValue("RegWithProxyServer" + idx.ToString(), acct.RegWithProxyServer);
                    regkey.SetValue("DIDCount" + idx.ToString(), acct.DIDList.Count);
                    for (int j = 0; j < acct.DIDList.Count; j++)
                    {
                        regkey.SetValue("DIDS" + idx.ToString() + "-" + j.ToString(), acct.DIDList[j]);
                    }
                }
            }

            regkey.Close();
        }

        public void SaveDBSettingsToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "Database");

            if (regkey == null)
                return;

            regkey.SetValue("Enabled", (pbx.db_set != null) ? 1 : 0);

            if (pbx.db_set != null)
            {
                regkey.SetValue("AuthType", pbx.db_set.authType);
                regkey.SetValue("DBType", pbx.db_set.dbType);
                regkey.SetValue("DBServer", pbx.db_set.sDBServer);
                regkey.SetValue("DBName", pbx.db_set.sDBName);
                regkey.SetValue("UserName", pbx.db_set.sUserName);
                regkey.SetValue("Password", pbx.db_set.sPassword);
            }

            regkey.Close();
        }

        public void LoadDBSettingsFromRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "Database");

            pbx.db_set = null;

            if (regkey == null)
                return;

            Object obj = regkey.GetValue("Enabled");
            int count = 0;

            if (obj != null)
                count = (int)obj;

            if (count > 0)
            {
                pbx.db_set = new DBServerSetting();

                obj = regkey.GetValue("AuthType");
                if (obj != null)
                    pbx.db_set.authType = (int)obj;

                obj = regkey.GetValue("DBType");
                if (obj != null)
                    pbx.db_set.dbType = (int)obj;

                obj = regkey.GetValue("DBServer");
                if (obj != null)
                    pbx.db_set.sDBServer = (string)obj;

                obj = regkey.GetValue("DBName");
                if (obj != null)
                    pbx.db_set.sDBName = (string)obj;

                obj = regkey.GetValue("UserName");
                if (obj != null)
                    pbx.db_set.sUserName = (string)obj;

                obj = regkey.GetValue("Password");
                if (obj != null)
                    pbx.db_set.sPassword = (string)obj;

                if (pbx.db_set.ConnectDB())
                {
                    pbx.db_set.TestTables();
                    pbx.db_set.DisconnectDB();
                }
            }

            regkey.Close();

        }

        public void LoadSIPAccountConfigFromRegistry()
        {
            RegistryKey regkey;
            string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "SIPAccounts");

            if (regkey == null)
                return;

            Object obj = regkey.GetValue("Count");
            int count = 0;

            if (obj != null)
                count = (int)obj;

            pbx.sip_acct.Clear();

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    SIPAccount acct = new SIPAccount();

                    int idx = i + 1;

                    acct.AccID = idx;

                    obj = regkey.GetValue("DisplayName" + idx.ToString());
                    if (obj != null)
                        acct.DisplayName = (string)obj;
                    obj = regkey.GetValue("UserName" + idx.ToString());
                    if (obj != null)
                        acct.UserName = (string)obj;

                    if (SelfBrand.Contains("iFoneline"))
                    {
                        acct.DomainServer = "sip.ifoneline.com";
                        acct.ProxyServer = "sip.ifoneline.com";
                    }
                    else
                    {
                        obj = regkey.GetValue("DomainServer" + idx.ToString());
                        if (obj != null)
                            acct.DomainServer = (string)obj;
                        obj = regkey.GetValue("ProxyServer" + idx.ToString());
                        if (obj != null)
                            acct.ProxyServer = (string)obj;
                    }

                    obj = regkey.GetValue("AuthName" + idx.ToString());
                    if (obj != null)
                        acct.AuthName = (string)obj;
                    obj = regkey.GetValue("Password" + idx.ToString());
                    if (obj != null)
                        acct.Password = (string)obj;
                    obj = regkey.GetValue("ExpireSec" + idx.ToString());
                    if (obj != null)
                        acct.ExpireSec = (int)obj;
                    obj = regkey.GetValue("RegWithProxyServer" + idx.ToString());
                    if (obj != null)
                        tmp = (string)obj;
                    else
                        tmp = "TRUE";
                    if (tmp.ToUpper() == "TRUE")
                        acct.RegWithProxyServer = true;
                    else
                        acct.RegWithProxyServer = false;

                    int DIDCount = 0;
                    obj = regkey.GetValue("DIDCount" + idx.ToString());
                    if (obj != null)
                        DIDCount = (int)obj;
                    for (int j = 0; j < DIDCount; j++)
                    {
                        obj = regkey.GetValue("DIDS" + idx.ToString() + "-" + j.ToString());
                        if (obj != null)
                            acct.DIDList.Add((string)obj);
                    }

                    pbx.sip_acct.Add(acct);
                }
            }

            regkey.Close();

        }

        public void LoadExtensionsConfigFromRegistry()
        {
            RegistryKey regkey;
            //string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "Extensions");

            if (regkey == null)
                return;

            Object obj = regkey.GetValue("Count");
            int count = 0;

            if (obj != null)
                count = (int)obj;

            pbx.sip_exten.Clear();

            if (count > 0)
            {
                /*
                                if (pbx.bFreeVersion && count > 4)
                                {
                                    count = 4;
                                }
                */
                for (int i = 0; i < count; i++)
                {
                    SIPPBXExten extn = new SIPPBXExten();

                    int idx = i + 1;

                    regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "Extensions\\" + idx.ToString());

                    if (regkey == null)
                        return;

                    obj = regkey.GetValue("UserName");
                    if (obj != null)
                        extn.UserName = (string)obj;
                    else
                        continue;

                    obj = regkey.GetValue("RealName");
                    if (obj != null)
                        extn.RealName = (string)obj;

                    obj = regkey.GetValue("Password");
                    if (obj != null)
                        extn.Password = (string)obj;

                    obj = regkey.GetValue("Email");
                    if (obj != null)
                        extn.Email = (string)obj;

                    obj = regkey.GetValue("AlternativePhoneNumber");
                    if (obj != null)
                        extn.AlternativePhoneNumber = (string)obj;

                    obj = regkey.GetValue("RegSDKTime");
                    if (obj != null)
                        extn.RegSDKTime = Convert.ToUInt32(obj);

                    obj = regkey.GetValue("RegisterTime");
                    if (obj != null)
                        extn.RegisterTime = Convert.ToDateTime(obj);

                    obj = regkey.GetValue("RegisterExpire");
                    if (obj != null)
                        extn.RegisterExpire = Convert.ToUInt32(obj);

                    obj = regkey.GetValue("ContactAddr");
                    if (obj != null)
                        extn.ContactAddr = (string)obj;

                    obj = regkey.GetValue("RegFromID");
                    if (obj != null)
                        extn.RegFromID = (string)obj;

                    obj = regkey.GetValue("RegToID");
                    if (obj != null)
                        extn.RegToID = (string)obj;

                    obj = regkey.GetValue("UAName");
                    if (obj != null)
                        extn.UAName = (string)obj;

                    obj = regkey.GetValue("NATType");
                    if (obj != null)
                        extn.NATType = (int)obj;

                    obj = regkey.GetValue("MsgWaitingCount");
                    if (obj != null)
                        extn.MsgWaitingCount = (int)obj;

                    obj = regkey.GetValue("MsgTotalCount");
                    if (obj != null)
                        extn.MsgTotalCount = (int)obj;

                    obj = regkey.GetValue("MsgAccount");
                    if (obj != null)
                        extn.MsgAccount = (string)obj;

                    obj = regkey.GetValue("VoiceMsg");
                    if (obj != null)
                        extn.VoiceMsg = (string)obj;

                    //regkey.SetValue("Subscribed" + idx.ToString(), extn.bSubscribed);

                    obj = regkey.GetValue("PriorityLevel");
                    if (obj != null)
                        extn.PriorityLevel = Convert.ToUInt32(obj);

                    obj = regkey.GetValue("VirtualExtenDestAddr");
                    if (obj != null)
                        extn.VirtualExtenDestAddr = (string)obj;

                    obj = regkey.GetValue("ACDCallMethod");
                    if (obj != null)
                        extn.ACDCallMethod = (int)obj;

                    obj = regkey.GetValue("RingTimeoutSec");
                    if (obj != null)
                        extn.RingTimeoutSec = (int)obj;

                    obj = regkey.GetValue("CallForwardingPlan");
                    if (obj != null)
                        extn.CallForwardingPlan = (string)obj;

                    obj = regkey.GetValue("RecordCall");
                    if (obj != null)
                        if ((int)obj == 1)
                            extn.RecordCall = true;
                        else
                            extn.RecordCall = false;

                    obj = regkey.GetValue("AcceptOtherID");
                    if (obj != null)
                        if ((int)obj == 1)
                            extn.bAcceptOtherID = true;
                        else
                            extn.bAcceptOtherID = false;

                    obj = regkey.GetValue("RestSeconds");
                    if (obj != null)
                        extn.RestSeconds = (int)obj;

                    obj = regkey.GetValue("VMBOn");
                    if (obj != null)
                    {
                        if ((int)obj == 1)
                        {
                            extn.vmb = new VoiceMailBox();
                            extn.vmb.vmbExten = extn;

                            obj = regkey.GetValue("VMBPrompt");
                            if (obj != null)
                                extn.vmb.vmbPrompt = (string)obj;

                            obj = regkey.GetValue("VMBEmail");
                            if (obj != null)
                                extn.vmb.vmbEmailAddr = (string)obj;

                            obj = regkey.GetValue("VMBMaxLength");
                            if (obj != null)
                                extn.vmb.maxLengthInSecond = (int)obj;
                        }
                        else
                        {
                            extn.vmb = null;
                        }
                    }

                    pbx.sip_exten.Add(extn);
                }
            }

            regkey.Close();

        }

        public void LoadParkingSlotConfigFromRegistry()
        {
            RegistryKey regkey;
            //string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "ParkingSlots");

            pbx.sip_parkingslots.Clear();

            if (regkey == null)
                return;

            int count = 0;
            Object obj;
            obj = regkey.GetValue("Count");
            if (obj != null)
                count = (int)obj;

            for (int i = 0; i < count; i++)
            {
                SIPPBXParkingSlot ps = new SIPPBXParkingSlot();
                int idx = i + 1;
                regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "ParkingSlots\\" + idx.ToString());
                if (regkey == null)
                    return;

                obj = regkey.GetValue("Name");
                if (obj != null)
                    ps.psName = (string)obj;

                obj = regkey.GetValue("DTMFStr");
                if (obj != null)
                    ps.dtmfStr = (string)obj;

                obj = regkey.GetValue("PlayMOH");
                if (obj != null)
                    ps.playMOH = (((int)obj) == 1);

                obj = regkey.GetValue("MOHDir");
                if (obj != null)
                    ps.mohDir = (string)obj;

                obj = regkey.GetValue("DialplanDTMF");
                if (obj != null)
                    ps.dpDTMF = (string)obj;

                obj = regkey.GetValue("DialplanName");
                if (obj != null)
                    ps.dpName = (string)obj;

                obj = regkey.GetValue("WaitTimeout");
                if (obj != null)
                    ps.waitTimeout = (int)obj;

                obj = regkey.GetValue("WaitTimeoutTo");
                if (obj != null)
                    ps.waitTimeoutTo = (string)obj;

                obj = regkey.GetValue("VMBDTMF");
                if (obj != null)
                    ps.vmbDTMF = (string)obj;

                obj = regkey.GetValue("VMBOn");
                if (obj != null)
                {
                    if ((int)obj == 1)
                    {
                        ps.vmb = new VoiceMailBox();
                        obj = regkey.GetValue("VMBPrompt");
                        if (obj != null)
                            ps.vmb.vmbPrompt = (string)obj;

                        obj = regkey.GetValue("VMBEmail");
                        if (obj != null)
                            ps.vmb.vmbEmailAddr = (string)obj;

                        obj = regkey.GetValue("VMBMaxLength");
                        if (obj != null)
                            ps.vmb.maxLengthInSecond = (int)obj;
                    }
                    else
                    {
                        ps.vmb = null;
                    }
                }


                pbx.sip_parkingslots.Add(ps);
            }

        }

        public void SaveParkingSlotConfigToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "ParkingSlots");

            if (regkey == null)
                return;

            regkey.SetValue("Count", pbx.sip_parkingslots.Count);

            for (int i = 0; i < pbx.sip_parkingslots.Count; i++)
            {
                SIPPBXParkingSlot ps = pbx.sip_parkingslots[i];
                int idx = i + 1;
                regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "ParkingSlots\\" + idx.ToString());
                if (regkey == null)
                    return;

                regkey.SetValue("Name", ps.psName);
                regkey.SetValue("DTMFStr", ps.dtmfStr);
                regkey.SetValue("PlayMOH", ps.playMOH ? 1 : 0);
                regkey.SetValue("MOHDir", ps.mohDir);

                regkey.SetValue("VMBDTMF", ps.vmbDTMF);
                regkey.SetValue("VMBOn", ps.vmb != null ? 1 : 0);
                if (ps.vmb != null)
                {
                    regkey.SetValue("VMBPrompt", ps.vmb.vmbPrompt);
                    regkey.SetValue("VMBEmail", ps.vmb.vmbEmailAddr);
                    regkey.SetValue("VMBMaxLength", ps.vmb.maxLengthInSecond);
                }
                regkey.SetValue("DialplanDTMF", ps.dpDTMF);
                regkey.SetValue("DialplanName", ps.dpName);
                regkey.SetValue("WaitTimeout", ps.waitTimeout);
                regkey.SetValue("WaitTimeoutTo", ps.waitTimeoutTo);
            }

        }

        public void SaveACDConfigToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "ACDHuntGroups");

            if (regkey == null)
                return;

            regkey.SetValue("Count", pbx.sip_huntgroups.Count);

            for (int i = 0; i < pbx.sip_huntgroups.Count; i++)
            {
                SIPPBXACDHuntGroup hg = pbx.sip_huntgroups[i];
                int idx = i + 1;
                regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "ACDHuntGroups\\" + idx.ToString());
                if (regkey == null)
                    return;

                regkey.SetValue("Name", hg.hgName);
                regkey.SetValue("Type", hg.hgType);
                regkey.SetValue("PlayMOH", hg.playMOH ? 1 : 0);
                regkey.SetValue("MOHDir", hg.mohDir);
                regkey.SetValue("VMBDTMF", hg.vmbDTMF);
                regkey.SetValue("VMBOn", (hg.vmb != null) ? 1 : 0);
                if (hg.vmb != null)
                {
                    regkey.SetValue("VMBPrompt", hg.vmb.vmbPrompt);
                    regkey.SetValue("VMBEmail", hg.vmb.vmbEmailAddr);
                    regkey.SetValue("VMBMaxLength", hg.vmb.maxLengthInSecond);
                }
                regkey.SetValue("DialplanDTMF", hg.dpDTMF);
                regkey.SetValue("DialplanName", hg.dpName);

                regkey.SetValue("WaitTimeout", hg.waitTimeout);
                regkey.SetValue("WaitTimeoutTo", hg.waitTimeoutTo);

                regkey.SetValue("AgentType", hg.agentType);
                regkey.SetValue("AgentCount", hg.agents.Count);

                for (int j = 0; j < hg.agents.Count; j++)
                {
                    int idx1 = j + 1;
                    regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "ACDHuntGroups\\" + idx.ToString() + "\\Agent" + idx1.ToString());
                    if (regkey == null)
                        return;

                    regkey.SetValue("Name", hg.agents[j]);
                }
            }
        }

        public void LoadACDConfigFromRegistry()
        {
            RegistryKey regkey;
            //string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "ACDHuntGroups");

            pbx.sip_huntgroups.Clear();

            if (regkey == null)
                return;

            int count = 0;
            Object obj;
            obj = regkey.GetValue("Count");
            if (obj != null)
                count = (int)obj;

            for (int i = 0; i < count; i++)
            {
                SIPPBXACDHuntGroup hg = new SIPPBXACDHuntGroup();
                int idx = i + 1;
                regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "ACDHuntGroups\\" + idx.ToString());
                if (regkey == null)
                    return;

                obj = regkey.GetValue("Name");
                if (obj != null)
                    hg.hgName = (string)obj;

                obj = regkey.GetValue("Type");
                if (obj != null)
                    hg.hgType = (int)obj;

                obj = regkey.GetValue("PlayMOH");
                if (obj != null)
                    hg.playMOH = (((int)obj) == 1);

                obj = regkey.GetValue("MOHDir");
                if (obj != null)
                    hg.mohDir = (string)obj;

                obj = regkey.GetValue("DialplanDTMF");
                if (obj != null)
                    hg.dpDTMF = (string)obj;

                obj = regkey.GetValue("DialplanName");
                if (obj != null)
                    hg.dpName = (string)obj;

                obj = regkey.GetValue("WaitTimeout");
                if (obj != null)
                    hg.waitTimeout = (int)obj;

                obj = regkey.GetValue("WaitTimeoutTo");
                if (obj != null)
                    hg.waitTimeoutTo = (string)obj;

                obj = regkey.GetValue("VMBDTMF");
                if (obj != null)
                    hg.vmbDTMF = (string)obj;

                obj = regkey.GetValue("VMBOn");
                if (obj != null)
                {
                    if ((int)obj == 1)
                    {
                        hg.vmb = new VoiceMailBox();
                        obj = regkey.GetValue("VMBPrompt");
                        if (obj != null)
                            hg.vmb.vmbPrompt = (string)obj;

                        obj = regkey.GetValue("VMBEmail");
                        if (obj != null)
                            hg.vmb.vmbEmailAddr = (string)obj;

                        obj = regkey.GetValue("VMBMaxLength");
                        if (obj != null)
                            hg.vmb.maxLengthInSecond = (int)obj;
                    }
                    else
                    {
                        hg.vmb = null;
                    }
                }

                obj = regkey.GetValue("AgentType");
                if (obj != null)
                    hg.agentType = (int)obj;

                int count1 = 0;
                obj = regkey.GetValue("AgentCount");
                if (obj != null)
                    count1 = (int)obj;

                for (int j = 0; j < count1; j++)
                {
                    int idx1 = j + 1;
                    regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "ACDHuntGroups\\" + idx.ToString() + "\\Agent" + idx1.ToString());
                    if (regkey == null)
                        return;

                    obj = regkey.GetValue("Name");
                    if (obj != null)
                        hg.agents.Add((string)obj);
                }

                pbx.sip_huntgroups.Add(hg);

            }

        }

        public void SaveAgentsToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "Agents");

            if (regkey == null)
                return;

            regkey.SetValue("Count", pbx.sip_agents.Count);

            for (int i = 0; i < pbx.sip_agents.Count; i++)
            {
                SIPPBXAgent agent = pbx.sip_agents[i];
                int idx = i + 1;
                regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "Agents\\" + idx.ToString());
                if (regkey == null)
                    return;

                regkey.SetValue("Name", agent.Name);
                regkey.SetValue("Code", agent.Code);
                regkey.SetValue("Password", agent.Password);
                regkey.SetValue("RecordCall", agent.RecordCall ? 1 : 0);
                regkey.SetValue("AtExten", (agent.AtExten != null) ? agent.AtExten.UserName : "");
                regkey.SetValue("LogInTime", agent.LogInTime);
                regkey.SetValue("LogOutTime", agent.LogOutTime);
            }
        }

        public void LoadAgentsFromRegistry()
        {
            RegistryKey regkey;
            //string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "Agents");

            pbx.sip_agents.Clear();

            if (regkey == null)
                return;

            int count = 0;
            Object obj;
            obj = regkey.GetValue("Count");
            if (obj != null)
                count = (int)obj;

            for (int i = 0; i < count; i++)
            {
                SIPPBXAgent agent = new SIPPBXAgent();
                int idx = i + 1;
                regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "Agents\\" + idx.ToString());
                if (regkey == null)
                    return;

                obj = regkey.GetValue("Name");
                if (obj != null)
                    agent.Name = (string)obj;

                obj = regkey.GetValue("Code");
                if (obj != null)
                    agent.Code = (string)obj;

                obj = regkey.GetValue("Password");
                if (obj != null)
                    agent.Password = (string)obj;

                obj = regkey.GetValue("RecordCall");
                if (obj != null)
                    if ((int)obj == 1)
                        agent.RecordCall = true;
                    else
                        agent.RecordCall = false;

                obj = regkey.GetValue("AtExten");
                if (obj != null)
                {
                    string extn_username = (string)obj;
                    if (extn_username != "")
                    {
                        SIPPBXExten extn = pbx.getExtensionByName(extn_username);
                        if (extn != null)
                        {
                            agent.AtExten = extn;
                            extn.Agent = agent;
                        }
                    }
                }

                obj = regkey.GetValue("LogInTime");
                if (obj != null)
                    agent.LogInTime = Convert.ToDateTime(obj);

                obj = regkey.GetValue("LogOutTime");
                if (obj != null)
                    agent.LogOutTime = Convert.ToDateTime(obj);

                pbx.sip_agents.Add(agent);
            }

        }

        public void SaveEmailNetConfigToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "SMTPServer");

            if (regkey == null)
                return;

            regkey.SetValue("Server", pbx.email_set.emailServer);
            regkey.SetValue("Port", pbx.email_set.emailPort.ToString());
            regkey.SetValue("EmailAddr", pbx.email_set.emailAddr);
            regkey.SetValue("Password", pbx.email_set.emailPassword);
            regkey.SetValue("SSL", pbx.email_set.emailSSL ? 1 : 0);

            regkey.Close();
        }

        public void LoadEmailNetConfigFromRegistry()
        {
            RegistryKey regkey;
            //string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "SMTPServer");

            if (regkey == null)
                return;

            Object obj;
            obj = regkey.GetValue("Server");
            if (obj != null)
                pbx.email_set.emailServer = (string)obj;

            obj = regkey.GetValue("Port");
            if (obj != null)
                pbx.email_set.emailPort = Convert.ToUInt16((string)obj);

            obj = regkey.GetValue("EmailAddr");
            if (obj != null)
                pbx.email_set.emailAddr = (string)obj;

            obj = regkey.GetValue("Password");
            if (obj != null)
                pbx.email_set.emailPassword = (string)obj;

            obj = regkey.GetValue("SSL");
            if (obj != null)
            {
                if ((int)obj == 1)
                    pbx.email_set.emailSSL = true;
                else
                    pbx.email_set.emailSSL = false;
            }

            regkey.Close();

        }

        public void LoadSIPNetConfigFromRegistry()
        {
            RegistryKey regkey;
            //string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "SIPNetwork");

            if (regkey == null)
                return;

            Object obj;

            obj = regkey.GetValue("SIPAddr");
            if (obj != null)
                pbx.sip_set.sipAddr = (string)obj;

            obj = regkey.GetValue("SIPPort");
            if (obj != null)
                pbx.sip_set.sipPort = Convert.ToUInt16((string)obj);

            obj = regkey.GetValue("RTPPort");
            if (obj != null)
                pbx.sip_set.rtpPort = Convert.ToUInt16((string)obj);

            obj = regkey.GetValue("AudioCodecs");
            if (obj != null)
                pbx.sip_set.auCodecs = (string)obj;

            obj = regkey.GetValue("StunServer");
            if (obj != null)
            {
                pbx.sip_set.sStunServer = (string)obj;
            }

            obj = regkey.GetValue("DTMFMethod");
            if (obj != null)
            {
                pbx.sip_set.dtmfMethod = (int)obj;
                if (pbx.sip_set.dtmfMethod < 0 || pbx.sip_set.dtmfMethod > 3)
                    pbx.sip_set.dtmfMethod = 3;
            }

            regkey.Close();

        }

        public void SaveSIPNetConfigToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "SIPNetwork");

            if (regkey == null)
                return;

            regkey.SetValue("SIPAddr", pbx.sip_set.sipAddr);
            regkey.SetValue("SIPPort", pbx.sip_set.sipPort.ToString());
            regkey.SetValue("RTPPort", pbx.sip_set.rtpPort.ToString());
            regkey.SetValue("AudioCodecs", pbx.sip_set.auCodecs);
            regkey.SetValue("StunServer", pbx.sip_set.sStunServer);
            regkey.SetValue("DTMFMethod", pbx.sip_set.dtmfMethod);

            regkey.Close();
        }

        public void LoadSIPProxySitesConfigFromRegistry()
        {
            RegistryKey regkey;
            //string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "SIPProxySite");

            if (regkey == null)
                return;

            Object obj;
            obj = regkey.GetValue("DomainList");
            if (obj != null)
                pbx.sip_proxy_sites[0].domainList = (string)obj;

            obj = regkey.GetValue("MapSIPAddr");
            if (obj != null)
            {
                if ((int)obj == 1)
                    pbx.sip_proxy_sites[0].mapSIPAddr = true;
                else
                    pbx.sip_proxy_sites[0].mapSIPAddr = false;
            }

            regkey.Close();
        }


        public void SaveSIPProxySitesConfigToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "SIPProxySite");

            if (regkey == null)
                return;

            regkey.SetValue("DomainList", pbx.sip_proxy_sites[0].domainList);
            regkey.SetValue("MapSIPAddr", pbx.sip_proxy_sites[0].mapSIPAddr ? 1 : 0);

            regkey.Close();
        }

        public void LoadIVRsFromRegsitry()
        {
            RegistryKey regkey, regkey1;
            //string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "IVRs");

            if (regkey == null)
                return;

            Object obj = regkey.GetValue("Count");
            int count = 0;

            if (obj != null)
                count = (int)obj;

            pbx.sip_ivrs.Clear();

            SIPPBXIVR ivr = null;

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    ivr = new SIPPBXIVR();
                    int idx = i + 1;

                    regkey1 = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "IVRs\\IVR" + idx.ToString());

                    if (regkey1 == null)
                        return;

                    obj = regkey1.GetValue("MenuName");
                    if (obj != null)
                        ivr.name = (string)obj;

                    obj = regkey1.GetValue("Action");
                    if (obj != null)
                        ivr.action = (int)obj;

                    obj = regkey1.GetValue("MenuSound");
                    if (obj != null)
                        ivr.sound_file = (string)obj;

                    obj = regkey1.GetValue("TransferTo");
                    if (obj != null)
                        ivr.transfer_to = (string)obj;

                    obj = regkey1.GetValue("MenuDTMFWaitMS");
                    if (obj != null)
                        ivr.menu_dtmf_wait_ms = (int)obj;

                    obj = regkey1.GetValue("DTMFAcceptExtenWaitMS");
                    if (obj != null)
                        ivr.dtmf_accept_exten_wait_ms = (int)obj;

                    obj = regkey1.GetValue("DTMFAcceptExten");
                    if (obj != null)
                        if ((int)obj == 1)
                            ivr.dtmf_accept_exten = true;

                    /*
                     * //root menu, parent menu should always be null
                    if (dp.ivr.ParentIVRMenu != null)
                        regkey.SetValue("ParentMenu", 1);
                    else
                        regkey.SetValue("ParentMenu", 0);
                    */

                    int dtmf_count = 0;

                    obj = regkey1.GetValue("DTMFCount");
                    if (obj != null)
                        dtmf_count = (int)obj;

                    if (dtmf_count > 0)
                    {
                        for (int j = 0; j < dtmf_count; j++)
                        {
                            int idx1 = j + 1;
                            regkey1 = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "IVRs\\IVR" + idx.ToString() + "\\DTMF" + idx1.ToString());
                            if (regkey1 == null)
                                return;

                            SIPPBXDTMF dtmf = new SIPPBXDTMF();
                            dtmf.IVRMenu = new SIPPBXIVR();

                            obj = regkey1.GetValue("DTMFStr");
                            if (obj != null)
                                dtmf.DTMFStr = (string)obj;

                            obj = regkey1.GetValue("IVRMenuAction");
                            if (obj != null)
                                dtmf.IVRMenu.action = (int)obj;

                            obj = regkey1.GetValue("IVRMenuSoundFile");
                            if (obj != null)
                                dtmf.IVRMenu.sound_file = (string)obj;

                            obj = regkey1.GetValue("IVRMenuTransferTo");
                            if (obj != null)
                                dtmf.IVRMenu.transfer_to = (string)obj;

                            /*
                                                        obj = regkey1.GetValue("IVRMenuParent");
                                                        if (obj != null)
                                                        {
                                                            if ((int)obj == 1)
                                                            {
                                                                dtmf.IVRMenu.ParentIVRMenu = ivr;
                                                            }
                                                        }
                             */

                            ivr.dtmfs.Add(dtmf);
                        }
                    }

                    pbx.sip_ivrs.Add(ivr);

                    regkey1.Close();
                }
            }

            regkey.Close();
        }

        public void SaveIVRsToRegistry()
        {
            RegistryKey regkey, regkey1;
            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "IVRs");
            if (regkey == null)
                return;

            int count = pbx.sip_ivrs.Count;
            regkey.SetValue("Count", count);

            SIPPBXIVR ivr = null;
            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    ivr = pbx.sip_ivrs[i];
                    int idx = i + 1;
                    regkey1 = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "IVRs\\IVR" + idx.ToString());

                    if (regkey1 == null)
                        return;

                    regkey1.SetValue("MenuName", ivr.name);
                    regkey1.SetValue("Action", ivr.action);
                    /*
                                        if (ivr.ParentIVRMenu != null)
                                            regkey1.SetValue("ParentMenu", 1);
                                        else
                                            regkey1.SetValue("ParentMenu", 0);
                    */
                    regkey1.SetValue("MenuSound", ivr.sound_file);
                    regkey1.SetValue("TransferTo", ivr.transfer_to);
                    regkey1.SetValue("MenuDTMFWaitMS", ivr.menu_dtmf_wait_ms);
                    regkey1.SetValue("DTMFAcceptExten", ivr.dtmf_accept_exten ? 1 : 0);
                    regkey1.SetValue("DTMFAcceptExtenWaitMS", ivr.dtmf_accept_exten_wait_ms);

                    if (ivr.dtmfs.Count > 0)
                    {
                        regkey1.SetValue("DTMFCount", ivr.dtmfs.Count);

                        for (int j = 0; j < ivr.dtmfs.Count; j++)
                        {
                            int idx1 = j + 1;
                            regkey1 = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "IVRs\\IVR" + idx.ToString() + "\\DTMF" + idx1.ToString());
                            if (regkey1 == null) continue;

                            regkey1.SetValue("DTMFStr", ivr.dtmfs[j].DTMFStr);
                            regkey1.SetValue("IVRMenuAction", ivr.dtmfs[j].IVRMenu.action);
                            regkey1.SetValue("IVRMenuSoundFile", ivr.dtmfs[j].IVRMenu.sound_file);
                            regkey1.SetValue("IVRMenuTransferTo", ivr.dtmfs[j].IVRMenu.transfer_to);

                            /*
                                                        if (ivr.dtmfs[j].IVRMenu.ParentIVRMenu != null)
                                                            regkey1.SetValue("IVRMenuParent", 1);
                                                        else
                                                            regkey1.SetValue("IVRMenuParent", 0);
                             */
                        }
                    }

                    regkey1.Close();
                }
            }
        }

        public void SaveDialplansConfigToRegistry()
        {
            RegistryKey regkey;
            RegistryKey regkey1;

            regkey = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "Dialplans");

            if (regkey == null)
                return;

            int count = pbx.sip_dialplan.Count;
            regkey.SetValue("Count", count);

            SIPPBXDialPlan dp;

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    dp = pbx.sip_dialplan[i];
                    int idx = i + 1;
                    regkey.SetValue("DiaPlanName" + idx.ToString(), dp.planName);
                    regkey.SetValue("CallDirection" + idx.ToString(), dp.CallDirection);
                    regkey.SetValue("Caller" + idx.ToString(), dp.CallerID);
                    regkey.SetValue("Called" + idx.ToString(), dp.CalledID);
                    regkey.SetValue("CallPlan" + idx.ToString(), dp.CallPlan);
                    regkey.SetValue("OutboundPreStrip" + idx.ToString(), dp.OutboundPreStrip);
                    regkey.SetValue("OutboundPrepend" + idx.ToString(), dp.OutboundPrepend);
                    regkey.SetValue("OutboundSIPAcct" + idx.ToString(), dp.OutboundSIPAcct);
                    regkey.SetValue("ExtenPriorityLevel" + idx.ToString(), dp.ExtenPriorityLevel);
                    regkey.SetValue("DestAddress" + idx.ToString(), dp.DestAddress);

                    regkey.SetValue("TimeLimited" + idx.ToString(), dp.TimeLimited ? 1 : 0);
                    regkey.SetValue("TimeStartHour" + idx.ToString(), dp.TimeStartHour);
                    regkey.SetValue("TimeStartMinute" + idx.ToString(), dp.TimeStartMinute);
                    regkey.SetValue("TimeEndHour" + idx.ToString(), dp.TimeEndHour);
                    regkey.SetValue("TimeEndMinute" + idx.ToString(), dp.TimeEndMinute);
                    for (int j = 0; j < 7; j++)
                        regkey.SetValue("TimeDay" + idx.ToString() + "-" + j.ToString(), dp.TimeDays[j]);

                    int nMemCnt = -1;
                    if (dp.MemberList != null)
                        nMemCnt = dp.MemberList.members.Count;

                    regkey.SetValue("MemberCount" + idx.ToString(), nMemCnt);

                    if (nMemCnt < 0)
                        continue;

                    regkey1 = Registry.CurrentUser.CreateSubKey(PBX_REG_KEY_ROOT + "Dialplans\\Members" + idx.ToString());

                    if (regkey1 == null)
                        return;

                    for (int j = 0; j < dp.MemberList.members.Count; j++)
                    {
                        regkey1.SetValue("Name" + j.ToString(), dp.MemberList.members[j]);
                    }

                    regkey1.Close();
                }
            }

            regkey.Close();

        }

        public void LoadDialplansConfigFromRegistry()
        {
            RegistryKey regkey;
            RegistryKey regkey1;

            //string tmp;
            regkey = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "Dialplans");

            if (regkey == null)
                return;

            Object obj = regkey.GetValue("Count");
            int count = 0;

            if (obj != null)
                count = (int)obj;

            pbx.sip_dialplan.Clear();

            if (count > 0)
            {
                for (int i = 0; i < count; i++)
                {
                    SIPPBXDialPlan dp = new SIPPBXDialPlan();

                    int idx = i + 1;
                    obj = regkey.GetValue("DiaPlanName" + idx.ToString());
                    if (obj != null)
                        dp.planName = (string)obj;
                    else
                        continue;
                    obj = regkey.GetValue("CallDirection" + idx.ToString());
                    if (obj != null)
                    {
                        if ((string)obj == "CALL_DIR_INBOUND")
                            dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND;
                        else
                            dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND;
                    }

                    obj = regkey.GetValue("Caller" + idx.ToString());
                    if (obj != null)
                        dp.CallerID = (string)obj;

                    obj = regkey.GetValue("Called" + idx.ToString());
                    if (obj != null)
                        dp.CalledID = (string)obj;

                    obj = regkey.GetValue("CallPlan" + idx.ToString());
                    if (obj != null)
                    {
                        if ((string)obj == "AUTO_ATTENDANT")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT;
                        }
                        else if ((string)obj == "VOICE_MAIL_BOX")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.VOICE_MAIL_BOX;
                        }
                        else if ((string)obj == "ACD_QUEUE")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ACD_QUEUE;
                        }
                        /*
                                                else if ((string)obj == "CALL_FORWARDING")
                                                {
                                                    dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CALL_FORWARDING;
                                                }
                         */
                        else if ((string)obj == "DIAL_EXTENSION")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION;
                        }
                        else if ((string)obj == "DO_NOT_DISTURB")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DO_NOT_DISTURB;
                        }
                        else if ((string)obj == "RING_GROUP")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.RING_GROUP;
                        }
                        else if ((string)obj == "CONFERENCE_ROOM")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CONFERENCE_ROOM;
                        }
                        else if ((string)obj == "PLUGIN_ROUTINE")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.PLUGIN_ROUTINE;
                        }
                    }

                    obj = regkey.GetValue("DestAddress" + idx.ToString());
                    if (obj != null)
                        dp.DestAddress = (string)obj;

                    obj = regkey.GetValue("OutboundPreStrip" + idx.ToString());
                    if (obj != null)
                        dp.OutboundPreStrip = (string)obj;

                    obj = regkey.GetValue("OutboundPrepend" + idx.ToString());
                    if (obj != null)
                        dp.OutboundPrepend = (string)obj;

                    obj = regkey.GetValue("OutboundSIPAcct" + idx.ToString());
                    if (obj != null)
                        dp.OutboundSIPAcct = (int)obj;

                    obj = regkey.GetValue("ExtenPriorityLevel" + idx.ToString());
                    if (obj != null)
                        dp.ExtenPriorityLevel = Convert.ToUInt32(obj);

                    obj = regkey.GetValue("TimeLimited" + idx.ToString());
                    if (obj != null)
                        dp.TimeLimited = Convert.ToInt32(obj) == 1 ? true : false;

                    obj = regkey.GetValue("TimeStartHour" + idx.ToString());
                    if (obj != null)
                        dp.TimeStartHour = Convert.ToInt32(obj);

                    obj = regkey.GetValue("TimeStartMinute" + idx.ToString());
                    if (obj != null)
                        dp.TimeStartMinute = Convert.ToInt32(obj);

                    obj = regkey.GetValue("TimeEndHour" + idx.ToString());
                    if (obj != null)
                        dp.TimeEndHour = Convert.ToInt32(obj);

                    obj = regkey.GetValue("TimeEndMinute" + idx.ToString());
                    if (obj != null)
                        dp.TimeEndMinute = Convert.ToInt32(obj);

                    for (int j = 0; j < 7; j++)
                    {
                        obj = regkey.GetValue("TimeDay" + idx.ToString() + "-" + j.ToString());
                        if (obj != null)
                            dp.TimeDays[j] = Convert.ToInt32(obj);
                    }

                    int nMemCnt = -1;

                    obj = regkey.GetValue("MemberCount" + idx.ToString());
                    if (obj != null)
                        nMemCnt = Convert.ToInt32(obj);

                    if (nMemCnt >= 0)
                    {
                        dp.MemberList = new PBXMemberList();

                        regkey1 = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "Dialplans\\Members" + idx.ToString());

                        if (regkey1 == null)
                            return;

                        for (int j = 0; j < nMemCnt; j++)
                        {
                            obj = regkey1.GetValue("Name" + j.ToString());
                            if (obj != null)
                                dp.MemberList.members.Add((string)obj);
                        }

                        regkey1.Close();
                    }
                    /*

                                        if (regkey1 == null)
                                            return;

                                        obj = regkey1.GetValue("MenuName");
                                        if (obj != null)
                                            dp.ivr.name = (string)obj;

                                        obj = regkey1.GetValue("Action");
                                        if (obj != null)
                                            dp.ivr.action =  (int)obj;

                                        obj = regkey1.GetValue("MenuSound");
                                        if (obj != null)
                                            dp.ivr.sound_file = (string)obj;

                                        obj = regkey1.GetValue("TransferTo");
                                        if (obj != null)
                                            dp.ivr.transfer_to = (string)obj;

                                        obj = regkey1.GetValue("DTMFWaitMS");
                                        if (obj != null)
                                            dp.ivr.dtmf_wait_ms = (int)obj;

                                        obj = regkey1.GetValue("DTMFAcceptExten");
                                        if (obj != null)
                                            if ((int)obj == 1)
                                                dp.ivr.dtmf_accept_exten = true;
                    
                                        int dtmf_count = 0;

                                        obj = regkey1.GetValue("DTMFCount");
                                        if (obj != null)
                                            dtmf_count = (int)obj;

                                        if (dtmf_count > 0)
                                        {

                                            for (int j = 0; j < dtmf_count; j++)
                                            {
                                                int idx1 = j + 1;
                                                regkey1 = Registry.CurrentUser.OpenSubKey(PBX_REG_KEY_ROOT + "Dialplans\\IVR" + idx.ToString() + "\\DTMF" + idx1.ToString());
                                                if (regkey1 == null)
                                                    return;

                                                SIPPBXDTMF dtmf = new SIPPBXDTMF();
                                                dtmf.IVRMenu = new SIPPBXIVR();

                                                obj = regkey1.GetValue("DTMFStr");
                                                if (obj != null)
                                                    dtmf.DTMFStr = (string)obj;

                                                obj = regkey1.GetValue("IVRMenuAction");
                                                if (obj != null)
                                                    dtmf.IVRMenu.action  = (int)obj;

                                                obj = regkey1.GetValue("IVRMenuSoundFile");
                                                if (obj != null)
                                                    dtmf.IVRMenu.sound_file = (string)obj;

                                                obj = regkey1.GetValue("IVRMenuTransferTo");
                                                if (obj != null)
                                                    dtmf.IVRMenu.transfer_to = (string)obj;

                                                obj = regkey1.GetValue("IVRMenuParent");
                                                if (obj != null)
                                                {
                                                    if ((int)obj == 1)
                                                    {
                                                        dtmf.IVRMenu.ParentIVRMenu = dp.ivr;
                                                    }
                                                }

                                                dp.ivr.dtmfs.Add(dtmf);
                                            }
                                        }
                     */

                    pbx.sip_dialplan.Add(dp);
                }
            }

            regkey.Close();

        }

        public void SaveConfigToRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.CreateSubKey("SOFTWARE\\PCBest.net\\SIPPBXV2");

            if (regkey == null)
                return;

            //regkey.SetValue("ChansPerSpan", pbx.ChansPerSpan);
            //regkey.SetValue("SpansPerBoard", pbx.SpansPerBoard);
            //regkey.SetValue("BoardsPerServer", pbx.BoardsPerServer);
            regkey.SetValue("ChanNum", pbx.ChanNum);
            //regkey.SetValue("OutboundIndexStart", pbx.OutboundIndexStart);
            regkey.SetValue("PBXLicKey", pbx.PBXLicKey);
            regkey.SetValue("MohDir", pbx.moh_dir);
            regkey.SetValue("LogDir", pbx.log_dir);
            regkey.SetValue("LogLevel", pbx.log_level);
            regkey.SetValue("ReportDir", pbx.report_dir);
            regkey.SetValue("RecordDir", pbx.record_dir);
            regkey.SetValue("VMBDir", pbx.vmb_dir);

            regkey.SetValue("OutboundPercent", pbx.pbx_sys_set.OutPercent);
            regkey.SetValue("ExtenCanInbound", pbx.pbx_sys_set.bExtenCanInbound ? 1 : 0);
            regkey.SetValue("MaxProxyUserRegSec", pbx.pbx_sys_set.MaxProxyUserRegSec);

            regkey.SetValue("PreferOutlineCodec", pbx.pbx_sys_set.PreferOutlineCodec);
            regkey.SetValue("PreferExtensionCodec", pbx.pbx_sys_set.PreferExtensionCodec);

            regkey.SetValue("RestartTime", pbx.pbx_sys_set.sRestartTime);

            //special numbers
            regkey.SetValue("PickupShortCode", pbx.pickup_shortcode);
            regkey.SetValue("ACDNumber", pbx.acd_number);
            regkey.SetValue("AgentLoginNumber", pbx.agent_login_number);
            regkey.SetValue("AgentLogoutNumber", pbx.agent_logout_number);

            //cdr_option
            regkey.SetValue("PBXCDR", pbx.cdr_option.pbx_cdr);
            regkey.SetValue("ACDCDR", pbx.cdr_option.acd_cdr);
            regkey.SetValue("ExtenCDR", pbx.cdr_option.exten_cdr);
            regkey.SetValue("AgentCDR", pbx.cdr_option.agent_cdr);

            regkey.SetValue("NoAudioDuration", pbx.no_audio_dur);

            SaveSIPAccountConfigToRegistry();
            SaveExtensionsConfigToRegistry();
            SaveEmailNetConfigToRegistry();
            SaveSIPNetConfigToRegistry();
            SaveSIPProxySitesConfigToRegistry();
            SaveDialplansConfigToRegistry();
            SaveACDConfigToRegistry();
            SaveParkingSlotConfigToRegistry();
            SaveRingGroupConfigToRegistry();
            SaveLoadBalanceConfigToRegistry();
            SaveMonitorGroupConfigToRegistry();
            SaveAgentsToRegistry();
            SaveIVRsToRegistry();
            SaveAutoDialerTasksToRegistry();
            SaveDBSettingsToRegistry();
            SavePickupGroupConfigToRegistry();
            SaveConferRoomsConfigToRegistry();
        }

        public void LoadConfigFromRegistry()
        {
            RegistryKey regkey;
            regkey = Registry.CurrentUser.OpenSubKey("SOFTWARE\\PCBest.net\\SIPPBXV2");

            if (regkey == null)
                return;
            /*
                        Object obj = regkey.GetValue("ChansPerSpan");
                        if (obj != null)
                            pbx.ChansPerSpan = (int)obj;

                        obj = regkey.GetValue("SpansPerBoard");
                        if (obj != null)
                            pbx.SpansPerBoard = (int)obj;

                        obj = regkey.GetValue("BoardsPerServer");
                        if (obj != null)
                            pbx.BoardsPerServer = (int)obj;
             */

            Object obj = regkey.GetValue("ChanNum");
            if (obj != null)
                pbx.ChanNum = (int)obj;

            obj = regkey.GetValue("OutboundPercent");
            if (obj != null)
            {
                pbx.pbx_sys_set.OutPercent = (int)obj;
                if (pbx.pbx_sys_set.OutPercent > 100)
                    pbx.pbx_sys_set.OutPercent = 100;
                else if (pbx.pbx_sys_set.OutPercent < 0)
                    pbx.pbx_sys_set.OutPercent = 0;
            }

            obj = regkey.GetValue("ExtenCanInbound");
            if (obj != null)
            {
                if ((int)obj == 1)
                    pbx.pbx_sys_set.bExtenCanInbound = true;
                else
                    pbx.pbx_sys_set.bExtenCanInbound = false;
            }

            obj = regkey.GetValue("MaxProxyUserRegSec");
            if (obj != null)
            {
                pbx.pbx_sys_set.MaxProxyUserRegSec = (int)obj;
                if (pbx.pbx_sys_set.MaxProxyUserRegSec < 60)
                    pbx.pbx_sys_set.MaxProxyUserRegSec = 60;
                else if (pbx.pbx_sys_set.MaxProxyUserRegSec > 3600)
                    pbx.pbx_sys_set.MaxProxyUserRegSec = 3600;
            }

            obj = regkey.GetValue("PreferOutlineCodec");
            if (obj != null)
            {
                pbx.pbx_sys_set.PreferOutlineCodec = (string)obj;
            }

            obj = regkey.GetValue("PreferExtensionCodec");
            if (obj != null)
            {
                pbx.pbx_sys_set.PreferExtensionCodec = (string)obj;
            }

            obj = regkey.GetValue("RestartTime");
            if (obj != null)
            {
                pbx.pbx_sys_set.sRestartTime = (string)obj;
            }

            /*
                        obj = regkey.GetValue("OutboundIndexStart");
                        if (obj != null)
                            pbx.OutboundIndexStart = (int)obj;
            */

            obj = regkey.GetValue("PBXLicKey");
            if (obj != null)
                pbx.PBXLicKey = (string)obj;

            if (pbx.PBXLicKey.Length > 0)
            {
                pbx.bFreeVersion = false;
            }
            else
            {
                pbx.bFreeVersion = true;
            }

            obj = regkey.GetValue("MohDir");
            if (obj != null)
                pbx.moh_dir = (string)obj;

            obj = regkey.GetValue("LogDir");
            if (obj != null)
                pbx.log_dir = (string)obj;

            obj = regkey.GetValue("LogLevel");
            if (obj != null)
                pbx.log_level = (int)obj;

            obj = regkey.GetValue("ReportDir");
            if (obj != null)
                pbx.report_dir = (string)obj;

            obj = regkey.GetValue("RecordDir");
            if (obj != null)
                pbx.record_dir = (string)obj;

            obj = regkey.GetValue("VMBDir");
            if (obj != null)
                pbx.vmb_dir = (string)obj;


            //special numbers
            obj = regkey.GetValue("PickupShortCode");
            if (obj != null)
                pbx.pickup_shortcode = (string)obj;

            obj = regkey.GetValue("ACDNumber");
            if (obj != null)
                pbx.acd_number = (string)obj;

            obj = regkey.GetValue("AgentLoginNumber");
            if (obj != null)
                pbx.agent_login_number = (string)obj;

            obj = regkey.GetValue("AgentLogoutNumber");
            if (obj != null)
                pbx.agent_logout_number = (string)obj;

            //CDR option
            obj = regkey.GetValue("PBXCDR");
            if (obj != null)
                pbx.cdr_option.pbx_cdr = (int)obj;

            obj = regkey.GetValue("ACDCDR");
            if (obj != null)
                pbx.cdr_option.acd_cdr = (int)obj;

            obj = regkey.GetValue("ExtenCDR");
            if (obj != null)
                pbx.cdr_option.exten_cdr = (int)obj;

            obj = regkey.GetValue("AgentCDR");
            if (obj != null)
                pbx.cdr_option.agent_cdr = (int)obj;

            obj = regkey.GetValue("NoAudioDuration");
            if (obj != null)
                pbx.no_audio_dur = (int)obj;

            LoadDBSettingsFromRegistry();
            LoadSIPAccountConfigFromRegistry();
            LoadExtensionsConfigFromRegistry();

            LoadEmailNetConfigFromRegistry();
            LoadSIPNetConfigFromRegistry();
            LoadSIPProxySitesConfigFromRegistry();

            LoadDialplansConfigFromRegistry();
            LoadACDConfigFromRegistry();
            LoadParkingSlotConfigFromRegistry();
            LoadRingGroupConfigFromRegistry();
            LoadLoadBalanceConfigFromRegistry();
            LoadMonitorGroupConfigFromRegistry();
            LoadAgentsFromRegistry();
            LoadIVRsFromRegsitry();
            LoadAutoDialerTasksFromRegistry();
            LoadPickupGroupConfigFromRegistry();
            LoadConferRoomsConfigFromRegistry();
        }


    }
}
