/*////////////////////////////////////////////////////////////////////////////////////
//
//Copyright (c) 2007-2020 by PC Best Networks, Inc.   All rights reserved
//
*/////////////////////////////////////////////////////////////////////////////////////

//#define PBXV3_DEBUG

using System;
using System.Collections.Generic;
using System.Text;
using System.Data.SqlClient;
using System.Threading;
using System.IO;
using System.Windows.Forms;
using Microsoft.Win32;

namespace SIPPBXv3
{
    public class SIPPBXCFGDB
    {
        public const string EXTN_BLOCK_INCOMING_CALLERID_ATTR = "1001";
        public const string EXTN_PING_CODE_ATTR = "1002";

        public static bool RefreshAllCfgFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SIPPBXLog log)
        {
            //DBServerSetting db_set = pbx.GetDBServerSet();

            try
            {
                //if (db_set != null)
                {
                    //if (db_set.ConnectDB())
                    if(pbxMain.dbPBXSet.IsDBConnected())
                    {
                        RefreshSysCfgFromDB(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);

                        //RefreshSysCfg(pbxMain, pbx, env, db_set.myConn);
                        RefreshSIPAccountConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);
                        RefreshSecurityConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);

                        RefreshExtensionsConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);

                        RefreshDialplansConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);
                        RefreshACDConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);
                        RefreshParkingSlotConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);
                        RefreshRingGroupConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);
                        RefreshPagingGroupConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);

                        //RefreshLoadBalanceConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);

                        RefreshMonitorGroupConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);
                        RefreshAgentsConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);
                        RefreshIVRsConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);
                        RefreshAutoDialerTasks(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);
                        RefreshPickupGroupConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);
                        RefreshConferRoomsConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);

                        RefreshCallLimitConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);
                        RefreshBlackListConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);
                        RefreshCallBackConfig(pbxMain, pbx, env, pbxMain.dbPBXSet.myConn, log);

                        //db_set.DisconnectDB();
                        return true;
                    }
                }
            }
            catch (Exception e)
            {
                if(log != null)
                    log.LogoutText(e.ToString());

                //reset DB connection
                if (pbxMain.dbPBXSet != null)
                {
                    try
                    {
                        pbxMain.dbPBXSet.DisconnectDB();
                    }
                    catch (Exception)
                    {
                    }

                    pbxMain.dbPBXSet.ConnectDB();
                }
            }

            return false;
        }

        //pbxMain and env are null for GUI app
        public static bool LoadAllCfgFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SIPPBXLog log)
        {
            DBServerSetting db_set = pbx.GetDBServerSet();

#if PBXV3_DEBUG   
            SIPPBXMain.LogMessageToFile("LoadAllCfgFromDB 1");
#endif

            try
            {
#if PBXV3_DEBUG
                SIPPBXMain.LogMessageToFile("LoadAllCfgFromDB 2");
#endif

                if (db_set != null)
                {
#if PBXV3_DEBUG
                    SIPPBXMain.LogMessageToFile("LoadAllCfgFromDB 3");
#endif

                    if (db_set.ConnectDB())
                    {
#if PBXV3_DEBUG
                        SIPPBXMain.LogMessageToFile("LoadAllCfgFromDB 4");
#endif
                        //CheckAttrDef(pbxMain, pbx, env, db_set.myConn, log);

                        LoadSysCfgFromDB(pbxMain, pbx, env, db_set.myConn, log);

                        //if (pbxMain != null && env != null)
                        {
                            //server application. 
                            //need to check the DB.
                            double curVersion = 3.68;
                            double dbVersion = 3.68;
                            try
                            {
                                if (pbx.PBXVersion.Length > 0)
                                    curVersion = Convert.ToDouble(pbx.PBXVersion);

                                dbVersion = Convert.ToDouble(GetSysPBXVersionSettingsFromDB(pbxMain, pbx, env, db_set.myConn, log));
                            }
                            catch (Exception ex)
                            {
                                SIPPBXMain.LogMessageToFile("GetSysPBXVersionSettingsFromDB returns " + GetSysPBXVersionSettingsFromDB(pbxMain, pbx, env, db_set.myConn, log));
                                SIPPBXMain.LogMessageToFile(ex.ToString());
                            }

                            //I don't know why, in some system it is 329 like
                            //if (curVersion > 100) curVersion /= 100.00;
                            //if (dbVersion > 100) dbVersion /= 100.00;

                            if (curVersion < dbVersion)
                            {
                                log.LogoutText("PBX version is older than DB version! You must used a newer PBX before! Please remove the DB, or create a new DB for this PBX application.");
                                return false;
                            }

                            log.LogoutText("DBVersion:" + dbVersion.ToString() + " AppVersion:" + curVersion.ToString());
                            if (curVersion > dbVersion)
                            {
                                log.LogoutText("AppVersion is greater than DBVersio!");
                                if (dbVersion < 3.08)
                                {
                                    if (curVersion > 3.07)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo308, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo308(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.09)
                                {
                                    if (curVersion > 3.08)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo309, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo309(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.11)
                                {
                                    if (curVersion > 3.10)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo311, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo311(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.20)
                                {
                                    if (curVersion > 3.19)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo320, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo320(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.22)
                                {
                                    if (curVersion > 3.21)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo322, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo322(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.29)
                                {
                                    if (curVersion > 3.28)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo329, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo329(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.31)
                                {
                                    if (curVersion > 3.30)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo331, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo331(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.44)
                                {
                                    if (curVersion > 3.45)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo346, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo346(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.48)
                                {
                                    if (curVersion > 3.47)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo348, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo348(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.50)
                                {
                                    if (curVersion > 3.49)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo350, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo350(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.51)
                                {
                                    if (curVersion > 3.50)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo351, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo351(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.52)
                                {
                                    if (curVersion > 3.51)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo352, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo352(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.53)
                                {
                                    if (curVersion > 3.52)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo353, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo353(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.54)
                                {
                                    if (curVersion > 3.53)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo354, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo354(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.57)
                                {
                                    if (curVersion > 3.56)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo357, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo357(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.58)
                                {
                                    if (curVersion > 3.57)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo358, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo358(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.59)
                                {
                                    if (curVersion > 3.58)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo359, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo359(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.60)
                                {
                                    if (curVersion > 3.59)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo360, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo360(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.61)
                                {
                                    if (curVersion > 3.60)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo361, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo361(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.62)
                                {
                                    if (curVersion > 3.61)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo362, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo362(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.63)
                                {
                                    if (curVersion > 3.62)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo363, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo363(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.64)
                                {
                                    if (curVersion > 3.63)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo364, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo364(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.65)
                                {
                                    if (curVersion > 3.64)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo365, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo365(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.66)
                                {
                                    if (curVersion > 3.65)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo366, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo366(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.67)
                                {
                                    if (curVersion > 3.66)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo367, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo367(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }

                                if (dbVersion < 3.68)
                                {
                                    if (curVersion > 3.67)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo368, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo368(pbxMain, pbx, env, db_set.myConn, log);
                                    }
                                }
                                
                                UpgradeDBTo368_1(pbxMain, pbx, env, db_set.myConn, log);

                                SavePBXVersionToDB(curVersion.ToString(), env, db_set.myConn, log);
                            }
                            else if (curVersion == dbVersion)
                            {
                                if (curVersion >= 3.68)
                                {
                                    UpgradeDBTo368_1(pbxMain, pbx, env, db_set.myConn, log);
                                }
                            }
                        }

                        LoadSIPAccountConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);
                        LoadSecurityFromDB(pbxMain, pbx, env, db_set.myConn, log);
                        LoadExtensionsConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);

                        LoadDialplansConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);
                        LoadACDConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);
                        LoadParkingSlotConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);
                        LoadRingGroupConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);
                        LoadPagingGroupConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);

                        LoadLoadBalanceConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);

                        LoadMonitorGroupConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);
                        LoadAgentsConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);
                        LoadIVRsConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);
                        LoadAutoDialerTasksFromDB(pbxMain, pbx, env, db_set.myConn, log);
                        LoadPickupGroupConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);
                        LoadConferRoomsConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);

                        LoadAutoDialerTasksFromDB(pbxMain, pbx, env, db_set.myConn, log);

                        LoadCallLimitConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);
                        LoadBlackListConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);
                        LoadCallBackConfigFromDB(pbxMain, pbx, env, db_set.myConn, log);

                        db_set.DisconnectDB();
                        return true;
                    }
                    else
                    {
                        SIPPBXMain.LogMessageToFile("cannot connect to DB!");
                    }
                }
            }
            catch (Exception ex)
            {
                if (log != null)
                    log.LogoutText(ex.ToString());
                SIPPBXMain.LogMessageToFile(ex.ToString());
            }

            return false;
        }

        public static string SysCFGGetValue(string cfgName, SqlConnection myConn, SIPPBXLog log)
        {
            string cfgValue = "";

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT * FROM cfg_sys WHERE CfgName = '" + cfgName + "'";
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        cfgValue = myReader.GetString(1);
                        break;
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return cfgValue;
        }

        public static void SysCFGSetValue(string cfgName, string cfgValue, SqlConnection myConn, SIPPBXLog log, bool bMod)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT * FROM cfg_sys WHERE CfgName = '" + cfgName + "'";
                SqlDataReader myReader = catCMD.ExecuteReader();

                if (myReader.HasRows)
                {
                    myReader.Close();
                    catCMD.CommandText = "UPDATE cfg_sys SET CfgValue = '" + cfgValue + "', ModTag = " + (bMod ? "1" : "0") + " WHERE CfgName = '" + cfgName + "'";
                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }
                else
                {
                    myReader.Close();
                    catCMD.CommandText = "INSERT INTO cfg_sys VALUES('" + cfgName + "','" + cfgValue + "', 1)";
                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void SavePBXVersionToDB(string ver, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            //PBXVersion
            SysCFGSetValue("PBXVersion", ver, myConn, log, false);
        }

        public static void SaveSysCfgToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            SysCFGSetValue("ChanNum", pbx.ChanNum.ToString(), myConn, log, false);
            SysCFGSetValue("PBXLicKey", pbx.PBXLicKey, myConn, log, false);
            //SysCFGSetValue("UseUSBKey", pbx.bUseUSBKey ? "1" : "0", myConn, log, false);
            SysCFGSetValue("USBKeyDriver", pbx.USBKeyDriver, myConn, log, false);
            SysCFGSetValue("LicMAC", pbx.LicMAC, myConn, log, false);
            SysCFGSetValue("MohDir", pbx.moh_dir, myConn, log, false);
            SysCFGSetValue("LogDir", pbx.log_dir, myConn, log, false);
            SysCFGSetValue("LogLevel", pbx.log_level.ToString(), myConn, log, false);
            SysCFGSetValue("ReportDir", pbx.report_dir, myConn, log, false);
            SysCFGSetValue("RecordDir", pbx.record_dir, myConn, log, false);
            SysCFGSetValue("VMBDir", pbx.vmb_dir, myConn, log, false);

            SysCFGSetValue("OutboundPercent", pbx.pbx_sys_set.OutPercent.ToString(), myConn, log, false);
            SysCFGSetValue("ExtenCanInbound", pbx.pbx_sys_set.bExtenCanInbound ? "1" : "0", myConn, log, false);
            SysCFGSetValue("MaxProxyUserRegSec", pbx.pbx_sys_set.MaxProxyUserRegSec.ToString(), myConn, log, false);

            SysCFGSetValue("PreferOutlineCodec", pbx.pbx_sys_set.PreferOutlineCodec, myConn, log, false);
            SysCFGSetValue("PreferExtensionCodec", pbx.pbx_sys_set.PreferExtensionCodec, myConn, log, false);

            SysCFGSetValue("RestartTime", pbx.pbx_sys_set.sRestartTime, myConn, log, false);

            SysCFGSetValue("PlayMOHRandomly", pbx.pbx_sys_set.bRandomPlayMOH ? "1" : "0", myConn, log, false);
            SysCFGSetValue("PlayRingbackTone", pbx.pbx_sys_set.bPlayRingbackTone ? "1" : "0", myConn, log, false);
            SysCFGSetValue("NoAudioDisconnect", pbx.pbx_sys_set.bNoAudioDisconnect ? "1" : "0", myConn, log, false);

            SysCFGSetValue("StopPlayingForFirstDTMFkey", pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey ? "1" : "0", myConn, log, false);

            SysCFGSetValue("NoAudioDisconnectDur", pbx.pbx_sys_set.NoAudioDisconnectDur.ToString(), myConn, log, false);

            SysCFGSetValue("MaxCallDuration", pbx.pbx_sys_set.MaxCallDuration.ToString(), myConn, log, false);

            //special numbers
            SysCFGSetValue("PickupShortCode", pbx.pickup_shortcode, myConn, log, false);
            SysCFGSetValue("ACDNumber", pbx.acd_number, myConn, log, false);
            SysCFGSetValue("AgentLoginNumber", pbx.agent_login_number, myConn, log, false);
            SysCFGSetValue("AgentLogoutNumber", pbx.agent_logout_number, myConn, log, false);
            SysCFGSetValue("VoiceMailBoxNumber", pbx.vmb_code, myConn, log, false);

            SysCFGSetValue("BlindTransCode", pbx.blindtrans_code, myConn, log, false);
            SysCFGSetValue("ConsultTransCode", pbx.consulttrans_code, myConn, log, false);

            SysCFGSetValue("TrunkBlindTransCode", pbx.trunk_blindtrans_code, myConn, log, false);
            SysCFGSetValue("TrunkConsultTransCode", pbx.trunk_consulttrans_code, myConn, log, false);
            SysCFGSetValue("TrunkHookFlashCode", pbx.trunk_hook_flash_code, myConn, log, false);
            SysCFGSetValue("MagicCancelCode", pbx.magic_cancel_code, myConn, log, false);

            //cdr_option
            SysCFGSetValue("PBXCDR", pbx.cdr_option.pbx_cdr.ToString(), myConn, log, false);
            SysCFGSetValue("ACDCDR", pbx.cdr_option.acd_cdr.ToString(), myConn, log, false);
            SysCFGSetValue("ExtenCDR", pbx.cdr_option.exten_cdr.ToString(), myConn, log, false);
            SysCFGSetValue("AgentCDR", pbx.cdr_option.agent_cdr.ToString(), myConn, log, false);

            SysCFGSetValue("NoAudioDuration", pbx.no_audio_dur.ToString(), myConn, log, false);
            SysCFGSetValue("UseGroupNameAsDisplayName", pbx.use_gpname_as_dispname ? "1" : "0", myConn, log, false);
            SysCFGSetValue("GetRemoteContactFromRing", pbx.get_remote_contact_from_ring ? "1" : "0", myConn, log, false);

            SysCFGSetValue("AudioFormat", pbx.AudioFormat.ToString(), myConn, log, false);
            SysCFGSetValue("AudioEncode", pbx.AudioEncode.ToString(), myConn, log, false);

            //email settings
            SysCFGSetValue("Email.SMTPServer", pbx.email_set.emailServer, myConn, log, false);
            SysCFGSetValue("Email.SMTPPort", pbx.email_set.emailPort.ToString(), myConn, log, false);
            SysCFGSetValue("Email.EmailAddr", pbx.email_set.emailAddr, myConn, log, false);
            SysCFGSetValue("Email.Password", pbx.email_set.emailPassword, myConn, log, false);
            SysCFGSetValue("Email.SSL", pbx.email_set.emailSSL ? "1" : "0", myConn, log, false);

            //sip net
            SysCFGSetValue("SIPNetwork.SIPAddr", pbx.sip_set.sipAddr, myConn, log, false);
            SysCFGSetValue("SIPNetwork.SIPProtocol", pbx.sip_set.sipProtocol.ToString(), myConn, log, false);
            SysCFGSetValue("SIPNetwork.SIPPort", pbx.sip_set.sipPort.ToString(), myConn, log, false);
            SysCFGSetValue("SIPNetwork.RTPPort", pbx.sip_set.rtpPort.ToString(), myConn, log, false);
            SysCFGSetValue("SIPNetwork.RTPPortSpace", pbx.sip_set.rtpPortSpace.ToString(), myConn, log, false);
            SysCFGSetValue("SIPNetwork.AudioCodecs", pbx.sip_set.auCodecs, myConn, log, false);
            SysCFGSetValue("SIPNetwork.VideoCodecs", pbx.sip_set.videoCodecs, myConn, log, false);
            SysCFGSetValue("SIPNetwork.StunServer", pbx.sip_set.sStunServer, myConn, log, false);
            SysCFGSetValue("SIPNetwork.DTMFMethod", pbx.sip_set.dtmfMethod.ToString(), myConn, log, false);
            SysCFGSetValue("SIPNetwork.PublicIP", pbx.sip_set.sPublicIPAddr, myConn, log, false);
            SysCFGSetValue("SIPNetwork.ManagerPort", pbx.sip_set.managerPort.ToString(), myConn, log, false);
            SysCFGSetValue("SIPNetwork.DynMapRTP", pbx.sip_set.dynMapRTP.ToString(), myConn, log, false);
            SysCFGSetValue("SIPNetwork.DoRTPRelay", pbx.sip_set.doRTPRelay?"1":"0", myConn, log, false);
            SysCFGSetValue("SIPNetwork.UseDNSSRV", pbx.sip_set.useDNSSRV ? "1" : "0", myConn, log, false);
            SysCFGSetValue("SIPNetwork.DoExtenProxy", pbx.sip_set.doExtenProxy ? "1" : "0", myConn, log, false);
            SysCFGSetValue("SIPNetwork.ForwardPAssertedIdentity", pbx.sip_set.bForwardPAssertedIdentity ? "1" : "0", myConn, log, false);
            

            SysCFGSetValue("SIPNetwork.UserAgentName", pbx.sip_set.sUAName, myConn, log, false);

            //call limit list and black list
            SysCFGSetValue("PBX.EnableCallLimit", pbx.calllimit_enabled? "1" : "0", myConn, log, false);
            SysCFGSetValue("PBX.EnableBlackList", pbx.callblock_enabled? "1" : "0", myConn, log, false);
            SysCFGSetValue("PBX.EnableCallBack", pbx.callback_enabled ? "1" : "0", myConn, log, false);
            SysCFGSetValue("PBX.RecordAllCalls", pbx.RecordAllCalls ? "1" : "0", myConn, log, false);


            //proxy site
            SysCFGSetValue("SIPProxySite.DomainList", pbx.sip_proxy_sites[0].domainList, myConn, log, false);
            SysCFGSetValue("SIPProxySite.MapSIPAddr", pbx.sip_proxy_sites[0].mapSIPAddr ? "1" : "0", myConn, log, false);

            SysCFGSetValue("SIPProxySite.OptionPingExtension", pbx.sip_proxy_sites[0].optionPingExten ? "1" : "0", myConn, log, false);

            SavePBXVersionToDB(pbx.PBXVersion, env, myConn, log);
        }

        public static string GetSysPBXVersionSettingsFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            string sVersion = SysCFGGetValue("PBXVersion", myConn, log);
            if (sVersion == "")
            {
                sVersion = pbx.PBXVersion;
            }
            return sVersion;
        }

        public static void SavePBXLicOwner(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            SysCFGSetValue("PBXLicOwner", pbx.LicOwner, myConn, log, false);
            SysCFGSetValue("PBXFreeVersion", pbx.bFreeVersion?"1":"0", myConn, log, false);
        }

        public static void GetPBXLicOwner(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.LicOwner = SysCFGGetValue("PBXLicOwner", myConn, log);
            pbx.bFreeVersion = SysCFGGetValue("PBXFreeVersion", myConn, log) == "1";
        }

        public static void UpdateSysUseGroupNameAsDisplayNameToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            SysCFGSetValue("UseGroupNameAsDisplayName", pbx.use_gpname_as_dispname ? "1" : "0", myConn, log, true);
        }

        public static void UpdateGetRemoteContactFromRingToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            SysCFGSetValue("GetRemoteContactFromRing", pbx.get_remote_contact_from_ring ? "1" : "0", myConn, log, true);
        }

        public static void UpdateSysRegLicKeyToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            SysCFGSetValue("ChanNum", pbx.ChanNum.ToString(), myConn, log, true);
            SysCFGSetValue("PBXLicKey", pbx.PBXLicKey, myConn, log, true);
            //SysCFGSetValue("UseUSBKey", pbx.bUseUSBKey?"1":"0", myConn, log, true);
            SysCFGSetValue("USBKeyDriver", pbx.USBKeyDriver, myConn, log, true);
            SysCFGSetValue("LicMAC", pbx.LicMAC, myConn, log, true);
        }

        public static void UpdateSysCDROptionToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            SysCFGSetValue("PBXCDR", pbx.cdr_option.pbx_cdr.ToString(), myConn, log, true);
            SysCFGSetValue("ACDCDR", pbx.cdr_option.acd_cdr.ToString(), myConn, log, true);
            SysCFGSetValue("ExtenCDR", pbx.cdr_option.exten_cdr.ToString(), myConn, log, true);
            SysCFGSetValue("AgentCDR", pbx.cdr_option.agent_cdr.ToString(), myConn, log, true);
        }

        public static void UpdateSysSpecialNumberToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            SysCFGSetValue("PickupShortCode", pbx.pickup_shortcode, myConn, log, true);
            SysCFGSetValue("ACDNumber", pbx.acd_number, myConn, log, true);
            SysCFGSetValue("AgentLoginNumber", pbx.agent_login_number, myConn, log, true);
            SysCFGSetValue("AgentLogoutNumber", pbx.agent_logout_number, myConn, log, true);
            SysCFGSetValue("VoiceMailBoxNumber", pbx.vmb_code, myConn, log, true);

            //******changed below bMod parameters from false to true
            //******I think it should follow above footprint
            SysCFGSetValue("BlindTransCode", pbx.blindtrans_code, myConn, log, true);
            SysCFGSetValue("ConsultTransCode", pbx.consulttrans_code, myConn, log, true);

            SysCFGSetValue("TrunkBlindTransCode", pbx.trunk_blindtrans_code, myConn, log, true);
            SysCFGSetValue("TrunkConsultTransCode", pbx.trunk_consulttrans_code, myConn, log, true);
            SysCFGSetValue("TrunkHookFlashCode", pbx.trunk_hook_flash_code, myConn, log, true);
            SysCFGSetValue("MagicCancelCode", pbx.magic_cancel_code, myConn, log, true);

        }

        public static void UpdateSysOptionsToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            SysCFGSetValue("PreferOutlineCodec", pbx.pbx_sys_set.PreferOutlineCodec, myConn, log, true);
            SysCFGSetValue("PreferExtensionCodec", pbx.pbx_sys_set.PreferExtensionCodec, myConn, log, true);

            SysCFGSetValue("OutboundPercent", pbx.pbx_sys_set.OutPercent.ToString(), myConn, log, true);

            SysCFGSetValue("ExtenCanInbound", pbx.pbx_sys_set.bExtenCanInbound ? "1" : "0", myConn, log, true);
            SysCFGSetValue("MaxProxyUserRegSec", pbx.pbx_sys_set.MaxProxyUserRegSec.ToString(), myConn, log, true);

            SysCFGSetValue("RestartTime", pbx.pbx_sys_set.sRestartTime, myConn, log, true);

            SysCFGSetValue("PlayMOHRandomly", pbx.pbx_sys_set.bRandomPlayMOH ? "1" : "0", myConn, log, true);
            SysCFGSetValue("PlayRingbackTone", pbx.pbx_sys_set.bPlayRingbackTone ? "1" : "0", myConn, log, true);
            SysCFGSetValue("NoAudioDisconnect", pbx.pbx_sys_set.bNoAudioDisconnect ? "1" : "0", myConn, log, true);

            SysCFGSetValue("StopPlayingForFirstDTMFkey", pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey ? "1" : "0", myConn, log, true);

            SysCFGSetValue("NoAudioDisconnectDur", pbx.pbx_sys_set.NoAudioDisconnectDur.ToString(), myConn, log, true);

            SysCFGSetValue("MaxCallDuration", pbx.pbx_sys_set.MaxCallDuration.ToString(), myConn, log, true);


            SysCFGSetValue("AudioFormat", pbx.AudioFormat.ToString(), myConn, log, true);
            SysCFGSetValue("AudioEncode", pbx.AudioEncode.ToString(), myConn, log, true);

            SysCFGSetValue("PBX.RecordAllCalls", pbx.RecordAllCalls ? "1" : "0", myConn, log, true);

            UpdateGetRemoteContactFromRingToDB(pbxMain, pbx, env, myConn, log);
        }

        public static void UpdateSysServerFoldersToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            SIPPBXCFGDB.SysCFGSetValue("MohDir", pbx.moh_dir, pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("LogDir", pbx.log_dir, pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("LogLevel", pbx.log_level.ToString(), pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("ReportDir", pbx.report_dir, pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("RecordDir", pbx.record_dir, pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("VMBDir", pbx.vmb_dir, pbx.db_set.myConn, log, true);
        }

        public static void GetSysProxySiteSettingsFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.sip_proxy_sites[0].domainList = SysCFGGetValue("SIPProxySite.DomainList", myConn, log);
            pbx.sip_proxy_sites[0].mapSIPAddr = SysCFGGetValue("SIPProxySite.MapSIPAddr", myConn, log) == "1";
            pbx.sip_proxy_sites[0].optionPingExten = SysCFGGetValue("SIPProxySite.OptionPingExtension", myConn, log) == "1";
        }

        public static void UpdateSysProxySiteToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            SIPPBXCFGDB.SysCFGSetValue("SIPProxySite.DomainList", pbx.sip_proxy_sites[0].domainList, pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPProxySite.MapSIPAddr", pbx.sip_proxy_sites[0].mapSIPAddr ? "1" : "0", pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPProxySite.OptionPingExtension", pbx.sip_proxy_sites[0].optionPingExten ? "1" : "0", pbx.db_set.myConn, log, true);
        }

        public static void UpdateCallLimitAndBlackListToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            //call limit list and black list
            SysCFGSetValue("PBX.EnableCallLimit", pbx.calllimit_enabled ? "1" : "0", myConn, log, true);
            SysCFGSetValue("PBX.EnableBlackList", pbx.callblock_enabled ? "1" : "0", myConn, log, true);
            SysCFGSetValue("PBX.EnableCallBack", pbx.callback_enabled ? "1" : "0", myConn, log, true);
        }

        public static void UpdateSysNetworkSettingsToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.SIPAddr", pbx.sip_set.sipAddr, pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.SIPProtocol", pbx.sip_set.sipProtocol.ToString(), pbx.db_set.myConn, log, true);    
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.SIPPort", pbx.sip_set.sipPort.ToString(), pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.RTPPort", pbx.sip_set.rtpPort.ToString(), pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.RTPPortSpace", pbx.sip_set.rtpPortSpace.ToString(), pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.StunServer", pbx.sip_set.sStunServer, pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.DTMFMethod", pbx.sip_set.dtmfMethod.ToString(), pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.PublicIP", pbx.sip_set.sPublicIPAddr, myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.ManagerPort", pbx.sip_set.managerPort.ToString(), myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.DynMapRTP", pbx.sip_set.dynMapRTP.ToString(), myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.DoRTPRelay", pbx.sip_set.doRTPRelay?"1":"0", myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.UseDNSSRV", pbx.sip_set.useDNSSRV ? "1" : "0", myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.DoExtenProxy", pbx.sip_set.doExtenProxy ? "1" : "0", myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.ForwardPAssertedIdentity", pbx.sip_set.bForwardPAssertedIdentity ? "1" : "0", myConn, log, true);

            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.UserAgentName", pbx.sip_set.sUAName, myConn, log, true);

            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.AudioCodecs", pbx.sip_set.auCodecs, pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.VideoCodecs", pbx.sip_set.videoCodecs, pbx.db_set.myConn, log, true);

            SIPPBXCFGDB.SysCFGSetValue("Email.SMTPServer", pbx.email_set.emailServer, pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("Email.SMTPPort", pbx.email_set.emailPort.ToString(), pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("Email.EmailAddr", pbx.email_set.emailAddr, pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("Email.Password", pbx.email_set.emailPassword, pbx.db_set.myConn, log, true);
            SIPPBXCFGDB.SysCFGSetValue("Email.SSL", pbx.email_set.emailSSL ? "1" : "0", pbx.db_set.myConn, log, true);
        }

        public static void RefreshSysCfgFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT * FROM cfg_sys WHERE ModTag = 1";

                Queue<PBXOptCmd> tempQueue = new Queue<PBXOptCmd>();

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        PBXOptCmd cmd = new PBXOptCmd();
                        cmd.CmdName = myReader.GetString(0);
                        cmd.CmdArgs = myReader.GetString(1);
                        tempQueue.Enqueue(cmd);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                while (tempQueue.Count > 0)
                {
                    PBXOptCmd cmd = tempQueue.Dequeue();

                    if (cmd.CmdName == "ChanNum")
                    {
                        //pbx.ChanNum = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "OutboundPercent")
                    {
                        pbx.pbx_sys_set.OutPercent = Convert.ToInt32(cmd.CmdArgs);
                        if (pbx.pbx_sys_set.OutPercent > 100)
                            pbx.pbx_sys_set.OutPercent = 100;
                        else if (pbx.pbx_sys_set.OutPercent < 0)
                            pbx.pbx_sys_set.OutPercent = 0;
                    }
                    else if (cmd.CmdName == "ExtenCanInbound")
                    {
                        if (Convert.ToInt32(cmd.CmdArgs) == 1)
                            pbx.pbx_sys_set.bExtenCanInbound = true;
                        else
                            pbx.pbx_sys_set.bExtenCanInbound = false;
                    }
                    else if (cmd.CmdName == "MaxProxyUserRegSec")
                    {
                        pbx.pbx_sys_set.MaxProxyUserRegSec = Convert.ToInt32(cmd.CmdArgs);
                        if (pbx.pbx_sys_set.MaxProxyUserRegSec < 60)
                            pbx.pbx_sys_set.MaxProxyUserRegSec = 60;
                        else if (pbx.pbx_sys_set.MaxProxyUserRegSec > 3600)
                            pbx.pbx_sys_set.MaxProxyUserRegSec = 3600;
                    }
                    else if (cmd.CmdName == "PreferOutlineCodec")
                    {
                        pbx.pbx_sys_set.PreferOutlineCodec = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "PreferExtensionCodec")
                    {
                        pbx.pbx_sys_set.PreferExtensionCodec = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "RestartTime")
                    {
                        pbx.pbx_sys_set.sRestartTime = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "PlayMOHRandomly")
                    {
                        pbx.pbx_sys_set.bRandomPlayMOH = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "PlayRingbackTone")
                    {
                        pbx.pbx_sys_set.bPlayRingbackTone = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "NoAudioDisconnect")
                    {
                        pbx.pbx_sys_set.bNoAudioDisconnect = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "StopPlayingForFirstDTMFkey")
                    {
                        pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "NoAudioDisconnectDur")
                    {
                        pbx.pbx_sys_set.NoAudioDisconnectDur = Convert.ToInt32(cmd.CmdArgs);
                        if (pbx.pbx_sys_set.NoAudioDisconnectDur < 10)
                            pbx.pbx_sys_set.NoAudioDisconnectDur = 10;
                    }
                    else if (cmd.CmdName == "MaxCallDuration")
                    {
                        pbx.pbx_sys_set.MaxCallDuration = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "PBXLicKey")
                    {
                        pbx.PBXLicKey = cmd.CmdArgs;
                    }
                    /*else if (cmd.CmdName == "UseUSBKey")
                    {
                        pbx.bUseUSBKey = cmd.CmdArgs == "1";
                    }*/
                    else if (cmd.CmdName == "USBKeyDriver")
                    {
                        pbx.USBKeyDriver = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "LicMAC")
                    {
                        pbx.LicMAC = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "MohDir")
                    {
                        pbx.moh_dir = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "LogDir")
                    {
                        // pbx.log_dir = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "LogLevel")
                    {
                        //pbx.log_level = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "ReportDir")
                    {
                        pbx.report_dir = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "RecordDir")
                    {
                        pbx.record_dir = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "VMBDir")
                    {
                        pbx.vmb_dir = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "PickupShortCode")
                    {
                        pbx.pickup_shortcode = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "ACDNumber")
                    {
                        pbx.acd_number = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "AgentLoginNumber")
                    {
                        pbx.agent_login_number = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "AgentLogoutNumber")
                    {
                        pbx.agent_logout_number = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "VoiceMailBoxNumber")
                    {
                        pbx.vmb_code = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "BlindTransCode")
                    {
                        pbx.blindtrans_code = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "ConsultTransCode")
                    {
                        pbx.consulttrans_code = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "TrunkBlindTransCode")
                    {
                        pbx.trunk_blindtrans_code = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "TrunkConsultTransCode")
                    {
                        pbx.trunk_consulttrans_code = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "TrunkHookFlashCode")
                    {
                        pbx.trunk_hook_flash_code = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "MagicCancelCode")
                    {
                        pbx.magic_cancel_code = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "PBXCDR")
                    {
                        pbx.cdr_option.pbx_cdr = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "ACDCDR")
                    {
                        pbx.cdr_option.acd_cdr = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "ExtenCDR")
                    {
                        pbx.cdr_option.exten_cdr = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "AgentCDR")
                    {
                        pbx.cdr_option.agent_cdr = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "NoAudioDuration")
                    {
                        pbx.no_audio_dur = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "AudioFormat")
                    {
                        pbx.AudioFormat = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "AudioEncode")
                    {
                        pbx.AudioEncode = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "UseGroupNameAsDisplayName")
                    {
                        pbx.use_gpname_as_dispname = Convert.ToInt32(cmd.CmdArgs) == 1;

                        if (pbx.sip_ringgroups.Count > 0)
                        {
                            for (int i = 0; i < pbx.sip_ringgroups.Count; i++)
                            {
                                pbx.sip_ringgroups[i].bUseGroupName = pbx.use_gpname_as_dispname;
                            }
                        }
                        if (pbx.sip_huntgroups.Count > 0)
                        {
                            for (int i = 0; i < pbx.sip_huntgroups.Count; i++)
                            {
                                pbx.sip_huntgroups[i].bUseGroupName = pbx.use_gpname_as_dispname;
                            }
                        }
                    }
                    else if (cmd.CmdName == "GetRemoteContactFromRing")
                    {
                        pbx.get_remote_contact_from_ring = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    //original email part.
                    else if (cmd.CmdName == "Email.SMTPServer")
                    {
                        pbx.email_set.emailServer = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "Email.SMTPPort")
                    {
                        pbx.email_set.emailPort = Convert.ToUInt16(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "Email.EmailAddr")
                    {
                        pbx.email_set.emailAddr = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "Email.Password")
                    {
                        pbx.email_set.emailPassword = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "Email.SSL")
                    {
                        pbx.email_set.emailSSL = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    //sip network
                    else if (cmd.CmdName == "SIPNetwork.SIPAddr")
                    {
                        //pbx.sip_set.sipAddr = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "SIPNetwork.SIPProtocol")
                    {
                        //pbx.sip_set.sipProtocol = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "SIPNetwork.SIPPort")
                    {
                        //pbx.sip_set.sipPort = Convert.ToUInt16(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "SIPNetwork.RTPPort")
                    {
                        //pbx.sip_set.rtpPort = Convert.ToUInt16(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "SIPNetwork.RTPPortSpace")
                    {
                        //pbx.sip_set.rtpPortSpace = Convert.ToUInt16(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "SIPNetwork.AudioCodecs")
                    {
                        //pbx.sip_set.auCodecs = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "SIPNetwork.VideoCodecs")
                    {
                        //pbx.sip_set.videoCodecs = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "SIPNetwork.StunServer")
                    {
                        //pbx.sip_set.sStunServer = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "SIPNetwork.DTMFMethod")
                    {
                        /*
                        pbx.sip_set.dtmfMethod = Convert.ToInt32(cmd.CmdArgs);
                        if (pbx.sip_set.dtmfMethod < 0 || pbx.sip_set.dtmfMethod > 3)
                            pbx.sip_set.dtmfMethod = 3;
                         */
                    }
                    else if (cmd.CmdName == "SIPNetwork.DoRTPRelay")
                    {
                        pbx.sip_set.doRTPRelay = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "SIPNetwork.UseDNSSRV")
                    {
                        pbx.sip_set.useDNSSRV = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "SIPNetwork.DoExtenProxy")
                    {
                        pbx.sip_set.doExtenProxy = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "SIPNetwork.ForwardPAssertedIdentity")
                    {
                        pbx.sip_set.bForwardPAssertedIdentity = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "SIPNetwork.UserAgentName")
                    {
                        pbx.sip_set.sUAName = cmd.CmdArgs;
                    }
                    //proxy sites
                    else if (cmd.CmdName == "SIPProxySite.DomainList")
                    {
                        //pbx.sip_proxy_sites[0].domainList = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "SIPProxySite.MapSIPAddr")
                    {
                        //pbx.sip_proxy_sites[0].mapSIPAddr = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "SIPProxySite.OptionPingExtension")
                    {
                        //pbx.sip_proxy_sites[0].optionPingExten = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "PBX.EnableCallLimit")
                    {
                        pbx.calllimit_enabled = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "PBX.EnableBlackList")
                    {
                        pbx.callblock_enabled = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "PBX.EnableCallBack")
                    {
                        pbx.callback_enabled = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "PBX.RecordAllCalls")
                    {
                        pbx.RecordAllCalls = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                }

                if (pbx.PBXLicKey.Length > 0)
                {
                    pbx.bFreeVersion = false;
                }
                else
                {
                    pbx.bFreeVersion = true;
                }

                catCMD.CommandText = "UPDATE cfg_sys SET ModTag = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void CheckAttrDef(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool fnd = false;
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                //catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT * FROM cfg_attrdef WHERE AttrType = " + EXTN_BLOCK_INCOMING_CALLERID_ATTR;
                SqlDataReader myReader = catCMD.ExecuteReader();
                try
                {
                    if (myReader.Read())
                    {
                        int attrType = myReader.GetInt32(0);
                        string attrName = myReader.GetString(1);
                        string attrDesc = myReader.GetString(2);
                        fnd = true;
                    }
                    else
                    {
                        fnd = false;
                    }
                }
                catch (Exception ex)
                {
                    if (log != null)
                        log.LogoutText(ex.ToString());

                    SIPPBXMain.LogMessageToFile(ex.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (!fnd)
                {
                    catCMD.CommandText = "INSERT INTO cfg_attrdef(AttrType, AttrName, AttrDesc) VALUES(" + EXTN_BLOCK_INCOMING_CALLERID_ATTR + ", 'Extension block incoming caller id', 'for cfg_extensions')";
                    catCMD.ExecuteNonQuery();
                }
            }
            catch (Exception ex1)
            {
                log.LogoutText(ex1.ToString());
                //env.LOG_Trace(1, ex1.ToString());
            }
            finally { }

        }

        public static void LoadSysCfgFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
#if PBXV3_DEBUG
            SIPPBXMain.LogMessageToFile("LoadSysCfgFromDB 1");
#endif

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT * FROM cfg_sys";

                Queue<PBXOptCmd> tempQueue = new Queue<PBXOptCmd>();

                SqlDataReader myReader = catCMD.ExecuteReader();

#if PBXV3_DEBUG
                SIPPBXMain.LogMessageToFile("LoadSysCfgFromDB 2");
#endif

                try
                {
                    while (myReader.Read())
                    {
                        PBXOptCmd cmd = new PBXOptCmd();
                        cmd.CmdName = myReader.GetString(0);
                        cmd.CmdArgs = myReader.GetString(1);
                        tempQueue.Enqueue(cmd);
                    }
                }
                catch (Exception ex)
                {
                    if (log != null)
                        log.LogoutText(ex.ToString());

                    SIPPBXMain.LogMessageToFile(ex.ToString());
                }
                finally
                {
                    myReader.Close();
                }

#if PBXV3_DEBUG
                SIPPBXMain.LogMessageToFile("LoadSysCfgFromDB 3");
                SIPPBXMain.LogMessageToFile("tempQueue.Count = " + tempQueue.Count.ToString());
#endif

                while (tempQueue.Count > 0)
                {
                    PBXOptCmd cmd = tempQueue.Dequeue();

                    try
                    {

                        if (cmd.CmdName == "ChanNum")
                        {
                            pbx.ChanNum = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "OutboundPercent")
                        {
                            pbx.pbx_sys_set.OutPercent = Convert.ToInt32(cmd.CmdArgs);
                            if (pbx.pbx_sys_set.OutPercent > 100)
                                pbx.pbx_sys_set.OutPercent = 100;
                            else if (pbx.pbx_sys_set.OutPercent < 0)
                                pbx.pbx_sys_set.OutPercent = 0;
                        }
                        else if (cmd.CmdName == "ExtenCanInbound")
                        {
                            if (Convert.ToInt32(cmd.CmdArgs) == 1)
                                pbx.pbx_sys_set.bExtenCanInbound = true;
                            else
                                pbx.pbx_sys_set.bExtenCanInbound = false;
                        }
                        else if (cmd.CmdName == "MaxProxyUserRegSec")
                        {
                            pbx.pbx_sys_set.MaxProxyUserRegSec = Convert.ToInt32(cmd.CmdArgs);
                            if (pbx.pbx_sys_set.MaxProxyUserRegSec < 60)
                                pbx.pbx_sys_set.MaxProxyUserRegSec = 60;
                            else if (pbx.pbx_sys_set.MaxProxyUserRegSec > 3600)
                                pbx.pbx_sys_set.MaxProxyUserRegSec = 3600;
                        }
                        else if (cmd.CmdName == "PreferOutlineCodec")
                        {
                            pbx.pbx_sys_set.PreferOutlineCodec = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "PreferExtensionCodec")
                        {
                            pbx.pbx_sys_set.PreferExtensionCodec = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "RestartTime")
                        {
                            pbx.pbx_sys_set.sRestartTime = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "PlayMOHRandomly")
                        {
                            pbx.pbx_sys_set.bRandomPlayMOH = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "PlayRingbackTone")
                        {
                            pbx.pbx_sys_set.bPlayRingbackTone = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "NoAudioDisconnect")
                        {
                            pbx.pbx_sys_set.bNoAudioDisconnect = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "StopPlayingForFirstDTMFkey")
                        {
                            pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "NoAudioDisconnectDur")
                        {
                            pbx.pbx_sys_set.NoAudioDisconnectDur = Convert.ToInt32(cmd.CmdArgs);
                            if (pbx.pbx_sys_set.NoAudioDisconnectDur < 10)
                                pbx.pbx_sys_set.NoAudioDisconnectDur = 10;
                        }
                        else if (cmd.CmdName == "MaxCallDuration")
                        {
                            pbx.pbx_sys_set.MaxCallDuration = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "PBXLicKey")
                        {
                            pbx.PBXLicKey = cmd.CmdArgs;
                        }
                        /*else if (cmd.CmdName == "UseUSBKey")
                        {
                            pbx.bUseUSBKey = cmd.CmdArgs == "1";
                        }*/
                        else if (cmd.CmdName == "USBKeyDriver")
                        {
                            pbx.USBKeyDriver = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "LicMAC")
                        {
                            pbx.LicMAC = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "MohDir")
                        {
                            pbx.moh_dir = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "LogDir")
                        {
                            pbx.log_dir = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "LogLevel")
                        {
                            pbx.log_level = Convert.ToInt32(cmd.CmdArgs);
#if PBXV3_DEBUG
                            SIPPBXMain.LogMessageToFile("pbx.log_level = " + pbx.log_level.ToString());
#endif
                        }
                        else if (cmd.CmdName == "ReportDir")
                        {
                            pbx.report_dir = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "RecordDir")
                        {
                            pbx.record_dir = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "VMBDir")
                        {
                            pbx.vmb_dir = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "PickupShortCode")
                        {
                            pbx.pickup_shortcode = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "ACDNumber")
                        {
                            pbx.acd_number = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "AgentLoginNumber")
                        {
                            pbx.agent_login_number = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "AgentLogoutNumber")
                        {
                            pbx.agent_logout_number = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "VoiceMailBoxNumber")
                        {
                            pbx.vmb_code = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "BlindTransCode")
                        {
                            pbx.blindtrans_code = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "ConsultTransCode")
                        {
                            pbx.consulttrans_code = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "TrunkBlindTransCode")
                        {
                            pbx.trunk_blindtrans_code = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "TrunkConsultTransCode")
                        {
                            pbx.trunk_consulttrans_code = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "TrunkHookFlashCode")
                        {
                            pbx.trunk_hook_flash_code = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "MagicCancelCode")
                        {
                            pbx.magic_cancel_code = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "PBXCDR")
                        {
                            pbx.cdr_option.pbx_cdr = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "ACDCDR")
                        {
                            pbx.cdr_option.acd_cdr = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "ExtenCDR")
                        {
                            pbx.cdr_option.exten_cdr = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "AgentCDR")
                        {
                            pbx.cdr_option.agent_cdr = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "NoAudioDuration")
                        {
                            pbx.no_audio_dur = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "AudioFormat")
                        {
                            pbx.AudioFormat = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "AudioEncode")
                        {
                            pbx.AudioEncode = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "UseGroupNameAsDisplayName")
                        {
                            pbx.use_gpname_as_dispname = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "GetRemoteContactFromRing")
                        {
                            pbx.get_remote_contact_from_ring = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        //original email part.
                        else if (cmd.CmdName == "Email.SMTPServer")
                        {
                            pbx.email_set.emailServer = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "Email.SMTPPort")
                        {
                            pbx.email_set.emailPort = Convert.ToUInt16(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "Email.EmailAddr")
                        {
                            pbx.email_set.emailAddr = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "Email.Password")
                        {
                            pbx.email_set.emailPassword = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "Email.SSL")
                        {
                            pbx.email_set.emailSSL = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        //sip network
                        else if (cmd.CmdName == "SIPNetwork.SIPAddr")
                        {
                            pbx.sip_set.sipAddr = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "SIPNetwork.SIPProtocol")
                        {
                            pbx.sip_set.sipProtocol = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "SIPNetwork.SIPPort")
                        {
                            pbx.sip_set.sipPort = Convert.ToUInt16(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "SIPNetwork.RTPPort")
                        {
                            pbx.sip_set.rtpPort = Convert.ToUInt16(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "SIPNetwork.RTPPortSpace")
                        {
                            pbx.sip_set.rtpPortSpace = Convert.ToUInt16(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "SIPNetwork.AudioCodecs")
                        {
                            pbx.sip_set.auCodecs = cmd.CmdArgs.Trim();
                        }
                        else if (cmd.CmdName == "SIPNetwork.VideoCodecs")
                        {
                            pbx.sip_set.videoCodecs = cmd.CmdArgs.Trim();
                        }
                        else if (cmd.CmdName == "SIPNetwork.StunServer")
                        {
                            pbx.sip_set.sStunServer = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "SIPNetwork.DTMFMethod")
                        {
                            pbx.sip_set.dtmfMethod = Convert.ToInt32(cmd.CmdArgs);
                            if (pbx.sip_set.dtmfMethod < 0 || pbx.sip_set.dtmfMethod > 3)
                                pbx.sip_set.dtmfMethod = 3;
                        }
                        else if (cmd.CmdName == "SIPNetwork.PublicIP")
                        {
                            pbx.sip_set.sPublicIPAddr = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "SIPNetwork.ManagerPort")
                        {
                            pbx.sip_set.managerPort = Convert.ToUInt16(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "SIPNetwork.DynMapRTP")
                        {
                            pbx.sip_set.dynMapRTP = Convert.ToUInt16(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "SIPNetwork.DoRTPRelay")
                        {
                            pbx.sip_set.doRTPRelay = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "SIPNetwork.UseDNSSRV")
                        {
                            pbx.sip_set.useDNSSRV = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "SIPNetwork.DoExtenProxy")
                        {
                            pbx.sip_set.doExtenProxy = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "SIPNetwork.ForwardPAssertedIdentity")
                        {
                            pbx.sip_set.bForwardPAssertedIdentity = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "SIPNetwork.UserAgentName")
                        {
                            pbx.sip_set.sUAName = cmd.CmdArgs;
                        }
                        //proxy sites
                        else if (cmd.CmdName == "SIPProxySite.DomainList")
                        {
                            pbx.sip_proxy_sites[0].domainList = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "SIPProxySite.MapSIPAddr")
                        {
                            pbx.sip_proxy_sites[0].mapSIPAddr = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "SIPProxySite.OptionPingExtension")
                        {
                            pbx.sip_proxy_sites[0].optionPingExten = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "PBX.EnableCallLimit")
                        {
                            pbx.calllimit_enabled = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "PBX.EnableBlackList")
                        {
                            pbx.callblock_enabled = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "PBX.EnableCallBack")
                        {
                            pbx.callback_enabled = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "PBX.RecordAllCalls")
                        {
                            pbx.RecordAllCalls = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                    }
                    catch (Exception ex)
                    {
                        if (log != null)
                            log.LogoutText(ex.ToString());
                        SIPPBXMain.LogMessageToFile(ex.ToString());
                    }
                }

                if (pbx.PBXLicKey.Length > 0)
                {
                    pbx.bFreeVersion = false;
                }
                else
                {
                    pbx.bFreeVersion = true;
                }

                catCMD.CommandText = "UPDATE cfg_sys SET ModTag = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception ex)
            {
                if (log != null)
                    log.LogoutText(ex.ToString());
                SIPPBXMain.LogMessageToFile(ex.ToString());
            }
        }

        public static void RefreshSIPAccountConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool newRow = false;
            bool bChanged = false;

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT ID, DisplayName, UserName, DomainServer, ProxyServer, AuthName, Password, ExpireSec, RegWithProxyServer, DIDS, Disabled, ModTag, AcceptOtherID, UseLocalIPInFrom, MappedExten, AppendExtenID, SIPProtocol, SIPTrunk FROM cfg_sipaccounts WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        bChanged = true; //so it will re-init status_sipaccount table.

                        newRow = false;

                        SIPAccount acct = pbx.getSIPAccountByID(myReader.GetInt32(0));

                        if (myReader.GetInt16(11) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (acct != null)
                            {
                                env.SIPAccount_Remove(acct.accHandle);
                                pbx.sip_acct.Remove(acct);
                            }

                            bChanged = true;

                            continue;
                        }

                        if (acct == null)
                        {
                            acct = new SIPAccount();
                            acct.AccID = myReader.GetInt32(0);
                            pbx.sip_acct.Add(acct);
                            newRow = true;

                            bChanged = true;
                        }

                        acct.AccID = myReader.GetInt32(0);
                        acct.DisplayName = myReader.GetString(1);
                        acct.UserName = myReader.GetString(2);

                        if (pbxMain.SelfBrand.Contains("iFoneline"))
                        {
                            acct.DomainServer = "sip.ifoneline.com";
                            acct.ProxyServer = "sip.ifoneline.com";
                        }
                        else if (pbxMain.SelfBrand.Contains("ENACCS"))
                        {
                            acct.DomainServer = "sip.enaccs.com";
                            acct.ProxyServer = "sip.enaccs.com";
                        }
                        else
                        {
                            acct.DomainServer = myReader.GetString(3);
                            acct.ProxyServer = myReader.GetString(4);
                        }

                        acct.AuthName = myReader.GetString(5);
                        acct.Password = myReader.GetString(6);
                        acct.ExpireSec = myReader.GetInt32(7);
                        acct.RegWithProxyServer = (myReader.GetByte(8) == 1) ? true : false;

                        acct.DIDList.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(9).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        if (members.Length > 0)
                        {
                            for (int i = 0; i < members.Length; i++)
                            {
                                acct.DIDList.Add(members[i]);
                            }
                        }

                        acct.Disabled = (myReader.GetByte(10) == 1) ? true : false;
                        acct.OutboundAcceptOtherID = myReader.GetByte(12) == 1;
                        acct.UseLocalIPInFrom = myReader.GetByte(13) == 1;
                        try
                        {
                            acct.MappedExten = myReader.GetString(14);
                        }
                        catch (Exception ex)
                        {
                            acct.MappedExten = "";
                            env.LOG_Trace(1, ex.ToString());
                        }

                        acct.OutboundAppendExtenID = myReader.GetByte(15) == 1;
                        acct.SIPProtocol = myReader.GetByte(16);
                        acct.SIPTrunk = myReader.GetByte(17);

                        if (newRow)
                        {
                            acct.accHandle = env.SIPAccount_Add(acct.DisplayName, acct.UserName, acct.DomainServer, acct.ProxyServer, acct.AuthName, acct.Password, acct.ExpireSec, acct.RegWithProxyServer ? 1 : 0, 0, 0, !acct.Disabled, acct.SIPProtocol);
                        }
                        else
                        {
                            env.SIPAccount_Remove(acct.accHandle);
                            acct.accHandle = env.SIPAccount_Add(acct.DisplayName, acct.UserName, acct.DomainServer, acct.ProxyServer, acct.AuthName, acct.Password, acct.ExpireSec, acct.RegWithProxyServer ? 1 : 0, 0, 0, !acct.Disabled, acct.SIPProtocol);
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "DELETE FROM cfg_sipaccounts WHERE ModTag = 2";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
                catCMD.CommandText = "UPDATE cfg_sipaccounts SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                if (bChanged)
                {
                    SIPPBXDBUtil.InitSIPAccountStatusTable(pbx, env, myConn);
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveSIPAccountFromDB(SIPAccount acct, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_sipaccounts SET ModTag = 2 WHERE ID = " + acct.AccID.ToString();

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddSIPAccountToDB(SIPAccount acct, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_sipaccounts(ID, DisplayName, UserName, DomainServer, ProxyServer, AuthName, Password, ExpireSec, RegWithProxyServer, DIDS, Disabled, ModTag, AcceptOtherID, UseLocalIPInFrom, MappedExten, AppendExtenID, SIPProtocol, SIPTrunk) VALUES(" + acct.AccID.ToString() + ", ";
                catCMD.CommandText += "'" + acct.DisplayName + "', ";
                catCMD.CommandText += "'" + acct.UserName + "', ";

                catCMD.CommandText += "'" + acct.DomainServer + "', ";
                catCMD.CommandText += "'" + acct.ProxyServer + "', ";

                catCMD.CommandText += "'" + acct.AuthName + "', ";
                catCMD.CommandText += "'" + acct.Password + "', ";

                catCMD.CommandText += acct.ExpireSec.ToString() + ", ";
                catCMD.CommandText += acct.RegWithProxyServer ? "1, " : "0, ";

                string sDIDs = "";
                for (int i = 0; i < acct.DIDList.Count; i++)
                {
                    sDIDs += acct.DIDList[i];
                    if (i != acct.DIDList.Count - 1)
                        sDIDs += ";";
                }
                catCMD.CommandText += "'" + sDIDs + "', ";
                catCMD.CommandText += acct.Disabled ? "1, " : "0, ";
                catCMD.CommandText += "1, " + (acct.OutboundAcceptOtherID ? "1, " : "0, ");
                catCMD.CommandText += acct.UseLocalIPInFrom ? "1, " : "0, ";
                catCMD.CommandText += "'" + acct.MappedExten + "', ";
                catCMD.CommandText += acct.OutboundAppendExtenID ? "1, " : "0, ";
                catCMD.CommandText += acct.SIPProtocol.ToString() + ", ";
                catCMD.CommandText += acct.SIPTrunk.ToString() + ")";

                if (catCMD.ExecuteNonQuery() == 1)
                {
/*
                    catCMD.CommandText = "SELECT * FROM cfg_sipaccounts WHERE ";
                    catCMD.CommandText += "UserName='" + acct.UserName + "' AND ";
                    catCMD.CommandText += "DomainServer='" + acct.DomainServer + "' AND ";
                    catCMD.CommandText += "AuthName='" + acct.AuthName + "' AND ";
                    catCMD.CommandText += "Password='" + acct.Password + "'";

                    SqlDataReader myReader = catCMD.ExecuteReader();

                    try
                    {
                        while (myReader.Read())
                        {
                            acct.AccID = myReader.GetInt32(0);
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
*/
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateSIPAccountInDB(SIPAccount acct, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_sipaccounts SET ";

                catCMD.CommandText += "DisplayName=" + "'" + acct.DisplayName + "', ";
                catCMD.CommandText += "UserName=" + "'" + acct.UserName + "', ";

                catCMD.CommandText += "DomainServer=" + "'" + acct.DomainServer + "', ";
                catCMD.CommandText += "ProxyServer=" + "'" + acct.ProxyServer + "', ";

                catCMD.CommandText += "AuthName=" + "'" + acct.AuthName + "', ";
                catCMD.CommandText += "Password=" + "'" + acct.Password + "', ";

                catCMD.CommandText += "ExpireSec=" + acct.ExpireSec.ToString() + ", ";
                catCMD.CommandText += "RegWithProxyServer=" + (acct.RegWithProxyServer ? "1, " : "0, ");

                string sDIDs = "";
                for (int i = 0; i < acct.DIDList.Count; i++)
                {
                    sDIDs += acct.DIDList[i];
                    if (i != acct.DIDList.Count - 1)
                        sDIDs += ";";
                }
                catCMD.CommandText += "DIDS=" + "'" + sDIDs + "', ";
                catCMD.CommandText += "Disabled=" + (acct.Disabled ? "1, " : "0, ");
                catCMD.CommandText += "AcceptOtherID=" + (acct.OutboundAcceptOtherID ? "1, " : "0, ");
                catCMD.CommandText += "AppendExtenID=" + (acct.OutboundAppendExtenID ? "1, " : "0, ");
                catCMD.CommandText += "UseLocalIPInFrom=" + (acct.UseLocalIPInFrom ? "1, " : "0, ");
                catCMD.CommandText += "MappedExten=" + "'" + acct.MappedExten + "', ";
                catCMD.CommandText += "SIPProtocol=" + acct.SIPProtocol.ToString() + ", ";
                catCMD.CommandText += "SIPTrunk=" + acct.SIPTrunk.ToString() + ", ";

                catCMD.CommandText += "ModTag=1 ";
                catCMD.CommandText += "WHERE ID = " + acct.AccID.ToString();

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadSIPAccountConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.sip_acct.Clear();

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_sipaccounts WHERE ModTag = 2";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT ID, DisplayName, UserName, DomainServer, ProxyServer, AuthName, Password, ExpireSec, RegWithProxyServer, DIDS, Disabled, ModTag, AcceptOtherID, UseLocalIPInFrom, MappedExten, AppendExtenID, SIPProtocol, SIPTrunk FROM cfg_sipaccounts";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        SIPAccount acct = new SIPAccount();

                        acct.AccID = myReader.GetInt32(0);
                        acct.DisplayName = myReader.GetString(1);
                        acct.UserName = myReader.GetString(2);

                        try
                        {
                            if (pbxMain != null)
                            {
                                if (pbxMain.SelfBrand.Contains("iFoneline"))
                                {
                                    acct.DomainServer = "sip.ifoneline.com";
                                    acct.ProxyServer = "sip.ifoneline.com";
                                }
                                else if (pbxMain.SelfBrand.Contains("ENACCS"))
                                {
                                    acct.DomainServer = "sip.enaccs.com";
                                    acct.ProxyServer = "sip.enaccs.com";
                                }
                                else
                                {
                                    acct.DomainServer = myReader.GetString(3);
                                    acct.ProxyServer = myReader.GetString(4);
                                }
                            }
                            else
                            {
                                acct.DomainServer = myReader.GetString(3);
                                acct.ProxyServer = myReader.GetString(4);
                            }
                        }
                        catch (Exception e)
                        {
                            if (log != null)
                                log.LogoutText(e.ToString());
                        }

                        acct.AuthName = myReader.GetString(5);
                        acct.Password = myReader.GetString(6);
                        acct.ExpireSec = myReader.GetInt32(7);
                        acct.RegWithProxyServer = (myReader.GetByte(8) == 1) ? true : false;

                        acct.DIDList.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(9).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        if (members.Length > 0)
                        {
                            for (int i = 0; i < members.Length; i++)
                            {
                                acct.DIDList.Add(members[i]);
                            }
                        }

                        acct.Disabled = (myReader.GetByte(10) == 1) ? true : false;
                        acct.OutboundAcceptOtherID = myReader.GetByte(12) == 1;
                        acct.UseLocalIPInFrom = myReader.GetByte(13) == 1;
                        try
                        {
                            acct.MappedExten = myReader.GetString(14);
                        }
                        catch (Exception ex)
                        {
                            acct.MappedExten = "";
                            env.LOG_Trace(1, ex.ToString());
                        }
                        acct.OutboundAppendExtenID = myReader.GetByte(15) == 1;
                        acct.SIPProtocol = myReader.GetByte(16);
                        acct.SIPTrunk = myReader.GetByte(17);

                        pbx.sip_acct.Add(acct);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "UPDATE cfg_sipaccounts SET ModTag = 0";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }
        
        //only called from SIPPBXv3 service, not from GUI tool, when a proxy user(extension) just registered
        public static bool SaveExtensionStatusConfigToDB(SIPPBXExten extn, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_extensions SET ";

                catCMD.CommandText += "RegSDKTime=" + extn.RegSDKTime.ToString() + ", ";
                catCMD.CommandText += "RegisterTime=" + "'" + SIPPBXWinUtil.GetSQLDateTime(extn.RegisterTime) + "', ";
                catCMD.CommandText += "RegisterExpire=" + extn.RegisterExpire.ToString() + ", ";
                catCMD.CommandText += "ContactAddr=" + "'" + extn.ContactAddr + "', ";
                catCMD.CommandText += "MappedContactAddr=" + "'" + extn.MappedContactAddr + "', ";
                catCMD.CommandText += "RegFromID=" + "'" + extn.RegFromID + "', ";
                catCMD.CommandText += "RegToID=" + "'" + extn.RegToID + "', ";
                catCMD.CommandText += "RegSrcIP=" + "'" + extn.RegSrcIP + "', ";
                catCMD.CommandText += "RegSrcPort=" + extn.RegSrcPort.ToString() + ", ";
                catCMD.CommandText += "UAName=" + "'" + extn.UAName + "', ";
                catCMD.CommandText += "NATType=" + extn.NATType.ToString() + ", ";
                catCMD.CommandText += "AuthType=" + extn.AuthType.ToString() + " ";
                //catCMD.CommandText += "MaxRegExpSec=" + extn.RegMaxExp.ToString() + " "; This value won't change by REGISTER event. 


                //catCMD.CommandText += "MsgWaitingCount=" + extn.MsgWaitingCount.ToString() + ", ";
                //catCMD.CommandText += "MsgTotalCount=" + extn.MsgTotalCount.ToString() + ", ";
                //catCMD.CommandText += "MsgAccount='" + extn.MsgAccount + "', ";
                //catCMD.CommandText += "VoiceMsg=" + "'" + extn.VoiceMsg + "', ";

                //catCMD.CommandText += "ModTag=1 ";
                catCMD.CommandText += "WHERE UserName = '" + extn.UserName + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    //extn.SaveAttrs(pbxMain, pbx, env, myConn, log);
                    //no need to refresh extension's EXTN_BLOCK_INCOMING_CALLERID_ATTR and EXTN_PING_CODE_ATTR
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;

        }

        public static void RefreshExtensionsConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool bChanged = false;
            bool bResetExtn = false;

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT UserName, RealName, Password, Email, AltPhoneNumber, RegSDKTime, RegisterTime, RegisterExpire, ContactAddr, RegFromID, RegToID, UAName, NATType, MsgWaitingCount, MsgTotalCount, MsgAccount, VoiceMsg, PriorityLevel, VirtualExtenDestAddr, ACDCallMethod, RingTimeoutSec, CallForwardingPlan, RecordCall, AcceptOtherID, RestSeconds, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, ModTag, AuthType, OnlyAgentLogin, MappedContactAddr, RegSrcIP, RegSrcPort, MultipleCall, VMBPassword, MaxRegExpSec FROM cfg_extensions WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {

                    while (myReader.Read())
                    {
                        bChanged = true; //so it will re-init status_extension table

                        bResetExtn = true;

                        SIPPBXExten extn = pbx.getExtensionByName(myReader.GetString(0));

                        if (myReader.GetInt16(29) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (extn != null)
                            {
                                pbx.sip_exten.Remove(extn);
                            }

                            bChanged = true;

                            continue;
                        }

                        if (extn == null)
                        {
                            extn = new SIPPBXExten();
                            extn.UserName = myReader.GetString(0);
                            pbx.sip_exten.Add(extn);

                            bChanged = true;
                        }

                        extn.RealName = myReader.GetString(1);
                        extn.Password = myReader.GetString(2);

                        try
                        {
                            extn.Email = myReader.GetString(3);
                            extn.AlternativePhoneNumber = myReader.GetString(4);
                        }
                        catch (Exception) { }
                        /*
                        extn.RegSDKTime = Convert.ToUInt64(myReader.GetInt32(5));
                        extn.RegisterTime = myReader.GetDateTime(6);
                        extn.RegisterExpire = Convert.ToUInt32(myReader.GetInt32(7));
                        extn.ContactAddr = myReader.GetString(8);
                        extn.RegFromID = myReader.GetString(9);
                        extn.RegToID = myReader.GetString(10);
                        extn.UAName = myReader.GetString(11);
                        extn.NATType = myReader.GetInt32(12);
                        extn.MsgWaitingCount = myReader.GetInt32(13);
                        extn.MsgTotalCount = myReader.GetInt32(14);
                        extn.MsgAccount = myReader.GetString(15);
                        extn.VoiceMsg = myReader.GetString(16);
                         */
                        try
                        {
                            extn.PriorityLevel = Convert.ToUInt32(myReader.GetInt32(17));
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.VirtualExtenDestAddr = myReader.GetString(18);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.ACDCallMethod = myReader.GetInt32(19);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RingTimeoutSec = myReader.GetInt32(20);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.CallForwardingPlan = myReader.GetString(21);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RecordCall = myReader.GetByte(22) == 1 ? true : false;
                        }
                        catch (Exception)
                        {
                        }

                        try
                        {
                            extn.bAcceptOtherID = myReader.GetByte(23) == 1 ? true : false;
                        }
                        catch (Exception)
                        {
                        }

                        try
                        {
                            extn.RestSeconds = myReader.GetInt32(24);
                        }
                        catch (Exception) { }

                        try
                        {

                            if (myReader.GetByte(25) == 1)
                            {
                                extn.vmb = new VoiceMailBox();
                                extn.vmb.vmbExten = extn;
                                extn.vmb.vmbPrompt = myReader.GetString(26);
                                extn.vmb.vmbEmailAddr = myReader.GetString(27);
                                extn.vmb.maxLengthInSecond = myReader.GetInt32(28);
                                extn.vmb.vmbPassword = myReader.GetString(36);
                            }
                            else
                            {
                                extn.vmb = null;
                            }
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.AuthType = myReader.GetInt32(30);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.bOnlyAgentLogin = myReader.GetByte(31) == 1 ? true : false;
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.MappedContactAddr = myReader.GetString(32);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RegSrcIP = myReader.GetString(33);
                            extn.RegSrcPort = Convert.ToUInt16(myReader.GetInt32(34));
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.bMultipleCalls = myReader.GetByte(35) == 1 ? true : false;
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RegMaxExp = Convert.ToUInt32(myReader.GetInt32(37));
                        }
                        catch (Exception) { }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                foreach (SIPPBXExten extn in pbx.sip_exten)
                {
                    extn.ReadAttrs(pbxMain, pbx, env, myConn, log);
                }

                if (bResetExtn)
                {
                    catCMD.CommandText = "UPDATE cfg_extensions SET ModTag = 0 WHERE ModTag = 1";
                    if (catCMD.ExecuteNonQuery() >= 1)
                    {
                    }

                    if (pbxMain != null)
                    {
                        pbxMain.ResetExtensions();
                    }
                }

                if (bChanged)
                {
                    catCMD.CommandText = "DELETE FROM cfg_extensions WHERE ModTag = 2";
                    if (catCMD.ExecuteNonQuery() >= 1)
                    {
                    }

                    SIPPBXDBUtil.InitExtenStatusTable(pbx, env, myConn);
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveExtensionFromDB(SIPPBXExten extn, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_extensions SET ModTag=2 WHERE UserName = '" + extn.UserName + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    extn.DelAttrs(pbxMain, pbx, env, myConn, log);
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddExtensionToDB(SIPPBXExten extn, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_extensions(UserName, RealName, Password, Email, AltPhoneNumber, RegSDKTime, RegisterTime, RegisterExpire, ContactAddr, RegFromID, RegToID, UAName, NATType, MsgWaitingCount, MsgTotalCount, MsgAccount, VoiceMsg, PriorityLevel, VirtualExtenDestAddr, ACDCallMethod, RingTimeoutSec, CallForwardingPlan, RecordCall, AcceptOtherID, RestSeconds, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, ModTag, AuthType, OnlyAgentLogin, MappedContactAddr, RegSrcIP, RegSrcPort, MultipleCall, MaxRegExpSec) VALUES('" + extn.UserName + "', ";
                catCMD.CommandText += "'" + extn.RealName + "', ";
                catCMD.CommandText += "'" + extn.Password + "', ";
                catCMD.CommandText += "'" + extn.Email + "', ";
                catCMD.CommandText += "'" + extn.AlternativePhoneNumber + "', ";
                catCMD.CommandText += extn.RegSDKTime.ToString() + ", ";
                catCMD.CommandText += "'" + SIPPBXWinUtil.GetSQLDateTime(extn.RegisterTime) + "', ";
                catCMD.CommandText += extn.RegisterExpire.ToString() + ", ";
                catCMD.CommandText += "'" + extn.ContactAddr + "', ";
                catCMD.CommandText += "'" + extn.RegFromID + "', ";
                catCMD.CommandText += "'" + extn.RegToID + "', ";
                catCMD.CommandText += "'" + extn.UAName + "', ";
                catCMD.CommandText += extn.NATType.ToString() + ", ";
                catCMD.CommandText += extn.MsgNewCount.ToString() + ", ";
                catCMD.CommandText += extn.MsgOldCount.ToString() + ", ";
                catCMD.CommandText += "'" + extn.MsgAccount + "', ";
                catCMD.CommandText += "'" + extn.VoiceMsg + "', ";
                catCMD.CommandText += extn.PriorityLevel.ToString() + ", ";
                catCMD.CommandText += "'" + extn.VirtualExtenDestAddr + "', ";
                catCMD.CommandText += extn.ACDCallMethod.ToString() + ", ";
                catCMD.CommandText += extn.RingTimeoutSec.ToString() + ", ";
                catCMD.CommandText += "'" + extn.CallForwardingPlan + "', ";
                catCMD.CommandText += extn.RecordCall ? "1, " : "0, ";
                catCMD.CommandText += extn.bAcceptOtherID ? "1, " : "0, ";
                catCMD.CommandText += extn.RestSeconds.ToString() + ", ";

                if (extn.vmb != null)
                {
                    catCMD.CommandText += "1, ";
                    catCMD.CommandText += "'" + extn.vmb.vmbPrompt + "', ";
                    catCMD.CommandText += "'" + extn.vmb.vmbEmailAddr + "', ";
                    catCMD.CommandText += extn.vmb.maxLengthInSecond.ToString() + ", '";
                    catCMD.CommandText += extn.vmb.vmbPassword + "', 1, ";
                }
                else
                {
                    catCMD.CommandText += "0, ";
                    catCMD.CommandText += "'', ";
                    catCMD.CommandText += "'', ";
                    catCMD.CommandText += "0, '', 1, ";
                }

                catCMD.CommandText += extn.AuthType.ToString() + ", ";
                catCMD.CommandText += extn.bOnlyAgentLogin? "1, " : "0, ";
                catCMD.CommandText += "'" + extn.MappedContactAddr + "', ";
                catCMD.CommandText += "'" + extn.RegSrcIP + "', ";
                catCMD.CommandText += extn.RegSrcPort.ToString() + ", ";
                catCMD.CommandText += extn.bMultipleCalls? "1, " : "0, ";
                catCMD.CommandText += extn.RegMaxExp.ToString() + ")";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    extn.SaveAttrs(pbxMain, pbx, env, myConn, log);
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateExtensionVMBInDB(SIPPBXExten extn, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_extensions SET ";
                if (extn.vmb != null)
                {
                    catCMD.CommandText += "VMBOn=" + "1, ";
                    catCMD.CommandText += "VMBPrompt=" + "'" + extn.vmb.vmbPrompt + "', ";
                    catCMD.CommandText += "VMBEmail=" + "'" + extn.vmb.vmbEmailAddr + "', ";
                    catCMD.CommandText += "VMBMaxLength=" + extn.vmb.maxLengthInSecond.ToString() + ", ";
                    catCMD.CommandText += "VMBPassword='" + extn.vmb.vmbPassword + "', ";

                }
                else
                {
                    catCMD.CommandText += "VMBOn=0, ";
                    catCMD.CommandText += "VMBPrompt='', ";
                    catCMD.CommandText += "VMBEmail='', ";
                    catCMD.CommandText += "VMBMaxLength=0, ";
                    catCMD.CommandText += "VMBPassword='', ";
                }

                catCMD.CommandText += "ModTag=1 ";

                catCMD.CommandText += "WHERE UserName = '" + extn.UserName + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;

        }

        public static bool UpdateExtensionInDB(SIPPBXExten extn, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_extensions SET ";
                catCMD.CommandText += "RealName=" + "'" + extn.RealName + "', ";
                catCMD.CommandText += "Password=" + "'" + extn.Password + "', ";
                catCMD.CommandText += "Email=" + "'" + extn.Email + "', ";
                catCMD.CommandText += "AltPhoneNumber=" + "'" + extn.AlternativePhoneNumber + "', ";
                //            catCMD.CommandText += "RegSDKTime=" + extn.RegSDKTime.ToString() + ", ";
                //            catCMD.CommandText += "RegisterTime=" + "'" + SIPPBXWinUtil.GetSQLDateTime(extn.RegisterTime) + "', ";
                //            catCMD.CommandText += "RegisterExpire=" + extn.RegisterExpire.ToString() + ", ";
                //            catCMD.CommandText += "ContactAddr=" + "'" + extn.ContactAddr + "', ";
                //            catCMD.CommandText += "RegFromID=" + "'" + extn.RegFromID + "', ";
                //            catCMD.CommandText += "RegToID=" + "'" + extn.RegToID + "', ";
                //            catCMD.CommandText += "UAName=" + "'" + extn.UAName + "', ";
                //            catCMD.CommandText += "NATType=" + extn.NATType.ToString() + ", ";
                //            catCMD.CommandText += "MsgWaitingCount=" + extn.MsgWaitingCount.ToString() + ", ";
                //            catCMD.CommandText += "MsgTotalCount=" + extn.MsgTotalCount.ToString() + ", ";
                //            catCMD.CommandText += "MsgAccount='" + extn.MsgAccount + "', ";
                //            catCMD.CommandText += "VoiceMsg=" + "'" + extn.VoiceMsg + "', ";
                catCMD.CommandText += "PriorityLevel=" + extn.PriorityLevel.ToString() + ", ";
                catCMD.CommandText += "VirtualExtenDestAddr=" + "'" + extn.VirtualExtenDestAddr + "', ";
                catCMD.CommandText += "ACDCallMethod=" + extn.ACDCallMethod.ToString() + ", ";
                catCMD.CommandText += "RingTimeoutSec=" + extn.RingTimeoutSec.ToString() + ", ";
                catCMD.CommandText += "CallForwardingPlan=" + "'" + extn.CallForwardingPlan + "', ";
                catCMD.CommandText += "RecordCall=" + (extn.RecordCall ? "1, " : "0, ");
                catCMD.CommandText += "AcceptOtherID=" + (extn.bAcceptOtherID ? "1, " : "0, ");
                catCMD.CommandText += "RestSeconds=" + extn.RestSeconds.ToString() + ", ";

                if (extn.vmb != null)
                {
                    catCMD.CommandText += "VMBOn=" + "1, ";
                    catCMD.CommandText += "VMBPrompt=" + "'" + extn.vmb.vmbPrompt + "', ";
                    catCMD.CommandText += "VMBEmail=" + "'" + extn.vmb.vmbEmailAddr + "', ";
                    catCMD.CommandText += "VMBMaxLength=" + extn.vmb.maxLengthInSecond.ToString() + ", ";
                    catCMD.CommandText += "VMBPassword='" + extn.vmb.vmbPassword + "', ";

                }
                else
                {
                    catCMD.CommandText += "VMBOn=0, ";
                    catCMD.CommandText += "VMBPrompt='', ";
                    catCMD.CommandText += "VMBEmail='', ";
                    catCMD.CommandText += "VMBMaxLength=0, ";
                    catCMD.CommandText += "VMBPassword='', ";
                }

                catCMD.CommandText += "AuthType=" + extn.AuthType.ToString() + ", ";
                catCMD.CommandText += "OnlyAgentLogin=" + (extn.bOnlyAgentLogin?"1":"0") + ", ";
                catCMD.CommandText += "MultipleCall=" + (extn.bMultipleCalls? "1" : "0") + ", ";
                catCMD.CommandText += "MaxRegExpSec=" + extn.RegMaxExp.ToString() + ", ";

                catCMD.CommandText += "ModTag=1 ";

                catCMD.CommandText += "WHERE UserName = '" + extn.UserName + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    extn.SaveAttrs(pbxMain, pbx, env, myConn, log);
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadExtensionsConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.sip_exten.Clear();

            try
            {

                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_extensions WHERE ModTag = 2";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT UserName, RealName, Password, Email, AltPhoneNumber, RegSDKTime, RegisterTime, RegisterExpire, ContactAddr, RegFromID, RegToID, UAName, NATType, MsgWaitingCount, MsgTotalCount, MsgAccount, VoiceMsg, PriorityLevel, VirtualExtenDestAddr, ACDCallMethod, RingTimeoutSec, CallForwardingPlan, RecordCall, AcceptOtherID, RestSeconds, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, ModTag, AuthType, OnlyAgentLogin, MappedContactAddr, RegSrcIP, RegSrcPort, MultipleCall, VMBPassword, MaxRegExpSec FROM cfg_extensions";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {

                    while (myReader.Read())
                    {
                        SIPPBXExten extn = new SIPPBXExten();

                        extn.UserName = myReader.GetString(0);
                        extn.RealName = myReader.GetString(1);
                        extn.Password = myReader.GetString(2);
                        try
                        {
                            extn.Email = myReader.GetString(3);
                        }
                        catch(Exception)
                        {
                        }

                        try
                        {
                            extn.AlternativePhoneNumber = myReader.GetString(4);
                        }
                        catch (Exception)
                        {
                        }

                        try
                        {
                            extn.RegSDKTime = Convert.ToUInt32(myReader.GetInt64(5));
                            extn.RegisterTime = myReader.GetDateTime(6);
                            extn.RegisterExpire = Convert.ToUInt32(myReader.GetInt32(7));
                            extn.ContactAddr = myReader.GetString(8);
                            extn.RegFromID = myReader.GetString(9);
                            extn.RegToID = myReader.GetString(10);
                            extn.UAName = myReader.GetString(11);
                            extn.NATType = myReader.GetInt32(12);
                        }
                        catch (Exception)
                        {
                        }

                        try
                        {
                            extn.MsgNewCount = myReader.GetInt32(13);
                            extn.MsgOldCount = myReader.GetInt32(14);
                            extn.MsgAccount = myReader.GetString(15);
                            extn.VoiceMsg = myReader.GetString(16);
                        }
                        catch (Exception)
                        {
                        }

                        try
                        {
                            extn.PriorityLevel = Convert.ToUInt32(myReader.GetInt32(17));
                        }
                        catch (Exception)
                        {
                        }

                        try
                        {
                            extn.VirtualExtenDestAddr = myReader.GetString(18);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.ACDCallMethod = myReader.GetInt32(19);
                            extn.RingTimeoutSec = myReader.GetInt32(20);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.CallForwardingPlan = myReader.GetString(21);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RecordCall = myReader.GetByte(22) == 1 ? true : false;
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.bAcceptOtherID = myReader.GetByte(23) == 1 ? true : false;
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RestSeconds = myReader.GetInt32(24);
                        }
                        catch (Exception) { }

                        try
                        {
                            if (myReader.GetByte(25) == 1)
                            {
                                extn.vmb = new VoiceMailBox();
                                extn.vmb.vmbExten = extn;
                                extn.vmb.vmbPrompt = myReader.GetString(26);
                                extn.vmb.vmbEmailAddr = myReader.GetString(27);
                                extn.vmb.maxLengthInSecond = myReader.GetInt32(28);
                                extn.vmb.vmbPassword = myReader.GetString(36);
                            }
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.AuthType = myReader.GetInt32(30);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.bOnlyAgentLogin = myReader.GetByte(31) == 1 ? true : false;
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.MappedContactAddr = myReader.GetString(32);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RegSrcIP = myReader.GetString(33);
                            extn.RegSrcPort = Convert.ToUInt16(myReader.GetInt32(34));
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.bMultipleCalls = myReader.GetByte(35) == 1 ? true : false;
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RegMaxExp = Convert.ToUInt32(myReader.GetInt32(37));
                        }
                        catch (Exception) { }

                        pbx.sip_exten.Add(extn);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                foreach (SIPPBXExten extn in pbx.sip_exten)
                {
                    extn.ReadAttrs(pbxMain, pbx, env, myConn, log);
                }

                catCMD.CommandText = "UPDATE cfg_extensions SET ModTag = 0";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshDialplansConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT DialPlanName, CallDirection, Caller, Called, CallPlan, DestAddress, OutboundPreStrip, OutboundPrepend, OutboundSIPAcct, OutboundCallerID, ExtenPriorityLevel, TimeLimited, TimeStartHour, TimeStartMinute, TimeEndHour, TimeEndMinute, TimeDay, ExtenMembers, ModTag, DialPlanIndex FROM cfg_dialplans WHERE ModTag != 0 ORDER BY DialPlanIndex ASC";
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXDialPlan dp = pbx.getDialPlanByPlanName(myReader.GetString(0));

                        if (myReader.GetInt16(18) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (dp != null)
                            {
                                pbx.sip_dialplan.Remove(dp);
                            }

                            bChanged = true;

                            continue;
                        }

                        if (dp == null)
                        {
                            dp = new SIPPBXDialPlan();
                            dp.planName = myReader.GetString(0);
                            pbx.sip_dialplan.Add(dp);

                            bChanged = true;
                        }

                        if (myReader.GetInt16(1) == 0)
                            dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND;
                        else
                            dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND;

                        dp.CallerID = myReader.GetString(2);
                        dp.CalledID = myReader.GetString(3);
                        if (myReader.GetString(4) == "AUTO_ATTENDANT")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT;
                        }
                        else if (myReader.GetString(4) == "VOICE_MAIL_BOX")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.VOICE_MAIL_BOX;
                        }
                        else if (myReader.GetString(4) == "ACD_QUEUE")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ACD_QUEUE;
                        }
                        else if (myReader.GetString(4) == "DIAL_EXTENSION")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION;
                        }
                        else if (myReader.GetString(4) == "DO_NOT_DISTURB")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DO_NOT_DISTURB;
                        }
                        else if (myReader.GetString(4) == "MONITOR_GROUP")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MONITOR_GROUP;
                        }
                        else if (myReader.GetString(4) == "RING_GROUP")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.RING_GROUP;
                        }
                        else if (myReader.GetString(4) == "CONFERENCE_ROOM")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CONFERENCE_ROOM;
                        }
                        else if (myReader.GetString(4) == "PLUGIN_ROUTINE")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.PLUGIN_ROUTINE;
                        }
                        else if (myReader.GetString(4) == "CALL_FORWARDING")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CALL_FORWARDING;
                        }
                        else if (myReader.GetString(4) == "MUSIC_SERVER")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MUSIC_SERVER;
                        }
                        else if (myReader.GetString(4) == "ECHO_TEST")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ECHO_TEST;
                        }

                        dp.DestAddress = myReader.GetString(5);
                        dp.OutboundPreStrip = myReader.GetString(6);
                        dp.OutboundPrepend = myReader.GetString(7);

                        //2016-06-17 decided to use 0xff, 0xff00, and 0xff0000 for alternative sip account
                        int acct = myReader.GetInt32(8);

                        dp.OutboundSIPAcct = acct & 0xff;
                        dp.OutboundSIPAcct1 = (acct & 0xff00) >> 8;
                        dp.OutboundSIPAcct2 = (acct & 0xff0000) >> 16;

                        dp.OutboundCallerID = myReader.GetString(9);
                        dp.ExtenPriorityLevel = Convert.ToUInt32(myReader.GetInt32(10));
                        dp.TimeLimited = myReader.GetByte(11) == 1;
                        dp.TimeStartHour = myReader.GetInt32(12);
                        dp.TimeStartMinute = myReader.GetInt32(13);
                        dp.TimeEndHour = myReader.GetInt32(14);
                        dp.TimeEndMinute = myReader.GetInt32(15);
                        for (int j = 0; j < 7; j++)
                        {
                            int bitFlag = 1 << j;
                            if ((myReader.GetInt32(16) & bitFlag) == bitFlag)
                                dp.TimeDays[j] = 1;
                            else
                                dp.TimeDays[j] = 0;
                        }

                        char[] delimiters = new char[] { ';', ',', ' ' };

                        int mbType = 0;
                        string strExtnList = myReader.GetString(17);
                        if (strExtnList.Contains("agt:"))
                        {
                            mbType = 1;
                            strExtnList = strExtnList.Substring(4);
                        }

                        string[] members = strExtnList.Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        if (members.Length > 0)
                        {
                            dp.MemberList = new PBXMemberList();
                            dp.MemberList.mb_type = mbType;
                            for (int i = 0; i < members.Length; i++)
                            {
                                dp.MemberList.members.Add(members[i]);
                            }
                        }
                        else
                        {
                            dp.MemberList = null;
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (bChanged)
                {
                    catCMD.CommandText = "DELETE FROM cfg_dialplans WHERE ModTag = 2";
                    if (catCMD.ExecuteNonQuery() >= 1)
                    {
                    }
                }

                catCMD.CommandText = "UPDATE cfg_dialplans SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() >= 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }


        public static bool RemoveDialPlanFromDB(SIPPBXDialPlan dp, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_dialplans SET ModTag=2 WHERE DialPlanName = '" + dp.planName + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddDialPlanToDB(SIPPBXDialPlan dp, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            int maxIndex = 0;
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT MAX(DialPlanIndex) FROM cfg_dialplans";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        maxIndex = myReader.GetInt32(0); //When adding the first dialplan, it will have exception. So not logging out below
                    }
                }
                catch (Exception)
                {
                    //if (log != null) log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                maxIndex++;

                catCMD.CommandText = "INSERT INTO cfg_dialplans(DialPlanName, CallDirection, Caller, Called, CallPlan, DestAddress, OutboundPreStrip, OutboundPrepend, OutboundSIPAcct, OutboundCallerID, ExtenPriorityLevel, TimeLimited, TimeStartHour, TimeStartMinute, TimeEndHour, TimeEndMinute, TimeDay, ExtenMembers, ModTag, DialPlanIndex) VALUES('" + dp.planName + "', ";

                catCMD.CommandText += (dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND) ? "0, " : "1, ";
                catCMD.CommandText += "'" + dp.CallerID + "', ";
                catCMD.CommandText += "'" + dp.CalledID + "', ";

                if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT)
                {
                    catCMD.CommandText += "'AUTO_ATTENDANT', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ACD_QUEUE)
                {
                    catCMD.CommandText += "'ACD_QUEUE', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.VOICE_MAIL_BOX)
                {
                    catCMD.CommandText += "'VOICE_MAIL_BOX', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION)
                {
                    catCMD.CommandText += "'DIAL_EXTENSION', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DO_NOT_DISTURB)
                {
                    catCMD.CommandText += "'DO_NOT_DISTURB', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MONITOR_GROUP)
                {
                    catCMD.CommandText += "'MONITOR_GROUP', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.RING_GROUP)
                {
                    catCMD.CommandText += "'RING_GROUP', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CONFERENCE_ROOM)
                {
                    catCMD.CommandText += "'CONFERENCE_ROOM', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.PLUGIN_ROUTINE)
                {
                    catCMD.CommandText += "'PLUGIN_ROUTINE', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CALL_FORWARDING)
                {
                    catCMD.CommandText += "'CALL_FORWARDING', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MUSIC_SERVER)
                {
                    catCMD.CommandText += "'MUSIC_SERVER', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ECHO_TEST)
                {
                    catCMD.CommandText += "'ECHO_TEST', ";
                }
                else
                {
                    catCMD.CommandText += "'', ";
                }

                catCMD.CommandText += "'" + dp.DestAddress + "', ";
                catCMD.CommandText += "'" + dp.OutboundPreStrip + "', ";
                catCMD.CommandText += "'" + dp.OutboundPrepend + "', ";

                //2016-06-16 Used multiple sip accounts for a dialplan
                int acct = dp.OutboundSIPAcct | (dp.OutboundSIPAcct1 << 8) | (dp.OutboundSIPAcct2 << 16);
                catCMD.CommandText += "'" + acct.ToString() + "', ";

                catCMD.CommandText += "'" + dp.OutboundCallerID  + "', ";
                catCMD.CommandText += dp.ExtenPriorityLevel.ToString() + ", ";
                catCMD.CommandText += dp.TimeLimited ? "1, " : "0, ";
                catCMD.CommandText += dp.TimeStartHour.ToString() + ", ";
                catCMD.CommandText += dp.TimeStartMinute.ToString() + ", ";
                catCMD.CommandText += dp.TimeEndHour.ToString() + ", ";
                catCMD.CommandText += dp.TimeEndMinute.ToString() + ", ";

                int bitValue = 0;
                for (int j = 0; j < 7; j++)
                {
                    int bitFlag = 1 << j;
                    if (dp.TimeDays[j] == 1)
                        bitValue |= bitFlag;
                }
                catCMD.CommandText += bitValue.ToString() + ", ";


                string memlist = "";
                if (dp.MemberList != null)
                {
                    for (int i = 0; i < dp.MemberList.members.Count; i++)
                    {
                        memlist += dp.MemberList.members[i];
                        if (i != dp.MemberList.members.Count - 1)
                            memlist += ";";
                    }

                    if (dp.MemberList.mb_type == 1) //agent
                    {
                        memlist = "agt:" + memlist;
                    }
                }
                catCMD.CommandText += "'" + memlist + "', ";
                catCMD.CommandText += " 1, " + maxIndex.ToString() + ")";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool ExchangeDialPlanInDB(SIPPBXDialPlan dp, SIPPBXDialPlan dp1, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            int idx1 = 0;
            int idx2 = 0;
            int cnt = 0;
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT DialPlanName, DialPlanIndex FROM cfg_dialplans WHERE DialPlanName = '" + dp.planName + "' OR DialPlanName = '" + dp1.planName + "'";
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        cnt++;
                        if (myReader.GetString(0) == dp.planName)
                        {
                            idx1 = myReader.GetInt32(1);
                        }
                        else if (myReader.GetString(0) == dp1.planName)
                        {
                            idx2 = myReader.GetInt32(1);
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (cnt == 2)
                {
                    catCMD.CommandText = "UPDATE cfg_dialplans SET DialPlanIndex = " + idx1.ToString() + " WHERE DialPlanName = '" + dp1.planName + "'";
                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                    catCMD.CommandText = "UPDATE cfg_dialplans SET DialPlanIndex = " + idx2.ToString() + " WHERE DialPlanName = '" + dp.planName + "'";
                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }


            return true;
        }

        public static bool UpdateDialPlanInDB(SIPPBXDialPlan dp, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log/*, string dpName*/)
        {
            string sqltxt = "";

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_dialplans SET ";

                //if (dpName.Length > 0) catCMD.CommandText += "DialPlanName=" + "'" + dp.planName + "', ";

                catCMD.CommandText += "CallDirection=" + ((dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND) ? "0, " : "1, ");
                catCMD.CommandText += "Caller=" + "'" + dp.CallerID + "', ";
                catCMD.CommandText += "Called=" + "'" + dp.CalledID + "', ";

                catCMD.CommandText += "CallPlan=";
                if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT)
                {
                    catCMD.CommandText += "'AUTO_ATTENDANT', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ACD_QUEUE)
                {
                    catCMD.CommandText += "'ACD_QUEUE', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.VOICE_MAIL_BOX)
                {
                    catCMD.CommandText += "'VOICE_MAIL_BOX', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION)
                {
                    catCMD.CommandText += "'DIAL_EXTENSION', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DO_NOT_DISTURB)
                {
                    catCMD.CommandText += "'DO_NOT_DISTURB', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MONITOR_GROUP)
                {
                    catCMD.CommandText += "'MONITOR_GROUP', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.RING_GROUP)
                {
                    catCMD.CommandText += "'RING_GROUP', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CONFERENCE_ROOM)
                {
                    catCMD.CommandText += "'CONFERENCE_ROOM', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.PLUGIN_ROUTINE)
                {
                    catCMD.CommandText += "'PLUGIN_ROUTINE', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CALL_FORWARDING)
                {
                    catCMD.CommandText += "'CALL_FORWARDING', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MUSIC_SERVER)
                {
                    catCMD.CommandText += "'MUSIC_SERVER', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ECHO_TEST)
                {
                    catCMD.CommandText += "'ECHO_TEST', ";
                }
                else
                {
                    catCMD.CommandText += "'', ";
                }

                catCMD.CommandText += "DestAddress=" + "'" + dp.DestAddress + "', ";
                catCMD.CommandText += "OutboundPreStrip=" + "'" + dp.OutboundPreStrip + "', ";
                catCMD.CommandText += "OutboundPrepend=" + "'" + dp.OutboundPrepend + "', ";

                //2016-06-16 Used multiple sip accounts for a dialplan
                int acct = dp.OutboundSIPAcct | (dp.OutboundSIPAcct1 << 8) | (dp.OutboundSIPAcct2 << 16);
                catCMD.CommandText += "OutboundSIPAcct=" + "'" + acct.ToString() + "', ";

                catCMD.CommandText += "OutboundCallerID=" + "'" + dp.OutboundCallerID + "', ";
                catCMD.CommandText += "ExtenPriorityLevel=" + dp.ExtenPriorityLevel.ToString() + ", ";
                catCMD.CommandText += "TimeLimited=" + (dp.TimeLimited ? "1, " : "0, ");
                catCMD.CommandText += "TimeStartHour=" + dp.TimeStartHour.ToString() + ", ";
                catCMD.CommandText += "TimeStartMinute=" + dp.TimeStartMinute.ToString() + ", ";
                catCMD.CommandText += "TimeEndHour=" + dp.TimeEndHour.ToString() + ", ";
                catCMD.CommandText += "TimeEndMinute=" + dp.TimeEndMinute.ToString() + ", ";

                int bitValue = 0;
                for (int j = 0; j < 7; j++)
                {
                    int bitFlag = 1 << j;
                    if (dp.TimeDays[j] == 1)
                        bitValue |= bitFlag;
                }
                catCMD.CommandText += "TimeDay=" + bitValue.ToString() + ", ";


                string memlist = "";
                if (dp.MemberList != null)
                {
                    for (int i = 0; i < dp.MemberList.members.Count; i++)
                    {
                        memlist += dp.MemberList.members[i];
                        if (i != dp.MemberList.members.Count - 1)
                            memlist += ";";
                    }

                    if (dp.MemberList.mb_type == 1) //agent
                    {
                        memlist = "agt:" + memlist;
                    }
                }
                catCMD.CommandText += "ExtenMembers=" + "'" + memlist + "', ";

                catCMD.CommandText += "ModTag=1 ";

                //if(dpName.Length > 0)
                //    catCMD.CommandText += "WHERE DialPlanName = '" + dpName + "'";
                //else
                    catCMD.CommandText += "WHERE DialPlanName = '" + dp.planName + "'";

                sqltxt = catCMD.CommandText;

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(sqltxt);
                    log.LogoutText(e.ToString());
                }
            }

            return false;
        }

        public static void LoadDialplansConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.sip_dialplan.Clear();

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_dialplans WHERE ModTag = 2";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT DialPlanName, CallDirection, Caller, Called, CallPlan, DestAddress, OutboundPreStrip, OutboundPrepend, OutboundSIPAcct, OutboundCallerID, ExtenPriorityLevel, TimeLimited, TimeStartHour, TimeStartMinute, TimeEndHour, TimeEndMinute, TimeDay, ExtenMembers, ModTag, DialPlanIndex FROM cfg_dialplans ORDER BY DialPlanIndex ASC";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXDialPlan dp = new SIPPBXDialPlan();

                        dp.planName = myReader.GetString(0);
                        if (myReader.GetInt16(1) == 0)
                            dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND;
                        else
                            dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND;

                        dp.CallerID = myReader.GetString(2);
                        dp.CalledID = myReader.GetString(3);

                        if (myReader.GetString(4) == "AUTO_ATTENDANT")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT;
                        }
                        else if (myReader.GetString(4) == "VOICE_MAIL_BOX")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.VOICE_MAIL_BOX;
                        }
                        else if (myReader.GetString(4) == "ACD_QUEUE")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ACD_QUEUE;
                        }
                        else if (myReader.GetString(4) == "DIAL_EXTENSION")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION;
                        }
                        else if (myReader.GetString(4) == "DO_NOT_DISTURB")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DO_NOT_DISTURB;
                        }
                        else if (myReader.GetString(4) == "MONITOR_GROUP")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MONITOR_GROUP;
                        }
                        else if (myReader.GetString(4) == "RING_GROUP")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.RING_GROUP;
                        }
                        else if (myReader.GetString(4) == "CONFERENCE_ROOM")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CONFERENCE_ROOM;
                        }
                        else if (myReader.GetString(4) == "PLUGIN_ROUTINE")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.PLUGIN_ROUTINE;
                        }
                        else if (myReader.GetString(4) == "CALL_FORWARDING")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CALL_FORWARDING;
                        }
                        else if (myReader.GetString(4) == "MUSIC_SERVER")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MUSIC_SERVER;
                        }
                        else if (myReader.GetString(4) == "ECHO_TEST")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ECHO_TEST;
                        }

                        dp.DestAddress = myReader.GetString(5);
                        dp.OutboundPreStrip = myReader.GetString(6);
                        dp.OutboundPrepend = myReader.GetString(7);

                        int acct = myReader.GetInt32(8);
                        dp.OutboundSIPAcct = acct & 0xff;
                        dp.OutboundSIPAcct1 = (acct & 0xff00) >> 8;
                        dp.OutboundSIPAcct2 = (acct & 0xff0000) >> 16;

                        dp.OutboundCallerID = myReader.GetString(9);
                        dp.ExtenPriorityLevel = Convert.ToUInt32(myReader.GetInt32(10));
                        dp.TimeLimited = myReader.GetByte(11) == 1;
                        dp.TimeStartHour = myReader.GetInt32(12);
                        dp.TimeStartMinute = myReader.GetInt32(13);
                        dp.TimeEndHour = myReader.GetInt32(14);
                        dp.TimeEndMinute = myReader.GetInt32(15);
                        for (int j = 0; j < 7; j++)
                        {
                            int bitFlag = 1 << j;
                            if ((myReader.GetInt32(16) & bitFlag) == bitFlag)
                                dp.TimeDays[j] = 1;
                            else
                                dp.TimeDays[j] = 0;
                        }

                        string strExtnList = myReader.GetString(17);
                        int mbType = 0;
                        if (strExtnList.Contains("agt:"))
                        {
                            mbType = 1;
                            strExtnList = strExtnList.Substring(4);
                        }

                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = strExtnList.Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        if (members.Length > 0)
                        {
                            dp.MemberList = new PBXMemberList();
                            dp.MemberList.mb_type = mbType;
                            for (int i = 0; i < members.Length; i++)
                            {
                                dp.MemberList.members.Add(members[i]);
                            }
                        }

                        pbx.sip_dialplan.Add(dp);

                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "UPDATE cfg_dialplans SET ModTag = 0";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshACDConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT Name, Type, PlayMOH, MOHDir, DialplanDTMF, DialplanName, WaitTimeout, WaitTimeoutTo, VMBDTMF, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, AgentType, Agents, ModTag, VMBPassword, MaxNumOfCalls, CallForwardingType, CallForwardingPlan, PromptQueuePosition FROM cfg_huntgroups WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        bChanged = true;

                        SIPPBXACDHuntGroup hg = pbx.getACDByName(myReader.GetString(0));

                        if (myReader.GetInt16(15) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (hg != null)
                            {
                                pbx.sip_huntgroups.Remove(hg);
                            }

                            bChanged = true;
                            continue;
                        }

                        if (hg == null)
                        {
                            hg = new SIPPBXACDHuntGroup();
                            hg.hgName = myReader.GetString(0);
                            hg.bUseGroupName = pbx.use_gpname_as_dispname;
                            pbx.sip_huntgroups.Add(hg);
                            bChanged = true;
                        }

                        hg.hgType = myReader.GetInt32(1);
                        hg.playMOH = (myReader.GetByte(2) == 1);
                        hg.mohDir = myReader.GetString(3);
                        hg.dpDTMF = myReader.GetString(4);
                        hg.dpName = myReader.GetString(5);
                        hg.waitTimeout = myReader.GetInt32(6);
                        hg.waitTimeoutTo = myReader.GetString(7);
                        hg.vmbDTMF = myReader.GetString(8);

                        if (myReader.GetByte(9) == 1)
                        {
                            hg.vmb = new VoiceMailBox();
                            hg.vmb.vmbPrompt = myReader.GetString(10);
                            hg.vmb.vmbEmailAddr = myReader.GetString(11);
                            hg.vmb.maxLengthInSecond = myReader.GetInt32(12);
                            hg.vmb.vmbPassword = myReader.GetString(16);
                        }
                        else
                        {
                            hg.vmb = null;
                        }

                        hg.agentType = myReader.GetInt32(13);

                        hg.agents.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(14).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        for (int i = 0; i < members.Length; i++)
                        {
                            hg.agents.Add(members[i]);
                        }

                        hg.maxNumOfCalls = myReader.GetInt32(17);
                        hg.callForwardingType = myReader.GetInt16(18);
                        hg.callForwardingPlan = myReader.GetString(19);
                        hg.promptQueuePosition = myReader.GetInt16(20) == 1;
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (bChanged)
                {
                    catCMD.CommandText = "DELETE FROM cfg_huntgroups WHERE ModTag = 2";
                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }

                catCMD.CommandText = "UPDATE cfg_huntgroups SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                if(bChanged)
                    SIPPBXDBUtil.InitACDStatusTable(pbx, env, myConn);
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static bool RemoveACDConfigFromDB(SIPPBXACDHuntGroup hg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                //catCMD.CommandText = "DELETE FROM cfg_huntgroups WHERE Name = '" + hg.hgName + "'";
                catCMD.CommandText = "UPDATE cfg_huntgroups SET ModTag=2 WHERE Name = '" + hg.hgName + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddACDConfigToDB(SIPPBXACDHuntGroup hg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_huntgroups(Name, Type, PlayMOH, MOHDir, DialplanDTMF, DialplanName, WaitTimeout, WaitTimeoutTo, VMBDTMF, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, AgentType, Agents, ModTag, MaxNumOfCalls, CallForwardingType, CallForwardingPlan, PromptQueuePosition) VALUES('" + hg.hgName + "', ";
                catCMD.CommandText += hg.hgType.ToString() + ", ";
                catCMD.CommandText += hg.playMOH ? "1, " : "0, ";
                catCMD.CommandText += "'" + hg.mohDir + "', ";
                catCMD.CommandText += "'" + hg.dpDTMF + "', ";
                catCMD.CommandText += "'" + hg.dpName + "', ";
                catCMD.CommandText += hg.waitTimeout.ToString() + ", ";
                catCMD.CommandText += "'" + hg.waitTimeoutTo + "', ";
                catCMD.CommandText += "'" + hg.vmbDTMF + "', ";

                if (hg.vmb != null)
                {
                    catCMD.CommandText += "1, ";
                    catCMD.CommandText += "'" + hg.vmb.vmbPrompt + "', ";
                    catCMD.CommandText += "'" + hg.vmb.vmbEmailAddr + "', ";
                    catCMD.CommandText += hg.vmb.maxLengthInSecond.ToString() + ", ";
                    catCMD.CommandText += "'" + hg.vmb.vmbPassword + "', ";
                }
                else
                {
                    catCMD.CommandText += "0, ";
                    catCMD.CommandText += "'', ";
                    catCMD.CommandText += "'', ";
                    catCMD.CommandText += "0, '', ";
                }

                catCMD.CommandText += hg.agentType.ToString() + ", ";

                string agents = "";
                for (int i = 0; i < hg.agents.Count; i++)
                {
                    agents += hg.agents[i];
                    if (i != hg.agents.Count - 1)
                        agents += ";";
                }

                catCMD.CommandText += "'" + agents + "', 1, ";
                catCMD.CommandText += hg.maxNumOfCalls.ToString() + ", ";
                catCMD.CommandText += hg.callForwardingType.ToString() + ", '";
                catCMD.CommandText += hg.callForwardingPlan + "', ";
                catCMD.CommandText += hg.promptQueuePosition ? "1" : "0";
                catCMD.CommandText += ")";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateACDConfigInDB(SIPPBXACDHuntGroup hg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_huntgroups SET ";

                catCMD.CommandText += "Type=" + hg.hgType.ToString() + ", ";
                catCMD.CommandText += "PlayMOH=" + (hg.playMOH ? "1, " : "0, ");
                catCMD.CommandText += "MOHDir=" + "'" + hg.mohDir + "', ";
                catCMD.CommandText += "DialplanDTMF=" + "'" + hg.dpDTMF + "', ";
                catCMD.CommandText += "DialplanName=" + "'" + hg.dpName + "', ";
                catCMD.CommandText += "WaitTimeout=" + hg.waitTimeout.ToString() + ", ";
                catCMD.CommandText += "WaitTimeoutTo=" + "'" + hg.waitTimeoutTo + "', ";
                catCMD.CommandText += "VMBDTMF=" + "'" + hg.vmbDTMF + "', ";

                catCMD.CommandText += "VMBOn=" + ((hg.vmb != null) ? "1, " : "0, ");
                catCMD.CommandText += "VMBPrompt=" + "'" + ((hg.vmb != null) ? hg.vmb.vmbPrompt : "") + "', ";
                catCMD.CommandText += "VMBEmail=" + "'" + ((hg.vmb != null) ? hg.vmb.vmbEmailAddr : "") + "', ";
                catCMD.CommandText += "VMBMaxLength=" + ((hg.vmb != null) ? hg.vmb.maxLengthInSecond.ToString() : "0") + ", ";
                catCMD.CommandText += "VMBPassword='" + ((hg.vmb != null) ? hg.vmb.vmbPassword : "") + "', ";

                catCMD.CommandText += "AgentType=" + hg.agentType.ToString() + ", ";

                string agents = "";
                for (int i = 0; i < hg.agents.Count; i++)
                {
                    agents += hg.agents[i];
                    if (i != hg.agents.Count - 1)
                        agents += ";";
                }

                catCMD.CommandText += "Agents='" + agents + "', ModTag=1, ";
                catCMD.CommandText += "MaxNumOfCalls=" + hg.maxNumOfCalls.ToString() +", ";
                catCMD.CommandText += "CallForwardingType=" + hg.callForwardingType.ToString() +", ";
                catCMD.CommandText += "CallForwardingPlan='" + hg.callForwardingPlan +"', ";
                catCMD.CommandText += "PromptQueuePosition=" + (hg.promptQueuePosition ? "1 " : "0 ");
                catCMD.CommandText += "WHERE Name = '" + hg.hgName + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadACDConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.sip_huntgroups.Clear();

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_huntgroups WHERE ModTag = 2";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT Name, Type, PlayMOH, MOHDir, DialplanDTMF, DialplanName, WaitTimeout, WaitTimeoutTo, VMBDTMF, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, AgentType, Agents, VMBPassword, ModTag, MaxNumOfCalls, CallForwardingType, CallForwardingPlan, PromptQueuePosition FROM cfg_huntgroups";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXACDHuntGroup hg = new SIPPBXACDHuntGroup();
                        hg.bUseGroupName = pbx.use_gpname_as_dispname;

                        hg.hgName = myReader.GetString(0);
                        hg.hgType = myReader.GetInt32(1);
                        hg.playMOH = (myReader.GetByte(2) == 1);
                        hg.mohDir = myReader.GetString(3);
                        hg.dpDTMF = myReader.GetString(4);
                        hg.dpName = myReader.GetString(5);
                        hg.waitTimeout = myReader.GetInt32(6);
                        hg.waitTimeoutTo = myReader.GetString(7);
                        hg.vmbDTMF = myReader.GetString(8);

                        if (myReader.GetByte(9) == 1)
                        {
                            hg.vmb = new VoiceMailBox();
                            hg.vmb.vmbPrompt = myReader.GetString(10);
                            hg.vmb.vmbEmailAddr = myReader.GetString(11);
                            hg.vmb.maxLengthInSecond = myReader.GetInt32(12);
                            hg.vmb.vmbPassword = myReader.GetString(15);
                        }
                        else
                        {
                            hg.vmb = null;
                        }

                        hg.agentType = myReader.GetInt32(13);

                        hg.agents.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(14).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        for (int i = 0; i < members.Length; i++)
                        {
                            hg.agents.Add(members[i]);
                        }

                        hg.maxNumOfCalls = myReader.GetInt32(17);
                        hg.callForwardingType = myReader.GetInt16(18);
                        hg.callForwardingPlan = myReader.GetString(19);
                        hg.promptQueuePosition = myReader.GetInt16(20) == 1;

                        pbx.sip_huntgroups.Add(hg);

                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "UPDATE cfg_huntgroups SET ModTag = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshParkingSlotConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT Name, DTMFStr, PlayMOH, MOHDir, DialplanDTMF, DialplanName, WaitTimeout, WaitTimeoutTo, VMBDTMF, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, ModTag FROM cfg_parkingslots WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXParkingSlot ps = pbx.getParkingSlotByName(myReader.GetString(0));

                        if (myReader.GetInt16(14) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (ps != null)
                            {
                                pbx.sip_parkingslots.Remove(ps);
                            }

                            bChanged = true;
                            continue;
                        }

                        if (ps == null)
                        {
                            ps = new SIPPBXParkingSlot();
                            ps.psName = myReader.GetString(0);
                            pbx.sip_parkingslots.Add(ps);

                            bChanged = true;
                        }

                        ps.psDTMF = myReader.GetString(1);
                        ps.playMOH = (myReader.GetByte(2) == 1);
                        ps.mohDir = myReader.GetString(3);
                        ps.dpDTMF = myReader.GetString(4);
                        ps.dpName = myReader.GetString(5);
                        ps.waitTimeout = myReader.GetInt32(6);
                        ps.waitTimeoutTo = myReader.GetString(7);
                        ps.vmbDTMF = myReader.GetString(8);

                        if (myReader.GetByte(9) == 1)
                        {
                            ps.vmb = new VoiceMailBox();
                            ps.vmb.vmbPrompt = myReader.GetString(10);
                            ps.vmb.vmbEmailAddr = myReader.GetString(11);
                            ps.vmb.maxLengthInSecond = myReader.GetInt32(12);
                            ps.vmb.vmbPassword = myReader.GetString(13);
                        }
                        else
                        {
                            ps.vmb = null;
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (bChanged)
                {
                    catCMD.CommandText = "DELETE FROM cfg_parkingslots WHERE ModTag = 2";
                    if (catCMD.ExecuteNonQuery() >= 1)
                    {
                    }

                    SIPPBXDBUtil.InitParkingSlotStatusTable(pbx, env, myConn);
                }

                catCMD.CommandText = "UPDATE cfg_parkingslots SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveParkingSlotFromDB(SIPPBXParkingSlot ps, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_parkingslots SET ModTag=2 WHERE Name = '" + ps.psName + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddParkingSlotToDB(SIPPBXParkingSlot ps, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_parkingslots(Name, DTMFStr, PlayMOH, MOHDir, DialplanDTMF, DialplanName, WaitTimeout, WaitTimeoutTo, VMBDTMF, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, ModTag) VALUES('" + ps.psName + "', ";
                catCMD.CommandText += "'" + ps.psDTMF + "', ";
                catCMD.CommandText += ps.playMOH ? "1, " : "0, ";
                catCMD.CommandText += "'" + ps.mohDir + "', ";
                catCMD.CommandText += "'" + ps.dpDTMF + "', ";
                catCMD.CommandText += "'" + ps.dpName + "', ";
                catCMD.CommandText += ps.waitTimeout.ToString() + ", ";
                catCMD.CommandText += "'" + ps.waitTimeoutTo + "', ";
                catCMD.CommandText += "'" + ps.vmbDTMF + "', ";
                catCMD.CommandText += (ps.vmb != null) ? "1, " : "0, ";

                if (ps.vmb != null)
                {
                    catCMD.CommandText += "'" + ps.vmb.vmbPrompt + "', ";
                    catCMD.CommandText += "'" + ps.vmb.vmbEmailAddr + "', ";
                    catCMD.CommandText += ps.vmb.maxLengthInSecond.ToString() + ", '";
                    catCMD.CommandText += ps.vmb.vmbPassword + "', 1)";
                }
                else
                {
                    catCMD.CommandText += "'', ";
                    catCMD.CommandText += "'', ";
                    catCMD.CommandText += "0, '', 1)";
                }

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateParkingSlotInDB(SIPPBXParkingSlot ps, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_parkingslots SET ";

                catCMD.CommandText += "DTMFStr=" + "'" + ps.psDTMF + "', ";
                catCMD.CommandText += "PlayMOH=" + (ps.playMOH ? "1, " : "0, ");
                catCMD.CommandText += "MOHDir=" + "'" + ps.mohDir + "', ";
                catCMD.CommandText += "DialplanDTMF=" + "'" + ps.dpDTMF + "', ";
                catCMD.CommandText += "DialplanName=" + "'" + ps.dpName + "', ";
                catCMD.CommandText += "WaitTimeout=" + ps.waitTimeout.ToString() + ", ";
                catCMD.CommandText += "WaitTimeoutTo=" + "'" + ps.waitTimeoutTo + "', ";
                catCMD.CommandText += "VMBDTMF=" + "'" + ps.vmbDTMF + "', ";
                catCMD.CommandText += "VMBOn=" + ((ps.vmb != null) ? "1, " : "0, ");

                if (ps.vmb != null)
                {
                    catCMD.CommandText += "VMBPrompt=" + "'" + ps.vmb.vmbPrompt + "', ";
                    catCMD.CommandText += "VMBEmail=" + "'" + ps.vmb.vmbEmailAddr + "', ";
                    catCMD.CommandText += "VMBMaxLength=" + ps.vmb.maxLengthInSecond.ToString() + ", ";
                    catCMD.CommandText += "VMBPassword='" + ps.vmb.vmbPassword + "', ModTag=1 ";
                }
                else
                {
                    catCMD.CommandText += "VMBPrompt='', ";
                    catCMD.CommandText += "VMBEmail='', ";
                    catCMD.CommandText += "VMBMaxLength=0, VMBPassword='', ModTag=1 ";
                }

                catCMD.CommandText += " WHERE Name = '" + ps.psName + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadParkingSlotConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.sip_parkingslots.Clear();

            try
            {

                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_parkingslots WHERE ModTag = 2";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT Name, DTMFStr, PlayMOH, MOHDir, DialplanDTMF, DialplanName, WaitTimeout, WaitTimeoutTo, VMBDTMF, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, ModTag FROM cfg_parkingslots";
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXParkingSlot ps = new SIPPBXParkingSlot();

                        ps.psName = myReader.GetString(0);
                        ps.psDTMF = myReader.GetString(1);
                        ps.playMOH = (myReader.GetByte(2) == 1);
                        ps.mohDir = myReader.GetString(3);
                        ps.dpDTMF = myReader.GetString(4);
                        ps.dpName = myReader.GetString(5);
                        ps.waitTimeout = myReader.GetInt32(6);
                        ps.waitTimeoutTo = myReader.GetString(7);
                        ps.vmbDTMF = myReader.GetString(8);

                        if (myReader.GetByte(9) == 1)
                        {
                            ps.vmb = new VoiceMailBox();
                            ps.vmb.vmbPrompt = myReader.GetString(10);
                            ps.vmb.vmbEmailAddr = myReader.GetString(11);
                            ps.vmb.maxLengthInSecond = myReader.GetInt32(12);
                            ps.vmb.vmbPassword = myReader.GetString(13);
                        }
                        else
                        {
                            ps.vmb = null;
                        }

                        pbx.sip_parkingslots.Add(ps);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }


                catCMD.CommandText = "UPDATE cfg_parkingslots SET ModTag = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshRingGroupConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool bChanged = false;
            SIPPBXRingGroup rg = null;

            List<SIPPBXRingGroup> tempListRingGroup = new List<SIPPBXRingGroup>();

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT Name, Type, PlayMOH, MOHDir, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, AnswerCallFirst, ModTag FROM cfg_ringgroups WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        rg = pbx.getRingGroupByName(myReader.GetString(0));

                        if (myReader.GetInt16(10) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (rg != null)
                                pbx.sip_ringgroups.Remove(rg);

                            bChanged = true;
                            continue;
                        }

                        if (rg == null)
                        {
                            rg = new SIPPBXRingGroup();
                            rg.gpName = myReader.GetString(0);
                            rg.bUseGroupName = pbx.use_gpname_as_dispname;
                            pbx.sip_ringgroups.Add(rg);

                            bChanged = true;
                        }

                        rg.ringType = myReader.GetInt32(1);
                        rg.playMOH = (myReader.GetByte(2) == 1);
                        rg.mohDir = myReader.GetString(3);
                        rg.bAnswerCallFirst = (myReader.GetByte(9) == 1);

                        if (myReader.GetByte(4) == 1)
                        {
                            rg.vmb = new VoiceMailBox();
                            rg.vmb.vmbPrompt = myReader.GetString(5);
                            rg.vmb.vmbEmailAddr = myReader.GetString(6);
                            rg.vmb.maxLengthInSecond = myReader.GetInt32(7);
                            rg.vmb.vmbPassword = myReader.GetString(8);
                        }
                        else
                        {
                            rg.vmb = null;
                        }

                        tempListRingGroup.Add(rg);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (tempListRingGroup.Count > 0)
                {
                    for (int i = 0; i < tempListRingGroup.Count; i++)
                    {
                        rg = tempListRingGroup[i];

                        rg.destList.Clear();

                        catCMD.CommandText = "SELECT * FROM cfg_dests WHERE BelongTo = '" + rg.gpName + "'";
                        myReader = catCMD.ExecuteReader();

                        try
                        {
                            while (myReader.Read())
                            {
                                SIPPBXDest dest = new SIPPBXDest();

                                dest.DestType = myReader.GetInt32(0);
                                dest.DestAddr = myReader.GetString(1);
                                dest.RingTimeout = myReader.GetInt32(2);

                                rg.destList.Add(dest);
                            }
                        }
                        catch (Exception e)
                        {
                            if (log != null)
                                log.LogoutText(e.ToString());
                        }
                        finally
                        {
                            myReader.Close();
                        }
                    }
                }

                if (bChanged)
                {
                    catCMD.CommandText = "DELETE FROM cfg_ringgroups WHERE ModTag = 2";
                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }

                catCMD.CommandText = "UPDATE cfg_ringgroups SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveRingGroupFromDB(SIPPBXRingGroup rg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_ringgroups SET ModTag=2 WHERE Name = '" + rg.gpName + "'";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                    catCMD.CommandText = "DELETE FROM cfg_dests WHERE BelongTo = '" + rg.gpName + "'";
                    catCMD.ExecuteNonQuery();
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddRingGroupToDB(SIPPBXRingGroup rg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_ringgroups(Name, Type, PlayMOH, MOHDir, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, AnswerCallFirst, ModTag) VALUES('" + rg.gpName + "', ";

                catCMD.CommandText += rg.ringType.ToString() + ", ";
                catCMD.CommandText += rg.playMOH ? "1, " : "0, ";
                catCMD.CommandText += "'" + rg.mohDir + "', ";
                catCMD.CommandText += (rg.vmb != null) ? "1, " : "0, ";

                if (rg.vmb != null)
                {
                    catCMD.CommandText += "'" + rg.vmb.vmbPrompt + "', ";
                    catCMD.CommandText += "'" + rg.vmb.vmbEmailAddr + "', ";
                    catCMD.CommandText += rg.vmb.maxLengthInSecond.ToString() + ", '";
                    catCMD.CommandText += rg.vmb.vmbPassword + "', ";
                }
                else
                {
                    catCMD.CommandText += "'', ";
                    catCMD.CommandText += "'', ";
                    catCMD.CommandText += "0, '', ";
                }

                catCMD.CommandText += rg.bAnswerCallFirst ? "1, " : "0, ";

                catCMD.CommandText += "1)";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    catCMD.CommandText = "DELETE FROM cfg_dests WHERE BelongTo = '" + rg.gpName + "'";
                    catCMD.ExecuteNonQuery();

                    for (int i = 0; i < rg.destList.Count; i++)
                    {
                        catCMD.CommandText = "INSERT INTO cfg_dests VALUES(";
                        catCMD.CommandText += rg.destList[i].DestType.ToString() + ", ";
                        catCMD.CommandText += "'" + rg.destList[i].DestAddr + "', ";
                        catCMD.CommandText += rg.destList[i].RingTimeout.ToString() + ", ";
                        catCMD.CommandText += "'" + rg.gpName + "')";
                        if (catCMD.ExecuteNonQuery() != 1)
                        {
                        }
                    }
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateRingGroupInDB(SIPPBXRingGroup rg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_ringgroups SET ";

                catCMD.CommandText += "Type=" + rg.ringType.ToString() + ", ";
                catCMD.CommandText += "PlayMOH=" + (rg.playMOH ? "1, " : "0, ");
                catCMD.CommandText += "MOHDir=" + "'" + rg.mohDir + "', ";
                catCMD.CommandText += "VMBOn=" + ((rg.vmb != null) ? "1, " : "0, ");

                if (rg.vmb != null)
                {
                    catCMD.CommandText += "VMBPrompt=" + "'" + rg.vmb.vmbPrompt + "', ";
                    catCMD.CommandText += "VMBEmail=" + "'" + rg.vmb.vmbEmailAddr + "', ";
                    catCMD.CommandText += "VMBMaxLength=" + rg.vmb.maxLengthInSecond.ToString() + ", ";
                    catCMD.CommandText += "VMBPassword='" + rg.vmb.vmbPassword + "', ";
                }
                else
                {
                    catCMD.CommandText += "VMBPrompt='', ";
                    catCMD.CommandText += "VMBEmail='', ";
                    catCMD.CommandText += "VMBMaxLength=0, ";
                    catCMD.CommandText += "VMBPassword='', ";
                }

                catCMD.CommandText += "AnswerCallFirst=" + (rg.bAnswerCallFirst ? "1, " : "0, ");

                catCMD.CommandText += " ModTag=1 WHERE Name = '" + rg.gpName + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    catCMD.CommandText = "DELETE FROM cfg_dests WHERE BelongTo = '" + rg.gpName + "'";
                    catCMD.ExecuteNonQuery();

                    for (int i = 0; i < rg.destList.Count; i++)
                    {
                        catCMD.CommandText = "INSERT INTO cfg_dests VALUES(";
                        catCMD.CommandText += rg.destList[i].DestType.ToString() + ", ";
                        catCMD.CommandText += "'" + rg.destList[i].DestAddr + "', ";
                        catCMD.CommandText += rg.destList[i].RingTimeout.ToString() + ", ";
                        catCMD.CommandText += "'" + rg.gpName + "')";
                        if (catCMD.ExecuteNonQuery() != 1)
                        {
                        }
                    }

                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadRingGroupConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            SIPPBXRingGroup rg = null;
            List<SIPPBXRingGroup> tempListRingGroup = new List<SIPPBXRingGroup>();

            pbx.sip_ringgroups.Clear();

            try
            {

                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_ringgroups WHERE ModTag = 2";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT Name, Type, PlayMOH, MOHDir, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, AnswerCallFirst, ModTag FROM cfg_ringgroups";
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        rg = new SIPPBXRingGroup();

                        rg.gpName = myReader.GetString(0);
                        rg.bUseGroupName = pbx.use_gpname_as_dispname;

                        rg.ringType = myReader.GetInt32(1);
                        rg.playMOH = (myReader.GetByte(2) == 1);
                        rg.mohDir = myReader.GetString(3);

                        if (myReader.GetByte(4) == 1)
                        {
                            rg.vmb = new VoiceMailBox();
                            rg.vmb.vmbPrompt = myReader.GetString(5);
                            rg.vmb.vmbEmailAddr = myReader.GetString(6);
                            rg.vmb.maxLengthInSecond = myReader.GetInt32(7);
                            rg.vmb.vmbPassword = myReader.GetString(8);
                        }
                        else
                        {
                            rg.vmb = null;
                        }

                        rg.bAnswerCallFirst = (myReader.GetByte(9) == 1);

                        tempListRingGroup.Add(rg);

                        pbx.sip_ringgroups.Add(rg);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (tempListRingGroup.Count > 0)
                {
                    for (int i = 0; i < tempListRingGroup.Count; i++)
                    {
                        rg = tempListRingGroup[i];

                        rg.destList.Clear();

                        catCMD.CommandText = "SELECT * FROM cfg_dests WHERE BelongTo = '" + rg.gpName + "'";
                        myReader = catCMD.ExecuteReader();

                        try
                        {
                            while (myReader.Read())
                            {
                                SIPPBXDest dest = new SIPPBXDest();

                                dest.DestType = myReader.GetInt32(0);
                                dest.DestAddr = myReader.GetString(1);
                                dest.RingTimeout = myReader.GetInt32(2);

                                rg.destList.Add(dest);
                            }
                        }
                        catch (Exception e)
                        {
                            if (log != null)
                                log.LogoutText(e.ToString());
                        }
                        finally
                        {
                            myReader.Close();
                        }
                    }
                }

                catCMD.CommandText = "UPDATE cfg_ringgroups SET ModTag = 0 WHERE ModTag != 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void UpdateLoadBalanceConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_dests WHERE BelongTo = 'LoadBalance'";
                catCMD.ExecuteNonQuery();
                if (pbx.lb_on)
                {
                    for (int i = 0; i < pbx.lb_addrs.Count; i++)
                    {
                        catCMD.CommandText = "INSERT INTO cfg_dests VALUES(";
                        catCMD.CommandText += pbx.lb_addrs[i].DestType.ToString() + ", ";
                        catCMD.CommandText += "' " + pbx.lb_addrs[i].DestAddr + "', ";
                        catCMD.CommandText += pbx.lb_addrs[i].RingTimeout.ToString() + ", 'LoadBalance')";
                        if (catCMD.ExecuteNonQuery() == 1)
                        {
                        }
                    }
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void LoadLoadBalanceConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.lb_addrs.Clear();

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT * FROM cfg_dests WHERE BelongTo = 'LoadBalance'";
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    if (myReader.HasRows)
                    {
                        pbx.lb_on = true;
                        while (myReader.Read())
                        {
                            SIPPBXDest dest = new SIPPBXDest();

                            dest.DestType = myReader.GetInt32(0);
                            dest.DestAddr = myReader.GetString(1);
                            dest.RingTimeout = myReader.GetInt32(2);

                            pbx.lb_addrs.Add(dest);
                        }
                    }
                    else
                    {
                        pbx.lb_on = false;
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshMonitorGroupConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT Name, Number, PasswordPrompt, Password, KeyBargeIn, KeyBargeOut, KeyWhisper, ExtenPrompt, ExtenAll, Extensions, ModTag FROM cfg_monitorgroups WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXMonitorGroup mg = pbx.getMonitorGroupByName(myReader.GetString(0));

                        if (myReader.GetInt16(10) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (mg != null)
                            {
                                pbx.sip_monitorgroups.Remove(mg);
                            }

                            bChanged = true;
                            continue;
                        }

                        if (mg == null)
                        {
                            mg = new SIPPBXMonitorGroup();
                            mg.mgName = myReader.GetString(0);
                            pbx.sip_monitorgroups.Add(mg);
                            bChanged = true;
                        }

                        mg.mgNumber = myReader.GetString(1);
                        mg.mgPasswordPrompt = myReader.GetString(2);
                        mg.mgPassword = myReader.GetString(3);
                        mg.mgKeyBargeIn = myReader.GetString(4);
                        mg.mgKeyOut = myReader.GetString(5);
                        mg.mgKeyWhisper = myReader.GetString(6);
                        mg.mgExtenPrompt = myReader.GetString(7);
                        mg.mgAllExtens = (myReader.GetByte(8) == 1);

                        mg.mgExtenList.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(9).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        for (int i = 0; i < members.Length; i++)
                        {
                            mg.mgExtenList.Add(members[i]);
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (bChanged)
                {
                    catCMD.CommandText = "DELETE FROM cfg_monitorgroups WHERE ModTag = 2";
                    if (catCMD.ExecuteNonQuery() >= 1)
                    {
                    }
                }

                catCMD.CommandText = "UPDATE cfg_monitorgroups SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() >= 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveMonitorGroupFromDB(SIPPBXMonitorGroup mg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_monitorgroups SET ModTag=2 WHERE Name = '" + mg.mgName + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddMonitorGroupToDB(SIPPBXMonitorGroup mg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_monitorgroups(Name, Number, PasswordPrompt, Password, KeyBargeIn, KeyBargeOut, KeyWhisper, ExtenPrompt, ExtenAll, Extensions, ModTag) VALUES('" + mg.mgName + "', ";
                catCMD.CommandText += "'" + mg.mgNumber + "', ";
                catCMD.CommandText += "'" + mg.mgPasswordPrompt + "', ";
                catCMD.CommandText += "'" + mg.mgPassword + "', ";
                catCMD.CommandText += "'" + mg.mgKeyBargeIn + "', ";
                catCMD.CommandText += "'" + mg.mgKeyOut + "', ";
                catCMD.CommandText += "'" + mg.mgKeyWhisper + "', ";
                catCMD.CommandText += "'" + mg.mgExtenPrompt + "', ";
                catCMD.CommandText += mg.mgAllExtens ? "1, " : "0, ";

                string sExtens = "";
                for (int i = 0; i < mg.mgExtenList.Count; i++)
                {
                    sExtens += mg.mgExtenList[i];
                    if (i != mg.mgExtenList.Count - 1)
                        sExtens += ";";
                }
                catCMD.CommandText += "'" + sExtens + "', ";

                catCMD.CommandText += "1)";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateMonitorGroupInDB(SIPPBXMonitorGroup mg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_monitorgroups SET ";

                catCMD.CommandText += "Number=" + "'" + mg.mgNumber + "', ";
                catCMD.CommandText += "PasswordPrompt=" + "'" + mg.mgPasswordPrompt + "', ";
                catCMD.CommandText += "Password=" + "'" + mg.mgPassword + "', ";
                catCMD.CommandText += "KeyBargeIn=" + "'" + mg.mgKeyBargeIn + "', ";
                catCMD.CommandText += "KeyBargeOut=" + "'" + mg.mgKeyOut + "', ";
                catCMD.CommandText += "KeyWhisper=" + "'" + mg.mgKeyWhisper + "', ";
                catCMD.CommandText += "ExtenPrompt=" + "'" + mg.mgExtenPrompt + "', ";
                catCMD.CommandText += "ExtenAll=" + (mg.mgAllExtens ? "1, " : "0, ");

                string sExtens = "";
                for (int i = 0; i < mg.mgExtenList.Count; i++)
                {
                    sExtens += mg.mgExtenList[i];
                    if (i != mg.mgExtenList.Count - 1)
                        sExtens += ";";
                }
                catCMD.CommandText += "Extensions='" + sExtens + "', ";

                catCMD.CommandText += " ModTag=1 WHERE Name = '" + mg.mgName + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }


        public static void LoadMonitorGroupConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.sip_monitorgroups.Clear();

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_monitorgroups WHERE ModTag = 2";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT Name, Number, PasswordPrompt, Password, KeyBargeIn, KeyBargeOut, KeyWhisper, ExtenPrompt, ExtenAll, Extensions, ModTag FROM cfg_monitorgroups";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXMonitorGroup mg = new SIPPBXMonitorGroup();

                        mg.mgExtenPrompt = pbx.please_enter_extension_number_dir;
                        mg.mgPasswordPrompt = pbx.please_enter_password_dir;

                        mg.mgName = myReader.GetString(0);
                        mg.mgNumber = myReader.GetString(1);
                        mg.mgPasswordPrompt = myReader.GetString(2);
                        mg.mgPassword = myReader.GetString(3);
                        mg.mgKeyBargeIn = myReader.GetString(4);
                        mg.mgKeyOut = myReader.GetString(5);
                        mg.mgKeyWhisper = myReader.GetString(6);
                        mg.mgExtenPrompt = myReader.GetString(7);
                        mg.mgAllExtens = (myReader.GetByte(8) == 1);

                        mg.mgExtenList.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(9).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        for (int i = 0; i < members.Length; i++)
                        {
                            mg.mgExtenList.Add(members[i]);
                        }

                        pbx.sip_monitorgroups.Add(mg);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "UPDATE cfg_monitorgroups SET ModTag = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshAgentsConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT Name, Code, Password, RecordCall, AtExten, LogInTime, LogOutTime, ModTag, SkillLevel, Paused FROM cfg_agents WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                while (myReader.Read())
                {
                    bChanged = true;

                    SIPPBXAgent agent = pbx.getAgentByCode(myReader.GetString(1));

                    if (myReader.GetInt16(7) == 2)
                    {
                        //ModTag == 2, need remove.
                        if (agent != null)
                        {
                            pbx.sip_agents.Remove(agent);
                        }

                        bChanged = true;
                        continue;
                    }

                    if (agent == null)
                    {
                        agent = new SIPPBXAgent();
                        agent.Code = myReader.GetString(1);
                        pbx.sip_agents.Add(agent);
                        bChanged = true;
                    }

                    agent.Name = myReader.GetString(0);
                    agent.Password = myReader.GetString(2);
                    agent.RecordCall = (myReader.GetByte(3) == 1);

                    string extn_username = myReader.GetString(4);
                    if (extn_username.Contains(";"))
                    {
                        char[] delimiters = new char[] { ';', ',', ' ', '|' };
                        string[] members = extn_username.Split(delimiters, StringSplitOptions.None);
                        extn_username = members[0];
                        for (int i = 1; i < members.Length; i++)
                        {
                            if(members[i].Length > 0)
                                agent.LoggedInACD.Add(members[i]);
                        }
                    }

                    if (extn_username != "")
                    {
                        SIPPBXExten extn = pbx.getExtensionByName(extn_username);
                        if (extn != null)
                        {
                            agent.AtExten = extn;
                            extn.Agent = agent;
                        }
                        else
                            agent.AtExten = null;
                    }
                    else
                        agent.AtExten = null;

                    agent.LogInTime = myReader.GetDateTime(5);
                    agent.LogOutTime = myReader.GetDateTime(6);
                    agent.SkillLevel = myReader.GetInt16(8);

                    agent.Paused = (myReader.GetByte(9) == 1);

                }

                myReader.Close();

                if (bChanged)
                {
                    catCMD.CommandText = "DELETE FROM cfg_agents WHERE ModTag = 2";
                    if (catCMD.ExecuteNonQuery() >= 1)
                    {
                    }

                    SIPPBXDBUtil.InitAgentStatusTable(pbx, env, myConn);
                }

                catCMD.CommandText = "UPDATE cfg_agents SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() >= 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveAgentFromDB(SIPPBXAgent agent, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_agents SET ModTag=2 WHERE Code = '" + agent.Code + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddAgentToDB(SIPPBXAgent agent, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_agents(Name, Code, Password, RecordCall, AtExten, LogInTime, LogOutTime, ModTag, SkillLevel, Paused) VALUES('" + agent.Name + "', ";
                catCMD.CommandText += "'" + agent.Code + "', ";
                catCMD.CommandText += "'" + agent.Password + "', ";
                catCMD.CommandText += agent.RecordCall ? "1, " : "0, ";
                catCMD.CommandText += "'', '', '', 1, " + agent.SkillLevel.ToString() + ", 0)";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateAgentPausedStatusIntoDB(SIPPBXAgent agent, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_agents SET ";

                if(agent.Paused)
                    catCMD.CommandText += "Paused=1";
                catCMD.CommandText += " WHERE Code = '" + agent.Code + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateAgentStatusInDB(SIPPBXAgent agent, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_agents SET ";

                if(agent.Paused)
                    catCMD.CommandText += "Paused=1, ";
                else
                    catCMD.CommandText += "Paused=0, ";

                string atExtn = "";
                if (agent.AtExten != null)
                {
                    atExtn += agent.AtExten.UserName;
                    for (int i = 0; i < agent.LoggedInACD.Count; i++)
                    {
                        atExtn += ";" + agent.LoggedInACD[i];
                    }
                    atExtn.TrimEnd(';');
                }
                catCMD.CommandText += "AtExten='" + atExtn + "', ";

                catCMD.CommandText += "LogInTime='" + SIPPBXWinUtil.GetSQLDateTime(agent.LogInTime) + "', ";
                catCMD.CommandText += "LogOutTime='" +SIPPBXWinUtil.GetSQLDateTime(agent.LogOutTime) + "' ";

                catCMD.CommandText += " WHERE Code = '" + agent.Code + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateAgentInDB(SIPPBXAgent agent, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_agents SET ";

                catCMD.CommandText += "Name='" + agent.Name + "', ";
                catCMD.CommandText += "Password='" + agent.Password + "', ";
                catCMD.CommandText += "RecordCall=" + (agent.RecordCall ? "1, " : "0, ");
                catCMD.CommandText += "SkillLevel=" + agent.SkillLevel.ToString() + ", ";
                catCMD.CommandText += "ModTag=1 ";

                catCMD.CommandText += " WHERE Code = '" + agent.Code + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadAgentsConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.sip_agents.Clear();

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_agents WHERE ModTag = 2";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT Name, Code, Password, RecordCall, AtExten, LogInTime, LogOutTime, ModTag, SkillLevel, Paused FROM cfg_agents";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXAgent agent = new SIPPBXAgent();
                        agent.Name = myReader.GetString(0);
                        agent.Code = myReader.GetString(1);
                        agent.Password = myReader.GetString(2);
                        agent.RecordCall = (myReader.GetByte(3) == 1);

                        string extn_username = myReader.GetString(4);
                        if (extn_username.Contains(";"))
                        {
                            char[] delimiters = new char[] { ';', ',', ' ', '|' };
                            string[] members = extn_username.Split(delimiters, StringSplitOptions.None);
                            extn_username = members[0];
                            for (int i = 1; i < members.Length; i++)
                            {
                                if(members[i].Length > 0)
                                    agent.LoggedInACD.Add(members[i]);
                            }
                        }

                        if (extn_username != "")
                        {
                            SIPPBXExten extn = pbx.getExtensionByName(extn_username);
                            if (extn != null)
                            {
                                agent.AtExten = extn;
                                extn.Agent = agent;
                                agent.Paused = (myReader.GetByte(9) == 1);
                            }
                        }

                        agent.LogInTime = myReader.GetDateTime(5);
                        agent.LogOutTime = myReader.GetDateTime(6);

                        agent.SkillLevel = myReader.GetInt16(8);

                        pbx.sip_agents.Add(agent);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "UPDATE cfg_agents SET ModTag = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshIVRsConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool bChanged = false;
            SIPPBXIVR ivr = null;
            List<SIPPBXIVR> tempListIVR = new List<SIPPBXIVR>();

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT MenuName, Action, MenuSound, TransferTo, MenuDTMFWaitMS, DTMFAcceptExtenWaitMS, DTMFAcceptExten, ModTag FROM cfg_ivrs WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        ivr = pbx.getIVRMenuByName(myReader.GetString(0));

                        if (myReader.GetInt16(7) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (ivr != null)
                            {
                                pbx.sip_ivrs.Remove(ivr);
                            }

                            bChanged = true;
                            continue;
                        }

                        if (ivr == null)
                        {
                            ivr = new SIPPBXIVR();
                            ivr.name = myReader.GetString(0);
                            pbx.sip_ivrs.Add(ivr);

                            bChanged = true;
                        }

                        ivr.action = myReader.GetInt32(1);
                        ivr.sound_file = myReader.GetString(2);
                        ivr.transfer_to = myReader.GetString(3);
                        ivr.menu_dtmf_wait_ms = myReader.GetInt32(4);
                        ivr.dtmf_accept_exten_wait_ms = myReader.GetInt32(5);
                        ivr.dtmf_accept_exten = (myReader.GetByte(6) == 1);

                        tempListIVR.Add(ivr);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                for (int i = 0; i < tempListIVR.Count; i++)
                {
                    ivr = tempListIVR[i];

                    ivr.dtmfs.Clear();

                    catCMD.CommandText = "SELECT * FROM cfg_ivrsubitems WHERE BelongTo = '" + ivr.name + "'";
                    myReader = catCMD.ExecuteReader();

                    try
                    {
                        while (myReader.Read())
                        {
                            SIPPBXDTMF dtmf = new SIPPBXDTMF();
                            dtmf.IVRMenu = new SIPPBXIVR();
                            dtmf.DTMFStr = myReader.GetString(0);
                            dtmf.IVRMenu.action = myReader.GetInt32(1);
                            dtmf.IVRMenu.sound_file = myReader.GetString(2);
                            dtmf.IVRMenu.transfer_to = myReader.GetString(3);
                            ivr.dtmfs.Add(dtmf);
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }

                if (bChanged)
                {
                    catCMD.CommandText = "DELETE FROM cfg_ivrs WHERE ModTag = 2";
                    if (catCMD.ExecuteNonQuery() >= 1)
                    {
                    }
                }

                catCMD.CommandText = "UPDATE cfg_ivrs SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() >= 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveIVRFromDB(SIPPBXIVR ivr, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_ivrs SET ModTag=2 WHERE MenuName = '" + ivr.name + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    catCMD.CommandText = "DELETE FROM cfg_ivrsubitems WHERE BelongTo = '" + ivr.name + "'";
                    catCMD.ExecuteNonQuery();
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddIVRToDB(SIPPBXIVR ivr, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_ivrs(MenuName, Action, MenuSound, TransferTo, MenuDTMFWaitMS, DTMFAcceptExtenWaitMS, DTMFAcceptExten, ModTag) VALUES('" + ivr.name + "', ";

                catCMD.CommandText += ivr.action.ToString() + ", ";
                catCMD.CommandText += "'" + ivr.sound_file + "', ";
                catCMD.CommandText += "'" + ivr.transfer_to + "', ";
                catCMD.CommandText += ivr.menu_dtmf_wait_ms.ToString() + ", ";
                catCMD.CommandText += ivr.dtmf_accept_exten_wait_ms.ToString() + ", ";
                catCMD.CommandText += ivr.dtmf_accept_exten ? "1, " : "0, ";

                catCMD.CommandText += "1)";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    catCMD.CommandText = "DELETE FROM cfg_ivrsubitems WHERE BelongTo = '" + ivr.name + "'";
                    catCMD.ExecuteNonQuery();

                    for (int i = 0; i < ivr.dtmfs.Count; i++)
                    {
                        catCMD.CommandText = "INSERT INTO cfg_ivrsubitems VALUES(";
                        catCMD.CommandText += "'" + ivr.dtmfs[i].DTMFStr + "', ";
                        catCMD.CommandText += ivr.dtmfs[i].IVRMenu.action.ToString() + ", ";
                        catCMD.CommandText += "'" + ivr.dtmfs[i].IVRMenu.sound_file + "', ";
                        catCMD.CommandText += "'" + ivr.dtmfs[i].IVRMenu.transfer_to + "', ";
                        catCMD.CommandText += "'" + ivr.name + "')";
                        if (catCMD.ExecuteNonQuery() != 1)
                        {
                        }
                    }

                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateIVRInDB(SIPPBXIVR ivr, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_ivrs SET ";

                catCMD.CommandText += "Action=" + ivr.action.ToString() + ", ";
                catCMD.CommandText += "MenuSound=" + "'" + ivr.sound_file + "', ";
                catCMD.CommandText += "TransferTo=" + "'" + ivr.transfer_to + "', ";
                catCMD.CommandText += "MenuDTMFWaitMS=" + ivr.menu_dtmf_wait_ms.ToString() + ", ";
                catCMD.CommandText += "DTMFAcceptExtenWaitMS=" + ivr.dtmf_accept_exten_wait_ms.ToString() + ", ";
                catCMD.CommandText += "DTMFAcceptExten=" + (ivr.dtmf_accept_exten ? "1, " : "0, ");

                catCMD.CommandText += " ModTag=1 WHERE MenuName = '" + ivr.name + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    catCMD.CommandText = "DELETE FROM cfg_ivrsubitems WHERE BelongTo = '" + ivr.name + "'";
                    catCMD.ExecuteNonQuery();

                    for (int i = 0; i < ivr.dtmfs.Count; i++)
                    {
                        catCMD.CommandText = "INSERT INTO cfg_ivrsubitems VALUES(";
                        catCMD.CommandText += "'" + ivr.dtmfs[i].DTMFStr + "', ";
                        catCMD.CommandText += ivr.dtmfs[i].IVRMenu.action.ToString() + ", ";
                        catCMD.CommandText += "'" + ivr.dtmfs[i].IVRMenu.sound_file + "', ";
                        catCMD.CommandText += "'" + ivr.dtmfs[i].IVRMenu.transfer_to + "', ";
                        catCMD.CommandText += "'" + ivr.name + "')";
                        if (catCMD.ExecuteNonQuery() != 1)
                        {
                        }
                    }
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadIVRsConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.sip_ivrs.Clear();
            SIPPBXIVR ivr = null;
            List<SIPPBXIVR> tempListIVR = new List<SIPPBXIVR>();

            try
            {

                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_ivrs WHERE ModTag = 2";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT MenuName, Action, MenuSound, TransferTo, MenuDTMFWaitMS, DTMFAcceptExtenWaitMS, DTMFAcceptExten, ModTag FROM cfg_ivrs";
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        ivr = new SIPPBXIVR();
                        ivr.name = myReader.GetString(0);
                        ivr.action = myReader.GetInt32(1);
                        ivr.sound_file = myReader.GetString(2);
                        ivr.transfer_to = myReader.GetString(3);
                        ivr.menu_dtmf_wait_ms = myReader.GetInt32(4);
                        ivr.dtmf_accept_exten_wait_ms = myReader.GetInt32(5);
                        ivr.dtmf_accept_exten = (myReader.GetByte(6) == 1);

                        tempListIVR.Add(ivr);

                        pbx.sip_ivrs.Add(ivr);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                for (int i = 0; i < tempListIVR.Count; i++)
                {
                    ivr = tempListIVR[i];

                    ivr.dtmfs.Clear();

                    catCMD.CommandText = "SELECT * FROM cfg_ivrsubitems WHERE BelongTo = '" + ivr.name + "'";
                    myReader = catCMD.ExecuteReader();

                    try
                    {
                        while (myReader.Read())
                        {
                            SIPPBXDTMF dtmf = new SIPPBXDTMF();
                            dtmf.IVRMenu = new SIPPBXIVR();
                            dtmf.DTMFStr = myReader.GetString(0);
                            dtmf.IVRMenu.action = myReader.GetInt32(1);
                            dtmf.IVRMenu.sound_file = myReader.GetString(2);
                            dtmf.IVRMenu.transfer_to = myReader.GetString(3);
                            ivr.dtmfs.Add(dtmf);
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }

                catCMD.CommandText = "UPDATE cfg_ivrs SET ModTag = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshAutoDialerTasks(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT Name, Enabled, TypeCode, SIPAcct, DialPlan, RingTimeout, MaxSimCalls, ModTag, EnableDetect, DiscAfterDetect FROM cfg_autodialertasks WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        AutoDialerTask task = pbx.getAutoDialerTaskByName(myReader.GetString(0));

                        if (myReader.GetInt16(7) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (task != null)
                            {
                                pbx.auto_dialer_tasks.Remove(task);
                            }

                            bChanged = true;
                            continue;
                        }

                        if (task == null)
                        {
                            task = new AutoDialerTask();
                            task.task_name = myReader.GetString(0);
                            pbx.auto_dialer_tasks.Add(task);
                            bChanged = true;
                        }

                        task.isOn = (myReader.GetByte(1) == 1);
                        task.type_code = myReader.GetInt16(2);
                        task.sip_acc = myReader.GetString(3);
                        task.dial_plan = myReader.GetString(4);
                        task.m_ringTimeout = myReader.GetInt32(5);
                        task.m_maxSimCalls = myReader.GetInt32(6);
                        task.m_bEnableDetect = (myReader.GetByte(8) == 1);
                        task.m_bDiscAfterDetect = (myReader.GetByte(9) == 1);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (bChanged)
                {
                    catCMD.CommandText = "DELETE FROM cfg_autodialertasks WHERE ModTag = 2";
                    if (catCMD.ExecuteNonQuery() >= 1)
                    {
                    }
                }

                catCMD.CommandText = "UPDATE cfg_autodialertasks SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() >= 1)
                {
                }                
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }
        /*
                public static bool AddAutoDialerTaskToDB(AutoDialerTask task, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
                {
                    try
                    {
                        SqlCommand catCMD = myConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        catCMD.CommandText = "INSERT INTO cfg_autodialertasks VALUES('" + task.task_name + "', ";
                        catCMD.CommandText += task.isOn ? "1, " : "0, ";
                        catCMD.CommandText += task.type_code.ToString() + ", ";
                        catCMD.CommandText += "'" + task.sip_acc + "', ";
                        catCMD.CommandText += "'" + task.dial_plan + "', ";
                        catCMD.CommandText += task.m_ringTimeout.ToString() + ", ";
                        catCMD.CommandText += task.m_maxSimCalls.ToString() + ", ";
                        catCMD.CommandText += "1)";

                        if (catCMD.ExecuteNonQuery() == 1)
                            return true;
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }

                    return false;
                }
        */

        public static bool AddAutoDialerTasksToDB(AutoDialerTask task, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_autodialertasks(Name, Enabled, TypeCode, SIPAcct, DialPlan, RingTimeout, MaxSimCalls, ModTag, EnableDetect, DiscAfterDetect) VALUES('" + task.task_name + "', ";
                catCMD.CommandText += task.isOn ? "1, " : "0, ";
                catCMD.CommandText += task.type_code.ToString() + ", ";
                catCMD.CommandText += "'" + task.sip_acc.ToString() + "', ";
                catCMD.CommandText += "'" + task.dial_plan.ToString() + "', ";
                catCMD.CommandText += task.m_ringTimeout.ToString() + ", ";
                catCMD.CommandText += task.m_maxSimCalls.ToString() + ", ";
                catCMD.CommandText += "1, ";
                catCMD.CommandText += task.m_bEnableDetect? "1, " : "0, ";
                catCMD.CommandText += task.m_bDiscAfterDetect? "1)" : "0)";


                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool RemoveAutoDialerTaskFromDB(AutoDialerTask task, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_autodialertasks SET ModTag=2 WHERE Name = '" + task.task_name + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateAutoDialerTaskInDB(AutoDialerTask task, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_autodialertasks SET ";

                catCMD.CommandText += "Enabled=" + (task.isOn ? "1, " : "0, ");
                catCMD.CommandText += "TypeCode=" + task.type_code.ToString() + ", ";
                catCMD.CommandText += "SIPAcct=" + "'" + task.sip_acc + "', ";
                catCMD.CommandText += "DialPlan=" + "'" + task.dial_plan + "', ";
                catCMD.CommandText += "RingTimeout=" + task.m_ringTimeout.ToString() + ", ";
                catCMD.CommandText += "MaxSimCalls=" + task.m_maxSimCalls.ToString() + ", ";
                catCMD.CommandText += "EnableDetect=" + (task.m_bEnableDetect ? "1, " : "0, ");
                catCMD.CommandText += "DiscAfterDetect=" + (task.m_bDiscAfterDetect ? "1, " : "0, ");

                catCMD.CommandText += " ModTag=1 WHERE Name = '" + task.task_name + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadAutoDialerTasksFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.auto_dialer_tasks.Clear();

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_autodialertasks WHERE ModTag = 2";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT Name, Enabled, TypeCode, SIPAcct, DialPlan, RingTimeout, MaxSimCalls, ModTag, EnableDetect, DiscAfterDetect FROM cfg_autodialertasks";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        AutoDialerTask task = new AutoDialerTask();
                        task.task_name = myReader.GetString(0);
                        task.isOn = (myReader.GetByte(1) == 1);
                        task.type_code = myReader.GetInt16(2);
                        task.sip_acc = myReader.GetString(3);
                        task.dial_plan = myReader.GetString(4);
                        task.m_ringTimeout = myReader.GetInt32(5);
                        task.m_maxSimCalls = myReader.GetInt32(6);
                        task.m_bEnableDetect = (myReader.GetByte(8) == 1);
                        task.m_bDiscAfterDetect = (myReader.GetByte(9) == 1);

                        pbx.auto_dialer_tasks.Add(task);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "UPDATE cfg_autodialertasks SET ModTag = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshPickupGroupConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT Name, MemberType, Members, ModTag FROM cfg_pickupgroups WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        PickUpGroup pg = pbx.getPickupGroupByName(myReader.GetString(0));

                        if (myReader.GetInt16(3) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (pg != null)
                            {
                                pbx.pickup_groups.Remove(pg);
                            }

                            bChanged = true;
                            continue;
                        }

                        if (pg == null)
                        {
                            pg = new PickUpGroup();
                            pg.name = myReader.GetString(0);
                            pbx.pickup_groups.Add(pg);

                            bChanged = true;
                        }

                        pg.ml.mb_type = myReader.GetInt32(1);

                        pg.ml.members.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(2).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        if (members.Length > 0)
                        {
                            for (int i = 0; i < members.Length; i++)
                            {
                                pg.ml.members.Add(members[i]);
                            }
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (bChanged)
                {
                    catCMD.CommandText = "DELETE FROM cfg_pickupgroups WHERE ModTag = 2";
                    if (catCMD.ExecuteNonQuery() >= 1)
                    {
                    }
                }

                catCMD.CommandText = "UPDATE cfg_pickupgroups SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() >= 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemovePickUpGroupFromDB(PickUpGroup pg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_pickupgroups SET ModTag=2 WHERE Name = '" + pg.name + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddPickUpGroupToDB(PickUpGroup pg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_pickupgroups(Name, MemberType, Members, ModTag) VALUES('" + pg.name + "', ";
                catCMD.CommandText += pg.ml.mb_type.ToString() + ", ";

                string sMembers = "";
                for (int i = 0; i < pg.ml.members.Count; i++)
                {
                    sMembers += pg.ml.members[i];
                    if (i != pg.ml.members.Count - 1)
                        sMembers += ";";
                }
                catCMD.CommandText += "'" + sMembers + "', ";
                catCMD.CommandText += " 1)";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdatePickUpGroupInDB(PickUpGroup pg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_pickupgroups SET ";

                catCMD.CommandText += "MemberType=" + pg.ml.mb_type.ToString() + ", ";

                string sMembers = "";
                for (int i = 0; i < pg.ml.members.Count; i++)
                {
                    sMembers += pg.ml.members[i];
                    if (i != pg.ml.members.Count - 1)
                        sMembers += ";";
                }
                catCMD.CommandText += "Members='" + sMembers + "', ";

                catCMD.CommandText += "ModTag=1 ";
                catCMD.CommandText += "WHERE Name = '" + pg.name + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadPickupGroupConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.pickup_groups.Clear();

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_pickupgroups WHERE ModTag = 2";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT Name, MemberType, Members, ModTag FROM cfg_pickupgroups";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        PickUpGroup pg = new PickUpGroup();
                        pg.name = myReader.GetString(0);
                        pg.ml.mb_type = myReader.GetInt32(1);

                        pg.ml.members.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(2).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        if (members.Length > 0)
                        {
                            for (int i = 0; i < members.Length; i++)
                            {
                                pg.ml.members.Add(members[i]);
                            }
                        }

                        pbx.pickup_groups.Add(pg);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "UPDATE cfg_pickupgroups SET ModTag = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

		//service side
        public static void RefreshConferRoomsConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT Name, ModTag, MaxCallNum, JoinPrompt, LeavePrompt, MOHDir, DiscCall, HostPW, HostPrompt, RecordCall, EveryonePW FROM cfg_conferencerooms WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        SIPConferRoom room = pbx.getConferenceRoomByName(myReader.GetString(0));

                        if (myReader.GetInt16(1) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (room != null)
                            {
                                pbx.sip_conferooms.Remove(room);
                                if (room.conf_handle != IntPtr.Zero)
                                {
                                    room.conf_chans.Clear();
                                    env.DestroyConf(room.conf_handle);
                                }
                            }

                            bChanged = true;
                            continue;
                        }

                        if (room == null)
                        {
                            room = new SIPConferRoom();
							pbx.sip_conferooms.Add(room);  
							room.conf_handle = env.CreateConf();                          
						}
						
						room.conf_name = myReader.GetString(0);
						room.conf_max_num = myReader.GetInt32(2);
						room.join_prompt = myReader.GetString(3);
						room.leave_prompt = myReader.GetString(4);

						room.moh_dir = myReader.GetString(5);
						room.disc_call = (myReader.GetByte(6) == 1) ? true : false;
						room.host_pw = myReader.GetString(7);
						room.host_pw_prompt = myReader.GetString(8);
                        room.conf_record = (myReader.GetByte(9) == 1) ? true : false;
                        room.attendance_need_password = (myReader.GetByte(10) == 1) ? true : false;

						bChanged = true;
					
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (bChanged)
                {
                    catCMD.CommandText = "DELETE FROM cfg_conferencerooms WHERE ModTag = 2";
                    if (catCMD.ExecuteNonQuery() >= 1)
                    {
                    }

                    SIPPBXDBUtil.InitConferenceRoomStatusTable(pbx, env, myConn);
                }

                catCMD.CommandText = "UPDATE cfg_conferencerooms SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

		//GUI side
        public static bool RemoveConferRoomFromDB(SIPConferRoom room, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_conferencerooms SET ModTag=2 WHERE Name = '" + room.conf_name + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

		//GUI side
        public static bool AddConferRoomToDB(SIPConferRoom room, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_conferencerooms(Name, ModTag, MaxCallNum, JoinPrompt, LeavePrompt, MOHDir, DiscCall, HostPW, HostPrompt, RecordCall, EveryonePW) VALUES('" + room.conf_name + "', ";
                catCMD.CommandText += "1, " + room.conf_max_num.ToString() + ", ";
                catCMD.CommandText += "'" + room.join_prompt + "', ";
                catCMD.CommandText += "'" + room.leave_prompt + "', ";
                catCMD.CommandText += "'" + room.moh_dir + "', ";
                catCMD.CommandText += room.disc_call ? "1, " : "0, ";
                catCMD.CommandText += "'" + room.host_pw + "', ";
                catCMD.CommandText += "'" + room.host_pw_prompt + "', ";
                catCMD.CommandText += room.conf_record? "1, " : "0, ";
                catCMD.CommandText += room.attendance_need_password ? "1)" : "0)";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

		//GUI side
        public static bool UpdateConferRoomInDB(SIPConferRoom room, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
		    try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_conferencerooms SET ";

                catCMD.CommandText += "ModTag=1, ";
                catCMD.CommandText += "MaxCallNum=" + room.conf_max_num.ToString() + ", ";

                catCMD.CommandText += "JoinPrompt='" + room.join_prompt + "', ";
                catCMD.CommandText += "LeavePrompt='" + room.leave_prompt + "', ";

                catCMD.CommandText += "MOHDir='" + room.moh_dir + "', ";
                catCMD.CommandText += "DiscCall=" + (room.disc_call ? "1, " : "0, ");

                catCMD.CommandText += "HostPW='" + room.host_pw + "', ";
                catCMD.CommandText += "HostPrompt='" + room.host_pw_prompt + "', ";
                catCMD.CommandText += "RecordCall=" + (room.conf_record? "1, " : "0, ");
                catCMD.CommandText += "EveryonePW=" + (room.attendance_need_password? "1 " : "0 ");

                catCMD.CommandText += "WHERE Name = '" + room.conf_name + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;	
        }

		//GUI and Service side both
        public static void LoadConferRoomsConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.sip_conferooms.Clear();

            try
            {

                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_conferencerooms WHERE ModTag = 2";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT Name, ModTag, MaxCallNum, JoinPrompt, LeavePrompt, MOHDir, DiscCall, HostPW, HostPrompt, RecordCall, EveryonePW FROM cfg_conferencerooms";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        SIPConferRoom room = new SIPConferRoom();
                        room.conf_name = myReader.GetString(0);
                        room.conf_max_num = myReader.GetInt32(2);
                        room.join_prompt = myReader.GetString(3);
                        room.leave_prompt = myReader.GetString(4);

                        room.moh_dir = myReader.GetString(5);
                        room.disc_call = (myReader.GetByte(6) == 1) ? true : false;
                        room.host_pw = myReader.GetString(7);
                        room.host_pw_prompt = myReader.GetString(8);
                        room.conf_record = (myReader.GetByte(9) == 1) ? true : false;
                        room.attendance_need_password = (myReader.GetByte(10) == 1) ? true : false;
                        
                        if(pbxMain != null && env != null)
                        {
							//service side
							room.conf_handle = env.CreateConf();
						}
                        
                        pbx.sip_conferooms.Add(room);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "UPDATE cfg_conferencerooms SET ModTag = 0";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }
        
        
        public static void LoadCallLimitConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.call_credits.Clear();

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_calllimit WHERE ModTag = 2";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT DialPlan, Seconds, RoundupSeconds, ModTag FROM cfg_calllimit";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        CallLimit cl = new CallLimit();
                        cl.Name = myReader.GetString(0);
						cl.Seconds = myReader.GetInt32(1);
                        cl.roundupSeconds = myReader.GetInt32(2);
						
						//here we need to fill out it is credit according to dialplan, or what
						//cl.dp, or cl.extn, or cl.sipaccount
						pbx.setCallLimitParameters(cl);
						
                        pbx.call_credits.Add(cl);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "UPDATE cfg_calllimit SET ModTag = 0";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }


        public static void RefreshCallLimitConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            //bool newRow = false;
            //bool bChanged = false;

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT DialPlan, Seconds, RoundupSeconds, ModTag FROM cfg_calllimit WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        //bChanged = true;

                        //newRow = false;

                        CallLimit cl = pbx.getCallLimitByName(myReader.GetString(0));

                        if (myReader.GetInt16(3) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (cl != null)
                            {
                                pbx.call_credits.Remove(cl);
                            }

                            //bChanged = true;

                            continue;
                        }

                        if (cl == null)
                        {
                            cl = new CallLimit();
                            pbx.call_credits.Add(cl);
                            ///newRow = true;

                            //bChanged = true;
                        }

                        cl.Name = myReader.GetString(0);
						cl.Seconds = myReader.GetInt32(1);
                        cl.roundupSeconds = myReader.GetInt32(2);
						
						pbx.setCallLimitParameters(cl);
						
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "DELETE FROM cfg_calllimit WHERE ModTag = 2";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
                catCMD.CommandText = "UPDATE cfg_calllimit SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveCallLimitFromDB(CallLimit cl, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_calllimit SET ModTag = 2 WHERE DialPlan = '" + cl.Name + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddCallLimitToDB(CallLimit cl, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_calllimit(DialPlan, Seconds, RoundupSeconds, ModTag) VALUES(";
                catCMD.CommandText += "'" + cl.Name + "', ";
                catCMD.CommandText += cl.Seconds.ToString() + ", " + cl.roundupSeconds.ToString() + ", 1)";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateCallLimitInDB(CallLimit cl, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log, int mod)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_calllimit SET ";

                catCMD.CommandText += "DialPlan='" + cl.Name + "', ";
                catCMD.CommandText += "Seconds=" + cl.Seconds.ToString() + ", ";
                catCMD.CommandText += "RoundupSeconds=" + cl.roundupSeconds.ToString() + ", ";
                catCMD.CommandText += "ModTag=" + mod.ToString() + " ";
                catCMD.CommandText += "WHERE DialPlan = '" + cl.Name + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadBlackListConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.call_blocks.Clear();
            //string logTxt = "calling LoadBlackListConfigFromDB\r\n";

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_blacklist WHERE ModTag = 2";
                
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT ID, Callee, Caller, ModTag FROM cfg_blacklist";
                //logTxt += catCMD.CommandText + "\r\n";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        CallBlock cb = new CallBlock();
                        cb.ID = myReader.GetInt32(0);
                        cb.Callee = myReader.GetString(1);
						cb.Caller = myReader.GetString(2);
                        //logTxt += cb.ID.ToString() + " " + cb.Callee + " " + cb.Caller + "\r\n";
                        pbx.call_blocks.Add(cb);
                    }

                    //logTxt += pbx.call_blocks.Count.ToString() + " items in list";
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                    //if (log != null) log.LogoutText(logTxt);
                }

                catCMD.CommandText = "UPDATE cfg_blacklist SET ModTag = 0";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }


        public static void RefreshBlackListConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT ID, Callee, Caller, ModTag FROM cfg_blacklist WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        CallBlock cb = pbx.getCallBlockByID(myReader.GetInt32(0));

                        if (myReader.GetInt16(3) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (cb != null)
                            {
                                pbx.call_blocks.Remove(cb);
                            }

                            continue;
                        }

                        if (cb == null)
                        {
                            cb = new CallBlock();
                            pbx.call_blocks.Add(cb);
                        }

                        cb.ID = myReader.GetInt32(0);
                        cb.Callee = myReader.GetString(1);
                        cb.Caller = myReader.GetString(2);
						
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "DELETE FROM cfg_blacklist WHERE ModTag = 2";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
                catCMD.CommandText = "UPDATE cfg_blacklist SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveBlackListFromDB(CallBlock cb, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_blacklist SET ModTag = 2 WHERE ID = " + cb.ID.ToString();

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddBlackListToDB(CallBlock cb, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            string sqlTxt = "";
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_blacklist(ID, Callee, Caller, ModTag) VALUES(";
                catCMD.CommandText += cb.ID.ToString() + ", '" + cb.Callee + "', ";
                catCMD.CommandText += "'" + cb.Caller + "', 1)";

                sqlTxt = catCMD.CommandText;

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString() + " " + sqlTxt);
            }

            return false;
        }

        public static bool UpdateBlackListInDB(CallBlock cb, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_blacklist SET ";

                catCMD.CommandText += "Callee='" + cb.Callee + "', ";
                catCMD.CommandText += "Caller='" + cb.Caller + "', ";
                catCMD.CommandText += "ModTag=1 ";
                catCMD.CommandText += "WHERE ID = " + cb.ID.ToString();

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

/////////////////////2016-08-18 CallBack functions//////////////////////////////////////////////////////////
        public static void LoadCallBackConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.call_backlist.Clear();

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_callback WHERE ModTag = 2";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT ID, Callee, Caller, DialPlan, Exten, ExtraAttr, ModTag FROM cfg_callback";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        CallBack cb = new CallBack();
                        cb.ID = myReader.GetInt32(0);
                        cb.Callee = myReader.GetString(1);
                        cb.Caller = myReader.GetString(2);
                        cb.DialPlan = myReader.GetString(3);
                        cb.Exten = myReader.GetString(4);
                        cb.ExtraAttr = myReader.GetString(5);

                        pbx.call_backlist.Add(cb);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "UPDATE cfg_callback SET ModTag = 0";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }


        public static void RefreshCallBackConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT ID, Callee, Caller, DialPlan, Exten, ExtraAttr, ModTag FROM cfg_callback WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        CallBack cb = pbx.getCallBackByID(myReader.GetInt32(0));

                        if (myReader.GetInt16(6) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (cb != null)
                            {
                                pbx.call_backlist.Remove(cb);
                            }

                            continue;
                        }

                        if (cb == null)
                        {
                            cb = new CallBack();
                            pbx.call_backlist.Add(cb);
                        }

                        cb.ID = myReader.GetInt32(0);
                        cb.Callee = myReader.GetString(1);
                        cb.Caller = myReader.GetString(2);
                        cb.DialPlan = myReader.GetString(3);
                        cb.Exten = myReader.GetString(4);
                        cb.ExtraAttr = myReader.GetString(5);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "DELETE FROM cfg_callback WHERE ModTag = 2";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
                catCMD.CommandText = "UPDATE cfg_callback SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveCallBackFromDB(CallBack cb, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_callback SET ModTag = 2 WHERE ID = " + cb.ID.ToString();

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddCallBackToDB(CallBack cb, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_callback(ID, Callee, Caller, DialPlan, Exten, ExtraAttr, ModTag) VALUES(";
                catCMD.CommandText += cb.ID.ToString() + ", '" + cb.Callee + "', ";
                catCMD.CommandText += "'" + cb.Caller + "', ";
                catCMD.CommandText += "'" + cb.DialPlan + "', ";
                catCMD.CommandText += "'" + cb.Exten + "', ";
                catCMD.CommandText += "'" + cb.ExtraAttr + "', ";
                catCMD.CommandText += "1)";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateCallBackInDB(CallBack cb, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_callback SET ";

                catCMD.CommandText += "Callee='" + cb.Callee + "', ";
                catCMD.CommandText += "Caller='" + cb.Caller + "', ";
                catCMD.CommandText += "DialPlan='" + cb.DialPlan + "', ";
                catCMD.CommandText += "Exten='" + cb.Exten + "', ";
                catCMD.CommandText += "ExtraAttr='" + cb.ExtraAttr + "', ";
                catCMD.CommandText += "ModTag=1 ";
                catCMD.CommandText += "WHERE ID = " + cb.ID.ToString();

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }


/////////////////////2016-06-09 Paging group functions//////////////////////////////////////////////////////
        public static void RefreshPagingGroupConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool bChanged = false;
            SIPPBXPagingGroup paging_group = null;

            List<SIPPBXPagingGroup> tempListPagingGroup = new List<SIPPBXPagingGroup>();

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT Name, DID, UseGroupName, ModTag FROM cfg_paginggroups WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        paging_group = pbx.getPagingGroupByName(myReader.GetString(0));

                        if (myReader.GetInt16(3) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (paging_group != null)
                            {
                                pbx.sip_paginggroups.Remove(paging_group);
                                env.DestroyConf(paging_group.conf_handle);
                            }

                            bChanged = true;
                            continue;
                        }

                        if (paging_group == null)
                        {
                            paging_group = new SIPPBXPagingGroup();
                            paging_group.gpName = myReader.GetString(0);
                            paging_group.conf_handle = env.CreateConf();
                            pbx.sip_paginggroups.Add(paging_group);

                            bChanged = true;
                        }

                        paging_group.did = myReader.GetString(1);
                        paging_group.bUseGroupName = (myReader.GetInt16(2) == 1);
                        tempListPagingGroup.Add(paging_group);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (tempListPagingGroup.Count > 0)
                {
                    for (int i = 0; i < tempListPagingGroup.Count; i++)
                    {
                        paging_group = tempListPagingGroup[i];

                        paging_group.destList.Clear();

                        catCMD.CommandText = "SELECT * FROM cfg_dests WHERE BelongTo = '" + paging_group.gpName + "'";
                        myReader = catCMD.ExecuteReader();

                        try
                        {
                            while (myReader.Read())
                            {
                                SIPPBXDest dest = new SIPPBXDest();

                                dest.DestType = myReader.GetInt32(0);
                                dest.DestAddr = myReader.GetString(1);
                                dest.RingTimeout = myReader.GetInt32(2);

                                paging_group.destList.Add(dest);
                            }
                        }
                        catch (Exception e)
                        {
                            if (log != null)
                                log.LogoutText(e.ToString());
                        }
                        finally
                        {
                            myReader.Close();
                        }
                    }
                }

                if (bChanged)
                {
                    catCMD.CommandText = "DELETE FROM cfg_paginggroups WHERE ModTag = 2";
                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }

                catCMD.CommandText = "UPDATE cfg_paginggroups SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }



        public static bool RemovePagingGroupFromDB(SIPPBXPagingGroup pg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_paginggroups SET ModTag=2 WHERE Name = '" + pg.gpName + "'";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                    catCMD.CommandText = "DELETE FROM cfg_dests WHERE BelongTo = '" + pg.gpName + "'";
                    catCMD.ExecuteNonQuery();
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }


        public static bool AddPagingGroupToDB(SIPPBXPagingGroup pg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_paginggroups(Name, DID, UseGroupName , ModTag) VALUES('" + pg.gpName + "', '" + pg.did + "', ";
                catCMD.CommandText += pg.bUseGroupName ? "1, " : "0, ";
                catCMD.CommandText += "1)";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    catCMD.CommandText = "DELETE FROM cfg_dests WHERE BelongTo = '" + pg.gpName + "'";
                    catCMD.ExecuteNonQuery();

                    for (int i = 0; i < pg.destList.Count; i++)
                    {
                        catCMD.CommandText = "INSERT INTO cfg_dests VALUES(";
                        catCMD.CommandText += pg.destList[i].DestType.ToString() + ", ";
                        catCMD.CommandText += "'" + pg.destList[i].DestAddr + "', ";
                        catCMD.CommandText += pg.destList[i].RingTimeout.ToString() + ", ";
                        catCMD.CommandText += "'" + pg.gpName + "')";
                        if (catCMD.ExecuteNonQuery() != 1)
                        {
                        }
                    }
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }


        public static bool UpdatePagingGroupInDB(SIPPBXPagingGroup pg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_paginggroups SET ";
                catCMD.CommandText += "DID='" + pg.did + "', ";
                catCMD.CommandText += "UseGroupName=" + (pg.bUseGroupName ? "1, " : "0, ");

                catCMD.CommandText += " ModTag=1 WHERE Name = '" + pg.gpName + "'";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    catCMD.CommandText = "DELETE FROM cfg_dests WHERE BelongTo = '" + pg.gpName + "'";
                    catCMD.ExecuteNonQuery();

                    for (int i = 0; i < pg.destList.Count; i++)
                    {
                        catCMD.CommandText = "INSERT INTO cfg_dests VALUES(";
                        catCMD.CommandText += pg.destList[i].DestType.ToString() + ", ";
                        catCMD.CommandText += "'" + pg.destList[i].DestAddr + "', ";
                        catCMD.CommandText += pg.destList[i].RingTimeout.ToString() + ", ";
                        catCMD.CommandText += "'" + pg.gpName + "')";
                        if (catCMD.ExecuteNonQuery() != 1)
                        {
                        }
                    }

                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }


        public static void LoadPagingGroupConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            SIPPBXPagingGroup pg = null;
            List<SIPPBXPagingGroup> tempListPagingGroup = new List<SIPPBXPagingGroup>();

            pbx.sip_paginggroups.Clear();

            try
            {

                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_paginggroups WHERE ModTag = 2";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT Name, DID, UseGroupName, ModTag FROM cfg_paginggroups";
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        pg = new SIPPBXPagingGroup();

                        pg.gpName = myReader.GetString(0);
                        pg.did = myReader.GetString(1);
                        pg.bUseGroupName = myReader.GetInt16(2) == 1;

                        tempListPagingGroup.Add(pg);

                        pbx.sip_paginggroups.Add(pg);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (tempListPagingGroup.Count > 0)
                {
                    for (int i = 0; i < tempListPagingGroup.Count; i++)
                    {
                        pg = tempListPagingGroup[i];

                        pg.destList.Clear();

                        catCMD.CommandText = "SELECT * FROM cfg_dests WHERE BelongTo = '" + pg.gpName + "'";
                        myReader = catCMD.ExecuteReader();

                        try
                        {
                            while (myReader.Read())
                            {
                                SIPPBXDest dest = new SIPPBXDest();

                                dest.DestType = myReader.GetInt32(0);
                                dest.DestAddr = myReader.GetString(1);
                                dest.RingTimeout = myReader.GetInt32(2);

                                pg.destList.Add(dest);
                            }
                        }
                        catch (Exception e)
                        {
                            if (log != null)
                                log.LogoutText(e.ToString());
                        }
                        finally
                        {
                            myReader.Close();
                        }
                    }
                }

                catCMD.CommandText = "UPDATE cfg_paginggroups SET ModTag = 0 WHERE ModTag != 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }



/////////////////////////////security DB tables//////////////////////////////////////////////////////
        public static void RefreshSecurityConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            bool newRow = false;

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "SELECT ID, WhiteOrBlack, FilterType, IPAddr, CallID, MacAddr, ModTag FROM cfg_security WHERE ModTag != 0";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        newRow = false;

                        IPFilter filter = pbx.getSecurityFilterByID(myReader.GetInt32(0));

                        if (myReader.GetInt16(6) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (filter != null)
                            {
                                env.SetIPFilter(filter.IPAddr, filter.WhiteOrBlack, 0); 
                                pbx.IPFilterList.Remove(filter);
                            }

                            continue;
                        }

                        if (filter == null)
                        {
                            filter = new IPFilter();
                            filter.DBIdx = myReader.GetInt32(0);
                            pbx.IPFilterList.Add(filter);
                            newRow = true;
                        }

                        filter.WhiteOrBlack = myReader.GetInt16(1);
                        filter.FilterType = myReader.GetInt16(2); ;
                        filter.IPAddr = myReader.GetString(3);
                        filter.CallID = myReader.GetString(4);
                        filter.MACAddr = myReader.GetString(5);

                        if (newRow)
                        {
                            env.SetIPFilter(filter.IPAddr, filter.WhiteOrBlack, 1); 
                        }
                        else
                        {
                            //just update the filter
                            env.SetIPFilter(filter.IPAddr, filter.WhiteOrBlack, 0);
                            env.SetIPFilter(filter.IPAddr, filter.WhiteOrBlack, 1);
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "DELETE FROM cfg_security WHERE ModTag = 2";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
                catCMD.CommandText = "UPDATE cfg_security SET ModTag = 0 WHERE ModTag = 1";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveSecurityFromDB(IPFilter filter, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_security SET ModTag = 2 WHERE ID = " + filter.DBIdx.ToString();

                if (catCMD.ExecuteNonQuery() == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddSecurityToDB(IPFilter filter, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO cfg_security(ID, WhiteOrBlack, FilterType, IPAddr, CallID, MacAddr, ModTag) VALUES(" + filter.DBIdx.ToString() + ", ";
                catCMD.CommandText += filter.WhiteOrBlack.ToString() + ", ";
                catCMD.CommandText += filter.FilterType.ToString() + ", ";

                catCMD.CommandText += "'" + filter.IPAddr + "', ";
                catCMD.CommandText += "'" + filter.CallID + "', ";
                catCMD.CommandText += "'" + filter.MACAddr + "', ";
 
                catCMD.CommandText += "1)";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        /*
        public static bool UpdateSecurityInDB(SIPAccount acct, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "UPDATE cfg_sipaccounts SET ";

                catCMD.CommandText += "DisplayName=" + "'" + acct.DisplayName + "', ";
                catCMD.CommandText += "UserName=" + "'" + acct.UserName + "', ";

                catCMD.CommandText += "DomainServer=" + "'" + acct.DomainServer + "', ";
                catCMD.CommandText += "ProxyServer=" + "'" + acct.ProxyServer + "', ";

                catCMD.CommandText += "AuthName=" + "'" + acct.AuthName + "', ";
                catCMD.CommandText += "Password=" + "'" + acct.Password + "', ";

                catCMD.CommandText += "ExpireSec=" + acct.ExpireSec.ToString() + ", ";
                catCMD.CommandText += "RegWithProxyServer=" + (acct.RegWithProxyServer ? "1, " : "0, ");

                string sDIDs = "";
                for (int i = 0; i < acct.DIDList.Count; i++)
                {
                    sDIDs += acct.DIDList[i];
                    if (i != acct.DIDList.Count - 1)
                        sDIDs += ";";
                }
                catCMD.CommandText += "DIDS=" + "'" + sDIDs + "', ";
                catCMD.CommandText += "Disabled=" + (acct.Disabled ? "1, " : "0, ");
                catCMD.CommandText += "AcceptOtherID=" + (acct.OutboundAcceptOtherID ? "1, " : "0, ");
                catCMD.CommandText += "AppendExtenID=" + (acct.OutboundAppendExtenID ? "1, " : "0, ");
                catCMD.CommandText += "UseLocalIPInFrom=" + (acct.UseLocalIPInFrom ? "1, " : "0, ");
                catCMD.CommandText += "MappedExten=" + "'" + acct.MappedExten + "', ";
                catCMD.CommandText += "SIPProtocol=" + acct.SIPProtocol.ToString() + ", ";

                catCMD.CommandText += "ModTag=1 ";
                catCMD.CommandText += "WHERE ID = " + acct.AccID.ToString();

                if (catCMD.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }*/

        public static void LoadSecurityFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            pbx.IPFilterList.Clear();

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "DELETE FROM cfg_security WHERE ModTag = 2";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "SELECT ID, WhiteOrBlack, FilterType, IPAddr, CallID, MacAddr, ModTag FROM cfg_security";

                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        IPFilter filter = new IPFilter();

                        filter.DBIdx = myReader.GetInt32(0);
                        filter.WhiteOrBlack = myReader.GetInt16(1);
                        filter.FilterType = myReader.GetInt16(2);
                        filter.IPAddr = myReader.GetString(3);
                        filter.CallID = myReader.GetString(4);
                        filter.MACAddr = myReader.GetString(5);

                        pbx.IPFilterList.Add(filter);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                catCMD.CommandText = "UPDATE cfg_security SET ModTag = 0";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }


/////////////////////////////Security DB tables//////////////////////////////////////////////////////

        

//*****************************************************************************
        /*
                public static void RefreshAutoDialerTasksConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
                {
                    bool bChanged = false;

                    try
                    {
                        SqlCommand catCMD = myConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        catCMD.CommandText = "SELECT * FROM cfg_autodialertasks WHERE ModTag != 0";

                        SqlDataReader myReader = catCMD.ExecuteReader();

                        try
                        {
                            while (myReader.Read())
                            {
                                AutoDialerTask task = pbx.getAutoDialerTaskByName(myReader.GetString(0));

                                if (myReader.GetInt16(7) == 2)
                                {
                                    //ModTag == 2, need remove.
                                    if (task != null)
                                    {
                                        pbx.auto_dialer_tasks.Remove(task);
                                    }

                                    bChanged = true;
                                    continue;
                                }

                                if (task == null)
                                {
                                    task = new AutoDialerTask();
                                    task.task_name = myReader.GetString(0);
                                    pbx.auto_dialer_tasks.Add(task);

                                    bChanged = true;
                                }

                                task.isOn = myReader.GetByte(1) == 1;
                                task.type_code = myReader.GetInt16(2);
                                task.sip_acc = myReader.GetString(3);
                                task.dial_plan = myReader.GetString(4);
                                task.m_ringTimeout = myReader.GetInt32(5);
                                task.m_maxSimCalls = myReader.GetInt32(6);
                            }
                        }
                        catch (Exception e)
                        {
                            if (log != null)
                                log.LogoutText(e.ToString());
                        }
                        finally
                        {
                            myReader.Close();
                        }

                        if (bChanged)
                        {
                            catCMD.CommandText = "DELETE FROM cfg_autodialertasks WHERE ModTag = 2";
                            if (catCMD.ExecuteNonQuery() >= 1)
                            {
                            }
                        }

                        catCMD.CommandText = "UPDATE cfg_autodialertasks SET ModTag = 0 WHERE ModTag = 1";
                        if (catCMD.ExecuteNonQuery() >= 1)
                        {
                        }

                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }

                }

                public static bool RemoveAutoDialerTasksFromDB(AutoDialerTask task, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
                {
                    try
                    {
                        SqlCommand catCMD = myConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        catCMD.CommandText = "UPDATE cfg_autodialertasks SET ModTag=2 WHERE Name = '" + task.task_name + "'";

                        if (catCMD.ExecuteNonQuery() == 1)
                            return true;
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }

                    return false;
                }

                public static bool UpdateAutoDialerTasksInDB(AutoDialerTask task, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
                {
                    try
                    {
                        SqlCommand catCMD = myConn.CreateCommand();
                           catCMD.CommandTimeout = 3;
                        catCMD.CommandText = "UPDATE cfg_autodialertasks SET ";

                        catCMD.CommandText += "Enabled=" + (task.isOn ? "1, " : "0, ");
                        catCMD.CommandText += "Type=" + task.type_code.ToString() + ", ";
                        catCMD.CommandText += "SIPAcct='" + task.sip_acc.ToString() + "', ";
                        catCMD.CommandText += "DialPlan='" + task.dial_plan.ToString() + "', ";
                        catCMD.CommandText += "RingTimeout=" + task.m_ringTimeout.ToString() + ", ";
                        catCMD.CommandText += "MaxCalls=" + task.m_maxSimCalls.ToString() + ", ";
                        catCMD.CommandText += "ModTag=1 ";
                        catCMD.CommandText += "WHERE Name = '" + task.task_name + "'";

                        if (catCMD.ExecuteNonQuery() == 1)
                        {
                            return true;
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }

                    return false;
                }

                public static void LoadAutoDialerTasksConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
                {
                    pbx.auto_dialer_tasks.Clear();

                    try
                    {

                        SqlCommand catCMD = myConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        catCMD.CommandText = "DELETE FROM cfg_autodialertasks WHERE ModTag = 2";

                        if (catCMD.ExecuteNonQuery() == 1)
                        {
                        }

                        catCMD.CommandText = "SELECT * FROM cfg_autodialertasks";

                        SqlDataReader myReader = catCMD.ExecuteReader();

                        try
                        {
                            while (myReader.Read())
                            {
                                AutoDialerTask task = new AutoDialerTask();

                                task.task_name = myReader.GetString(0);
                                task.isOn = myReader.GetByte(1) == 1;
                                task.type_code = myReader.GetInt16(2);
                                task.sip_acc = myReader.GetString(3);
                                task.dial_plan = myReader.GetString(4);
                                task.m_ringTimeout = myReader.GetInt32(5);
                                task.m_maxSimCalls = myReader.GetInt32(6);

                                pbx.auto_dialer_tasks.Add(task);
                            }
                        }
                        catch (Exception e)
                        {
                            if (log != null)
                                log.LogoutText(e.ToString());
                        }
                        finally
                        {
                            myReader.Close();
                        }

                        catCMD.CommandText = "UPDATE cfg_autodialertasks SET ModTag = 0";

                        if (catCMD.ExecuteNonQuery() == 1)
                        {
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }

                }
        */

        public static void UpgradeDBTo320(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cdr_agent ADD Param1 varchar(80), Param2 varchar(80), Param3 varchar(80)";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cdr_pbx ADD CallDir tinyint";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cdr_acd ADD CallDir tinyint";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cdr_exten ADD CallDir tinyint";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo329(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_sipaccounts ADD UseLocalIPInFrom TinyInt NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_sipaccounts SET UseLocalIPInFrom = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo311(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_sipaccounts ADD AcceptOtherID TinyInt NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_sipaccounts SET AcceptOtherID = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo309(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_extensions ADD AuthType INT";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_extensions SET AuthType = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo308(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cdr_pbx ADD CallID varchar(40) NULL";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cdr_acd ADD CallID varchar(40) NULL";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cdr_exten ADD CallID varchar(40) NULL";

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void UpgradeDBTo322(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_extensions ADD OnlyAgentLogin TINYINT";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_extensions SET OnlyAgentLogin = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo331(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_extensions ADD MappedContactAddr varchar(120), RegSrcIP varchar(120), RegSrcPort INT";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_extensions SET MappedContactAddr = '', RegSrcIP = '', RegSrcPort = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void UpgradeDBTo346(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_sipaccounts ADD MappedExten varchar(80) NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_sipaccounts SET MappedExten = ''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo348(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_agents ADD SkillLevel SmallInt NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_agents SET SkillLevel = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cdr_pbx ADD Transferred tinyint, IVRKeys varchar(256)";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cdr_pbx SET Transferred = 0, IVRKeys = ''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cdr_acd ADD Transferred tinyint";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cdr_acd SET Transferred = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cdr_exten ADD Transferred tinyint";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cdr_exten SET Transferred = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE auto_dialer_jobs ADD TaskID varchar(60) NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE auto_dialer_jobs SET TaskID = ''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE auto_dialer_done ADD TaskID varchar(60) NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE auto_dialer_done SET TaskID = ''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo350(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_conferencerooms ADD MaxCallNum INT, JoinPrompt varchar(256), LeavePrompt varchar(256)";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_conferencerooms SET MaxCallNum = 0, JoinPrompt='', LeavePrompt=''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE status_channel ADD CallID varchar(40)";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }


            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo351(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_conferencerooms ADD MOHDir varchar(256), DiscCall TinyINT, HostPW varchar(256), HostPrompt varchar(256)";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_conferencerooms SET MOHDir='', DiscCall=0, HostPW='', HostPrompt=''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo352(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE auto_dialer_done ADD DetectResult int NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE auto_dialer_done SET DetectResult=-3";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cfg_autodialertasks ADD EnableDetect TinyINT NULL, DiscAfterDetect TinyINT NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_autodialertasks SET EnableDetect=0, DiscAfterDetect=0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void UpgradeDBTo353(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE voice_mailbox ADD CallID varchar(40) NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE voice_mailbox SET CallID=''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cdr_pbx ADD DiscReason varchar(80)";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cdr_pbx SET DiscReason=''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cdr_acd ADD DiscReason varchar(80)";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cdr_acd SET DiscReason=''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cdr_exten ADD DiscReason varchar(80)";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cdr_exten SET DiscReason=''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }


            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void UpgradeDBTo354(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_conferencerooms ADD RecordCall TinyINT";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_conferencerooms SET RecordCall=0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cdr_pbx ADD ConfName varchar(80)";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cdr_pbx SET ConfName=''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo357(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE auto_dialer_done ADD FinalCode int NULL, FinalDesc varchar(120) NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE auto_dialer_done SET FinalCode=0, FinalDesc=''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo358(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_extensions ADD MultipleCall TINYINT NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_extensions SET MultipleCall=0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo359(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_sipaccounts ADD AppendExtenID TinyInt NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_sipaccounts SET AppendExtenID = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo360(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_ringgroups ADD AnswerCallFirst TinyInt NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_ringgroups SET AnswerCallFirst = 1";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        //for 361, change DiscReason of cdr_pbx to 256, and change all other places which handle discReason to 256 length.

        public static void UpgradeDBTo361(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cdr_pbx ALTER COLUMN DiscReason varchar(256)";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cdr_acd ALTER COLUMN DiscReason varchar(256)";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cdr_exten ALTER COLUMN DiscReason varchar(256)";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo362(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_agents ADD Paused TinyInt NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_agents SET Paused = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo363(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_sipaccounts ADD SIPProtocol TinyInt NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_sipaccounts SET SIPProtocol = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo364(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_extensions ADD VMBPassword varchar(40) NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_extensions SET VMBPassword = ''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cfg_huntgroups ADD VMBPassword varchar(40) NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_huntgroups SET VMBPassword = ''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cfg_parkingslots ADD VMBPassword varchar(40) NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_parkingslots SET VMBPassword = ''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE cfg_ringgroups ADD VMBPassword varchar(40) NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_ringgroups SET VMBPassword = ''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo365(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_conferencerooms ADD EveryonePW TinyINT";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_conferencerooms SET EveryonePW = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo366(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "ALTER TABLE cfg_extensions ADD MaxRegExpSec INT NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_extensions SET MaxRegExpSec = 0";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo367(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;

                catCMD.CommandText = "EXEC sp_rename 'dbo.auto_dialer_jobs.TaskID', 'JobID', 'COLUMN'";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "EXEC sp_rename 'dbo.auto_dialer_done.TaskID', 'JobID', 'COLUMN'";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE auto_dialer_done ADD CallID varchar(40) NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE auto_dialer_done SET CallID = ''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo368(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;

                catCMD.CommandText = "ALTER TABLE cfg_huntgroups ADD MaxNumOfCalls INT NULL, CallForwardingType SmallInt NULL, CallForwardingPlan varchar(80) NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE cfg_huntgroups SET MaxNumOfCalls=0, CallForwardingType=0, CallForwardingPlan=''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "ALTER TABLE status_channel ADD AutoDialerId bigint NULL, AutoDialerJobId varchar(60) NULL";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }

                catCMD.CommandText = "UPDATE status_channel SET AutoDialerId=0, AutoDialerJobId=''";
                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo368_1(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                //v3.68f added
                if (!DBServerSetting.ColumnExists(myConn, "SIPTrunk", "cfg_sipaccounts"))
                {
                    try
                    {
                        SqlCommand catCMD = myConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        catCMD.CommandText = "ALTER TABLE cfg_sipaccounts ADD SIPTrunk TinyInt NULL";
                        if (catCMD.ExecuteNonQuery() == 1)
                        {
                        }

                        catCMD.CommandText = "UPDATE cfg_sipaccounts SET SIPTrunk = 0";
                        if (catCMD.ExecuteNonQuery() == 1)
                        {
                        }
                    }
                    catch (Exception ex)
                    {
                        //if (log != null) log.LogoutText(e.ToString());
                    }
                }

                //3.68g added
                if (!DBServerSetting.ColumnExists(myConn, "PromptQueuePosition", "cfg_huntgroups"))
                {
                    try
                    {
                        SqlCommand catCMD = myConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        catCMD.CommandText = "ALTER TABLE cfg_huntgroups ADD PromptQueuePosition SmallInt NULL";
                        if (catCMD.ExecuteNonQuery() == 1)
                        {
                        }

                        catCMD.CommandText = "UPDATE cfg_huntgroups SET PromptQueuePosition = 0";
                        if (catCMD.ExecuteNonQuery() == 1)
                        {
                        }
                    }
                    catch (Exception ex)
                    {
                        //if (log != null) log.LogoutText(e.ToString());
                    }
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

    }
}
