//#define PBXV3_DEBUG
using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace SIPPBXv3
{
    public class SIPPBXCFG
    {
        public static bool GetBooleanFromXMLNode(XmlNode tmpNode)
        {
            if (tmpNode != null)
            {
                if (tmpNode.InnerText.Trim().ToUpper() == "TRUE")
                    return true;
                else
                {
                    if (tmpNode.InnerText.Trim() == "1")
                        return true;
                    else
                        return false;
                }
            }

            return false;
        }

        public static int LoadConfigFromXML(string xmlFileName, SIPPBX pbx, GTSIPPBXEnv env)
        {
            XmlDocument xmlDoc = new XmlDocument();
            try
            {
                xmlDoc.Load(xmlFileName);
            }
            catch (Exception ex)
            {
                if (env != null)
                {
                    env.LOG_Trace(1, ex.ToString());
                    env.LogoutText(ex.ToString());
                }
                return 0;
            }

            XmlElement root = xmlDoc.DocumentElement;

            try
            {
                XmlNode tmpNode = root.SelectSingleNode("//System/CfgSource");
                if (tmpNode != null)
                {
                    if (tmpNode.InnerText.Trim().ToLower() == "database")
                    {
#if PBXV3_DEBUG
                        SIPPBXMain.LogMessageToFile("LoadConfigFromXML calling LoadDBSettingsFromXML");
#endif
                        LoadDBSettingsFromXML(xmlDoc, pbx, env);
                        return 1;
                    }
                    else if (tmpNode.InnerText.Trim().ToLower() == "registry")
                    {
                        return 2;
                    }
                    else if (tmpNode.InnerText.Trim().ToLower() == "xml")
                    {

                    }

                }

                tmpNode = root.SelectSingleNode("//System/CfgSource");

                if (tmpNode != null)
                    pbx.ChanNum = Convert.ToInt32(tmpNode.InnerText);

                tmpNode = root.SelectSingleNode("//System/Basic/LicKey");

                if(tmpNode != null)
                    pbx.PBXLicKey = tmpNode.InnerText;

                if (pbx.PBXLicKey.Length > 0)
                {
                    pbx.bFreeVersion = false;
                }
                else
                {
                    pbx.bFreeVersion = true;
                }

                tmpNode = root.SelectSingleNode("//System/Basic/MohDir");

                if (tmpNode != null)
                    pbx.moh_dir = tmpNode.InnerText;

                tmpNode = root.SelectSingleNode("//System/Basic/LogDir");

                if (tmpNode != null)
                    pbx.log_dir = tmpNode.InnerText;

                tmpNode = root.SelectSingleNode("//System/Basic/LogLevel");

                if (tmpNode != null)
                    pbx.log_level = Convert.ToInt32(tmpNode.InnerText);

                tmpNode = root.SelectSingleNode("//System/Basic/ReportDir");

                if (tmpNode != null)
                    pbx.report_dir = tmpNode.InnerText;

                tmpNode = root.SelectSingleNode("//System/Basic/RecordDir");

                if (tmpNode != null)
                    pbx.record_dir = tmpNode.InnerText;

                tmpNode = root.SelectSingleNode("//System/Basic/VMBDir");

                if (tmpNode != null)
                    pbx.vmb_dir = tmpNode.InnerText;

                //////////////////////////////////////////////////////////////
                //special numbers
                tmpNode = root.SelectSingleNode("//System/Basic/PickupShortCode");

                if (tmpNode != null)
                    pbx.pickup_shortcode = tmpNode.InnerText;

                tmpNode = root.SelectSingleNode("//System/Basic/ACDNumber");

                if (tmpNode != null)
                    pbx.acd_number = tmpNode.InnerText;

                tmpNode = root.SelectSingleNode("//System/Basic/AgentLoginNumber");

                if (tmpNode != null)
                    pbx.agent_login_number = tmpNode.InnerText;

                tmpNode = root.SelectSingleNode("//System/Basic/AgentLogoutNumber");

                if (tmpNode != null)
                    pbx.agent_logout_number = tmpNode.InnerText;


                //CDR option
                tmpNode = root.SelectSingleNode("//System/Basic/PBXCDR");

                if (tmpNode != null)
                    pbx.cdr_option.pbx_cdr = Convert.ToInt32(tmpNode.InnerText);

                tmpNode = root.SelectSingleNode("//System/Basic/ACDCDR");

                if (tmpNode != null)
                    pbx.cdr_option.acd_cdr = Convert.ToInt32(tmpNode.InnerText);

                tmpNode = root.SelectSingleNode("//System/Basic/ExtenCDR");

                if (tmpNode != null)
                    pbx.cdr_option.exten_cdr = Convert.ToInt32(tmpNode.InnerText);

                tmpNode = root.SelectSingleNode("//System/Basic/AgentCDR");

                if (tmpNode != null)
                    pbx.cdr_option.agent_cdr = Convert.ToInt32(tmpNode.InnerText);
            }
            catch (Exception ex)
            {
                if (env != null)
                {
                    env.LOG_Trace(1, ex.ToString());
                    env.LogoutText(ex.ToString());
                }
            }

            LoadDBSettingsFromXML(xmlDoc, pbx, env);
            LoadSIPNetConfigFromXML(xmlDoc, pbx, env);
            LoadSIPAccountConfigFromXML(xmlDoc, pbx, env);
            LoadExtensionsConfigFromXML(xmlDoc, pbx, env);
            LoadEmailNetConfigFromXML(xmlDoc, pbx, env);

            return 3;
        }

        public static bool LoadDBSettingsFromXML(XmlDocument xmlDoc, SIPPBX pbx, GTSIPPBXEnv env)
        {

#if PBXV3_DEBUG
            SIPPBXMain.LogMessageToFile("LoadDBSettingsFromXML");
#endif

            XmlElement root = xmlDoc.DocumentElement;
            try
            {
                XmlNode tmpNode = root.SelectSingleNode("//System/Database/Enabled");
                if (tmpNode != null)
                {
                    if (GetBooleanFromXMLNode(tmpNode))
                    {
                        pbx.db_set = new DBServerSetting();

                        tmpNode = root.SelectSingleNode("//System/Database/DBType");
                        if (tmpNode != null)
                        {
                            pbx.db_set.dbType = Convert.ToInt32(tmpNode.InnerText);
#if PBXV3_DEBUG
                            SIPPBXMain.LogMessageToFile("LoadDBSettingsFromXML dbType " + pbx.db_set.dbType.ToString());
#endif
                        }

                        tmpNode = root.SelectSingleNode("//System/Database/DBServer");
                        if (tmpNode != null)
                        {
                            pbx.db_set.sDBServer = tmpNode.InnerText;
#if PBXV3_DEBUG
                            SIPPBXMain.LogMessageToFile("LoadDBSettingsFromXML sDBServer " + pbx.db_set.sDBServer);
#endif
                        }

                        tmpNode = root.SelectSingleNode("//System/Database/DBName");
                        if (tmpNode != null)
                        {
                            pbx.db_set.sDBName = tmpNode.InnerText;
#if PBXV3_DEBUG
                            SIPPBXMain.LogMessageToFile("LoadDBSettingsFromXML sDBName " + pbx.db_set.sDBName);
#endif
                        }

                        tmpNode = root.SelectSingleNode("//System/Database/AuthType");
                        if (tmpNode != null)
                        {
                            pbx.db_set.authType = Convert.ToInt32(tmpNode.InnerText);
#if PBXV3_DEBUG
                            SIPPBXMain.LogMessageToFile("LoadDBSettingsFromXML authType " + pbx.db_set.authType.ToString());
#endif
                        }

                        tmpNode = root.SelectSingleNode("//System/Database/UserName");
                        if (tmpNode != null)
                        {
                            pbx.db_set.sUserName = tmpNode.InnerText;
#if PBXV3_DEBUG
                            SIPPBXMain.LogMessageToFile("LoadDBSettingsFromXML sUserName " + pbx.db_set.sUserName);
#endif
                        }

                        tmpNode = root.SelectSingleNode("//System/Database/Password");
                        if (tmpNode != null)
                        {
                            pbx.db_set.sPassword = tmpNode.InnerText;
#if PBXV3_DEBUG
                            SIPPBXMain.LogMessageToFile("LoadDBSettingsFromXML sPassword " + pbx.db_set.sPassword);
#endif
                        }
                    }
                    else
                    {
                    }
                }
            }
            catch (Exception ex)
            {
                if (env != null)
                {
                    env.LOG_Trace(1, ex.ToString());
                    env.LogoutText(ex.ToString());
                }
            }

            return true;
        }

        public static bool LoadSIPNetConfigFromXML(XmlDocument xmlDoc, SIPPBX pbx, GTSIPPBXEnv env)
        {
            XmlElement root = xmlDoc.DocumentElement;
            try
            {
                XmlNode tmpNode = root.SelectSingleNode("//System/Network/SIPAddr");
                if (tmpNode != null)
                    pbx.sip_set.sipAddr = tmpNode.InnerText;

                tmpNode = root.SelectSingleNode("//System/Network/SIPPort");
                if (tmpNode != null)
                    pbx.sip_set.sipPort = Convert.ToUInt16(tmpNode.InnerText);

                tmpNode = root.SelectSingleNode("//System/Network/RTPPort");
                if (tmpNode != null)
                    pbx.sip_set.rtpPort = Convert.ToUInt16(tmpNode.InnerText);

                tmpNode = root.SelectSingleNode("//System/Network/RTPPortSpace");
                if (tmpNode != null)
                    pbx.sip_set.rtpPortSpace = Convert.ToUInt16(tmpNode.InnerText);

                tmpNode = root.SelectSingleNode("//System/Network/AudioCodecs");
                if (tmpNode != null)
                    pbx.sip_set.auCodecs = tmpNode.InnerText;
            }
            catch (Exception ex)
            {
                if (env != null)
                {
                    env.LOG_Trace(1, ex.ToString());
                    env.LogoutText(ex.ToString());
                }
            }

            return true;
        }

        public static bool LoadSIPAccountConfigFromXML(XmlDocument xmlDoc, SIPPBX pbx, GTSIPPBXEnv env)
        {
            int nCount = 0;
            XmlElement root = xmlDoc.DocumentElement;
            XmlNode tmpNode;
            XmlNode tmpNode1;
            try
            {
                tmpNode = root.SelectSingleNode("//System/SIPAccounts/Count");
                if (tmpNode != null)
                {
                    nCount = Convert.ToInt32(tmpNode.InnerText);
                    if (nCount > 0)
                    {
                        for(int i=0; i<nCount; i++)
                        {
                            SIPAccount acct = new SIPAccount();

                            int idx = i + 1;
                            tmpNode = root.SelectSingleNode("//System/SIPAccounts/SIPAccount[@id='" + idx.ToString() + "']");
                            if (tmpNode != null)
                            {
                                tmpNode1 = tmpNode.SelectSingleNode("DisplayName");
                                if (tmpNode1 != null)
                                    acct.DisplayName = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("UserName");
                                if (tmpNode1 != null)
                                    acct.UserName = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("DomainServer");
                                if (tmpNode1 != null)
                                    acct.DomainServer = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("ProxyServer");
                                if (tmpNode1 != null)
                                    acct.ProxyServer = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("AuthName");
                                if (tmpNode1 != null)
                                    acct.AuthName = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("Password");
                                if (tmpNode1 != null)
                                    acct.Password = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("ExpireSec");
                                if (tmpNode1 != null)
                                    acct.ExpireSec = Convert.ToInt32(tmpNode1.InnerText);

                                tmpNode1 = tmpNode.SelectSingleNode("RegWithProxyServer");
                                if (tmpNode1 != null)
                                {
                                    if (tmpNode1.InnerText.ToUpper() == "TRUE")
                                        acct.RegWithProxyServer = true;
                                    else
                                        acct.RegWithProxyServer = false;
                                }
                            }

                            pbx.sip_acct.Add(acct);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                if (env != null)
                {
                    env.LOG_Trace(1, ex.ToString());
                    env.LogoutText(ex.ToString());
                }
            }

            return true;

        }

        public static bool LoadExtensionsConfigFromXML(XmlDocument xmlDoc, SIPPBX pbx, GTSIPPBXEnv env)
        {
            int nCount = 0;
            XmlElement root = xmlDoc.DocumentElement;
            XmlNode tmpNode;
            XmlNode tmpNode1;
            try
            {
                tmpNode = root.SelectSingleNode("//System/Extensions/Count");
                if (tmpNode != null)
                {
                    nCount = Convert.ToInt32(tmpNode.InnerText);
                    if (nCount > 0)
                    {
                        for (int i = 0; i < nCount; i++)
                        {
                            SIPPBXExten extn = new SIPPBXExten();

                            int idx = i + 1;
                            tmpNode = root.SelectSingleNode("//System/Extensions/Extension[@id='" + idx.ToString() + "']");
                            if (tmpNode != null)
                            {
                                tmpNode1 = tmpNode.SelectSingleNode("UserName");
                                if (tmpNode1 != null)
                                    extn.UserName = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("RealName");
                                if (tmpNode1 != null)
                                    extn.RealName = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("Password");
                                if (tmpNode1 != null)
                                    extn.Password = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("Email");
                                if (tmpNode1 != null)
                                    extn.Email = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("AlternativePhoneNumber");
                                if (tmpNode1 != null)
                                    extn.AlternativePhoneNumber = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("RegSDKTime");
                                if (tmpNode1 != null)
                                    extn.RegSDKTime = Convert.ToUInt32(tmpNode1.InnerText);

                                tmpNode1 = tmpNode.SelectSingleNode("RegisterTime");
                                if (tmpNode1 != null)
                                    extn.RegisterTime = Convert.ToDateTime(tmpNode1.InnerText);

                                tmpNode1 = tmpNode.SelectSingleNode("RegisterExpire");
                                if (tmpNode1 != null)
                                    extn.RegisterExpire = Convert.ToUInt32(tmpNode1.InnerText);

                                tmpNode1 = tmpNode.SelectSingleNode("ContactAddr");
                                if (tmpNode1 != null)
                                    extn.ContactAddr = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("UAName");
                                if (tmpNode1 != null)
                                    extn.UAName = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("NATType");
                                if (tmpNode1 != null)
                                    extn.NATType = Convert.ToInt32(tmpNode1.InnerText);

/*
                                tmpNode1 = tmpNode.SelectSingleNode("MsgWaitingCount");
                                if (tmpNode1 != null)
                                    extn.MsgWaitingCount = Convert.ToInt32(tmpNode1.InnerText);

                                tmpNode1 = tmpNode.SelectSingleNode("MsgTotalCount");
                                if (tmpNode1 != null)
                                    extn.MsgTotalCount = Convert.ToInt32(tmpNode1.InnerText);
*/

                                tmpNode1 = tmpNode.SelectSingleNode("MsgAccount");
                                if (tmpNode1 != null)
                                    extn.MsgAccount = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("VoiceMsg");
                                if (tmpNode1 != null)
                                    extn.VoiceMsg = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("PriorityLevel");
                                if (tmpNode1 != null)
                                    extn.PriorityLevel = Convert.ToUInt32(tmpNode1.InnerText);

                                tmpNode1 = tmpNode.SelectSingleNode("VirtualExtenDestAddr");
                                if (tmpNode1 != null)
                                    extn.VirtualExtenDestAddr = tmpNode1.InnerText;

                                tmpNode1 = tmpNode.SelectSingleNode("ACDCallMethod");
                                if (tmpNode1 != null)
                                    extn.ACDCallMethod = Convert.ToInt32(tmpNode1.InnerText);

                                tmpNode1 = tmpNode.SelectSingleNode("RecordCall");
                                if (tmpNode1 != null)
                                {
                                    if (tmpNode1.InnerText.ToUpper() == "TRUE")
                                        extn.RecordCall = true;
                                    else
                                        extn.RecordCall = false;
                                }

                                tmpNode1 = tmpNode.SelectSingleNode("AcceptOtherID");
                                if (tmpNode1 != null)
                                {
                                    if (tmpNode1.InnerText.ToUpper() == "TRUE")
                                        extn.bAcceptOtherID = true;
                                    else
                                        extn.bAcceptOtherID = false;
                                }

                                tmpNode1 = tmpNode.SelectSingleNode("VMBOn");
                                if (tmpNode1 != null)
                                {
                                    if (tmpNode1.InnerText.ToUpper() == "TRUE")
                                    {
                                        extn.vmb = new VoiceMailBox();
                                        extn.vmb.vmbExten = extn;

                                        tmpNode1 = tmpNode.SelectSingleNode("VMBPrompt");
                                        if (tmpNode1 != null)
                                            extn.vmb.vmbPrompt = tmpNode1.InnerText;

                                        tmpNode1 = tmpNode.SelectSingleNode("VMBEmail");
                                        if (tmpNode1 != null)
                                            extn.vmb.vmbEmailAddr = tmpNode1.InnerText;

                                        tmpNode1 = tmpNode.SelectSingleNode("VMBMaxLength");
                                        if (tmpNode1 != null)
                                            extn.vmb.maxLengthInSecond = Convert.ToInt32(tmpNode1.InnerText);
                                    }
                                }
                                else
                                    extn.vmb = null;
                            }

                            pbx.sip_exten.Add(extn);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                if (env != null)
                {
                    env.LOG_Trace(1, ex.ToString());
                    env.LogoutText(ex.ToString());
                }
            }

            return true;
        }

        public static bool LoadEmailNetConfigFromXML(XmlDocument xmlDoc, SIPPBX pbx, GTSIPPBXEnv env)
        {
            XmlElement root = xmlDoc.DocumentElement;
            XmlNode tmpNode = null;
            try
            {
                tmpNode = root.SelectSingleNode("//System/SMTPServer/Server");
                if (tmpNode != null)
                    pbx.email_set.emailServer = tmpNode.InnerText;

                tmpNode = root.SelectSingleNode("//System/SMTPServer/Port");
                if (tmpNode != null)
                    pbx.email_set.emailPort = Convert.ToUInt16(tmpNode.InnerText);

                tmpNode = root.SelectSingleNode("//System/SMTPServer/EmailAddr");
                if (tmpNode != null)
                    pbx.email_set.emailAddr = tmpNode.InnerText;

                tmpNode = root.SelectSingleNode("//System/SMTPServer/Password");
                if (tmpNode != null)
                    pbx.email_set.emailPassword = tmpNode.InnerText;

                pbx.email_set.emailSSL = GetBooleanFromXMLNode(root.SelectSingleNode("//System/SMTPServer/SSL"));

            }
            catch (Exception ex)
            {
                if (env != null)
                {
                    env.LOG_Trace(1, ex.ToString());
                    env.LogoutText(ex.ToString());
                }
            }

            return true;
        }
    }
}
