using System;
using System.Collections.Generic;
using System.Text;
using System.Data.SqlClient;

namespace SIPPBXv3
{
    public class PBXOptCmdProcess
    {
        public static void AddSrvCmd_MoveDownDialplan(SIPPBXDialPlan dp, SqlConnection myConn, SIPPBXLog log)
        {
            if (dp != null)
            {
                try
                {
                    SqlCommand catCMD = myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = "INSERT INTO opt_cmd VALUES(0, ";
                    catCMD.CommandText += "'movedowndialplan', ";
                    catCMD.CommandText += "'" + dp.planName + "')";

                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
            }
        }

        public static void AddSrvCmd_MoveUpDialplan(SIPPBXDialPlan dp, SqlConnection myConn, SIPPBXLog log)
        {
            if (dp != null)
            {
                try
                {
                    SqlCommand catCMD = myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = "INSERT INTO opt_cmd VALUES(0, ";
                    catCMD.CommandText += "'moveupdialplan', ";
                    catCMD.CommandText += "'" + dp.planName + "')";

                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
            }
        }

        public static void AddSrvCmd_ResetACD(SIPPBXACDHuntGroup acd, SqlConnection myConn, SIPPBXLog log)
        {
            if (acd != null)
            {
                try
                {
                    SqlCommand catCMD = myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = "INSERT INTO opt_cmd VALUES(0, ";
                    catCMD.CommandText += "'resetacd', ";
                    catCMD.CommandText += "'" + acd.hgName + "')";

                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
            }
        }

        //if pbxChan == null, then reset all channels
        public static void AddSrvCmd_ResetChannel(SIPPBXChan pbxChan, SqlConnection myConn, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = "INSERT INTO opt_cmd VALUES(0, ";
                if (pbxChan != null)
                {
                    catCMD.CommandText += "'resetchan', ";
                    catCMD.CommandText += "'" + pbxChan.index.ToString() + "')";
                }
                else
                {
                    catCMD.CommandText += "'resetchan', ";
                    catCMD.CommandText += "'all')";
                }

                if (catCMD.ExecuteNonQuery() == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        //if extn is null, means logout
        public static void AddSrvCmd_AgentLogin(SIPPBXAgent agent, SIPPBXExten extn, SqlConnection myConn, SIPPBXLog log, SIPPBXACDHuntGroup acd)
        {
            if (agent != null)
            {
                try
                {
                    SqlCommand catCMD = myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = "INSERT INTO opt_cmd VALUES(0, ";
                    if (extn != null)
                    {
                        catCMD.CommandText += "'agentlogin', ";
                        catCMD.CommandText += "'" + agent.Code + "|" + extn.UserName + "|";
                    }
                    else
                    {
                        catCMD.CommandText += "'agentlogout', ";
                        catCMD.CommandText += "'" + agent.Code + "||";
                    }

                    if (acd != null)
                        catCMD.CommandText += acd.hgName + "|')";
                    else
                        catCMD.CommandText += "|')";

                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
            }
        }

        public static void ProcessPBXOptCmdQueue(SIPPBX pbx, GTSIPPBXEnv env)
        {
            PBXOptCmd cmd = null;

            while (pbx.opt_cmd_queue.Count > 0)
            {
                cmd = pbx.opt_cmd_queue.Dequeue();
                if(cmd != null)
                    ProcessPBXOptCmd(pbx, env, cmd);
            }

        }

        public static void ProcessPBXOptCmd(SIPPBX pbx, GTSIPPBXEnv env, PBXOptCmd cmd)
        {
            if (string.Compare(cmd.CmdName, "extncallout", true) == 0)
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);
                if (members.Length >= 4)
                {
                    SIPPBXExten extn = pbx.getExtensionByName(members[0]);
                    SIPAccount acct = pbx.getSIPAccountByUserName(members[2]);
                    string destNum = members[1];
                    int ringTimeout = Convert.ToInt32(members[3]);
                    string jobId = "";

                    int enableDetect = 0;
                    int discAfterDetect = 0;
                    if (members.Length == 6)
                    {
                        enableDetect = Convert.ToInt32(members[4]);
                        discAfterDetect = Convert.ToInt32(members[5]);
                    }
                    if (members.Length == 7)
                        jobId = members[6];

                    if (extn != null && acct != null)
                    {
                        if (extn.bOnlyAgentLogin && extn.Agent == null)
                        {
                            //not allowed to call out untill agent login
                            env.LogoutText("Exten " + extn.UserName + " is not allowed to call out because there is no agent login on it.");
                        }
                        else
                        {
                            string taskName = "ToExten" + extn.UserName;
                            AutoDialerTask tsk = pbx.getAutoDialerTaskByName(taskName);
                            if (tsk == null)
                            {
                                tsk = new AutoDialerTask();
                                tsk.task_name = taskName;
                                tsk.isOn = true;
                                try
                                {
                                    tsk.type_code = Convert.ToInt16(extn.UserName);
                                    tsk.type_code += 13000;
                                }
                                catch (Exception e)
                                {
                                    env.LogoutText(e.ToString());
                                    tsk.type_code = 13000;
                                }
                                tsk.sip_acc = acct.UserName;
                                tsk.dial_plan = taskName;
                                tsk.m_ringTimeout = ringTimeout;
                                tsk.m_maxSimCalls = 1;
                                tsk.m_bEnableDetect = (enableDetect == 1);
                                tsk.m_bDiscAfterDetect = (discAfterDetect == 1);

                                if (!SIPPBXCFGDB.AddAutoDialerTasksToDB(tsk, env.pbxMain, pbx, env, env.pbxMain.dbPBXSet.myConn, env.pbxMain.GetPBXLog()))
                                    env.pbxMain.dbPBXSet.ResetConnection();

                                SIPPBXCFGDB.RefreshAutoDialerTasks(env.pbxMain, pbx, env, env.pbxMain.dbPBXSet.myConn, env.pbxMain.GetPBXLog());
                            }
                            else
                            {
                                if (tsk.sip_acc != acct.UserName
                                    || tsk.m_ringTimeout != ringTimeout
                                    || tsk.type_code != Convert.ToInt16(extn.UserName)
                                    || tsk.dial_plan != taskName
                                    || !tsk.isOn)
                                {
                                    //need update task
                                    tsk.isOn = true;
                                    //task already exists, no need to set type_code 
                                    //tsk.type_code = 21000 + Convert.ToInt16(extn.UserName); 
                                    tsk.sip_acc = acct.UserName;
                                    tsk.dial_plan = taskName;
                                    tsk.m_ringTimeout = ringTimeout;
                                    tsk.m_maxSimCalls = 1;
                                    if(!SIPPBXCFGDB.UpdateAutoDialerTaskInDB(tsk, env.pbxMain, pbx, env, env.pbxMain.dbPBXSet.myConn, env.pbxMain.GetPBXLog()))
                                        env.pbxMain.dbPBXSet.ResetConnection();
                                    SIPPBXCFGDB.RefreshAutoDialerTasks(env.pbxMain, pbx, env, env.pbxMain.dbPBXSet.myConn, env.pbxMain.GetPBXLog());
                                }
                            }

                            SIPPBXDialPlan dp = pbx.getDialPlanByPlanName(taskName);
                            if (dp == null)
                            {
                                dp = new SIPPBXDialPlan();
                                dp.planName = taskName;
                                dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND;

                                dp.CalledID = "";
                                dp.CallerID = "";

                                dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION;
                                dp.DestAddress = extn.UserName;

                                dp.TimeLimited = false;

                                if (!SIPPBXCFGDB.AddDialPlanToDB(dp, env.pbxMain, pbx, env, env.pbxMain.dbPBXSet.myConn, env.pbxMain.GetPBXLog()))
                                    env.pbxMain.dbPBXSet.ResetConnection();

                                SIPPBXCFGDB.RefreshDialplansConfig(env.pbxMain, pbx, env, env.pbxMain.dbPBXSet.myConn, env.pbxMain.GetPBXLog());
                            }
                            SIPPBXDBUtil.AddAutoDialerJob(env.pbxMain.dbPBXSet.myConn, extn.UserName, destNum, Convert.ToInt16(extn.UserName), DateTime.Now, 1, jobId);
                        }
                    }
                }
            }
            else if (string.Compare(cmd.CmdName, "extenstatus", true) == 0)
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);
                if (members.Length >= 1)
                {
                    SIPPBXExten extn = pbx.getExtensionByName(members[0]);
                    if (extn != null)
                    {
                        string sEventCmd = extn.UserName;

                        sEventCmd += "|" + extn.InCalling.ToString();

                        pbx.manager.SendEvent("ExtenStatus", sEventCmd);
                    }
                }
            }
            else if (string.Compare(cmd.CmdName, "agentstatus", true) == 0)
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);
                if (members.Length >= 1)
                {
                    SIPPBXAgent agent = pbx.getAgentByCode(members[0]);
                    if(agent != null)
                    {
                        string sEventCmd = agent.Code;

                        if(agent.AtExten != null)
                        {
                            sEventCmd += "|" + agent.AtExten.UserName;
                            sEventCmd += "|" + agent.AtExten.InCalling.ToString();
                        }
                        else
                        {
                            sEventCmd += "||0";
                        }

                        pbx.manager.SendEvent("AgentStatus", sEventCmd);
                    }
                }
            }
            else if (string.Compare(cmd.CmdName, "agentlogin", true) == 0)
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);
                //env.LogoutText("agentlogin members length " + members.Length.ToString());
                if (members.Length >= 2)
                {
                    SIPPBXAgent agent = pbx.getAgentByCode(members[0]);
                    SIPPBXExten extn = pbx.getExtensionByName(members[1]);

                    if (agent != null && extn != null)
                    {
                        //env.LogoutText("agentlogin agent " + agent.Code + " extn " + extn.UserName);
                        if (members.Length <= 2)
                            pbx.AgentLogin(agent, extn, env, "", "", "", null);
                        else if (members.Length >= 3)
                        {
                            SIPPBXACDHuntGroup acd = null;
                            acd = pbx.getACDByName(members[2]);

                            pbx.AgentLogin(agent, extn, env, "", "", "", acd);
                        }
                    }
                }
            }
            else if (string.Compare(cmd.CmdName, "agentpaused", true) == 0)
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);
                if (members.Length >= 2)
                {
                    SIPPBXAgent agent = pbx.getAgentByCode(members[0]);

                    if (agent != null)
                    {
                        if (agent.AtExten != null)
                        {
                            agent.Paused = Convert.ToInt32(members[1]) == 1;

                            if (!SIPPBXCFGDB.UpdateAgentPausedStatusIntoDB(agent, env.pbxMain, pbx, env, env.pbxMain.dbPBXSet.myConn, env.pbxMain.GetPBXLog()))
                                env.pbxMain.dbPBXSet.ResetConnection();
                        }
                    }
                }
            }
            else if (string.Compare(cmd.CmdName, "agentlogout", true) == 0)
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);
                if (members.Length >= 1)
                {
                    SIPPBXAgent agent = pbx.getAgentByCode(members[0]);

                    if (agent != null)
                    {
                        if (agent.AtExten != null)
                        {
                            if (members.Length <= 2)
                                pbx.AgentLogout(agent, agent.AtExten, env, "", "", "", null);
                            else if (members.Length >= 3)
                            {
                                SIPPBXACDHuntGroup acd = null;
                                acd = pbx.getACDByName(members[2]);

                                pbx.AgentLogout(agent, agent.AtExten, env, "", "", "", acd);
                            }
                        }
                    }
                }
            }
            else if (cmd.CmdName.ToLower() == "resetchan")
            {
                if (cmd.CmdArgs.ToLower() == "all")
                {
                    for (int i = 0; i < env.GetChannelCount(); i++)
                    {
                        GTAPIASM.GTAPIChan api_chan = env.GetChannel(i);

                        switch (api_chan.ch_status)
                        {
                            case GTAPIASM.GTAPI_CHANNEL_STATE.IDLE:
                                break;
                            case GTAPIASM.GTAPI_CHANNEL_STATE.RESERVED:
                                api_chan.Free();
                                break;
                            case GTAPIASM.GTAPI_CHANNEL_STATE.DIALING:
                            case GTAPIASM.GTAPI_CHANNEL_STATE.OFFERED:
                            case GTAPIASM.GTAPI_CHANNEL_STATE.CONNECTED:
                            case GTAPIASM.GTAPI_CHANNEL_STATE.DISCONNECTING:
                            case GTAPIASM.GTAPI_CHANNEL_STATE.HOLDING:
                            case GTAPIASM.GTAPI_CHANNEL_STATE.BE_HOLDED:
                            default:
                                env.DisconnectCall(i, 0, "", "PBX: got command resetchan all, so disconnect the call");
                                break; ;
                        }
                    }
                }
                else
                {
                    int i = Convert.ToInt32(cmd.CmdArgs);
                    GTAPIASM.GTAPIChan api_chan = env.GetChannel(i);

                    switch (api_chan.ch_status)
                    {
                        case GTAPIASM.GTAPI_CHANNEL_STATE.IDLE:
                            break;
                        case GTAPIASM.GTAPI_CHANNEL_STATE.RESERVED:
                            api_chan.Free();
                            break;
                        case GTAPIASM.GTAPI_CHANNEL_STATE.DIALING:
                        case GTAPIASM.GTAPI_CHANNEL_STATE.OFFERED:
                        case GTAPIASM.GTAPI_CHANNEL_STATE.CONNECTED:
                        case GTAPIASM.GTAPI_CHANNEL_STATE.DISCONNECTING:
                        case GTAPIASM.GTAPI_CHANNEL_STATE.HOLDING:
                        case GTAPIASM.GTAPI_CHANNEL_STATE.BE_HOLDED:
                        default:
                            env.DisconnectCall(i, 0, "", "PBX: got command reset chan, so disconnect the call");
                            break; ;
                    }
                }
            }
            else if (cmd.CmdName.ToLower() == "makeextensioncall")
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);
                if (members.Length == 4)
                {
                    int ch = Convert.ToInt32(members[0]);
                    SIPPBXExten extn = pbx.getExtensionByName(members[1]);
                    string sCaller = members[2];
                    string sCmdID = members[3];
                    bool cmdSucceed = false;

                    if (ch < 0 || ch >= pbx.chan_list.Length)
                    {
                        pbx.manager.SendEvent("CommandResult", sCmdID + "|0");
                        return;
                    }

                    GTAPIASM.GTAPIChan api_chan = env.GetChannel(ch);

                    if (api_chan.ch_status != GTAPIASM.GTAPI_CHANNEL_STATE.IDLE)
                    {
                        pbx.manager.SendEvent("CommandResult", sCmdID + "|0");
                        return;
                    }

                    if (sCaller.Length == 0)
                    {
                        sCaller = "<sip:unknown@" + env.GetMappedPublicSIPIPAddress() + ">";
                    }

                    if (extn != null)
                    {
                        if (extn.IsVirtualExten())
                        {
                            //calling to a virtual extension
                            if (extn.VirtualExtenDestAddr.Contains(".") || extn.VirtualExtenDestAddr.Contains("@"))
                            {
                                //sip address
                                string sipDestAddr = extn.VirtualExtenDestAddr;
                                pbx.chan_list[ch].ResetAll("", 0, pbx, extn);
                                pbx.chan_list[ch].call_dir = 1;

                                if (sipDestAddr.Contains("sip:"))
                                {
                                    env.Send_Make(ch, extn.VirtualExtenDestAddr, sCaller);
                                }
                                else
                                {
                                    env.Send_Make(ch, "<sip:" + sipDestAddr + ">", sCaller);
                                }

                                pbx.SetExtenCallingState(extn, env, 10);//offered
                                pbx.chan_list[ch].link_exten = extn;

                                //IT IS NOT WORKING, because Send_RecordAudio2 doesn't work when channel is IDLE
                                //Although we already called Send_Make above, but it takes a while for netserver side 
                                //to receive it and process it.
                                //It will record anyway on Bridge two calls function.
                                //pbx.chan_list[ch].Record(env, null);
                                cmdSucceed = true;
                            }
                            else
                            {
                                //to see if it matchs any outbound rules
                                SIPPBXDialPlan dp1 = pbx.getDialPlanByCalledNum(env, extn.VirtualExtenDestAddr, "", "", "", null, 1);
                                if (dp1 != null)
                                {
                                    SIPAccount sip_acct = pbx.getDialPlanSIPAccount(dp1);
                                    if (sip_acct != null)
                                    {
                                        //outbound, should take out predix digit, then use another channel to dialout
                                        string destaddr = dp1.OutboundPrepend + extn.VirtualExtenDestAddr.Substring(dp1.OutboundPreStrip.Length);
                                        destaddr += "@" + sip_acct.DomainServer;
                                        destaddr = "<sip:" + destaddr + ">";

                                        pbx.chan_list[ch].ResetAll("", 0, pbx, extn);
                                        pbx.chan_list[ch].call_dir = 1;
                                        pbx.chan_list[ch].sip_acct = sip_acct;

                                        env.Send_Make(ch, destaddr, sCaller, "", "", sip_acct.AuthName, sip_acct.Password);

                                        pbx.SetExtenCallingState(extn, env, 10); //offered
                                        pbx.chan_list[ch].link_exten = extn;

                                        //IT IS NOT WORKING, because Send_RecordAudio2 doesn't work when channel is IDLE
                                        //Although we already called Send_Make above, but it takes a while for netserver side 
                                        //to receive it and process it.
                                        //It will record anyway on Bridge two calls function.
                                        //pbx.chan_list[ch].Record(env, null);

                                        cmdSucceed = true;
                                    }
                                    else
                                    {
                                        //cannot find right SIP account for outbound
                                    }
                                }
                            }
                        }
                        else
                        {
                            //regular extension
                            if (extn.IsRegistered() && (extn.InCalling == 0 || extn.bMultipleCalls))
                            {
                                //_env.LOG_Trace(4, "Start perform asyncronized compound - GTOpOutbound 6!");
                                pbx.chan_list[ch].ResetAll("", 0, pbx, extn);
                                pbx.chan_list[ch].call_dir = 1;

                                if (extn.MappedContactAddr.Length > 0)
                                {
                                    string destAddr = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, extn.MappedContactAddr);
                                    string destPort = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, extn.MappedContactAddr);


                                    env.Send_Make(ch, extn.ContactAddr, sCaller, "", "", "", "", destAddr, Convert.ToUInt16(destPort));
                                }
                                else
                                {
                                    env.Send_Make(ch, extn.ContactAddr, sCaller);
                                }

                                pbx.SetExtenCallingState(extn, env, 10); //offered
                                pbx.chan_list[ch].link_exten = extn;
                                //IT IS NOT WORKING, because Send_RecordAudio2 doesn't work when channel is IDLE
                                //Although we already called Send_Make above, but it takes a while for netserver side 
                                //to receive it and process it.
                                //It will record anyway on Bridge two calls function.
                                //pbx.chan_list[ch].Record(env, null);
                                cmdSucceed = true;
                            }
                        }
                    }

                    if (cmdSucceed)
                        pbx.manager.SendEvent("CommandResult", sCmdID + "|1");
                    else
                        pbx.manager.SendEvent("CommandResult", sCmdID + "|0");
                }
            }
            else if (cmd.CmdName.ToLower() == "makecall")
            {
                //assume it is format like: makecall ch|caller|callee|username|password|uri|contact
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);
                bool cmdSucceed = false;

                if (members.Length < 4)
                {
                    return;
                }

                string sCmdID = members[0];
                int ch = Convert.ToInt32(members[1]);

                if (ch < 0 || ch >= pbx.chan_list.Length)
                {
                    pbx.manager.SendEvent("CommandResult", sCmdID + "|0");
                    return;
                }

                GTAPIASM.GTAPIChan api_chan = env.GetChannel(ch);

                if (api_chan.ch_status != GTAPIASM.GTAPI_CHANNEL_STATE.IDLE)
                {
                    pbx.manager.SendEvent("CommandResult", sCmdID + "|0");
                    return;
                }

                SIPPBXExten extn = pbx.getExtensionByName(GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, members[3]));

                if (extn != null)
                {
                    if (extn.IsVirtualExten())
                    {
                        //calling to a virtual extension
                        if (extn.VirtualExtenDestAddr.Contains(".") || extn.VirtualExtenDestAddr.Contains("@"))
                        {
                            //sip address
                            string sipDestAddr = extn.VirtualExtenDestAddr;
                            pbx.chan_list[ch].ResetAll("", 0, pbx, extn);
                            pbx.chan_list[ch].call_dir = 1;

                            if (sipDestAddr.Contains("sip:"))
                            {
                                env.Send_Make(ch, extn.VirtualExtenDestAddr, members[2]);
                            }
                            else
                            {
                                env.Send_Make(ch, "<sip:" + sipDestAddr + ">", members[2]);
                            }

                            pbx.SetExtenCallingState(extn, env, 10);//offered
                            pbx.chan_list[ch].link_exten = extn;

                            //IT IS NOT WORKING, because Send_RecordAudio2 doesn't work when channel is IDLE
                            //Although we already called Send_Make above, but it takes a while for netserver side 
                            //to receive it and process it.
                            //It will record anyway on Bridge two calls function.
                            //pbx.chan_list[ch].Record(env, null);
                            cmdSucceed = true;
                        }
                        else
                        {
                            //to see if it matchs any outbound rules
                            SIPPBXDialPlan dp1 = pbx.getDialPlanByCalledNum(env, extn.VirtualExtenDestAddr,"", "", "", null, 1);
                            if (dp1 != null)
                            {
                                SIPAccount sip_acct = pbx.getDialPlanSIPAccount(dp1);
                                if (sip_acct != null)
                                {
                                    //outbound, should take out predix digit, then use another channel to dialout
                                    string destaddr = dp1.OutboundPrepend + extn.VirtualExtenDestAddr.Substring(dp1.OutboundPreStrip.Length);
                                    destaddr += "@" + sip_acct.DomainServer;
                                    destaddr = "<sip:" + destaddr + ">";

                                    pbx.chan_list[ch].ResetAll("", 0, pbx, extn);
                                    pbx.chan_list[ch].call_dir = 1;
                                    pbx.chan_list[ch].sip_acct = sip_acct;

                                    env.Send_Make(ch, destaddr, members[2], "", "", sip_acct.AuthName, sip_acct.Password);

                                    pbx.SetExtenCallingState(extn, env, 10); //offered
                                    pbx.chan_list[ch].link_exten = extn;

                                    //IT IS NOT WORKING, because Send_RecordAudio2 doesn't work when channel is IDLE
                                    //Although we already called Send_Make above, but it takes a while for netserver side 
                                    //to receive it and process it.
                                    //It will record anyway on Bridge two calls function.
                                    //pbx.chan_list[ch].Record(env, null);

                                    cmdSucceed = true;
                                }
                                else
                                {
                                    //cannot find right SIP account for outbound
                                }
                            }
                        }
                    }
                    else
                    {
                        //regular extension
                        if (extn.IsRegistered() && (extn.InCalling == 0 || extn.bMultipleCalls))
                        {
                            //_env.LOG_Trace(4, "Start perform asyncronized compound - GTOpOutbound 6!");
                            pbx.chan_list[ch].ResetAll("", 0, pbx, extn);
                            pbx.chan_list[ch].call_dir = 1;

                            if (extn.MappedContactAddr.Length > 0)
                            {
                                string destAddr = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, extn.MappedContactAddr);
                                string destPort = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, extn.MappedContactAddr);


                                env.Send_Make(ch, extn.ContactAddr, members[2], "", "", "", "", destAddr, Convert.ToUInt16(destPort));
                            }
                            else
                            {
                                env.Send_Make(ch, extn.ContactAddr, members[2]);
                            }

                            pbx.SetExtenCallingState(extn, env, 10); //offered
                            pbx.chan_list[ch].link_exten = extn;

                            //IT IS NOT WORKING, because Send_RecordAudio2 doesn't work when channel is IDLE
                            //Although we already called Send_Make above, but it takes a while for netserver side 
                            //to receive it and process it.
                            //It will record anyway on Bridge two calls function.
                            //pbx.chan_list[ch].Record(env, null);
                            cmdSucceed = true;
                        }
                    }


                    if (cmdSucceed)
                        pbx.manager.SendEvent("CommandResult", sCmdID + "|1");
                    else
                        pbx.manager.SendEvent("CommandResult", sCmdID + "|0");

                    return;
                }

                if (members.Length == 4)
                {
                    pbx.chan_list[ch].ResetAll("", 0, pbx, extn);
                    pbx.chan_list[ch].call_dir = 1;

                    env.Send_Make(ch, members[3], members[2]);

                    //IT IS NOT WORKING, because Send_RecordAudio2 doesn't work when channel is IDLE
                    //Although we already called Send_Make above, but it takes a while for netserver side 
                    //to receive it and process it.
                    //It will record anyway on Bridge two calls function.
                    //pbx.chan_list[ch].Record(env, null);
                    pbx.manager.SendEvent("CommandResult", sCmdID + "|1");
                }
                else if (members.Length == 6)
                {
                    pbx.chan_list[ch].ResetAll("", 0, pbx, extn);
                    pbx.chan_list[ch].call_dir = 1;

                    env.Send_Make(ch, members[3], members[2], "", "", members[4], members[5]);
                    if (extn != null)
                        pbx.SetExtenCallingState(extn, env, 10); //offered
                    //IT IS NOT WORKING, because Send_RecordAudio2 doesn't work when channel is IDLE
                    //Although we already called Send_Make above, but it takes a while for netserver side 
                    //to receive it and process it.
                    //It will record anyway on Bridge two calls function.
                    //pbx.chan_list[ch].Record(env, null);
                    pbx.manager.SendEvent("CommandResult", sCmdID + "|1");
                }
                else if (members.Length == 8)
                {
                    pbx.chan_list[ch].ResetAll("", 0, pbx, extn);
                    pbx.chan_list[ch].call_dir = 1;

                    env.Send_Make(ch, members[3], members[2], members[6], members[7], members[4], members[5]);
                    if (extn != null)
                        pbx.SetExtenCallingState(extn, env, 10); //offered
                    //IT IS NOT WORKING, because Send_RecordAudio2 doesn't work when channel is IDLE
                    //Although we already called Send_Make above, but it takes a while for netserver side 
                    //to receive it and process it.
                    //It will record anyway on Bridge two calls function.
                    //pbx.chan_list[ch].Record(env, null);
                    pbx.manager.SendEvent("CommandResult", sCmdID + "|1");
                }
                else
                    pbx.manager.SendEvent("CommandResult", sCmdID + "|0");
            }
            else if (cmd.CmdName.ToLower() == "answercall")
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);

                if (members.Length >= 1)
                {
                    env.Send_Answer(Convert.ToInt32(members[0]));
                }
            }
            else if (cmd.CmdName.ToLower() == "hangupcall")
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);

                if (members.Length == 1)
                {
                    env.DisconnectCall(Convert.ToInt32(members[0]), 0, "", "PBX: got command hangupcall");
                }
                else if (members.Length == 3)
                {
                    env.DisconnectCall(Convert.ToInt32(members[0]), Convert.ToInt32(members[1]), members[2], "PBX: got command hangupcall");
                }
            }
            else if (cmd.CmdName.ToLower() == "holdcall")
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);

                if (members.Length == 1)
                {
                    env.Send_Hold(Convert.ToInt32(members[0]));
                }
            }
            else if (cmd.CmdName.ToLower() == "transfercall")
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);

                if (members.Length == 2)
                {
                    env.Send_Transfer(Convert.ToInt32(members[0]), members[1]);
                }
                else if (members.Length == 3)
                {
                    env.Send_TransferEx(Convert.ToInt32(members[0]), members[1], Convert.ToInt32(members[2]));
                }
            }
            else if (cmd.CmdName.ToLower() == "bridgetwocalls")
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);

                if (members.Length >= 3)
                {
                    int ch1 = Convert.ToInt32(members[0]);
                    int ch2 = Convert.ToInt32(members[1]);
                    string sCmdID = members[2];

                    if (ch1 < 0 || ch1 >= pbx.chan_list.Length)
                    {
                        pbx.manager.SendEvent("CommandResult", sCmdID + "|0");
                        return;
                    }

                    if (ch2 < 0 || ch2 >= pbx.chan_list.Length)
                    {
                        pbx.manager.SendEvent("CommandResult", sCmdID + "|0");
                        return;
                    }

                    SIPPBXChan chan1 = pbx.chan_list[ch1];
                    SIPPBXChan chan2 = pbx.chan_list[ch2];

                    if (chan1.link_exten != null)
                    {
                        chan1.async_op_compound = new GTOpCallBridge(pbx, env, chan1, chan2);
                        chan1.async_op_compound.start();
                        pbx.manager.SendEvent("CommandResult", sCmdID + "|1");
                    }
                    else if (chan2.link_exten != null)
                    {
                        chan2.async_op_compound = new GTOpCallBridge(pbx, env, chan2, chan1);
                        chan2.async_op_compound.start();
                        pbx.manager.SendEvent("CommandResult", sCmdID + "|1");
                    }
                    else
                    {
                        //env.Send_DuplexConnect(ch1, ch2);
                        chan1.async_op_compound = new GTOpCallBridge(pbx, env, chan1, chan2);
                        chan1.async_op_compound.start();
                        pbx.manager.SendEvent("CommandResult", sCmdID + "|1");
                    }
                }
            }
            else if (cmd.CmdName.ToLower() == "magictransfer")
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);

                if (members.Length >= 2)
                {
                    int ch = Convert.ToInt32(members[0]);
                    SIPPBXChan pbx_chan = env.pbx.chan_list[ch];
                    SIPPBXParkingSlot ps = env.pbx.getParkingSlotByName(members[1]);
                    if (ps != null)
                    {
                        ps.pbxChan = pbx_chan;
                        if (pbx_chan.link_chan != null)
                            env.DisconnectCall(pbx_chan.link_chan.index, 0, "", "PBX: got command magictransfer, so diconnect linked channel");
                        pbx_chan.link_chan = null;
                        return;
                    }

                    ps = env.pbx.getParkingSlot(members[1]);
                    if (ps != null)
                    {
                        ps.pbxChan = pbx_chan;

                        //record parking slot in IVR keys:
                        string sCallPark = "CallPark:" + ps.psDTMF + ";";
                        pbx_chan.ivrKeys += sCallPark;

                        if (pbx_chan.link_chan != null)
                        {
                            pbx_chan.link_chan.ivrKeys += sCallPark;
                            env.DisconnectCall(pbx_chan.link_chan.index, 0, "");
                        }

                        pbx_chan.link_chan = null;
                        return;
                    }

                    if (env.pbx.isTrunkHookFlashCode(members[1]))
                    {
                        env.Send_PlayDTMFStr(pbx_chan.index, "X");
                        return;
                    }

                    if (members[1].EndsWith(env.pbx.blindtrans_code) ||
                        members[1].EndsWith(env.pbx.consulttrans_code) ||
                        members[1].EndsWith(env.pbx.trunk_blindtrans_code) ||
                        members[1].EndsWith(env.pbx.trunk_consulttrans_code))
                    {
                        if (pbx_chan.link_chan != null)
                            env.Send_DuplexDisconnect(pbx_chan.index, pbx_chan.link_chan.index);
                    }

                    SIPPBXExten extn = env.pbx.isBlindTransfer(members[1]);
                    if (extn != null)
                    {
                        //LogoutText(4, "Blind transfer call to " + extn.UserName + " " + extn.IsRegistered().ToString() + " " + extn.InCalling.ToString());
                        if (pbx_chan.link_chan != null)
                            pbx_chan.link_chan.async_op_compound = null;
                        pbx_chan.async_op_compound = new GTOpCallTransBlind(env.pbx, env, pbx_chan, pbx_chan.link_chan, extn);
                        pbx_chan.async_op_compound.start();
                        return;
                    }

                    extn = env.pbx.isConsultTransfer(members[1]);
                    if (extn != null && pbx_chan.link_chan != null)
                    {
                        pbx_chan.link_chan.async_op_compound = null;
                        pbx_chan.async_op_compound = new GTOpCallTransConsult(env.pbx, env, pbx_chan, pbx_chan.link_chan, extn);
                        pbx_chan.async_op_compound.start();
                        return;
                    }

                    string sTrunkNum = env.pbx.isTrunkBlindTransferCode(members[1]);
                    if (sTrunkNum.Length > 0)
                    {
                        GTAPIASM.GTAPIChan apiChan = env.GetChannel(pbx_chan.index);

                        string sRefID;
                        if (apiChan.originate)
                            sRefID = apiChan.callee_num;
                        else
                            sRefID = apiChan.caller_num;

                        string domainName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sRefID);
                        string portName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, sRefID);

                        if (!apiChan.originate && !SIPPBXWinUtil.IsValidIPAddress(domainName))
                        {
                            domainName = pbx_chan.sFromIP;
                            if (pbx_chan.nFromPort != 5060 && pbx_chan.nFromPort != 0)
                                portName = pbx_chan.nFromPort.ToString();
                            else
                                portName = "";
                        }

                        if (portName.Length > 0)
                            sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ":" + portName + ">";
                        else
                            sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ">";
                        env.Send_Transfer(pbx_chan.index, sTrunkNum);

                        return;
                    }

                    sTrunkNum = env.pbx.isTrunkConsultTransferCode(members[1]);
                    if (sTrunkNum.Length > 0 && pbx_chan.link_chan != null)
                    {
                        GTOpCallTransConsultTrunk transConsultTrunk = new GTOpCallTransConsultTrunk(pbx, env, pbx_chan, pbx_chan.link_chan, sTrunkNum);
                        pbx_chan.async_op_compound = transConsultTrunk;
                        pbx_chan.async_op_compound.start();
                        pbx_chan.link_chan.link_dtmf = "";
                        pbx_chan.link_chan.async_op_compound = null;
                        return;
                    }
                }
            }
            else if (cmd.CmdName.ToLower() == "rundialplan")
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);

                if (members.Length == 2)
                {
                    int ch = Convert.ToInt32(members[0]);
                    pbx.chan_list[ch].dp = pbx.getDialPlanByPlanName(members[1]);
                    if (pbx.chan_list[ch].dp != null)
                    {
                        env.DoDialPlan(ch, pbx.chan_list[ch], null, null);
                    }
                }
            }
            else if (cmd.CmdName.ToLower() == "resetacd")
            {
                SIPPBXACDHuntGroup hg = null;

                try
                {
                    int idx = Int32.Parse(cmd.CmdArgs);
                    if (idx >= 0 && idx < pbx.sip_huntgroups.Count)
                        hg = pbx.sip_huntgroups[idx];
                }
                catch
                {
                    //not an integer
                    //may be hg name
                    hg = pbx.getACDByName(cmd.CmdArgs);
                }

                if (hg != null)
                {
                    if (hg.calls.Count > 0)
                    {
                        for (int j = 0; j < hg.calls.Count; j++)
                        {
                            GTOpAsync op = hg.calls[j].op;
                            if (op != null)
                            {
                                if (op.getPBXChan() != null)
                                {
                                    env.DisconnectCall(op.getPBXChan().index, 0, "");
                                }
                            }
                        }
                    }
                }
            }
            else if (cmd.CmdName.ToLower() == "moveupdialplan")
            {
                for (int i = 0; i < pbx.sip_dialplan.Count; i++)
                {
                    if (pbx.sip_dialplan[i].planName == cmd.CmdArgs)
                    {
                        //env.pbxMain.LogoutText("Found dialplan " + cmd.CmdArgs);
                        if (i > 0)
                        {
                            SIPPBXCFGDB.ExchangeDialPlanInDB(pbx.sip_dialplan[i], pbx.sip_dialplan[i - 1], env.pbxMain, pbx, env, env.pbxMain.dbPBXSet.myConn, env.pbxMain.GetPBXLog());
                            SIPPBXDialPlan dp = pbx.sip_dialplan[i];
                            pbx.sip_dialplan[i] = pbx.sip_dialplan[i - 1];
                            pbx.sip_dialplan[i - 1] = dp;
                        }
                        break;
                    }
                }

            }
            else if (cmd.CmdName.ToLower() == "movedowndialplan")
            {
                for (int i = 0; i < pbx.sip_dialplan.Count; i++)
                {
                    if (pbx.sip_dialplan[i].planName == cmd.CmdArgs)
                    {
                        //env.pbxMain.LogoutText("Found dialplan " + cmd.CmdArgs);
                        if (i < pbx.sip_dialplan.Count - 1)
                        {
                            SIPPBXCFGDB.ExchangeDialPlanInDB(pbx.sip_dialplan[i], pbx.sip_dialplan[i + 1], env.pbxMain, pbx, env, env.pbxMain.dbPBXSet.myConn, env.pbxMain.GetPBXLog());
                            SIPPBXDialPlan dp = pbx.sip_dialplan[i];
                            pbx.sip_dialplan[i] = pbx.sip_dialplan[i + 1];
                            pbx.sip_dialplan[i + 1] = dp;
                        }
                        break;
                    }
                }
            }
            else if (cmd.CmdName.ToLower() == "monitorcall")
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);
                if (members.Length >= 3)
                {
                    SIPPBXExten supervisorExten = pbx.getExtensionByName(members[0]);
                    SIPPBXExten normalExtn = pbx.getExtensionByName(members[1]);
                    int typeMonitor = Convert.ToInt32(members[2]);

                    if (supervisorExten != null && normalExtn != null)
                    {
                        if (supervisorExten.IsSupervisorExten())
                        {
                            if (supervisorExten.InCalling == 30 && normalExtn.InCalling == 30)
                            {
                                SIPPBXChan pbxChanSupervisor = pbx.getChanByExten(supervisorExten);
                                SIPPBXChan pbxChanNormal = pbx.getChanByExten(normalExtn);

                                if (pbxChanSupervisor.async_op_compound == null)
                                {
                                    pbxChanSupervisor.async_op_compound = new GTOpMonitorCmd(pbx, env, pbxChanSupervisor, supervisorExten, normalExtn, typeMonitor);
                                    pbxChanSupervisor.async_op_compound.start();
                                }
                                else
                                {
                                    try
                                    {
                                        GTOpMonitorCmd cmdOpt = (GTOpMonitorCmd)pbxChanSupervisor.async_op_compound;
                                        cmdOpt._callmonitor.ProcessMonitorCallCommand(supervisorExten, normalExtn, typeMonitor);
                                        if (typeMonitor == -1) //get out
                                            pbxChanSupervisor.async_op_compound = null;
                                    }
                                    catch (Exception e)
                                    {
                                        env.pbxMain.LogoutText(e.ToString());
                                        pbxChanSupervisor.async_op_compound = null;
                                    }
                                }
                            }
                            else
                            {
                                env.pbxMain.LogoutText("MonitorCall Command: Supervisor or Agent is not in calling status!");
                            }

                        }
                        else
                        {
                            env.pbxMain.LogoutText("MonitorCall Command: Extension " + members[0] + " is not supervisor!");
                        }
                    }
                    else
                    {
                        env.pbxMain.LogoutText("MonitorCall Command: Extension " + members[0] + " or " + members[1] + " doesn't exist!");
                    }

                }
            }
            else if (cmd.CmdName.ToLower() == "setchaninconfroom")
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);
                if (members.Length >= 3)
                {
                    int ch = Convert.ToInt32(members[0]);
                    string conf_name = members[1];
                    int opt = Convert.ToInt32(members[2]);

                    if (opt == 1 || opt == 2)
                    {
                        env.Send_StopAudioEx(ch, 1, ""); //stop audio playing possibly in conference for this channel

                        env.pbx.SetChanIntoConferenceRoom(env, env.pbx.chan_list[ch], conf_name, opt);
                    }
                    else if (opt == 0) //taking out of the conference
                    {
                        env.pbx.RemoveChanFromConferenceRoom(env, env.pbx.chan_list[ch]);
                    }
                }
            }
            else if (cmd.CmdName.ToLower() == "setchanconfmask")
            {
                char[] delimiters = new char[] { ';', ',', ' ', '|' };
                string[] members = cmd.CmdArgs.Split(delimiters, StringSplitOptions.None);
                if (members.Length >= 2)
                {
                    int ch = Convert.ToInt32(members[0]);
                    uint bitMask = Convert.ToUInt32(members[1]);
                    env.SetChanConfMask(ch, bitMask);
                }
            }
            else if (cmd.CmdName.ToLower() == "createconfroom")
            {
                cmd.CmdArgs = cmd.CmdArgs.Trim();
                if (cmd.CmdArgs.Length > 0)
                {
                    SIPConferRoom room = pbx.getConferenceRoomByName(cmd.CmdArgs);

                    if (room == null)
                    {
                        room = new SIPConferRoom();
                        room.conf_handle = env.CreateConf();

                        room.conf_name = cmd.CmdArgs;
                        room.conf_max_num = 30; //myReader.GetInt32(2);

                        room.join_prompt = "";
                        room.leave_prompt = "";

                        room.moh_dir = "";
                        room.disc_call = false;
                        room.host_pw = "";
                        room.host_pw_prompt = "";
                        room.conf_record = false;

                        env.pbx.sip_conferooms.Add(room);
                    }
                }
            }
            else if (cmd.CmdName.ToLower() == "destroyconfroom")
            {
                if (cmd.CmdArgs.Length > 0)
                {
                    SIPConferRoom room = env.pbx.getConferenceRoomByName(cmd.CmdArgs);
                    if (room != null)
                    {
                        env.DestroyConf(room.conf_handle);
                        env.pbx.sip_conferooms.Remove(room);
                    }
                }
            }
            else if (cmd.CmdName.ToLower() == "confstatus")
            {
                if (cmd.CmdArgs.Length > 0)
                {
                    SIPConferRoom room = env.pbx.getConferenceRoomByName(cmd.CmdArgs);
                    if (room != null)
                    {
                        env.pbx.manager.SendConferenceStatus(room, IntPtr.Zero);
                    }
                }
                else
                {
                    env.pbx.manager.SendConferenceStatus(IntPtr.Zero);
                }
            }
			
        }

    }
}
