using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Net.Mail;
using System.Net.Mime;
using System.Threading;
using System.ComponentModel;
using System.IO;


namespace SIPPBXv3
{
    public class GTOpVMB : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public VoiceMailBox _vmb;
        public SIPPBXChan _chan;
        public GTOpAudioPlay _audio_play;
        public GTOpAudioRecord _audio_record;
        public string _audio_fn;
        public string _audio_fn1;
        public bool mailSent;
        public DateTime _record_start_time;

        public GTOpVMB(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, VoiceMailBox vmb)
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _vmb = vmb;
            _audio_play = null;
            _audio_record = null;
            _audio_fn = "";
            _audio_fn1 = "";
            mailSent = false;
            _record_start_time = DateTime.Now;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpVMB::start()########################====>>");

            if (_vmb.vmbPrompt.Length > 0) 
            {
                //if it is a plugin name, run the plugin instead of the voice mail
                //it can be used for own customized voice mail feature
                ISIPPBXPluginClient client = _pbx.GetPluginClientInterfaceByName(_vmb.vmbPrompt);
                if (client != null)
                {
                    if (client.Type == "IVRMenu")
                    {
                        SIPPBXPluginHost plugin_host = new SIPPBXPluginHost();
                        _chan.plugin_host = plugin_host;
                        plugin_host.pbx_chan = _chan;
                        plugin_host.env = _env;
                        plugin_host.vmb = _vmb;
                        if (plugin_host.Register(client))
                        {
                            _chan.async_op_compound = new GTOpPluginCompound(_pbx, _env, _chan);
                            plugin_host.event_wait_handle.Set();
                        }

                        return;
                    }
                }
            }

            List<string> audios = new List<string>();

            audios.Add(_pbx.pbx_dir + "\\audio\\" + "blank1.wav");

            if (_vmb.vmbPrompt.Length > 0)
                audios.Add(_vmb.vmbPrompt);
            else
                audios.Add(_pbx.please_leave_your_message_after_beep_dir);

            audios.Add(_pbx.pbx_dir + "\\audio\\" + "ShortBeep.wav");

            _audio_play = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audios, null, 0, "", 0);
            _audio_play.perform();
        }

        private static void SendCompletedCallback(object sender, AsyncCompletedEventArgs e)
        {
            // Get the unique identifier for this asynchronous operation.
            GTOpVMB _op_vmb = (GTOpVMB)e.UserState;
            string m_to = "";

            try
            {
                if (_op_vmb._vmb.vmbEmailAddr.Length > 0)
                {
                    m_to = _op_vmb._vmb.vmbEmailAddr;
                }
                else if (_op_vmb._vmb.vmbExten != null)
                {
                    m_to = _op_vmb._vmb.vmbExten.Email;
                }

                if (e.Cancelled)
                {
                    //Console.WriteLine("[{0}] Send canceled.", token);
                    _op_vmb._env.LogoutText("Voice mail sent to " + m_to + " is cancelled!");
                    _op_vmb._env.LOG_Trace(1, "Voice mail sent to " + m_to + " is cancelled!");
                }
                if (e.Error != null)
                {
                    //Console.WriteLine("[{0}] {1}", token, e.Error.ToString());
                    _op_vmb._env.LogoutText("Voice mail sent to " + m_to + " got error:" + e.Error.ToString());
                    _op_vmb._env.LOG_Trace(1, "Voice mail sent to " + m_to + " got error:" + e.Error.ToString());
                }
                else
                {
                    //Console.WriteLine("Message sent.");
                    _op_vmb._env.LogoutText("Voice mail sent to " + m_to + " succeeded!");
                    _op_vmb._env.LOG_Trace(4, "Voice mail sent to " + m_to + " succeeded!");
                }

                _op_vmb.mailSent = true;

                File.Delete(_op_vmb._audio_fn);

            }
            catch (Exception)
            {

            }
        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _audio_play)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    _record_start_time = DateTime.Now;
                    _audio_fn = _pbx.pbx_dir + "\\temp\\" + SIPPBXWinUtil.GetFNDateTime(_record_start_time) + "-" + _chan.index.ToString() + ".wav";

                    if (_vmb.vmbExten != null)
                    {
                        _pbx.CreateDir(_pbx.vmb_dir + _vmb.vmbExten.UserName + "\\");
                        _pbx.CreateDir(_pbx.vmb_dir + _vmb.vmbExten.UserName + "\\" + SIPPBXWinUtil.GetDirDateTime(_record_start_time) + "\\");
                        _audio_fn1 = _pbx.vmb_dir + _vmb.vmbExten.UserName + "\\" + SIPPBXWinUtil.GetDirDateTime(_record_start_time) + "\\" + SIPPBXWinUtil.GetFNDateTime(_record_start_time) + "-" + _chan.index.ToString() + ".wav";
                    }
                    else
                    {
                        _pbx.CreateDir(_pbx.vmb_dir + SIPPBXWinUtil.GetDirDateTime(_record_start_time) + "\\");
                        _audio_fn1 = _pbx.vmb_dir + SIPPBXWinUtil.GetDirDateTime(_record_start_time) + "\\" + SIPPBXWinUtil.GetFNDateTime(_record_start_time) + "-" + _chan.index.ToString() + ".wav";
                    }
                    _audio_record = new GTOpAudioRecord(this, _env, _chan, _audio_fn, 0, "", _vmb.maxLengthInSecond * 1000);
                    _audio_record.perform();
                }
                else
                {
                    _env.DisconnectCall(_chan.index, 0, "", "PBX: audio play failed in OpVMB");
                }
            }
            else if (opAsync == _audio_record)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    GTAPIASM.GTAPIChan api_chan = _env.GetChannel(_chan.index);

                    if (_env.IsChanConnected(_chan.index))
                    {
                        //disconnect the call first if it is still connected
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: recording done in OpVMB");
                    }

                    string m_to = "";
                    if (_vmb.vmbEmailAddr.Length > 0)
                    {
                        m_to = _vmb.vmbEmailAddr;
                    }
                    else if (_vmb.vmbExten != null)
                    {
                        m_to = _vmb.vmbExten.Email;
                    }

                    //need to save voicemail info into DB
                    File.Copy(_audio_fn, _audio_fn1);
                    
                    DBServerSetting db_set = _pbx.GetDBServerSet();
                    if (db_set != null)
                    {
                        if (db_set.ConnectDB())
                        {
                            SIPPBXExtenVoiceMail vm = new SIPPBXExtenVoiceMail();
                            vm.UserName = (_vmb.vmbExten != null) ? _vmb.vmbExten.UserName : "";
                            vm.ToEmail = m_to;
                            vm.Caller = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.caller_num);
                            vm.Callee = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num);
                            vm.tBegin = _record_start_time;
                            TimeSpan tsp = DateTime.Now - _record_start_time;
                            vm.nDurSec = Convert.ToInt32(tsp.TotalSeconds);
                            vm.VMFile = _audio_fn1;
                            vm.VMStatus = 1; //new msg
                            vm.CallID = _chan.unique_call_id;

                            if (SIPPBXDBUtil.SaveVoiceMailIntoDB(_pbx, _env, db_set.myConn, vm, _env.pbxMain.GetPBXLog()))
                            {
                                if(_vmb.vmbExten != null)
                                    SIPPBXDBUtil.UpdateExtenVoiceMailFromDB(_pbx, _env, _vmb.vmbExten, db_set.myConn, _env.pbxMain.GetPBXLog());
                            }
                            db_set.DisconnectDB();
                        }
                    }

                    if (m_to.Length == 0)
                    {
                        _env.LogoutText("Cannot send voice mail to null email address!");
                        _env.LOG_Trace(1, "Cannot send voice mail to null email address!");
                        return;
                    }

                    if (_pbx.email_set.emailAddr.Length > 0 && _pbx.email_set.emailServer.Length > 0)
                    {
                        try
                        {
                            MailMessage myMail = new MailMessage(_pbx.email_set.emailAddr, m_to);
                            myMail.Subject = "Voice Mail Received from " + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(0, api_chan.caller_num) + " " + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.caller_num);

                            myMail.Body = "You got a voice mail. Caller " + api_chan.caller_num + " Callee " + api_chan.callee_num + " Time " + DateTime.Now.ToString();

                            Attachment data = new Attachment(_audio_fn, MediaTypeNames.Application.Octet);

                            myMail.Attachments.Add(data); //add the attachment

                            SmtpClient smtp_client = new SmtpClient(_pbx.email_set.emailServer, _pbx.email_set.emailPort);

                            smtp_client.UseDefaultCredentials = false;
                            smtp_client.Credentials = new NetworkCredential(_pbx.email_set.emailAddr, _pbx.email_set.emailPassword);
                            smtp_client.EnableSsl = _pbx.email_set.emailSSL;

                            // Set the method that is called back when the send operation ends.
                            smtp_client.SendCompleted += new SendCompletedEventHandler(SendCompletedCallback);

                            //string userState = "test message1";
                            smtp_client.SendAsync(myMail, this);
                        }
                        catch (Exception ex)
                        {
                            _env.LogoutText(ex.Message);
                            _env.LOG_Trace(1, ex.Message);
                            _env.LOG_Trace(1, ex.ToString());
                        }
                    }
                    else
                    {
                        _env.LogoutText("No email server settings to send out voice email notification!");
                    }
                }
                else
                {
                    if (_env.IsChanConnected(_chan.index))
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: recording failed in OpVMB");
                    }
                }
            }
        }
    }
}
