using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpPluginCompound : GTOpAsyncCompound
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXChan _chan;

        public GTOpAudioPlayEx _op_audio_play_ex;
        public GTOpAudioPlay _op_audio_play;
        public GTOpAudioRecord _op_audio_record;
        public GTOpDTMFDetect _op_dtmf_detect;

        public GTOpCallTransfer _op_call_transfer;
        public GTOpAsync.ResultCode _result;

        public GTOpPluginCompound(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;

            _op_audio_play_ex = null;
            _op_audio_play = null;
            _op_dtmf_detect = null;
            _op_audio_record = null;

            _op_call_transfer = null;

            _result = GTOpAsync.ResultCode.OP_RESULT_UNDEFINED;
        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            _result = result;

            if (opAsync == _op_audio_play_ex)
            {
                _chan.DTMFBuf = _op_audio_play_ex.getDTMFStr();
                try
                {
                    if (_chan.plugin_host != null)
                    {
                        _chan.plugin_host.event_wait_handle.Set();
                    }
                }
                catch (Exception e)
                {
                    _env.LOG_Trace(1, e.ToString());
                }
            }
            else if (opAsync == _op_audio_play)
            {
                _chan.DTMFBuf = _op_audio_play.getDTMFStr();
                try
                {
                    if (_chan.plugin_host != null)
                    {
                        _chan.plugin_host.event_wait_handle.Set();
                    }
                }
                catch (Exception e)
                {
                    _env.LOG_Trace(1, e.ToString());
                }
            }
            else if (opAsync == _op_dtmf_detect)
            {
                _chan.DTMFBuf = _op_dtmf_detect.getDTMFStr();
                try
                {
                    if (_chan.plugin_host != null)
                    {
                        _chan.plugin_host.event_wait_handle.Set();
                    }
                }
                catch (Exception e)
                {
                    _env.LOG_Trace(1, e.ToString());
                }
            }
            else if (opAsync == _op_audio_record)
            {
                _chan.DTMFBuf = _op_audio_record.getDTMFStr();
                try
                {
                    if (_chan.plugin_host != null)
                    {
                        _chan.plugin_host.event_wait_handle.Set();
                    }
                }
                catch (Exception e)
                {
                    _env.LOG_Trace(1, e.ToString());
                }
            }
            else if (opAsync == _op_call_transfer)
            {
                try
                {
                    if (_chan.plugin_host != null)
                    {
                        _chan.plugin_host.event_wait_handle.Set();
                    }
                }
                catch (Exception e)
                {
                    _env.LOG_Trace(1, e.ToString());
                }
            }
        }

        public override void start()
        {
            base.start();

            _chan.DTMFBuf = "";
        }



    }
}
